/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ClassManager {
    protected final Logger logger;
    private final List<Package> imports = new LinkedList<Package>();
    private final Map<String, Class<?>> classes = new HashMap();

    public ClassManager() {
        this.logger = LoggerTools.getLogger(this);
        this.addImport("java.lang");
        this.classes.put("int", Integer.TYPE);
        this.classes.put("long", Long.TYPE);
        this.classes.put("byte", Byte.TYPE);
        this.classes.put("short", Short.TYPE);
        this.classes.put("float", Float.TYPE);
        this.classes.put("double", Double.TYPE);
        this.classes.put("char", Character.TYPE);
        this.classes.put("boolean", Boolean.TYPE);
    }

    public ClassManager(String[] packageNames) {
        this();
        this.addAllImports(packageNames);
    }

    public void addAllImports(String[] packageNames) {
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            this.addImport(packageName);
            ++n2;
        }
    }

    public void addImport(String packageName) {
        Package pkg = Package.getPackage(packageName);
        if (pkg == null) {
            String message = "Package '" + packageName + "' does not exist in the current class path.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        this.imports.add(pkg);
    }

    public Class<?> forName(String className) throws ClassNotFoundException {
        if (this.classes.containsKey(className)) {
            return this.classes.get(className);
        }
        if (className.indexOf(46) != -1) {
            return Class.forName(className);
        }
        Class<?> clazz = null;
        for (Package pkg : this.imports) {
            String fullClassName = String.valueOf(pkg.getName()) + "." + className;
            this.logger.info("Trying to get the class '" + fullClassName + "'.");
            try {
                clazz = Class.forName(fullClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz == null) continue;
            this.classes.put(className, clazz);
            return clazz;
        }
        throw new ClassNotFoundException();
    }
}

