/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.core.shell.Environment;
import de.aristaflow.adept2.util.shell.TypeConverter;
import java.util.HashMap;
import java.util.Map;

public class CommandInterpreter {
    private final String[] command;
    Environment environment;

    public CommandInterpreter(Environment environment, String[] command) {
        this.environment = environment;
        this.command = command != null ? (String[])command.clone() : null;
    }

    public String getCommandName() {
        if (this.isAssigningVariable()) {
            return this.command[2];
        }
        return this.command[0];
    }

    public boolean isAssigningVariable() {
        return this.command.length >= 2 && this.command[1].equals("=");
    }

    public String getVariableName() {
        if (this.isAssigningVariable()) {
            return CommandInterpreter.parseVariableName(this.command[0]);
        }
        return null;
    }

    public Map<Character, Object> getOptions() {
        HashMap<Character, Object> options = new HashMap<Character, Object>();
        return options;
    }

    public Object[] getParameters() {
        int paramStart = 1;
        if (this.isAssigningVariable()) {
            paramStart += 2;
        }
        String[] parameters = new String[this.command.length - paramStart];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = this.command[i + paramStart];
            ++i;
        }
        Object[] objects = new Object[parameters.length];
        int i2 = 0;
        while (i2 < objects.length) {
            String param = parameters[i2];
            if (CommandInterpreter.isVariableName(param)) {
                objects[i2] = this.environment.getVariable(CommandInterpreter.parseVariableName(param));
            } else if (param.equals("null")) {
                objects[i2] = null;
            } else {
                Class<?> strongTyping = null;
                try {
                    strongTyping = TypeConverter.getStrongTyping(param);
                }
                catch (ClassCastException classCastException) {}
                objects[i2] = strongTyping != null ? TypeConverter.getStronglyTypedValue(param) : param;
            }
            ++i2;
        }
        return objects;
    }

    private static String parseVariableName(String param) {
        if (CommandInterpreter.isVariableName(param)) {
            return param.substring(1);
        }
        return param;
    }

    private static boolean isVariableName(String param) {
        if (param.length() <= 1) {
            return false;
        }
        return param.charAt(0) == '$';
    }
}

