/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.core.shell.Shell;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.logging.Logger;

public class CommandParser {
    protected final Logger logger;
    private final BufferedReader reader;
    private int oldIndex = 0;
    private String nextLine = "";
    private Queue<List<String>> readyCommands = new LinkedList<List<String>>();
    private Shell shell;

    public CommandParser(Shell shell, InputStream inputStream) {
        this.shell = shell;
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.logger = LoggerTools.getLogger(this);
    }

    public String[] parse() throws EOFException {
        if (!this.readyCommands.isEmpty()) {
            List<String> list = this.readyCommands.poll();
            return list.toArray(new String[list.size()]);
        }
        if (this.oldIndex == 0 || this.nextLine.equals("")) {
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (IOException iOException) {
                throw new EOFException("IOException during readline - EOF?");
            }
        }
        if (this.nextLine == null) {
            throw new EOFException("End of file");
        }
        Stack<ArrayList<String>> commands = new Stack<ArrayList<String>>();
        List<String> currentCommand = new ArrayList<String>();
        StringBuilder currentWord = new StringBuilder();
        Mode mode = Mode.READ;
        boolean inQuotation = false;
        int index = this.oldIndex;
        while (index < this.nextLine.length()) {
            this.oldIndex = index + 1;
            char c = this.nextLine.charAt(index);
            boolean addChar = true;
            switch (c) {
                case ';': {
                    if (inQuotation) break;
                    mode = Mode.NEXT_COMMAND;
                    addChar = false;
                    break;
                }
                case '(': {
                    if (inQuotation) break;
                    mode = Mode.BEGIN_COMMAND;
                    addChar = false;
                    break;
                }
                case ')': {
                    if (inQuotation) break;
                    mode = Mode.END_COMMAND;
                    addChar = false;
                    break;
                }
                case '\"': {
                    if (inQuotation) {
                        inQuotation = false;
                        break;
                    }
                    inQuotation = true;
                    break;
                }
                case ' ': {
                    if (inQuotation) break;
                    if (currentWord.length() != 0) {
                        mode = Mode.END_WORD;
                    }
                    addChar = false;
                }
            }
            if (addChar) {
                currentWord.append(c);
            }
            boolean quitLoop = false;
            switch (mode) {
                case NEXT_COMMAND: {
                    currentWord = CommandParser.addWordAndGetBuffer(currentCommand, currentWord);
                    if (!this.readyCommands.offer(currentCommand)) {
                        this.logger.severe("");
                    }
                    quitLoop = true;
                    if (commands.isEmpty()) break;
                    throw new RuntimeException("Syntax error?");
                }
                case BEGIN_COMMAND: {
                    if (currentCommand.size() != 0) {
                        commands.push((ArrayList<String>)currentCommand);
                        currentCommand = new LinkedList();
                    }
                    mode = Mode.READ;
                    break;
                }
                case END_COMMAND: {
                    currentWord = CommandParser.addWordAndGetBuffer(currentCommand, currentWord);
                    int internalVar = -1;
                    if (!commands.isEmpty()) {
                        internalVar = this.shell.getEnvironment().createInternalVariable(null);
                        currentCommand.add(0, Integer.toString(internalVar));
                        currentCommand.add(1, "=");
                    }
                    if (!this.readyCommands.offer(currentCommand)) {
                        this.logger.severe("");
                    }
                    if (!commands.isEmpty()) {
                        currentCommand = (List)commands.pop();
                        currentCommand.add("$" + internalVar);
                    } else {
                        quitLoop = true;
                    }
                    mode = Mode.READ;
                    break;
                }
                case END_WORD: {
                    currentWord = CommandParser.addWordAndGetBuffer(currentCommand, currentWord);
                    mode = Mode.READ;
                }
            }
            if (index == this.nextLine.length() - 1) {
                currentWord = CommandParser.addWordAndGetBuffer(currentCommand, currentWord);
                if (!this.readyCommands.offer(currentCommand)) {
                    this.logger.severe("");
                }
                quitLoop = true;
                if (!commands.isEmpty()) {
                    throw new RuntimeException("Syntax error?");
                }
                this.oldIndex = 0;
                this.nextLine = "";
            }
            if (quitLoop) break;
            ++index;
        }
        List<String> next = this.readyCommands.poll();
        if (next == null) {
            return new String[0];
        }
        return next.toArray(new String[next.size()]);
    }

    private static StringBuilder addWordAndGetBuffer(List<String> command, StringBuilder word) {
        if (word.length() > 0) {
            command.add(word.toString());
            return new StringBuilder();
        }
        return word;
    }

    private static enum Mode {
        READ,
        END_WORD,
        END_COMMAND,
        BEGIN_COMMAND,
        NEXT_COMMAND;

    }
}

