/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.core.shell.Environment;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.shell.Command;
import de.aristaflow.adept2.util.shell.CommandNotFoundException;
import de.aristaflow.adept2.util.shell.CommandRunner;
import de.aristaflow.adept2.util.shell.CommandSet;
import de.aristaflow.adept2.util.shell.ShellComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class CommandRegistry {
    protected final Logger logger;
    private final Map<String, Set<String>> commandsByPath = new HashMap<String, Set<String>>();
    private final Map<String, Object> commandsByFullPath = new HashMap<String, Object>();
    private final Environment environment;

    protected CommandRegistry(Environment environment) {
        this.environment = environment;
        this.logger = LoggerTools.getLogger(this);
    }

    public void addShellComponent(String path, ShellComponent shellComponent) {
        this.addCommandSet(path, shellComponent);
    }

    public void addCommandSet(String path, CommandSet commandSet) {
        if (!this.commandsByPath.containsKey(path)) {
            this.commandsByPath.put(path, new HashSet());
        }
        Set<String> nameSet = this.commandsByPath.get(path);
        for (Command command : commandSet.getCommands().values()) {
            String commandName = command.getName();
            String commandWithPath = String.valueOf(path) + commandName;
            if (nameSet.contains(commandName)) {
                this.logger.severe("Duplicate command entry '" + commandName + "' for path '" + path + "'.");
                continue;
            }
            nameSet.add(commandName);
            this.commandsByFullPath.put(commandWithPath, command);
        }
    }

    public void addCommandRunner(String path, CommandRunner commandRunner) {
        if (!this.commandsByPath.containsKey(path)) {
            this.commandsByPath.put(path, new HashSet());
        }
        Set<String> nameSet = this.commandsByPath.get(path);
        for (String commandName : commandRunner.getCommandNames()) {
            nameSet.add(commandName);
            this.commandsByFullPath.put(String.valueOf(path) + commandName, commandRunner);
        }
    }

    public String resolvePathForCommand(String currentPath, String commandName) {
        for (String path : this.environment.getPath()) {
            if (!this.commandsByFullPath.containsKey(String.valueOf(path) + commandName)) continue;
            return path;
        }
        if (this.commandsByFullPath.containsKey(String.valueOf(currentPath) + commandName)) {
            return currentPath;
        }
        String message = "Could not resolve the path for '" + commandName + "' from path '" + currentPath + "'.";
        throw new CommandNotFoundException(currentPath, commandName, message);
    }

    public void addShellCommand(Command command) {
        if (this.commandsByFullPath.containsKey("/" + command.getName())) {
            String message = "Shell command already exists, not adding it!";
            this.logger.severe(message);
            return;
        }
        this.commandsByFullPath.put("/" + command.getName(), command);
        Set<String> commandsInRoot = this.commandsByPath.get("/");
        commandsInRoot.add(command.getName());
    }

    public CommandRunner getCommand(String commandWithFullPath) {
        Object command = this.commandsByFullPath.get(commandWithFullPath);
        if (command instanceof CommandRunner) {
            return (CommandRunner)command;
        }
        throw new CommandNotFoundException(commandWithFullPath, "", "");
    }

    public List<String> getAllAvailableCommands(String currentpath) {
        LinkedList<String> result = new LinkedList<String>();
        LinkedList<String> pathsToConsider = new LinkedList<String>(this.environment.getPath());
        if (!pathsToConsider.contains(currentpath)) {
            pathsToConsider.add(currentpath);
        }
        for (String path : pathsToConsider) {
            if (!this.commandsByPath.containsKey(path)) continue;
            result.addAll((Collection<String>)this.commandsByPath.get(path));
        }
        return result;
    }

    public List<String> getAvailableCommands(String path) {
        LinkedList<String> result = new LinkedList<String>();
        if (!this.commandsByPath.containsKey(path)) {
            return result;
        }
        result.addAll((Collection<String>)this.commandsByPath.get(path));
        return result;
    }
}

