/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.core.shell.CommandRegistry;
import de.aristaflow.adept2.util.shell.CommandRunner;
import de.aristaflow.adept2.util.shell.ShellComponent;
import de.aristaflow.adept2.util.shell.defaultimplementation.ReflectionRunner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ComponentRegistry {
    private Map<String, CommandRunner> components = new HashMap<String, CommandRunner>();
    private Map<String, CommandRunner> componentsByPath = new HashMap<String, CommandRunner>();
    private final CommandRegistry commandRegistry;

    public ComponentRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public void addComponent(String root, String name, Object component) {
        if (component instanceof Class) {
            this.addComponent(root, name, component, (Class)component);
        } else {
            this.addComponent(root, name, component, component.getClass());
        }
    }

    public void addComponent(String origRoot, String name, Object component, Class<?> clazz) {
        CommandRunner cr;
        String root = origRoot;
        if (root.charAt(root.length() - 1) != '/') {
            root = String.valueOf(root) + "/";
        }
        String path = String.valueOf(root) + name + "/";
        if (component instanceof ShellComponent) {
            ShellComponent shellComponent;
            cr = shellComponent = (ShellComponent)component;
            this.commandRegistry.addShellComponent(path, shellComponent);
        } else if (component instanceof Class) {
            cr = new ReflectionRunner(null, (Class)component);
            this.commandRegistry.addCommandRunner(path, cr);
        } else {
            cr = new ReflectionRunner(component, clazz);
            this.commandRegistry.addCommandRunner(path, cr);
        }
        this.components.put(name, cr);
        this.componentsByPath.put(path, cr);
    }

    public CommandRunner getComponentForPath(String path) {
        return this.componentsByPath.get(path);
    }

    public Set<String> getComponentNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }
}

