/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Environment {
    private final List<String> path = new LinkedList<String>();
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final List<Object> internalVariables = new LinkedList<Object>();
    private int internalVarIndex = 0;

    public Environment() {
        this.path.add("/");
    }

    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public Object getVariable(String name) {
        if (!this.variables.containsKey(name)) {
            return null;
        }
        return this.variables.get(name);
    }

    public void removeVariable(String name) {
        this.variables.remove(name);
    }

    public void setVariable(String name, Object object) {
        this.variables.put(name, object);
    }

    public Set<String> getVariableNames() {
        return Collections.unmodifiableSet(this.variables.keySet());
    }

    protected int createInternalVariable(Object value) {
        ++this.internalVarIndex;
        return this.internalVarIndex;
    }

    protected void removeInternalVariable(int i) {
        this.internalVariables.remove(i);
    }
}

