/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.core.shell.ComponentRegistry;
import de.aristaflow.adept2.core.shell.Shell;
import de.aristaflow.adept2.util.shell.CommandNotFoundException;
import de.aristaflow.adept2.util.shell.CommandRunner;
import de.aristaflow.adept2.util.shell.defaultimplementation.AbstractCommand;
import de.aristaflow.adept2.util.shell.defaultimplementation.AbstractCommandSet;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class InternalShellCommands
extends AbstractCommandSet {
    final Shell shell;

    protected InternalShellCommands(Shell shell) {
        this.shell = shell;
        this.addCommand(new ExitCommand());
        this.addCommand(new HelpCommand());
        this.addCommand(new ShowCommand());
        this.addCommand(new PrintExceptionTracesCommand());
        this.addCommand(new ListComponentsCommand());
        this.addCommand(new ChangeComponentCommand());
        this.addCommand(new AddReflectionComponentCommand());
        this.addCommand(new ListMethodsCommand());
        this.addCommand(new ArrayCommand());
    }

    String getFormattedHelpForCommandsInPath(String path) {
        StringBuilder help = new StringBuilder();
        List<String> availableCommands = this.shell.getCommandRegistry().getAvailableCommands(path);
        Collections.sort(availableCommands);
        for (String commandName : availableCommands) {
            String commandPath = this.shell.getCommandRegistry().resolvePathForCommand(this.shell.getCurrentPath(), commandName);
            CommandRunner command = this.shell.getCommandRegistry().getCommand(String.valueOf(commandPath) + commandName);
            help.append(String.format("  %1$-20s %2$s", commandName, command.getDescription(commandName)));
            help.append('\n');
        }
        return help.toString();
    }

    protected class AddReflectionComponentCommand
    extends AbstractCommand {
        public AddReflectionComponentCommand() {
            super("reflect", "Add a component with the given name using reflection on the given object");
            this.parameters = new Class[]{String.class, Object.class};
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            String name = (String)parameters[0];
            Object component = parameters[1];
            Class<?> clazz = component.getClass();
            InternalShellCommands.this.shell.getComponentRegistry().addComponent("/", name, component, clazz);
            return null;
        }
    }

    protected class ArrayCommand
    extends AbstractCommand {
        public ArrayCommand() {
            super("array", "Create an array");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            if (parameters.length > 0 && parameters[0] != null) {
                Class<?> type = null;
                if (parameters[0] instanceof Class) {
                    type = (Class<?>)parameters[0];
                } else if (parameters[0] instanceof String) {
                    String typeName = (String)parameters[0];
                    try {
                        type = InternalShellCommands.this.shell.getClassManager().forName(typeName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        InternalShellCommands.this.shell.println("Type '" + typeName + "' not found.");
                    }
                }
                if (type != null) {
                    Object array = Array.newInstance(type, parameters.length - 1);
                    int i = 1;
                    while (i < parameters.length) {
                        try {
                            Array.set(array, i - 1, parameters[i]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String message = "Could not add element #" + (i - 1) + " to the aray (wrong type).";
                            InternalShellCommands.this.shell.println(message);
                        }
                        ++i;
                    }
                    return array;
                }
            }
            return new Object[0];
        }
    }

    protected class ChangeComponentCommand
    extends AbstractCommand {
        public ChangeComponentCommand() {
            super("cc", "Change the current component / path.");
            this.parameters = new Class[]{String.class};
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            InternalShellCommands.this.shell.cc((String)parameters[0]);
            return null;
        }
    }

    protected class ExitCommand
    extends AbstractCommand {
        public ExitCommand() {
            super("exit", "Exit the ADEPT2 shell");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            InternalShellCommands.this.shell.println("Goodbye.");
            InternalShellCommands.this.shell.exit();
            return null;
        }
    }

    protected class HelpCommand
    extends AbstractCommand {
        public HelpCommand() {
            super("help", "Show the help for the shell or a command");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            if (parameters.length > 0 && parameters[0] instanceof String) {
                String commandName = (String)parameters[0];
                CommandRunner cr = null;
                try {
                    String path = InternalShellCommands.this.shell.getCommandRegistry().resolvePathForCommand(InternalShellCommands.this.shell.getCurrentPath(), commandName);
                    cr = InternalShellCommands.this.shell.getCommandRegistry().getCommand(String.valueOf(path) + commandName);
                }
                catch (CommandNotFoundException commandNotFoundException) {}
                if (cr != null) {
                    InternalShellCommands.this.shell.println(cr.getHelpText(commandName));
                }
            } else {
                String help = InternalShellCommands.this.getFormattedHelpForCommandsInPath("/");
                InternalShellCommands.this.shell.println("\n ADEPT2 shell basic syntax:\n    command [parameter]*\n    variable = command [parameter]*\n    unset variable\n  Where: variable is a string;\n         parameter is a string or $variable.\n  Parameters are separated by blanks.\n");
                InternalShellCommands.this.shell.println(" ADEPT2 shell commands:");
                InternalShellCommands.this.shell.println(help);
            }
            return null;
        }
    }

    protected class ListCommandsCommand
    extends AbstractCommand {
        public ListCommandsCommand() {
            super("lc", "List the commands which are available at the current or global path");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            String help = InternalShellCommands.this.getFormattedHelpForCommandsInPath(InternalShellCommands.this.shell.getCurrentPath());
            InternalShellCommands.this.shell.println();
            InternalShellCommands.this.shell.println(help);
            return null;
        }
    }

    protected class ListComponentsCommand
    extends AbstractCommand {
        public ListComponentsCommand() {
            super("lsc", "List all shell components");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            InternalShellCommands.this.shell.println(" These are the available components:");
            ComponentRegistry componentRegistry = InternalShellCommands.this.shell.getComponentRegistry();
            for (String componentName : componentRegistry.getComponentNames()) {
                InternalShellCommands.this.shell.println("  " + componentName);
            }
            InternalShellCommands.this.shell.println();
            return null;
        }
    }

    protected class ListMethodsCommand
    extends AbstractCommand {
        public ListMethodsCommand() {
            super("lsm", "List the methods / commands which are available at the current path.");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            String help = InternalShellCommands.this.getFormattedHelpForCommandsInPath(InternalShellCommands.this.shell.getCurrentPath());
            InternalShellCommands.this.shell.println();
            InternalShellCommands.this.shell.println(help);
            return null;
        }
    }

    protected class PrintExceptionTracesCommand
    extends AbstractCommand {
        public PrintExceptionTracesCommand() {
            super("printExceptions", "Print the stacktraces of all exceptions which occured");
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            Stack<Exception> exceptions = InternalShellCommands.this.shell.getExceptionStack();
            while (!exceptions.isEmpty()) {
                Exception e = exceptions.pop();
                InternalShellCommands.this.shell.println(" Exception: " + e.toString());
                InternalShellCommands.this.shell.println("   Message: " + e.getMessage());
                InternalShellCommands.this.shell.println("   Stacktrace:");
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement stackTrace = stackTraceElementArray[n2];
                    InternalShellCommands.this.shell.println("\t" + stackTrace.toString());
                    ++n2;
                }
                InternalShellCommands.this.shell.println();
            }
            return null;
        }
    }

    protected class ShowCommand
    extends AbstractCommand {
        public ShowCommand() {
            super("show", "Show a description of a shell object");
            this.parameters = new Class[]{Object.class};
            this.helpText = "usage: show [variables|$variableName]";
        }

        @Override
        public Object runCommand(Map<Character, Object> options, Object[] parameters) {
            if (parameters.length == 0) {
                InternalShellCommands.this.shell.println(this.getHelpText());
            } else if (parameters[0] != null && parameters[0].getClass() != String.class) {
                InternalShellCommands.this.shell.println(String.valueOf(parameters[0].getClass().getSimpleName()) + ": " + parameters[0].toString());
            } else if (parameters[0] != null) {
                String param = (String)parameters[0];
                if (param.equals("variables")) {
                    for (String varName : InternalShellCommands.this.shell.getEnvironment().getVariableNames()) {
                        InternalShellCommands.this.shell.println(String.valueOf(varName) + ": '" + InternalShellCommands.this.shell.getEnvironment().getVariable(varName) + "'.");
                    }
                }
            } else {
                InternalShellCommands.this.shell.println("null");
            }
            return null;
        }
    }
}

