/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.shell;

import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.core.shell.ClassManager;
import de.aristaflow.adept2.core.shell.CommandInterpreter;
import de.aristaflow.adept2.core.shell.CommandParser;
import de.aristaflow.adept2.core.shell.CommandRegistry;
import de.aristaflow.adept2.core.shell.ComponentRegistry;
import de.aristaflow.adept2.core.shell.Environment;
import de.aristaflow.adept2.core.shell.InternalShellCommands;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.shell.CommandNotFoundException;
import de.aristaflow.adept2.util.shell.CommandRunner;
import de.aristaflow.adept2.util.shell.commands.FileCommands;
import de.aristaflow.adept2.util.shell.commands.HashMapCommands;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;

public class Shell {
    protected final Logger logger;
    private final InputStream in;
    private final OutputStream out;
    private final CommandParser commandParser;
    private final Environment environment;
    private final ClassManager classManager;
    private final CommandRegistry commandRegistry;
    private final ComponentRegistry componentRegistry;
    private String currentPath = "/";
    private Stack<Exception> exceptions = new Stack();
    private boolean exit = false;
    private boolean running = false;

    public Shell(Registry registry, ClientSessionFactory sessionFactory, InputStream in, OutputStream out) throws ServiceNotKnownException {
        this.in = in;
        this.out = out;
        this.commandParser = new CommandParser(this, this.in);
        this.environment = new Environment();
        this.classManager = new ClassManager();
        this.commandRegistry = new CommandRegistry(this.environment);
        this.componentRegistry = new ComponentRegistry(this.commandRegistry);
        this.logger = LoggerTools.getLogger(this);
        this.commandRegistry.addCommandSet("/", new InternalShellCommands(this));
        this.commandRegistry.addCommandSet("/", new HashMapCommands());
        this.commandRegistry.addCommandSet("/", new FileCommands());
        ProcessModelFactory processModelFactory = registry.getModelFactory("ProcessModelFactory", ProcessModelFactory.class);
        ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(processModelFactory);
        ProcessModelXMLExport xmlExport = new ProcessModelXMLExport();
        ActivityRepository activityRepository = null;
        ProcessRepository processRepository = null;
        JDBCDataSource dataSource = null;
        ActivityModelFactory activityModelFactory = null;
        try {
            activityRepository = registry.getServiceOfType(sessionFactory.getSessionToken(), "ActivityRepository", ActivityRepository.class);
        }
        catch (Throwable throwable) {}
        try {
            activityModelFactory = registry.getModelFactory("ActivityModelFactory", ActivityModelFactory.class);
        }
        catch (Throwable throwable) {}
        try {
            processRepository = registry.getServiceOfType(sessionFactory.getSessionToken(), "ProcessRepository", ProcessRepository.class);
        }
        catch (Throwable throwable) {}
        try {
            dataSource = registry.getServiceOfType(sessionFactory.getSessionToken(), "JDBCDataSource", JDBCDataSource.class);
        }
        catch (Throwable throwable) {}
        this.componentRegistry.addComponent("/", "registry", Registry.class);
        this.componentRegistry.addComponent("/", "xmlimport", xmlImport);
        this.componentRegistry.addComponent("/", "xmlexport", xmlExport);
        this.componentRegistry.addComponent("/", "processmodelfactory", processModelFactory, ProcessModelFactory.class);
        if (activityRepository != null) {
            this.componentRegistry.addComponent("/", "activityrep", activityRepository, ActivityRepository.class);
        }
        if (activityModelFactory != null) {
            this.componentRegistry.addComponent("/", "activityMF", activityModelFactory, ActivityModelFactory.class);
        }
        if (processRepository != null) {
            this.componentRegistry.addComponent("/", "processrep", processRepository, ProcessRepository.class);
        }
        if (dataSource != null) {
            this.componentRegistry.addComponent("/", "jdbcDataSource", dataSource, JDBCDataSource.class);
        }
    }

    public void run() {
        if (this.running) {
            String message = "Shell already started.";
            this.logger.severe(message);
            throw new RuntimeException(message);
        }
        this.running = true;
        this.println("");
        this.println("  Welcome to the ADEPT2 shell.");
        this.println("");
        while (!this.exit) {
            String[] command;
            try {
                this.out.write(this.getPrompt().getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                this.logger.severe("IOException during shell run: " + e);
            }
            try {
                command = this.commandParser.parse();
            }
            catch (EOFException eOFException) {
                String message = "no input left - closing";
                this.println(message);
                this.logger.info(message);
                return;
            }
            if (command.length == 0 || command[0].length() == 0) continue;
            this.logger.fine("Got command: '" + Shell.commandArrayToString(command) + "'");
            try {
                this.executeCommand(command);
            }
            catch (CommandNotFoundException e) {
                String message = "Command '" + e.getCommandName() + "' not found.";
                this.println(message);
                this.logger.warning(message);
            }
        }
        this.running = false;
        this.logger.info("Returning from run - exiting.");
    }

    private Object executeCommand(String[] commands) {
        String commandNameWithPath;
        CommandInterpreter commandInterpreter = new CommandInterpreter(this.environment, commands);
        String commandNameWithOutPath = commandNameWithPath = commandInterpreter.getCommandName();
        if (commandNameWithPath.charAt(0) != '/') {
            commandNameWithPath = String.valueOf(this.commandRegistry.resolvePathForCommand(this.currentPath, commandNameWithOutPath)) + commandNameWithOutPath;
        } else {
            String[] split = commandNameWithPath.split("/");
            commandNameWithOutPath = split[split.length - 1];
        }
        CommandRunner command = this.commandRegistry.getCommand(commandNameWithPath);
        Map<Character, Object> options = commandInterpreter.getOptions();
        Object[] parameterObjects = commandInterpreter.getParameters();
        Object result = null;
        try {
            result = command.runCommand(commandNameWithOutPath, options, parameterObjects);
        }
        catch (Exception e) {
            this.println("An exception occured ('" + e.toString() + "'). Use 'printExceptions' to print a stacktrace.");
            this.logger.severe("Exception in command execution: " + e.toString() + "\n   " + e.getStackTrace()[0].toString());
            this.getExceptionStack().push(e);
        }
        if (commandInterpreter.isAssigningVariable()) {
            this.environment.setVariable(commandInterpreter.getVariableName(), result);
        }
        if (result != null) {
            this.println("(" + result.getClass().getSimpleName() + ": " + result.toString() + ")");
        }
        return result;
    }

    public void println(String s) {
        try {
            this.out.write(s.getBytes());
            this.out.write(10);
            this.out.flush();
        }
        catch (IOException e) {
            this.logger.severe("IO exception while writing to out: " + e);
        }
    }

    public void println() {
        try {
            this.out.write(10);
        }
        catch (IOException e) {
            this.logger.severe("IOException while printing: " + e);
        }
    }

    private static String commandArrayToString(String[] commands) {
        StringBuilder res = new StringBuilder();
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            res.append(s);
            res.append(' ');
            ++n2;
        }
        return res.toString();
    }

    private String getPrompt() {
        return String.format("adept2:%s> ", this.currentPath);
    }

    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void exit() {
        this.exit = true;
    }

    public Stack<Exception> getExceptionStack() {
        return this.exceptions;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void cc(String param) {
        String currentPath = this.getCurrentPath();
        ArrayList<String> pathElements = new ArrayList<String>();
        Collections.addAll(pathElements, currentPath.split("/"));
        while (pathElements.remove("")) {
        }
        if (param.equals("")) {
            return;
        }
        if (param.equals("/")) {
            pathElements.clear();
        } else if (param.equals("..") && pathElements.size() > 0) {
            pathElements.remove(pathElements.size() - 1);
        } else {
            if (param.equals("..")) {
                return;
            }
            if (this.componentRegistry.getComponentNames().contains(param)) {
                pathElements.clear();
                pathElements.add(param);
            } else {
                this.println("Invalid argument / component not known.");
            }
        }
        StringBuilder newPath = new StringBuilder("/");
        for (String element : pathElements) {
            newPath.append(String.valueOf(element) + "/");
        }
        this.currentPath = newPath.toString();
    }

    public ClassManager getClassManager() {
        return this.classManager;
    }
}

