/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.subprocessmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.SubInstanceStateNotification;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.runtimemanager.SynchronousActivityStarting;
import de.aristaflow.adept2.core.subprocessmanager.SubprocessManager;
import de.aristaflow.adept2.core.subprocessmanager.defaultimplementation.DefaultSubprocessTermination;
import de.aristaflow.adept2.core.subprocessmanager.defaultimplementation.SubprocessExecutionControlManager;
import de.aristaflow.adept2.core.subprocessmanager.defaultimplementation.VarParTools;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.execution.LightWeightProcessInstance;
import de.aristaflow.adept2.model.execution.Vote;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="PropagateSuspension", type=Property.Type.BOOLEAN, defaultValue="False", description=" Specifies wether all the running activities of a subprocess instance should also be suspended if the corresponding LWP activity is suspended."), @Property(name="PropagateAbortion", type=Property.Type.BOOLEAN, defaultValue="False", description=" Specifies wether all the running activities of a subprocess instance should also be aborted if the corresponding LWP activity is aborted.")})
public class DefaultSubprocessManager
extends AbstractADEPT2Service
implements SubprocessManager {
    public static final String CONFIGURATION_PROPERTY_PROPAGATE_SUSPENSION = "PropagateSuspension";
    public static final String CONFIGURATION_PROPERTY_PROPAGATE_ABORTION = "PropagateAbortion";
    static final long ID_NOT_SET = Long.MIN_VALUE;
    private final SubprocessExecutionControlManager subprocessExecutionControlManager;
    private final DefaultSubprocessTermination subprocessTermination;
    private ExecutionFactory executionFactory;
    private final Set<EBPInstanceReference> failingLWPs;

    public DefaultSubprocessManager(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[0], new String[]{"ExecutionManager", "ProcessManager"});
        boolean propagateAbortion = configuration.getBoolean(CONFIGURATION_PROPERTY_PROPAGATE_ABORTION);
        boolean propagateSuspension = configuration.getBoolean(CONFIGURATION_PROPERTY_PROPAGATE_SUSPENSION);
        this.subprocessExecutionControlManager = new SubprocessExecutionControlManager(this, registry, propagateSuspension, propagateAbortion);
        this.subprocessTermination = new DefaultSubprocessTermination(this, registry);
        this.failingLWPs = new HashSet<EBPInstanceReference>();
    }

    @Override
    public void init(URI[] exportedURIs) throws AbortServiceException {
        super.init(exportedURIs, -2, -2, "password");
        this.executionFactory = this.registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        this.subprocessTermination.init(this.sessionFactory);
        this.subprocessExecutionControlManager.init(this.sessionFactory);
    }

    @Override
    public String[] getStartupRequiredServices() {
        HashSet<String> requiredServices = new HashSet<String>();
        requiredServices.addAll(Arrays.asList(super.getStartupRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.subprocessExecutionControlManager.getStartupRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.subprocessTermination.getStartupRequiredServices()));
        return requiredServices.toArray(new String[requiredServices.size()]);
    }

    @Override
    public String[] getRuntimeRequiredServices() {
        HashSet<String> requiredServices = new HashSet<String>();
        requiredServices.addAll(Arrays.asList(super.getRuntimeRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.subprocessExecutionControlManager.getRuntimeRequiredServices()));
        requiredServices.addAll(Arrays.asList(this.subprocessTermination.getRuntimeRequiredServices()));
        return requiredServices.toArray(new String[requiredServices.size()]);
    }

    @Override
    public void start() throws AbortServiceException {
        this.subprocessTermination.start();
        this.subprocessExecutionControlManager.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.subprocessExecutionControlManager.shutdown();
        this.subprocessTermination.shutdown();
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.subprocessExecutionControlManager.emergencyShutdown();
        this.subprocessTermination.emergencyShutdown();
    }

    @Override
    public void logon(SessionToken session, ClientSessionFactory clientSessionFactory) {
    }

    @Override
    public Map<EBPInstanceReference, ProcessConstants.NodeState> logoffAndTerminateActivities(SessionToken session, QualifiedAgent agent, boolean forceTermination) {
        return Collections.emptyMap();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference, ExecutionContext context) {
        super.sessionActive(parentSession);
        try {
            block41: {
                block36: {
                    block37: {
                        block43: {
                            msg = String.format("About to start subprocess instance for parent LWP '%s'.", new Object[]{ebpInstanceReference});
                            this.logger.fine(msg);
                            successful = false;
                            fork = false;
                            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                            if (context.getEBPInstance() instanceof LightWeightProcessInstance) {
                                fork = ((LightWeightProcessInstance)context.getEBPInstance()).fork();
                                msg = String.format("Found subprocess instance for parent LWP '%s' to be forked.", new Object[]{ebpInstanceReference});
                                this.logger.finer(msg);
                            }
                            try {
                                superEM = this.registry.getService(subSession, ebpInstanceReference.getExecutionManagerURIs(), ExecutionManager.class);
                                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
                                processManagerURI = superEM.getProcessManager(subSession, ebpInstanceReference.getInstanceID());
                                superIM = this.registry.getService(subSession, processManagerURI, ProcessManager.class).getInstanceManager();
                            }
                            catch (ServiceNotKnownException snke) {
                                msg = "Could not retrieve the necessary services for starting '%s'. Aborting start.";
                                throw new InternalServiceException(String.format(msg, new Object[]{ebpInstanceReference}), snke);
                            }
                            subInstanceID = null;
                            try {
                                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                                superInstance = superIM.getAndLockInstanceForExecution(subSession, ebpInstanceReference.getInstanceID());
                            }
                            catch (LockException le) {
                                msg = "startActivity(Subprocess): Cannot lock the super-instance '%1$s' for execution when starting the subprocess at node '%2$s'. Trying to fail the LWP in the superprocess.";
                                msg = String.format(msg, new Object[]{ebpInstanceReference.getInstanceID(), ebpInstanceReference});
                                this.logger.log(Level.SEVERE, msg, le);
                                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                                this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SuperProcess:ExecutionLockFailed", 1600000L);
                                super.sessionFinished(parentSession);
                                return;
                            }
                            ebp = superInstance.getTemplate().getNode(ebpInstanceReference.getNodeID()).getExecutableBusinessProcess();
                            if (ebp instanceof VariableParallelismEBP) break block43;
                            msg = String.format("Found normal subprocess instance for parent LWP '%s'. Starting it normally with a child session token.", new Object[]{ebpInstanceReference});
                            this.logger.finer(msg);
                            executionContexts = new ExecutionContext[]{context};
                            startingSessions = new SessionToken[]{this.sessionFactory.getChildSession(parentSession, this.getURIs())};
                            ** GOTO lbl86
                        }
                        msg = String.format("Found variable parallelism for parent LWP '%s'. Starting several subprocesses with the indexed input parameters distributed and separate new session tokens for each.", new Object[]{ebpInstanceReference});
                        this.logger.fine(msg);
                        vpEBP = (VariableParallelismEBP)ebp;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        inputParameterValues = VarParTools.getInputParameterValues(subSession, vpEBP, context.getDataContainer());
                        branchCount = VarParTools.branchCount(inputParameterValues);
                        if (branchCount > 0) break block36;
                        msg = String.format("startActivity(Subprocess): Cannot instantiate subprocess for '%1$s' since there are no elements in the corresponding list. Trying to fail the LWP in the super process.", new Object[]{ebpInstanceReference});
                        this.logger.severe(msg);
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:InsufficientData", 1600006L);
                        if (successful) break block37;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:RuntimeException", 1600007L);
                    }
                    try {
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        superIM.unlockExecutableInstance(subSession, superInstance.getID());
                    }
                    catch (LockException le) {
                        msg = String.format("startActivity(Subprocess): Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it. There is nothing we can do. Continuing.", new Object[]{superInstance.getID()});
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                    return;
                }
                try {
                    msg = String.format("Found list elements for %d branches. Creating  a subprocess for each.", new Object[]{branchCount});
                    this.logger.fine(msg);
                    executionContexts = new ExecutionContext[branchCount];
                    startingSessions = new SessionToken[branchCount];
                    indexedDataContainer = VarParTools.createIndexedDataContainer(subSession, vpEBP, context.getDataContainer());
                    i = 0;
                    while (i < branchCount) {
                        templateID = vpEBP.getLightWeightProcess() instanceof ReferencedProcess != false ? ((ReferencedProcess)vpEBP.getLightWeightProcess()).getTemplateID() : ((EmbeddedProcess)vpEBP.getLightWeightProcess()).getTemplateID();
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        innerDataContainer = subInstanceControl.createInstanceDataContainer(subSession, templateID);
                        VarParTools.initialiseDataContainer(subSession, innerDataContainer, vpEBP, indexedDataContainer, i);
                        executionContexts[i] = this.executionFactory.getExecutionContext(context.getAgent(), context.getEBPInstance(), innerDataContainer, context.getExecutionMode(), context.getCurrentEnquiry(), context.getRepliedEnquiry());
                        startingSessions[i] = this.sessionFactory.getSessionToken(this.getURIs());
                        msg = String.format("Prepared data for branch %d of variable parallelism for parent LWP '%s'.", new Object[]{i, ebpInstanceReference});
                        this.logger.finer(msg);
                        ++i;
                    }
lbl86:
                    // 2 sources

                    i = 0;
                    while (i < executionContexts.length) {
                        subInstanceID = subInstanceControl.createAndStartSubInstance(startingSessions[i], ebpInstanceReference, executionContexts[i], this.getURIs());
                        msg = String.format("Started subprocess instance '%s' for variable parallelism at parent LWP '%s'.", new Object[]{i, ebpInstanceReference});
                        this.logger.finer(msg);
                        superInstance.addNodeLWPInstanceID(ebpInstanceReference.getNodeID(), subInstanceID);
                        ++i;
                    }
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    superIM.setExecutableInstance(subSession, superInstance);
                    successful = true;
                }
                catch (InvalidTemplateStateException e) {
                    msg = String.format("startActivity(Subprocess): Cannot instantiate the subprocess for '%1$s' due to the state of the sub-template. Trying to fail the LWP in the superprocess.", new Object[]{ebpInstanceReference});
                    this.logger.log(Level.SEVERE, msg, e);
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:TemplateStateException", 1600001L);
                    if (!successful) {
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:RuntimeException", 1600007L);
                    }
                    try {
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        superIM.unlockExecutableInstance(subSession, superInstance.getID());
                    }
                    catch (LockException le) {
                        msg = String.format("startActivity(Subprocess): Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it. There is nothing we can do. Continuing.", new Object[]{superInstance.getID()});
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                }
                catch (InvalidDataContainerException e) {
                    block39: {
                        msg = String.format("startActivity(Subprocess): Cannot instantiate the subprocess for '%1$s' due to problems with data container for the subprocess. Trying to fail the LWP in the superprocess.", new Object[]{ebpInstanceReference});
                        this.logger.log(Level.SEVERE, msg, e);
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:DataContainer", 1600003L);
                        if (successful) break block39;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:RuntimeException", 1600007L);
                    }
                    try {
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        superIM.unlockExecutableInstance(subSession, superInstance.getID());
                    }
                    catch (LockException le) {
                        msg = String.format("startActivity(Subprocess): Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it. There is nothing we can do. Continuing.", new Object[]{superInstance.getID()});
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                }
                catch (LockException le) {
                    block40: {
                        msg = "startActivity(Subprocess): Cannot store the executable instance '%1$s'. It is locked by another user. Aborting start of subprocess activity '%2$s'.";
                        msg = String.format(msg, new Object[]{superInstance.getID(), ebpInstanceReference});
                        this.logger.log(Level.SEVERE, msg, le);
                        if (successful) break block40;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:RuntimeException", 1600007L);
                        {
                            catch (Throwable var24_36) {
                                if (!successful) {
                                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                                    this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:RuntimeException", 1600007L);
                                }
                                try {
                                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                                    superIM.unlockExecutableInstance(subSession, superInstance.getID());
                                }
                                catch (LockException le) {
                                    msg = String.format("startActivity(Subprocess): Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it. There is nothing we can do. Continuing.", new Object[]{superInstance.getID()});
                                    this.logger.log(Level.SEVERE, msg, le);
                                }
                                throw var24_36;
                            }
                        }
                    }
                    try {
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        superIM.unlockExecutableInstance(subSession, superInstance.getID());
                    }
                    catch (LockException le) {
                        msg = String.format("startActivity(Subprocess): Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it. There is nothing we can do. Continuing.", new Object[]{superInstance.getID()});
                        this.logger.log(Level.SEVERE, msg, le);
                    }
                }
                if (successful) break block41;
                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                this.failLWP(subSession, subInstanceControl, ebpInstanceReference, context.getDataContainer(), msg, "ADEPT2:SubprocessManager:StartActivity:SubProcess:RuntimeException", 1600007L);
            }
            try {
                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                superIM.unlockExecutableInstance(subSession, superInstance.getID());
            }
            catch (LockException le) {
                msg = String.format("startActivity(Subprocess): Cannot unlock the instance '%1$s' for execution. Another method may have unlocked it. There is nothing we can do. Continuing.", new Object[]{superInstance.getID()});
                this.logger.log(Level.SEVERE, msg, le);
            }
            if (fork && successful) {
                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                this.getSubInstanceStateNotification().instanceFinished(subSession, subInstanceID, ebpInstanceReference, context.getDataContainer());
                msg = "Subprocess instance %s successfully started. Signalled finished for corresponding parent LWP '%s' since the subprocess is forked.";
                this.logger.finer(String.format(msg, new Object[]{subInstanceID, ebpInstanceReference}));
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void resumeActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference, ExecutionContext executionContext, int savepointID) {
        super.sessionActive(parentSession);
        try {
            InstanceControl subInstanceControl;
            Collection<UUID> subInstanceIDs;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                subInstanceIDs = this.getNonForkedSubprocessInstancesForLWP(subSession, ebpInstanceReference);
                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary services controlling the parent or the subprocess instances of LWP '%s'. Aborting resume.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            for (UUID subInstanceID : subInstanceIDs) {
                try {
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    subInstanceControl.resumeInstance(subSession, subInstanceID, this.getURIs());
                }
                catch (InvalidInstanceStateException iise) {
                    Level level;
                    String msg = "Cannot resume subprocess instance '%s', because the  instance is in the state '%s' which is invalid for this operation! Depending on this instance execution state this message can be ignored (for instance for finished instances).";
                    msg = String.format(msg, subInstanceID.toString(), iise.getPreventingState());
                    switch (iise.getInstanceExecutionStatus()) {
                        case IE_FINISHED: {
                            level = Level.FINE;
                            break;
                        }
                        case IE_RUNNING: {
                            level = Level.WARNING;
                            break;
                        }
                        case IE_SUSPENDED: 
                        case IE_SOFTLY_SUSPENDED: 
                        case IE_ABORTED: 
                        case IE_SOFTLY_ABORTED: {
                            level = Level.SEVERE;
                            break;
                        }
                        default: {
                            level = Level.INFO;
                        }
                    }
                    this.logger.log(level, msg, iise);
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public Vote prepareCommit(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(parentSession);
        try {
            InstanceControl subInstanceControl;
            Collection<UUID> subInstanceIDs;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                subInstanceIDs = this.getNonForkedSubprocessInstancesForLWP(subSession, ebpInstanceReference);
                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary services controlling the parent or the subprocess instances of LWP '%s'. Aborting preparation of commit - this is no ROLLBACK yet.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            Vote vote = Vote.COMMIT;
            for (UUID subInstanceID : subInstanceIDs) {
                try {
                    vote = subInstanceControl.prepareCommitInstance(subSession, subInstanceID);
                    if (!vote.equals((Object)Vote.ROLLBACK)) continue;
                    break;
                }
                catch (InvalidInstanceStateException iise) {
                    String errorMessage = String.format("Cannot prepare commit for subprocess instance '%s', because the instance is in the  state '%s' invalid for this operation! Sending rollback.", subInstanceID.toString(), iise.getPreventingState());
                    this.logger.log(Level.SEVERE, errorMessage, iise);
                    vote = Vote.ROLLBACK;
                }
            }
            Vote vote2 = vote;
            return vote2;
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void commit(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(parentSession);
        try {
            InstanceControl subInstanceControl;
            Collection<UUID> subInstanceIDs;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                subInstanceIDs = this.getNonForkedSubprocessInstancesForLWP(subSession, ebpInstanceReference);
                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary services controlling the parent or the subprocess instances of LWP '%s'. Aborting Commit - this is no ROLLBACK yet.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            for (UUID subInstanceID : subInstanceIDs) {
                try {
                    subInstanceControl.commitInstance(subSession, subInstanceID);
                }
                catch (InvalidInstanceStateException iise) {
                    String errorMessage = String.format("Cannot commit subprocess instance '%s', because the instance is in the state '%s' invalid for this operation! We can not do anything, continuing.", subInstanceID.toString(), iise.getPreventingState());
                    this.logger.log(Level.SEVERE, errorMessage, iise);
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void rollbackActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(parentSession);
        try {
            InstanceControl subInstanceControl;
            Collection<UUID> subInstanceIDs;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                subInstanceIDs = this.getNonForkedSubprocessInstancesForLWP(subSession, ebpInstanceReference);
                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary services controlling the parent or subprocess instances of LWP '%s'. Aborting Rollback.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            for (UUID subInstanceID : subInstanceIDs) {
                try {
                    subInstanceControl.rollbackInstance(subSession, subInstanceID);
                }
                catch (InvalidInstanceStateException iise) {
                    String errorMessage = String.format("Cannot rollback subprocess instance '%s', because the instance is in the state '%s' invalid for this operation! We can not do anything, continuing.", subInstanceID.toString(), iise.getPreventingState());
                    this.logger.log(Level.SEVERE, errorMessage, iise);
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    protected Collection<UUID> getNonForkedSubprocessInstancesForLWP(SessionToken session, EBPInstanceReference ebpInstanceReference) throws ServiceNotKnownException {
        ExecutionManager executionManager = this.registry.getService(session, ebpInstanceReference.getExecutionManagerURIs(), ExecutionManager.class);
        URI[] processManagerURI = executionManager.getProcessManager(session, ebpInstanceReference.getInstanceID());
        ProcessManager processManager = this.registry.getService(session, processManagerURI, ProcessManager.class);
        InstanceManager instanceManager = processManager.getInstanceManager();
        Instance instance = instanceManager.getInstance(session, ebpInstanceReference.getInstanceID());
        ExecutableBusinessProcess ebp = instance.getTemplate().getNode(ebpInstanceReference.getNodeID()).getExecutableBusinessProcess();
        if (ebp instanceof ReferencedProcess && ((ReferencedProcess)ebp).fork()) {
            return new HashSet<UUID>(0);
        }
        return instance.getNodeLWPInstanceID(ebpInstanceReference.getNodeID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void failLWP(SessionToken parentSession, InstanceControl subInstanceControl, EBPInstanceReference ebpInstanceReference, DataContainer parentContainer, String errorMessage, String state, long errorCode) {
        block35: {
            super.sessionActive(parentSession);
            try {
                var9_8 = this.failingLWPs;
                synchronized (var9_8) {
                    block34: {
                        if (this.failingLWPs.add(ebpInstanceReference)) break block34;
                        return;
                    }
                    ** try [egrp 3[TRYBLOCK] [1 : 35->41)] { 
                    {
                    }
                }
lbl14:
                // 2 sources

                try {
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    superEM = this.registry.getService(subSession, ebpInstanceReference.getExecutionManagerURIs(), ExecutionManager.class);
                    processManagerURI = superEM.getProcessManager(subSession, ebpInstanceReference.getInstanceID());
                    superIM = this.registry.getService(subSession, processManagerURI, ProcessManager.class).getInstanceManager();
                    superInstance = superIM.getInstance(subSession, ebpInstanceReference.getInstanceID());
                    failSubinstances = superInstance.getNodeLWPInstanceID(ebpInstanceReference.getNodeID());
                    for (UUID failInstance : failSubinstances) {
                        try {
                            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                            subInstanceControl.stopAndAbortInstance(subSession, failInstance, true, errorMessage, state, errorCode);
                        }
                        catch (InvalidInstanceStateException iise) {
                            msg = "Subprocess:failLWP: Can not fail the subinstance '%s' (node '%s' of the super-instance '%s'), since it is in state '%s' which does not allow failing the LWP. This can be ignored if the instance is already terminated (finished or aborted) but it the subprocess may also be in an inconsistent state with respect to the LWP.";
                            msg = String.format(msg, new Object[]{ebpInstanceReference.getNodeID(), ebpInstanceReference.getInstanceID()});
                            switch (DefaultSubprocessManager.$SWITCH_TABLE$de$aristaflow$adept2$model$globals$ProcessConstants$InstanceExecutionStatus()[iise.getInstanceExecutionStatus().ordinal()]) {
                                case 4: 
                                case 6: {
                                    level = Level.FINE;
                                    break;
                                }
                                case 2: 
                                case 3: 
                                case 5: {
                                    level = Level.WARNING;
                                    break;
                                }
                                case 1: {
                                    level = Level.SEVERE;
                                    break;
                                }
                                default: {
                                    level = Level.INFO;
                                }
                            }
                            this.logger.log(level, msg, iise);
                        }
                    }
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    superEM.getActivityTermination().activityFailed(subSession, ebpInstanceReference, parentContainer, errorMessage, state, errorCode);
                }
                catch (ServiceNotKnownException snke) {
                    msg = String.format("Subprocess:failLWP: Can not fail the LWP '%1$s' in the super-instance '%2$s', since the corresponding services are unavailable. We can not do anything about it. The state of the subprocess(es) and the state of the activity may be inconsistent from now on.", new Object[]{ebpInstanceReference, ebpInstanceReference.getInstanceID()});
                    this.logger.log(Level.SEVERE, msg, snke);
                    var21_23 = this.failingLWPs;
                    synchronized (var21_23) {
                        this.failingLWPs.remove(ebpInstanceReference);
                        break block35;
                    }
                }
                catch (InvalidActivityStateException iase) {
                    try {
                        msg = String.format("Subprocess:failLWP: Can not fail the LWP '%1$s' in the super-instance '%2$s', since it seems to be in the wrong state. We can not do anything about it, the subprocess is not running and the state of the activityis wrong from now on.", new Object[]{ebpInstanceReference, ebpInstanceReference.getInstanceID()});
                        this.logger.log(Level.SEVERE, msg, iase);
                        var21_24 = this.failingLWPs;
                    }
                    catch (Throwable var20_27) {
                        var21_25 = this.failingLWPs;
                        synchronized (var21_25) {
                            this.failingLWPs.remove(ebpInstanceReference);
                        }
                        throw var20_27;
                    }
                    synchronized (var21_24) {
                        this.failingLWPs.remove(ebpInstanceReference);
                        break block35;
                    }
                }
                var21_26 = this.failingLWPs;
                synchronized (var21_26) {
                    this.failingLWPs.remove(ebpInstanceReference);
                }
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    @Override
    public ExecutionControlManager getExecutionControlManager() {
        return this.subprocessExecutionControlManager;
    }

    @Override
    public SubInstanceStateNotification getSubInstanceStateNotification() {
        return this.subprocessTermination;
    }

    @Override
    public SynchronousActivityStarting getSynchronousActivityStarting() {
        return null;
    }
}

