/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.subprocessmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessAwareAccess;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.executionmanager.SubInstanceStateNotification;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.subprocessmanager.defaultimplementation.DefaultSubprocessManager;
import de.aristaflow.adept2.core.subprocessmanager.defaultimplementation.VarParTools;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.IndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.ValidationFailedException;
import de.aristaflow.adept2.model.execution.AgentUnknownException;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class DefaultSubprocessTermination
extends AbstractSubService
implements SubInstanceStateNotification {
    private final Registry registry;
    private final DefaultSubprocessManager subprocessManager;
    private SessionFactory sessionFactory;
    private final Map<EBPInstanceReference, IndexedAccessDataContainer> parallelData;

    public DefaultSubprocessTermination(DefaultSubprocessManager subprocessManager, Registry registry) {
        super(new String[0], new String[]{"ExecutionManager", "ProcessManager", "DataManager"}, subprocessManager);
        this.registry = registry;
        this.subprocessManager = subprocessManager;
        this.parallelData = new HashMap<EBPInstanceReference, IndexedAccessDataContainer>();
    }

    protected void init(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void instanceFinished(SessionToken parentSession, UUID instanceID, EBPInstanceReference superLWP, DataContainer dataContainer) {
        block9: {
            super.sessionActive(parentSession);
            try {
                try {
                    String msg = String.format("Subprocess instance %s (parent LWP '%s')has been finished.", instanceID, superLWP);
                    this.logger.fine(msg);
                    SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    ExecutionManager parentEM = this.registry.getService(subSession, superLWP.getExecutionManagerURIs(), ExecutionManager.class);
                    SessionToken privilegedToken = this.sessionFactory.getPrivilegedChildSession(parentSession, this.getURIs());
                    Instance parentInstance = this.getInstance(privilegedToken, superLWP.getInstanceID(), parentEM);
                    ExecutableBusinessProcess ebp = parentInstance.getTemplate().getNode(superLWP.getNodeID()).getExecutableBusinessProcess();
                    try {
                        LightWeightProcess lwp;
                        boolean signalNow;
                        boolean bl = signalNow = !(ebp instanceof VariableParallelismEBP);
                        if (!signalNow && (lwp = ((VariableParallelismEBP)ebp).getLightWeightProcess()) instanceof ReferencedProcess) {
                            signalNow = ((ReferencedProcess)lwp).fork();
                        }
                        if (signalNow) {
                            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                            parentEM.getActivityTermination().activityFinished(subSession, superLWP, dataContainer);
                            break block9;
                        }
                        msg = String.format("Finished subprocess instance %s (parent LWP '%s') is part of variable parallelism. Collecting output parameters and aggregating the state.", instanceID, superLWP);
                        this.logger.fine(msg);
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.aggregteVarPar(subSession, instanceID, superLWP, dataContainer, true, (VariableParallelismEBP)ebp, parentEM);
                    }
                    catch (InvalidActivityStateException iase) {
                        msg = String.format("Cannot finish LWP '%s' of sub-instance %s because it is in state '%s'. Continuing with this inconsistent state.", new Object[]{superLWP, instanceID, iase.getActivityState()});
                        this.logger.log(Level.SEVERE, msg, iase);
                    }
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve the necessary services controlling the parent instance '%s' of subprocess instance '%s'. Cannot signal finish. The parent activity will be in an inconsistent state.";
                    throw new InternalServiceException(String.format(msg, superLWP.getInstanceID(), instanceID), snke);
                }
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    @Override
    public void instanceSuspended(SessionToken parentSession, UUID instanceID, EBPInstanceReference superLWP, DataContainer dataContainer) {
        block8: {
            super.sessionActive(parentSession);
            try {
                try {
                    String msg = String.format("Subprocess instance %s (parent LWP '%s') has been suspended.", instanceID, superLWP);
                    this.logger.fine(msg);
                    SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    ExecutionManager parentEM = this.registry.getService(subSession, superLWP.getExecutionManagerURIs(), ExecutionManager.class);
                    SessionToken privilegedToken = this.sessionFactory.getPrivilegedChildSession(parentSession, this.getURIs());
                    Instance parentInstance = this.getInstance(privilegedToken, superLWP.getInstanceID(), parentEM);
                    ExecutableBusinessProcess ebp = parentInstance.getTemplate().getNode(superLWP.getNodeID()).getExecutableBusinessProcess();
                    try {
                        if (!(ebp instanceof VariableParallelismEBP)) {
                            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                            parentEM.getActivityTermination().activitySuspended(subSession, superLWP, dataContainer);
                            break block8;
                        }
                        msg = String.format("Suspended subprocess instance %s (parent LWP '%s') is part of variable parallelism. Collecting output parameters and aggregating the state.", instanceID, superLWP);
                        this.logger.fine(msg);
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.aggregteVarPar(subSession, instanceID, superLWP, dataContainer, false, (VariableParallelismEBP)ebp, parentEM);
                    }
                    catch (InvalidActivityStateException iase) {
                        msg = String.format("Cannot suspend LWP '%s' of sub-instance %s because it is in state '%s'. Continuing with this inconsistent state, try to solve inconsistency manually.", new Object[]{superLWP, instanceID, iase.getActivityState()});
                        this.logger.log(Level.SEVERE, msg, iase);
                    }
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve the necessary service controlling the parent instance '%s' of subprocess instance '%s'. Cannot signal suspend. The parent activity will be in an inconsistent state.";
                    throw new InternalServiceException(String.format(msg, superLWP.getInstanceID(), instanceID), snke);
                }
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    @Override
    public void instanceResumed(SessionToken parentSession, UUID instanceID, EBPInstanceReference superLWP) {
        block11: {
            super.sessionActive(parentSession);
            try {
                try {
                    String msg = String.format("Subprocess instance %s (parent LWP '%s') has been resumed.", instanceID, superLWP);
                    this.logger.fine(msg);
                    SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    ExecutionManager parentEM = this.registry.getService(subSession, superLWP.getExecutionManagerURIs(), ExecutionManager.class);
                    SessionToken privilegedToken = this.sessionFactory.getPrivilegedChildSession(parentSession, this.getURIs());
                    Instance parentInstance = this.getInstance(privilegedToken, superLWP.getInstanceID(), parentEM);
                    ExecutableBusinessProcess ebp = parentInstance.getTemplate().getNode(superLWP.getNodeID()).getExecutableBusinessProcess();
                    try {
                        if (!(ebp instanceof VariableParallelismEBP)) {
                            if (parentInstance.getNodeState(superLWP.getNodeID()) != ProcessConstants.NodeState.NS_RUNNING) {
                                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                                parentEM.getActivityStarting().resumeActivity(subSession, superLWP);
                            }
                            break block11;
                        }
                        msg = String.format("Resumed subprocess instance %s (parent LWP '%s') is part of variable parallelism. Collecting output parameters and aggregating the state.", instanceID, superLWP);
                        this.logger.fine(msg);
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.aggregteVarPar(subSession, instanceID, superLWP, null, false, (VariableParallelismEBP)ebp, parentEM);
                    }
                    catch (InvalidActivityStateException iase) {
                        msg = String.format("Cannot resume LWP '%s' of sub-instance %s because it is in state '%s'. Aborting resume, please try to solve inconsistency manually.", new Object[]{superLWP, instanceID, iase.getActivityState()});
                        this.logger.log(Level.SEVERE, msg, iase);
                    }
                    catch (InvalidInstanceStateException iise) {
                        msg = String.format("Cannot resume LWP '%s' of sub-instance %s because it its instance (the parent instance) is in state '%s'. This is a serious error since the parent instance should be running before resuming a sub-instance", superLWP, instanceID, iise.getPreventingState());
                        this.logger.log(Level.SEVERE, msg, iise);
                    }
                    catch (AgentUnknownException aue) {
                        msg = String.format("The parent execution manager cannot resume LWP '%s'of sub-instance %s since the subprocess manager '%s' (this subprocess manager) does not know the agent ('%s'). However an AgentUnknownException will never be thrown by a subprocess manager!", superLWP, instanceID, Arrays.toString(aue.getRuntimeManagerURIs()), aue.getAgent());
                        this.logger.log(Level.SEVERE, msg, aue);
                    }
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve the necessary service controlling the parent instance '%s' of subprocess instance '%s'. Cannot signal resume. The parent LWP will be in an inconsistent state.";
                    throw new InternalServiceException(String.format(msg, superLWP.getInstanceID(), instanceID), snke);
                }
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    @Override
    public void instanceFailed(SessionToken parentSession, UUID instanceID, EBPInstanceReference superLWP, DataContainer dataContainer, String errorMessage, String state, long errorCode) {
        block8: {
            super.sessionActive(parentSession);
            try {
                try {
                    String msg = String.format("Subprocess instance %s signalled failed with message '%s', state '%s' and error code '%s'. Setting the corresponding LWP '%s' in the parent process to failed.", instanceID, errorMessage, state, errorCode, superLWP);
                    this.logger.fine(msg);
                    SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    ExecutionManager parentEM = this.registry.getService(subSession, superLWP.getExecutionManagerURIs(), ExecutionManager.class);
                    SessionToken privilegedToken = this.sessionFactory.getPrivilegedChildSession(parentSession, this.getURIs());
                    Instance parentInstance = this.getInstance(privilegedToken, superLWP.getInstanceID(), parentEM);
                    ExecutableBusinessProcess ebp = parentInstance.getTemplate().getNode(superLWP.getNodeID()).getExecutableBusinessProcess();
                    try {
                        if (!(ebp instanceof VariableParallelismEBP)) {
                            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                            parentEM.getActivityTermination().activityFailed(subSession, superLWP, dataContainer, errorMessage, state, errorCode);
                            break block8;
                        }
                        msg = String.format("Failed subprocess instance %s (parent LWP '%s') is part of variable parallelism. Collecting output parameters and aggregating the state.", instanceID, superLWP);
                        this.logger.fine(msg);
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        this.aggregteVarPar(subSession, instanceID, superLWP, dataContainer, false, (VariableParallelismEBP)ebp, parentEM);
                    }
                    catch (InvalidActivityStateException e) {
                        String message = String.format("Cannot fail LWP '%s', because it is in the wrong state '%s'!", new Object[]{superLWP, e.getActivityState()});
                        this.logger.log(Level.SEVERE, message, e);
                    }
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve the necessary service controlling the parent instance '%s' of subprocess instance '%s'. Cannot signal fail. The parent LWP will be in an inconsistent state.";
                    throw new InternalServiceException(String.format(msg, superLWP.getInstanceID(), instanceID), snke);
                }
            }
            finally {
                super.sessionFinished(parentSession);
            }
        }
    }

    private Instance getInstance(SessionToken session, UUID instanceID, ExecutionManager em) throws ServiceNotKnownException {
        URI[] processManagerURI = em.getProcessManager(session, instanceID);
        ProcessManager pm = this.registry.getService(session, processManagerURI, ProcessManager.class);
        return pm.getInstanceManager().getInstance(session, instanceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aggregteVarPar(SessionToken parentSession, UUID instanceID, EBPInstanceReference superLWP, DataContainer dataContainer, boolean validateValues, VariableParallelismEBP ebp, ExecutionManager parentEM) throws InvalidActivityStateException, ServiceNotKnownException {
        SessionToken privilegedToken = this.sessionFactory.getPrivilegedChildSession(parentSession, this.getURIs());
        UUID superID = superLWP.getInstanceID();
        Instance parentInstance = this.getInstance(privilegedToken, superID, parentEM);
        DataContainer nonIndexedParentData = this.getDataContainer(privilegedToken, parentInstance, superLWP.getNodeID(), parentEM);
        try {
            List<UUID> parallels;
            String msg;
            IndexedAccessDataContainer parentData;
            privilegedToken = this.sessionFactory.getPrivilegedChildSession(parentSession, this.getURIs());
            Map<EBPInstanceReference, IndexedAccessDataContainer> map = this.parallelData;
            synchronized (map) {
                parentData = this.parallelData.get(superLWP);
                if (parentData == null) {
                    parentData = VarParTools.createIndexedDataContainer(privilegedToken, ebp, nonIndexedParentData);
                    this.parallelData.put(superLWP, parentData);
                    this.logger.finer(String.format("Data container of parent LWP '%s' not found in cache. Loaded it explicitly from the corresponding (parent) data manager", superLWP));
                }
                parentData = this.parallelData.get(superLWP);
            }
            nonIndexedParentData = parentData.getWrappedDataContainer();
            URI[] processManagerURI = parentEM.getProcessManager(privilegedToken, superID);
            InstanceManager superIM = this.registry.getService(privilegedToken, processManagerURI, ProcessManager.class).getInstanceManager();
            ExecutableInstance lockedParentInstance = null;
            try {
                lockedParentInstance = superIM.getAndLockInstanceForExecution(privilegedToken, superID);
            }
            catch (LockException e) {
                msg = String.format("aggregteVarPar: Cannot lock the super-instance '%1$s' for execution when retrieving the parallel instance IDs at node '%2$s'. ", superID, superLWP);
                this.logger.log(Level.SEVERE, msg, e);
            }
            if (lockedParentInstance != null) {
                try {
                    parallels = lockedParentInstance.getNodeLWPInstanceID(superLWP.getNodeID());
                }
                catch (Throwable throwable) {
                    try {
                        superIM.unlockExecutableInstance(privilegedToken, superID);
                    }
                    catch (LockException e) {
                        msg = String.format("aggregteVarPar: Cannot unlock the super-instance '%1$s' for execution after retrieving the parallel instance IDs at node '%2$s'. ", superID, superLWP);
                        this.logger.log(Level.SEVERE, msg, e);
                    }
                    throw throwable;
                }
                try {
                    superIM.unlockExecutableInstance(privilegedToken, superID);
                }
                catch (LockException e) {
                    msg = String.format("aggregteVarPar: Cannot unlock the super-instance '%1$s' for execution after retrieving the parallel instance IDs at node '%2$s'. ", superID, superLWP);
                    this.logger.log(Level.SEVERE, msg, e);
                }
            } else {
                parallels = parentInstance.getNodeLWPInstanceID(superLWP.getNodeID());
            }
            IndexedAccessDataContainer indexedAccessDataContainer = parentData;
            synchronized (indexedAccessDataContainer) {
                SessionToken subSession;
                int index = parallels.indexOf(instanceID);
                if (dataContainer != null) {
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    VarParTools.writeOutputValues(subSession, dataContainer, ebp, parentData, index, validateValues);
                    msg = String.format("Output values of subprocess '%s' written to the corresponding indexed parent data container.", instanceID);
                    this.logger.finer(msg);
                    URI[] dataManagerURI = parentEM.getDataManager(privilegedToken, superID);
                    ProcessAwareAccess paa = this.registry.getService(privilegedToken, dataManagerURI, DataManager.class).getProcessAwareAccess();
                    paa.flushDataContainer(subSession, lockedParentInstance, superLWP.getNodeID(), superLWP.getNodeIteration(), parentData.getWrappedDataContainer());
                    msg = String.format("Flushed data container of the parent of subprocess '%s'.", instanceID);
                    this.logger.finer(msg);
                }
                subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                ProcessConstants.InstanceExecutionStatus aggregatedStatus = VarParTools.aggregateStatus(subSession, parallels, this.registry);
                ProcessConstants.NodeState newNodeState = VarParTools.mapToNodeState(aggregatedStatus);
                ProcessConstants.NodeState currentNodeState = parentInstance.getNodeState(superLWP.getNodeID());
                msg = String.format("The variable parallelism has now the aggregated node state '%s' for the parent node '%s'. The current state is: %s", new Object[]{newNodeState, superLWP, currentNodeState});
                this.logger.finer(msg);
                switch (newNodeState) {
                    case NS_COMPLETED: {
                        if (currentNodeState == ProcessConstants.NodeState.NS_COMPLETED || !parentData.validatedAll()) break;
                        Map<EBPInstanceReference, IndexedAccessDataContainer> map2 = this.parallelData;
                        synchronized (map2) {
                            this.parallelData.remove(superLWP);
                        }
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        parentEM.getActivityTermination().activityFinished(subSession, superLWP, parentData.getWrappedDataContainer());
                        msg = String.format("Set parent LWP '%s' (variable parallelism) to finished.", superLWP);
                        this.logger.finer(msg);
                        break;
                    }
                    case NS_SUSPENDED: {
                        if (currentNodeState == ProcessConstants.NodeState.NS_SUSPENDED) break;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        parentEM.getActivityTermination().activitySuspended(subSession, superLWP, parentData.getWrappedDataContainer());
                        msg = String.format("Set parent LWP '%s' (variable parallelism) to suspended.", superLWP);
                        this.logger.finer(msg);
                        break;
                    }
                    case NS_FAILED: {
                        if (currentNodeState == ProcessConstants.NodeState.NS_FAILED) break;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        msg = String.format("At least one of the branches (subinstances) of the LWP '%s' has failed. Setting the LWP to failed in the parent instance %s!", superLWP, superID);
                        this.logger.info(msg);
                        parentEM.getActivityTermination().activityFailed(subSession, superLWP, parentData.getWrappedDataContainer(), msg, "ADEPT2:SubprocessManager:SubprocessTermination:VariableParallelism:SubinstanceFailed", 1600005L);
                        msg = String.format("Set parent LWP '%s' (variable parallelism) to failed with message '%s', state '%s' and error code '%s'.", superLWP, msg, "ADEPT2:SubprocessManager:SubprocessTermination:VariableParallelism:SubinstanceFailed", 1600005L);
                        this.logger.finer(msg);
                        break;
                    }
                    case NS_RUNNING: {
                        if (currentNodeState != ProcessConstants.NodeState.NS_SUSPENDED) break;
                        subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                        msg = String.format("At least one of the branches (subinstances) of the LWP '%s' has been resumed. Setting the LWP to running in the parent instance %s!", superLWP, superID);
                        this.logger.finer(msg);
                        try {
                            parentEM.getActivityStarting().resumeActivity(subSession, superLWP);
                            break;
                        }
                        catch (InvalidInstanceStateException iise) {
                            msg = String.format("Cannot resume LWP '%s' of sub-instance %s because it its instance (the parent instance) is in state '%s'. This is a serious error since the parent instance should be running before resuming a sub-instance", superLWP, instanceID, iise.getPreventingState());
                            this.logger.log(Level.SEVERE, msg, iise);
                            throw new InvalidActivityStateException(msg, currentNodeState);
                        }
                        catch (AgentUnknownException aue) {
                            msg = String.format("The parent execution manager cannot resume LWP '%s'of sub-instance %s since the subprocess manager '%s' (this subprocess manager) does not know the agent ('%s'). However an AgentUnknownException will never be thrown by a subprocess manager!", superLWP, instanceID, Arrays.toString(aue.getRuntimeManagerURIs()), aue.getAgent());
                            this.logger.log(Level.SEVERE, msg, aue);
                            throw new InvalidActivityStateException(msg, currentNodeState);
                        }
                    }
                    default: {
                        msg = String.format("The suprocess instances of the (parent) LWP '%s' have the aggregated execution status '%s' which is mapped to the node state '%s'. This node state is not allowed to be set for the LWP. The parent instance '%s' may be in an inconsistent state!", new Object[]{superLWP, aggregatedStatus, newNodeState, superID});
                        assert (false) : msg;
                        this.logger.severe(msg);
                    }
                }
            }
        }
        catch (ValidationFailedException vfe) {
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            InstanceControl subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            String msg = String.format("Cannot terminate subprocess instance '%s' (branch of variable parallelism) since it does not provide all of its mandatory output parameters. Failing the LWP '%s' in the parent instance %s!", instanceID, superLWP, superID);
            this.logger.log(Level.SEVERE, msg, vfe);
            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            this.subprocessManager.failLWP(subSession, subInstanceControl, superLWP, nonIndexedParentData, msg, "ADEPT2:ExecutionManager:ActivityTermination:DataValidationFailed", 5L);
        }
        catch (InvalidDataContainerException idce) {
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            InstanceControl subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            String msg = String.format("Cannot terminate subprocess instance '%s', because it is a branch of variable parallelism and there are problems accessing the parent data container. Failing the LWP '%s' in the parent instance %s!", instanceID, superLWP, superID);
            this.logger.log(Level.SEVERE, msg, idce);
            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            this.subprocessManager.failLWP(subSession, subInstanceControl, superLWP, nonIndexedParentData, msg, "ADEPT2:SubprocessManager:SubprocessTermination:VariableParallelism:ParentDataContainer", 1600004L);
        }
        catch (IOException ioe) {
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            InstanceControl subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            String msg = "Cannot terminate subprocess instance '%s' (branch of variable parallelism since there are problems serialising and storing the indexed access data container. Failing the LWP '%s' in the parent instance %s!";
            msg = String.format(msg, instanceID, superLWP, superID);
            this.logger.log(Level.SEVERE, msg, ioe);
            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            this.subprocessManager.failLWP(subSession, subInstanceControl, superLWP, nonIndexedParentData, msg, "ADEPT2:SubprocessManager:SubprocessTermination:VariableParallelism:IndexedAccessDataContainer", 1600008L);
        }
        catch (XMLFormatException xmle) {
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            InstanceControl subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            String msg = "Cannot terminate subprocess instance '%s' (branch of variable parallelism since there are problems serialising and storing the indexed access data container. Failing the LWP '%s' in the parent instance %s!";
            msg = String.format(msg, instanceID, superLWP, superID);
            this.logger.log(Level.SEVERE, msg, xmle);
            subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            this.subprocessManager.failLWP(subSession, subInstanceControl, superLWP, nonIndexedParentData, msg, "ADEPT2:SubprocessManager:SubprocessTermination:VariableParallelism:IndexedAccessDataContainer", 1600008L);
        }
    }

    private DataContainer getDataContainer(SessionToken session, Instance instance, int nodeID, ExecutionManager em) throws ServiceNotKnownException {
        URI[] dataManagerURI = em.getDataManager(session, instance.getID());
        DataManager dm = this.registry.getService(session, dataManagerURI, DataManager.class);
        return dm.getProcessAwareAccess().getDataContainer(session, instance, nodeID);
    }
}

