/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.subprocessmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.runtimemanager.ExecutionControlManager;
import de.aristaflow.adept2.core.subprocessmanager.defaultimplementation.DefaultSubprocessManager;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.runtimeenvironment.ActivityState;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class SubprocessExecutionControlManager
extends AbstractSubService
implements ExecutionControlManager {
    private final Registry registry;
    private boolean PROPAGATE_SUSPENSION_TO_RUNNING_ACTIVITIES = false;
    private boolean PROPAGATE_ABORTION_TO_RUNNING_ACTIVITIES = false;
    private final DefaultSubprocessManager subprocessManager;
    private SessionFactory sessionFactory;

    public SubprocessExecutionControlManager(DefaultSubprocessManager subprocessManager, Registry registry, boolean propagateSuspension, boolean propagateAbortion) {
        super(new String[0], new String[]{"ExecutionManager"}, subprocessManager);
        this.registry = registry;
        this.subprocessManager = subprocessManager;
        this.PROPAGATE_SUSPENSION_TO_RUNNING_ACTIVITIES = propagateSuspension;
        this.PROPAGATE_ABORTION_TO_RUNNING_ACTIVITIES = propagateAbortion;
    }

    protected void init(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void sendSignalToActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference, int signal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspendActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(parentSession);
        try {
            InstanceControl subInstanceControl;
            Collection<UUID> subInstanceIDs;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                subInstanceIDs = this.subprocessManager.getNonForkedSubprocessInstancesForLWP(subSession, ebpInstanceReference);
                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary services controlling the parent or the subprocess instances of LWP '%s'. Aborting suspend.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            for (UUID subInstanceID : subInstanceIDs) {
                try {
                    subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
                    subInstanceControl.suspendInstance(subSession, subInstanceID, this.PROPAGATE_SUSPENSION_TO_RUNNING_ACTIVITIES);
                }
                catch (InvalidInstanceStateException iise) {
                    String msg;
                    if (subInstanceIDs.size() > 1 && iise.getInstanceExecutionStatus() != null && iise.getInstanceExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_FINISHED) {
                        msg = String.format("Cannot suspend subprocess instance '%s', because it is already finished. It is part of variable parallelism and therefore no problem at all.", subInstanceID.toString());
                        this.logger.log(Level.INFO, msg);
                        continue;
                    }
                    msg = String.format("Cannot suspend subprocess instance '%s', because the instance is in state '%s' which is invalid for this operation!", subInstanceID.toString(), iise.getPreventingState());
                    this.logger.log(Level.SEVERE, msg, iise);
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void finishActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(parentSession);
        try {
            String errorMessage = String.format("Cannot finish any running subprocess instances of activity '%s'!", ebpInstanceReference.toString());
            this.logger.log(Level.SEVERE, errorMessage);
            throw new RuntimeException(errorMessage);
        }
        catch (Throwable throwable) {
            super.sessionFinished(parentSession);
            throw throwable;
        }
    }

    @Override
    public void resetActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        super.sessionActive(parentSession);
        try {
            ExecutionManager executionManager;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                executionManager = this.registry.getService(subSession, ebpInstanceReference.getExecutionManagerURIs(), ExecutionManager.class);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary service controlling the parent instance of LWP '%s'. Aborting reset.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            try {
                executionManager.getActivityStarting().resetActivity(subSession, ebpInstanceReference, false);
            }
            catch (InvalidActivityStateException iase) {
                String msg = String.format("Cannot reset LWP activity '%s' because it is in state '%s'. Continuing with this inconsistent state.", new Object[]{ebpInstanceReference, iase.getActivityState()});
                this.logger.log(Level.SEVERE, msg, iase);
            }
            catch (InvalidInstanceStateException iise) {
                String msg = String.format("Cannot reset LWP activity '%s', because the corresponding instance (parent instance) is in the state '%s' which is invalid for this operation!", ebpInstanceReference, iise.getPreventingState());
                this.logger.log(Level.SEVERE, msg, iise);
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public void abortActivity(SessionToken parentSession, EBPInstanceReference ebpInstanceReference, long timeToRespond) {
        super.sessionActive(parentSession);
        try {
            InstanceControl subInstanceControl;
            Collection<UUID> subInstanceIDs;
            SessionToken subSession = this.sessionFactory.getChildSession(parentSession, this.getURIs());
            try {
                subInstanceIDs = this.subprocessManager.getNonForkedSubprocessInstancesForLWP(subSession, ebpInstanceReference);
                subInstanceControl = this.registry.getServiceOfType(subSession, "ExecutionManager", ExecutionManager.class).getInstanceControl();
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve the necessary services controlling the parent or the subprocess instances of LWP '%s'. Aborting abort.";
                throw new InternalServiceException(String.format(msg, ebpInstanceReference), snke);
            }
            for (UUID subInstanceID : subInstanceIDs) {
                try {
                    subInstanceControl.stopAndAbortInstance(subSession, subInstanceID, this.PROPAGATE_ABORTION_TO_RUNNING_ACTIVITIES, "Instance abort due to an abort signal to the parent LWP activity.", "ADEPT2:SubprocessManager:AbortActivity", 3L);
                }
                catch (InvalidInstanceStateException iise) {
                    String msg;
                    if (subInstanceIDs.size() > 1 && iise.getInstanceExecutionStatus() != null && iise.getInstanceExecutionStatus() == ProcessConstants.InstanceExecutionStatus.IE_FINISHED) {
                        msg = String.format("Cannot abort subprocess instance '%s', because it is already finished. It is part of variable parallelism and therefore no problem at all.", subInstanceID.toString());
                        this.logger.log(Level.INFO, msg);
                        continue;
                    }
                    msg = String.format("Cannot abort subprocess instance '%s', because the instance is in state '%s' which is invalid for this operation!", subInstanceID.toString(), iise.getPreventingState());
                    this.logger.log(Level.SEVERE, msg, iise);
                }
            }
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    @Override
    public boolean isRunning(SessionToken parentSession, EBPInstanceReference ebpInstanceReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<EBPInstanceReference> getRunningActivities(SessionToken parentSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActivityState waitForTermination(SessionToken session, EBPInstanceReference activity, long timeToRespond) throws InterruptedException {
        throw new UnsupportedOperationException();
    }
}

