/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.subprocessmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.IndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.InvalidListValuedDataContainerException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.ValidationFailedException;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.DefaultIndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml.DataContainerXMLExport;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml.DataContainerXMLImport;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InstanceStatus;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class VarParTools {
    private static Schema schema;

    static Schema getIADCSchema() {
        if (schema == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schema = schemaFactory.newSchema(DataContainerXMLImport.class.getResource("types.xsd"));
            }
            catch (SAXException ex) {
                String msg = "Could not load the XML Schema for the IndexedAccessDataContainer. No validation will take place.";
                LoggerTools.getLogger(VarParTools.class).log(Level.WARNING, msg, ex);
            }
        }
        return schema;
    }

    static IndexedAccessDataContainer createIndexedDataContainer(SessionToken session, VariableParallelismEBP ebp, DataContainer parentData) throws InvalidDataContainerException {
        IndexedAccessDataContainer ret;
        Map<ProcessModelParameter, List<? extends Serializable>> inputParameterValues = VarParTools.getInputParameterValues(session, ebp, parentData);
        int branchCount = VarParTools.branchCount(inputParameterValues);
        byte[] iadc = parentData.restoreSessionState(session, DefaultIndexedAccessDataContainer.GLOBAL_SAVEPOINT);
        if (iadc != null && iadc.length > 0) {
            try {
                ret = DataContainerXMLImport.getIndexedAccessDataContainerFromBytes(iadc, VarParTools.getIADCSchema(), session, parentData);
            }
            catch (XMLFormatException xmlfe) {
                throw new InvalidDataContainerException(parentData, (Throwable)xmlfe);
            }
            catch (IOException ioe) {
                throw new InvalidDataContainerException(parentData, (Throwable)ioe);
            }
        } else {
            Set<ProcessModelParameter> outputParams = ebp.getParameters(ActivityConstants.AccessType.WRITE);
            ret = new DefaultIndexedAccessDataContainer(parentData, inputParameterValues, outputParams, branchCount);
        }
        return ret;
    }

    static Map<ProcessModelParameter, List<? extends Serializable>> getInputParameterValues(SessionToken session, VariableParallelismEBP ebp, DataContainer parentData) throws InvalidDataContainerException {
        Set<ProcessModelParameter> indexedInputParameters = ebp.getIndexedInputParameters();
        HashMap<ProcessModelParameter, List<? extends Serializable>> ret = new HashMap<ProcessModelParameter, List<? extends Serializable>>(indexedInputParameters.size());
        for (ProcessModelParameter inputParameter : indexedInputParameters) {
            String parameterName = inputParameter.getName();
            try {
                List values;
                if (parentData.isNull(session, inputParameter.getName())) {
                    values = new ArrayList(0);
                } else {
                    UDTValue listValue = parentData.retrieveUDT(session, parameterName);
                    ObjectInputStream oi = new ObjectInputStream(listValue.getValueAsStream());
                    try {
                        values = (List)oi.readObject();
                    }
                    finally {
                        oi.close();
                    }
                }
                ret.put(inputParameter, values);
            }
            catch (NoSuchParameterException nspe) {
                throw new InvalidDataContainerException(parentData, parameterName, (Throwable)nspe);
            }
            catch (InvalidDataTypeException idte) {
                throw new InvalidListValuedDataContainerException(parentData, parameterName, (Throwable)idte);
            }
            catch (IOException ioe) {
                throw new InvalidListValuedDataContainerException(parentData, parameterName, (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new InvalidListValuedDataContainerException(parentData, parameterName, (Throwable)cnfe);
            }
        }
        return ret;
    }

    static int branchCount(Map<? extends Parameter, ? extends List<?>> indexedInputParameters) {
        int longestOptional = Integer.MIN_VALUE;
        int shortestMandatory = Integer.MAX_VALUE;
        for (Map.Entry<Parameter, List<?>> input : indexedInputParameters.entrySet()) {
            if (input.getKey().isOptional()) {
                longestOptional = Math.max(input.getValue().size(), longestOptional);
                continue;
            }
            shortestMandatory = Math.min(input.getValue().size(), shortestMandatory);
        }
        return shortestMandatory < Integer.MAX_VALUE ? shortestMandatory : longestOptional;
    }

    static void initialiseDataContainer(SessionToken session, InstanceDataContainer instanceData, VariableParallelismEBP ebp, IndexedAccessDataContainer parentData, int index) throws InvalidDataContainerException {
        Set<ProcessModelParameter> indexedInputParameters = ebp.getIndexedInputParameters();
        HashSet<String> indexedInputNames = new HashSet<String>(indexedInputParameters.size());
        for (ProcessModelParameter indexedInputParameter : indexedInputParameters) {
            indexedInputNames.add(indexedInputParameter.getName());
        }
        block13: for (ProcessModelParameter inputParameter : ebp.getLightWeightProcess().getParameters(ActivityConstants.AccessType.READ)) {
            String parameterName = inputParameter.getName();
            try {
                boolean isNull = indexedInputNames.contains(parameterName) ? parentData.isNull(session, parameterName, index) : parentData.isNull(session, parameterName);
                if (isNull) {
                    instanceData.setNull(parameterName);
                    continue;
                }
                switch (inputParameter.getDataType()) {
                    case INTEGER: {
                        long value = indexedInputNames.contains(parameterName) ? parentData.retrieveInteger(session, parameterName, index) : parentData.retrieveInteger(session, parameterName);
                        instanceData.setInteger(parameterName, value);
                        continue block13;
                    }
                    case FLOAT: {
                        double value = indexedInputNames.contains(parameterName) ? parentData.retrieveFloat(session, parameterName, index) : parentData.retrieveFloat(session, parameterName);
                        instanceData.setFloat(parameterName, value);
                        continue block13;
                    }
                    case BOOLEAN: {
                        boolean value = indexedInputNames.contains(parameterName) ? parentData.retrieveBoolean(session, parameterName, index) : parentData.retrieveBoolean(session, parameterName);
                        instanceData.setBoolean(parameterName, value);
                        continue block13;
                    }
                    case STRING: {
                        String value = indexedInputNames.contains(parameterName) ? parentData.retrieveString(session, parameterName, index) : parentData.retrieveString(session, parameterName);
                        instanceData.setString(parameterName, value);
                        continue block13;
                    }
                    case DATE: {
                        Date value = indexedInputNames.contains(parameterName) ? parentData.retrieveDate(session, parameterName, index) : parentData.retrieveDate(session, parameterName);
                        instanceData.setDate(parameterName, value);
                        continue block13;
                    }
                    case URI: {
                        URI value = indexedInputNames.contains(parameterName) ? parentData.retrieveURI(session, parameterName, index) : parentData.retrieveURI(session, parameterName);
                        instanceData.setURI(parameterName, value);
                        continue block13;
                    }
                    case USERDEFINED: {
                        UDTValue value = indexedInputNames.contains(parameterName) ? parentData.retrieveUDT(session, parameterName, index) : parentData.retrieveUDT(session, parameterName);
                        instanceData.setUDT(parameterName, value);
                        continue block13;
                    }
                    default: {
                        assert (false) : inputParameter;
                        continue block13;
                    }
                }
            }
            catch (NoSuchParameterException nspe) {
                throw new InvalidDataContainerException(parentData, parameterName, (Throwable)nspe);
            }
            catch (InvalidDataTypeException idte) {
                throw new InvalidDataContainerException(parentData, parameterName, (Throwable)idte);
            }
        }
    }

    static void writeOutputValues(SessionToken session, DataContainer instanceData, VariableParallelismEBP ebp, IndexedAccessDataContainer parentData, int index, boolean validate) throws InvalidDataContainerException, ValidationFailedException, IOException, XMLFormatException {
        block12: for (ProcessModelParameter outputParameter : ebp.getLightWeightProcess().getParameters(ActivityConstants.AccessType.WRITE)) {
            String parameterName = outputParameter.getName();
            try {
                if (instanceData.ignoredValue(parameterName)) {
                    parentData.ignoredValue(parameterName, index);
                    continue;
                }
                switch (outputParameter.getDataType()) {
                    case INTEGER: {
                        long value = instanceData.storedInteger(parameterName);
                        parentData.storeInteger(session, parameterName, index, value);
                        continue block12;
                    }
                    case FLOAT: {
                        double value = instanceData.storedFloat(parameterName);
                        parentData.storeFloat(session, parameterName, index, value);
                        continue block12;
                    }
                    case BOOLEAN: {
                        boolean value = instanceData.storedBoolean(parameterName);
                        parentData.storeBoolean(session, parameterName, index, value);
                        continue block12;
                    }
                    case STRING: {
                        String value = instanceData.storedString(parameterName);
                        parentData.storeString(session, parameterName, index, value);
                        continue block12;
                    }
                    case DATE: {
                        Date value = instanceData.storedDate(parameterName);
                        parentData.storeDate(session, parameterName, index, value);
                        continue block12;
                    }
                    case URI: {
                        URI value = instanceData.storedURI(parameterName);
                        parentData.storeURI(session, parameterName, index, value);
                        continue block12;
                    }
                    case USERDEFINED: {
                        UDTValue value = instanceData.storedUDT(parameterName);
                        parentData.storeUDT(session, parameterName, index, value);
                        continue block12;
                    }
                    default: {
                        assert (false) : outputParameter;
                        continue block12;
                    }
                }
            }
            catch (NoSuchParameterException nspe) {
                throw new InvalidDataContainerException(parentData, parameterName, (Throwable)nspe);
            }
            catch (InvalidDataTypeException idte) {
                throw new InvalidDataContainerException(parentData, parameterName, (Throwable)idte);
            }
        }
        if (validate) {
            parentData.validateWrittenValues(session, index);
        }
        parentData.flush(session);
        byte[] bytes = DataContainerXMLExport.getBytesForIndexedAccessDataContainer(parentData, VarParTools.getIADCSchema());
        parentData.getWrappedDataContainer().storeSessionState(session, DefaultIndexedAccessDataContainer.GLOBAL_SAVEPOINT, bytes);
    }

    static ProcessConstants.InstanceExecutionStatus aggregateStatus(SessionToken session, List<UUID> parallels, Registry registry) throws ServiceNotKnownException {
        ProcessConstants.InstanceExecutionStatus ret = ProcessConstants.InstanceExecutionStatus.IE_FINISHED;
        block27: for (UUID parallelInstance : parallels) {
            URI[] processManagerURI = registry.getServiceOfType(session, "ExecutionManager", ExecutionManager.class).getProcessManager(session, parallelInstance);
            InstanceManager instanceManager = registry.getService(session, processManagerURI, ProcessManager.class).getInstanceManager();
            InstanceStatus status = instanceManager.getInstanceStatus(session, parallelInstance);
            block0 : switch (status.getExecutionStatus()) {
                case IE_RUNNING: {
                    return ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                }
                case IE_SUSPENDED: {
                    switch (ret) {
                        case IE_RUNNING: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                            break block0;
                        }
                        case IE_ABORTED: 
                        case IE_SOFTLY_ABORTED: 
                        case IE_FINISHED: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_SUSPENDED;
                            break block0;
                        }
                    }
                    break;
                }
                case IE_SOFTLY_SUSPENDED: {
                    switch (ret) {
                        case IE_RUNNING: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                            break block0;
                        }
                        case IE_SUSPENDED: 
                        case IE_ABORTED: 
                        case IE_SOFTLY_ABORTED: 
                        case IE_FINISHED: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_SUSPENDED;
                            break block0;
                        }
                    }
                    break;
                }
                case IE_ABORTED: {
                    switch (ret) {
                        case IE_RUNNING: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                            break block0;
                        }
                        case IE_FINISHED: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_ABORTED;
                            break block0;
                        }
                    }
                    break;
                }
                case IE_SOFTLY_ABORTED: {
                    switch (ret) {
                        case IE_RUNNING: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                            break block0;
                        }
                        case IE_ABORTED: 
                        case IE_FINISHED: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_SOFTLY_ABORTED;
                            break block0;
                        }
                    }
                    break;
                }
                case IE_FINISHED: {
                    switch (ret) {
                        case IE_RUNNING: {
                            ret = ProcessConstants.InstanceExecutionStatus.IE_RUNNING;
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    assert (false) : status;
                    continue block27;
                }
            }
        }
        return ret;
    }

    static ProcessConstants.NodeState mapToNodeState(ProcessConstants.InstanceExecutionStatus instanceExecutionStatus) {
        ProcessConstants.NodeState ret;
        switch (instanceExecutionStatus) {
            case IE_RUNNING: {
                ret = ProcessConstants.NodeState.NS_RUNNING;
                break;
            }
            case IE_SUSPENDED: 
            case IE_SOFTLY_SUSPENDED: {
                ret = ProcessConstants.NodeState.NS_SUSPENDED;
                break;
            }
            case IE_ABORTED: 
            case IE_SOFTLY_ABORTED: {
                ret = ProcessConstants.NodeState.NS_FAILED;
                break;
            }
            case IE_FINISHED: {
                ret = ProcessConstants.NodeState.NS_COMPLETED;
                break;
            }
            default: {
                assert (false) : instanceExecutionStatus;
                ret = ProcessConstants.NodeState.NS_FAILED;
            }
        }
        return ret;
    }
}

