/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.executionmanager.WorklistInteraction;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.processmanager.ProcessManager;
import de.aristaflow.adept2.core.worklistmanager.DelegationHandling;
import de.aristaflow.adept2.core.worklistmanager.DelegationManager;
import de.aristaflow.adept2.core.worklistmanager.DistributionHandling;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.WorklistAdministration;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AvailabilityManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.BroadcastDistributionHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DefaultDelegationManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DefaultEscalationManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DefaultWorklistAdministration;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DefaultWorklistNotification;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DefaultWorklistUpdateManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.DelayedUpdateHandler;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.EscalationManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.MailingClientWorklist;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.OrderedMailingClientWorklist;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.OrgModelTools;
import de.aristaflow.adept2.core.worklistmanager.storage.ClientStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistManagerStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.Worklist;
import de.aristaflow.adept2.model.worklistmodel.WorklistFilters;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultClientWorklist;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.i18n.AristaFlowBundle;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="WMAgentID", type=Property.Type.INT, isRequired=true, description="The ID of the Agent used for Authenticating the Worklist Manager."), @Property(name="WMAgentOrgPositionID", type=Property.Type.INT, isRequired=true, description="The ID of the Organisational Position used for Authenticating the Worklist Manager."), @Property(name="WMAgentPassword", type=Property.Type.STRING, isRequired=true, description="The Password  used for Authenticating the Worklist Manager."), @Property(name="FallbackWorklistAgentID", type=Property.Type.INT, isRequired=true, description="The ID of the Agent assigned to the fallback worklist."), @Property(name="FallbackWorklistOrgPositionID", type=Property.Type.INT, isRequired=true, description="The Organisational Position ID of the Agent assigned to the fallback worklist."), @Property(name="GlobalWorklistAgentID", type=Property.Type.INT, isRequired=true, description="The ID of the Agent used for Authenticating the Global Worklist Agent."), @Property(name="GlobalWorklistOrgPositionID", type=Property.Type.INT, isRequired=true, description="The ID of the Organisational Position used for Authenticating the Global Worklist Agent."), @Property(name="SupervisorWorklistAgentID", type=Property.Type.INT, isRequired=true, description="The ID of the Agent used for Authenticating the Supervisor Worklist Agent."), @Property(name="SupervisorWorklistOrgPositionID", type=Property.Type.INT, isRequired=true, description="The ID of the Organisational Position used for Authenticating the Supervisor Worklist Agent."), @Property(name="maximumDelegationLevel", type=Property.Type.INT, defaultValue="1000", description="Maximum Delegation Level to Prevent loop Delegation"), @Property(name="defaultDelegationRecipients", type=Property.Type.STRING, defaultValue="OrgPosition(ID=%i:orgPositionID%).getOrgUnit().getOrgPositions()", description="Staff Assignment Rule for Default Delegation Recipients"), @Property(name="globalWorklistDelegationRecipients", type=Property.Type.STRING, defaultValue="Agent()", description="Staff Assignment Rule for Default Delegation Recipients in case the Delegating Agent is the Global Worklist Agent"), @Property(name="fallbackWorklistDelegationRecipients", type=Property.Type.STRING, defaultValue="Agent()", description="Staff Assignment Rule for Default Delegation Recipients in case the Delegating Agent is the Fallback Worklist Agent"), @Property(name="supervisorWorklistDelegationRecipients", type=Property.Type.STRING, defaultValue="Agent()", description="Staff Assignment Rule for Default Delegation Recipients in case the Delegating Agent is the Supervisor Agent"), @Property(name="WorklistConnectionRetryCount", type=Property.Type.INT, defaultValue="3", description="Maximum Number of retries if a connection to the Client fails"), @Property(name="UpdateRequestCoreThreadCount", type=Property.Type.INT, defaultValue="20", description="Number of Core Threads used for processing update Requests"), @Property(name="UpdateRequestQueueSize", type=Property.Type.INT, defaultValue="1000", description="Size of the Update Request Queue"), @Property(name="UpdateRequestMaxThreadCount", type=Property.Type.INT, defaultValue="2147483647", description="Maximum Number of Threads used for processing update Requests"), @Property(name="TestMode", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether the Worklist Manager should be started in testmode. When in test mode, "), @Property(name="distributionHandlingID", type=Property.Type.STRING, defaultValue="Broadcast", description="The ID of the Distribution Handling used by Default"), @Property(name="delegationHandlingID", type=Property.Type.STRING, description="The ID of the Delegation Handling used by Default"), @Property(name="escalationProcedureID", type=Property.Type.STRING, description="The ID of the Escalation Procedure used by Default"), @Property(name="possibleAbsentees", type=Property.Type.STRING, defaultValue="Agent(id=%i:agentID%).getOrgPositions(id=%i:orgPositionID%).getOrgUnit()", description="Staff Assignment Rule to determine which worklists the user is allowed to set absent."), @Property(name="possibleAbsenteesGlobalWorklistAgent", type=Property.Type.STRING, defaultValue="Agent()", description="Configuration Constant for Possible Absentees Staff assignment Rule for the global worklist agent."), @Property(name="possibleAbsenteesFallbackWorklistAgent", type=Property.Type.STRING, defaultValue="Agent()", description="Configuration Constant for Possible Absentees Staff assignment Rule for the fallback worklist agent."), @Property(name="possibleAbsenteesSupervisorWorklistAgent", type=Property.Type.STRING, defaultValue="Agent()", description="Configuration Constant for Possible Absentees Staff assignment Rule for the supervisor."), @Property(name="AgentValidPredicate", type=Property.Type.STRING, defaultNull=true, description="The predicate as part of a staff assignment rule to whether a specific agent is valid. The resulting rule will look like Agent(ID=%id% & (%predicate%)). If no predicate is provided (the default) only the presence of the agent in the OM will be considererd."), @Property(name="mailNotification.subject", type=Property.Type.STRING, description="Text used as Subject for Notification Mails"), @Property(name="mailNotification.body", type=Property.Type.STRING, description="Text used as Body for Notification Mails"), @Property(name="mailNotification.itemText", type=Property.Type.STRING, description="Text used for each Item for Notification Mails"), @Property(name="UseOrderedMailNotification", type=Property.Type.BOOLEAN, defaultValue="true", description="Whether to used the extended mailing worklist ordering items by their status."), @Property(name="OrderedMailNotification.Subject", type=Property.Type.STRING, defaultValue="Worklist for %s:agentUserName% (%s:orgPositionName%)", description="The parameterised subject used for the ordering mailing worklist."), @Property(name="OrderedMailNotification.Body", type=Property.Type.STRING, defaultValue="Worklist for %s:agentUserName% (%s:orgPositionName%)\n at %s:currentTime%\n%s:items%\n%i:itemsAdded% items added\\, %i:itemsChanged% items changed\\, %i:itemsRemoved% items removed from worklist update %i:sourceRevision% to %i:revision%.", description="The parameterised text for the mail body of the ordering mailing worklist."), @Property(name="OrderedMailNotification.ItemText", type=Property.Type.STRING, defaultValue="%s:title% (%s:individualTitle%)\\, %s:processInstanceName%\\, %s:processTemplateName%\n  available since %s:activationDate% %s:dueDateLine% %s:delegationLine% %s:enquiryLine% %s:replyLine%\n\n|", description="The parameterised text for one worklist item used of the ordering mailing worklist."), @Property(name="OrderedMailNotification.AddedItemsHeader", type=Property.Type.STRING, defaultValue="|\n---- Added items ----", description="The (non-parameterised) subheading for added worklist items used by the ordering mailing worklist."), @Property(name="OrderedMailNotification.ChangedItemsHeader", type=Property.Type.STRING, defaultValue="|\n---- Changed items ----", description="The (non-parameterised) subheading for changed worklist items used by the ordering mailing worklist."), @Property(name="OrderedMailNotification.RemovedItemsHeader", type=Property.Type.STRING, defaultValue="|\n---- Removed items ----", description="The (non-parameterised) subheading for removed worklist items used by the ordering mailing worklist."), @Property(name="OrderedMailNotification.UnchangedItemsHeader", type=Property.Type.STRING, defaultValue="|\n---- Unchanged items ----", description="The (non-parameterised) subheading for unchanged worklist items used by the ordering mailing worklist."), @Property(name="OrderedMailNotification.DueDateText", type=Property.Type.STRING, defaultValue="|\n  due at %s:dueDate%", description="The parameterised text for the due date of a worklist item of the ordering mailing worklist. This will only be used if the worklist item has a due date."), @Property(name="OrderedMailNotification.DelegationText", type=Property.Type.STRING, defaultValue="|\n  delegated by %s:delegation.agentUserName% (%s:delegation.orgPositionName%): %s:delegation.comment%|", description="The parameterised text for the due date of a worklist item of the ordering mailing worklist. This will only be used if the worklist item has a due date."), @Property(name="OrderedMailNotification.EnquiryText", type=Property.Type.STRING, defaultValue="|\n  enquired by %s:currentEnquiry.originator.agentUserName% (%s:currentEnquiry.originator.orgPositionName%): %s:currentEnquiry.question%|", description="The parameterised text for the due date of a worklist item of the ordering mailing worklist. This will only be used if the worklist item has a due date."), @Property(name="OrderedMailNotification.ReplyText", type=Property.Type.STRING, defaultValue="|\n  replied by %s:repliedEnquiry.replier.agentUserName% (%s:repliedEnquiry.replier.orgPositionName%):\n    %s:repliedEnquiry.question%\n    %s:repliedEnquiry.reply%|", description="The parameterised text for the due date of a worklist item of the ordering mailing worklist. This will only be used if the worklist item has a due date.")})
public abstract class AbstractWorklistManager
extends AbstractADEPT2Service
implements WorklistManager {
    protected static final String CFG_WM_AGENT = "WMAgentID";
    protected static final String CFG_WM_ORG_POSITION = "WMAgentOrgPositionID";
    protected static final String CFG_WM_PASSWORD = "WMAgentPassword";
    protected static final String CFG_FALLBACK_WORKLIST_AGENT_ID = "FallbackWorklistAgentID";
    protected static final String CFG_FALLBACK_WORKLIST_ORGPOSITION_ID = "FallbackWorklistOrgPositionID";
    protected static final String CFG_GLOBAL_WORKLIST_AGENT_ID = "GlobalWorklistAgentID";
    protected static final String CFG_GLOBAL_WORKLIST_ORGPOSITION_ID = "GlobalWorklistOrgPositionID";
    protected static final String CFG_SUPERVISOR_WORKLIST_AGENT_ID = "SupervisorWorklistAgentID";
    protected static final String CFG_SUPERVISOR_WORKLIST_ORGPOSITION_ID = "SupervisorWorklistOrgPositionID";
    protected static final String CFG_UPDATE_REQUEST_MAX_THREAD_COUNT = "UpdateRequestMaxThreadCount";
    protected static final String CFG_UPDATE_REQUEST_CORE_THREAD_COUNT = "UpdateRequestCoreThreadCount";
    protected static final String CFG_UPDATE_REQUEST_QUEUE_SIZE = "UpdateRequestQueueSize";
    protected static final String CFG_UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES = "WorklistConnectionRetryCount";
    public static final String CFG_MAILNOTIFICATION_SUBJECT = "mailNotification.subject";
    public static final String CFG_MAILNOTIFICATION_BODY = "mailNotification.body";
    public static final String CFG_MAILNOTIFICATION_ITEM_TEXT = "mailNotification.itemText";
    protected static final String CFG_TEST_MODE = "TestMode";
    protected static final String CFG_AGENT_VALID_PREDICATE = "AgentValidPredicate";
    protected static final String CONF_USE_ORDERED_MAILING_WORKLIST = "UseOrderedMailNotification";
    protected final boolean USE_ORDERED_MAILING_WORKLIST;
    protected static final String ORDERED_MAILING_WORKLIST_PREFIX = "OrderedMailNotification";
    private final int WM_AGENT;
    private final int WM_ORG_POSITION;
    private final String WM_PASSWORD;
    private final int FALLBACK_WORKLIST_AGENT_ID;
    private final int FALLBACK_WORKLIST_ORGPOSITION_ID;
    private final int GLOBAL_WORKLIST_AGENT_ID;
    private final int GLOBAL_WORKLIST_ORGPOSITION_ID;
    private final int SUPERVISOR_WORKLIST_AGENT_ID;
    private final int SUPERVISOR_WORKLIST_ORGPOSITION_ID;
    private final int UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES;
    private final int UPDATE_REQUEST_CORE_THREAD_COUNT;
    private final int UPDATE_REQUEST_QUEUE_SIZE;
    private final int UPDATE_REQUEST_MAX_THREAD_COUNT;
    private final String PRESENT_PREDICATE;
    final String MAIL_SUBJECT;
    final String MAIL_BODY;
    final String MAIL_ITEM_TEXT;
    private final boolean TEST_MODE;
    private DefaultWorklistAdministration worklistAdministration;
    protected DelegationManager delegationManager;
    private DefaultWorklistUpdateManager worklistUpdateManager;
    protected DefaultWorklistNotification worklistNotification;
    private OrgModelManager orgModelManager;
    private ExecutionManager executionManager;
    private WorklistManagerStorage storage;
    private DelayedUpdateHandler delayedUpdateHandler;
    private final ExecutorService updateExecutor;
    private DefaultEscalationManager escalationManager;
    private final AvailabilityManager availabilityManager;
    private QualifiedAgent fallbackWorklistAgent;
    private UUID fallbackWorklistID;
    private QualifiedAgent globalWorklistAgent;
    private UUID globalWorklistID;
    private QualifiedAgent supervisorWorklistAgent;
    private UUID supervisorWorklistID;
    private WorklistModelFactory worklistModelFactory;
    private FilterFactory filterFactory;
    protected final Configuration configuration;

    public AbstractWorklistManager(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, new String[]{"OrgModelManager", "ExecutionManager", "ProcessManager"}, new String[0]);
        this.configuration = configuration;
        this.USE_ORDERED_MAILING_WORKLIST = configuration.getBoolean(CONF_USE_ORDERED_MAILING_WORKLIST);
        this.WM_AGENT = configuration.getInt(CFG_WM_AGENT);
        this.WM_ORG_POSITION = configuration.getInt(CFG_WM_ORG_POSITION);
        try {
            this.WM_PASSWORD = ConfigurationTools.parsePassword(configuration, CFG_WM_PASSWORD);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("The password could not be parsed! Maybe it is not set.", e);
        }
        this.FALLBACK_WORKLIST_AGENT_ID = configuration.getInt(CFG_FALLBACK_WORKLIST_AGENT_ID);
        this.FALLBACK_WORKLIST_ORGPOSITION_ID = configuration.getInt(CFG_FALLBACK_WORKLIST_ORGPOSITION_ID);
        this.GLOBAL_WORKLIST_AGENT_ID = configuration.getInt(CFG_GLOBAL_WORKLIST_AGENT_ID);
        this.GLOBAL_WORKLIST_ORGPOSITION_ID = configuration.getInt(CFG_GLOBAL_WORKLIST_ORGPOSITION_ID);
        this.SUPERVISOR_WORKLIST_AGENT_ID = configuration.getInt(CFG_SUPERVISOR_WORKLIST_AGENT_ID);
        this.SUPERVISOR_WORKLIST_ORGPOSITION_ID = configuration.getInt(CFG_SUPERVISOR_WORKLIST_ORGPOSITION_ID);
        this.UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES = configuration.getInt(CFG_UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES);
        this.UPDATE_REQUEST_CORE_THREAD_COUNT = configuration.getInt(CFG_UPDATE_REQUEST_CORE_THREAD_COUNT);
        this.UPDATE_REQUEST_QUEUE_SIZE = configuration.getInt(CFG_UPDATE_REQUEST_QUEUE_SIZE);
        this.UPDATE_REQUEST_MAX_THREAD_COUNT = configuration.getInt(CFG_UPDATE_REQUEST_MAX_THREAD_COUNT);
        this.MAIL_SUBJECT = configuration.getString(CFG_MAILNOTIFICATION_SUBJECT);
        this.MAIL_BODY = configuration.getString(CFG_MAILNOTIFICATION_BODY);
        this.MAIL_ITEM_TEXT = configuration.getString(CFG_MAILNOTIFICATION_ITEM_TEXT);
        this.TEST_MODE = configuration.getBoolean(CFG_TEST_MODE);
        String presentPredicate = configuration.getString(CFG_AGENT_VALID_PREDICATE);
        this.PRESENT_PREDICATE = presentPredicate == null || presentPredicate.length() <= 0 ? "Agent(ID=%s)" : String.format("Agent(ID=%%s & (%s))", presentPredicate);
        this.updateExecutor = new ThreadPoolExecutor(this.UPDATE_REQUEST_CORE_THREAD_COUNT, this.UPDATE_REQUEST_MAX_THREAD_COUNT, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.UPDATE_REQUEST_QUEUE_SIZE), new Adept2ThreadFactory("WorklistManager.UpdateExecutor", 128L));
        this.availabilityManager = new AvailabilityManager(this, "WorklistManager.AvailablilityScheduler");
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs, this.WM_AGENT, this.WM_ORG_POSITION, this.WM_PASSWORD);
        SessionToken initSession = this.sessionFactory.getSessionToken(myURIs);
        this.worklistModelFactory = this.registry.getModelFactory("WorklistModelFactory", WorklistModelFactory.class);
        this.filterFactory = this.registry.getModelFactory("FilterFactory", FilterFactory.class);
        this.storage = this.createStorageFacility(initSession, this.configuration);
        this.worklistAdministration = new DefaultWorklistAdministration(this);
        this.delegationManager = new DefaultDelegationManager(this.configuration, this);
        this.worklistUpdateManager = new DefaultWorklistUpdateManager(this.configuration, this);
        this.worklistNotification = new DefaultWorklistNotification(this.configuration, this);
        this.delayedUpdateHandler = new DelayedUpdateHandler("WorklistManager.DelayedTaskExecutor", this.storage.getWorklistStorage());
        this.escalationManager = new DefaultEscalationManager(this);
        initSession = this.sessionFactory.getSessionToken(myURIs);
        this.orgModelManager = this.registry.getServiceOfType(initSession, "OrgModelManager", OrgModelManager.class);
        try {
            this.fallbackWorklistAgent = this.getQualifiedAgentFor(this.FALLBACK_WORKLIST_AGENT_ID, this.FALLBACK_WORKLIST_ORGPOSITION_ID);
        }
        catch (OrgModelException e) {
            String msg = "An OrgModelException occured while validating the configured agent for the fallback worklist!";
            throw new InternalServiceException(msg, e);
        }
        catch (PolicyResolutionException e) {
            String msg = "A PolicyResolutionException occured while validating the configured agent for the fallback worklist!";
            throw new InternalServiceException(msg, e);
        }
        catch (DataSourceException e) {
            String msg = "A DataSourceException occured while validating the configured agent for the fallback worklist!";
            throw new InternalServiceException(msg, e);
        }
        try {
            this.fallbackWorklistID = this.createWorklistForAgent(this.fallbackWorklistAgent, null);
        }
        catch (DataSourceException ex) {
            throw new InternalServiceException("Could not create Fallback Worklist", ex);
        }
        try {
            this.globalWorklistAgent = this.getQualifiedAgentFor(this.GLOBAL_WORKLIST_AGENT_ID, this.GLOBAL_WORKLIST_ORGPOSITION_ID);
        }
        catch (OrgModelException e) {
            String msg = "An OrgModelException occured while validating the configured agent for the global worklist!";
            throw new InternalServiceException(msg, e);
        }
        catch (PolicyResolutionException e) {
            String msg = "A PolicyResolutionException occured while validating the configured agent for the global worklist!";
            throw new InternalServiceException(msg, e);
        }
        catch (DataSourceException e) {
            String msg = "A DataSourceException occured while validating the configured agent for the global worklist!";
            throw new InternalServiceException(msg, e);
        }
        try {
            this.globalWorklistID = this.createWorklistForAgent(this.globalWorklistAgent, null);
        }
        catch (DataSourceException ex) {
            throw new InternalServiceException("Could not create Global Worklist!", ex);
        }
        try {
            this.supervisorWorklistAgent = this.getQualifiedAgentFor(this.SUPERVISOR_WORKLIST_AGENT_ID, this.SUPERVISOR_WORKLIST_ORGPOSITION_ID);
        }
        catch (OrgModelException e) {
            String msg = "An OrgModelException occured while validating the configured agent for the Supervisor worklist!";
            throw new InternalServiceException(msg, e);
        }
        catch (PolicyResolutionException e) {
            String msg = "A PolicyResolutionException occured while validating the configured agent for the Supervisor worklist!";
            throw new InternalServiceException(msg, e);
        }
        catch (DataSourceException e) {
            String msg = "A DataSourceException occured while validating the configured agent for the Supervisor worklist!";
            throw new InternalServiceException(msg, e);
        }
        try {
            this.supervisorWorklistID = this.createWorklistForAgent(this.supervisorWorklistAgent, null);
        }
        catch (DataSourceException ex) {
            throw new InternalServiceException("Could not create Supervisor Worklist!", ex);
        }
        this.worklistAdministration.init();
    }

    private QualifiedAgent getQualifiedAgentFor(long agentID, long orgPositionID) throws PolicyResolutionException, OrgModelException, DataSourceException {
        String initiatorPolicy = String.format("OrgPosition(id=%s).getAgents(id=%s)", orgPositionID, agentID);
        SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
        Set<QualifiedAgent> resolvePolicy = this.getOrgModelManager().getPolicyResolution().resolvePolicy(session, initiatorPolicy);
        if (resolvePolicy.size() == 0) {
            String msg = "Agent ID, Org. Position ID and/or their relation does not exist!";
            throw new OrgModelException(msg);
        }
        return resolvePolicy.iterator().next();
    }

    protected abstract WorklistManagerStorage createStorageFacility(SessionToken var1, Configuration var2) throws ConfigurationException, ServiceNotKnownException;

    @Override
    public void start() throws AbortServiceException {
        SessionToken startSession = this.getSessionFactory().getSessionToken(this.getURIs());
        this.executionManager = this.registry.getServiceOfType(startSession, "ExecutionManager", ExecutionManager.class);
        WorklistInteraction worklistInteraction = this.executionManager.getWorklistInteraction();
        worklistInteraction.addWorklistManager(startSession, this.worklistNotification);
        this.worklistAdministration.start();
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        SessionToken shutdownSession = this.getSessionFactory().getSessionToken(this.getURIs());
        if (this.executionManager != null) {
            this.executionManager.getWorklistInteraction().removeWorklistManager(shutdownSession, this.worklistNotification);
        }
        this.worklistNotification.emergencyShutdown();
        this.delayedUpdateHandler.shutdown();
        this.updateExecutor.shutdownNow();
        try {
            if (!this.updateExecutor.awaitTermination(20000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Scheduler didn't terminate in time.");
            }
        }
        catch (InterruptedException interruptedException) {}
        this.escalationManager.shutdown();
        this.availabilityManager.shutdown();
        this.worklistAdministration.emergencyShutdown();
        this.orgModelManager = null;
        this.executionManager = null;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        SessionToken shutdownSession = this.getSessionFactory().getSessionToken(this.getURIs());
        if (this.executionManager != null) {
            this.executionManager.getWorklistInteraction().removeWorklistManager(shutdownSession, this.worklistNotification);
        }
        this.worklistNotification.shutdown();
        this.delayedUpdateHandler.shutdown();
        this.updateExecutor.shutdownNow();
        try {
            if (!this.updateExecutor.awaitTermination(20000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Scheduler didn't terminate in time.");
            }
        }
        catch (InterruptedException interruptedException) {}
        this.escalationManager.shutdown();
        this.availabilityManager.shutdown();
        this.worklistAdministration.shutdown();
        this.orgModelManager = null;
        this.executionManager = null;
    }

    @Override
    public UUID logon(SessionToken session) {
        this.sessionActive(session);
        try {
            UUID uUID = this.createWorklistForAgent(this.checkAndGetTopLevelAgent(session), session.getCallingComponent());
            return uUID;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not logon Agent!", e);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void logoff(SessionToken session, boolean longterm) {
        this.sessionActive(session);
        try {
            this.logoffAgent(this.checkAndGetTopLevelAgent(session), session.getCallingComponent(), longterm);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Map<String, String> getWorklistConfiguration(SessionToken session, UUID worklistID) {
        Map<String, String> result;
        this.sessionActive(session);
        try {
            try {
                result = this.getWorklistStorage().getWorklistConfiguration(worklistID);
            }
            catch (DataSourceException e) {
                this.logger.log(Level.SEVERE, "DataSource Exception while accessing Worklist Configuration", e);
                throw new InternalServiceException("DataSource Exception while accessing Worklist Configuration", e);
            }
        }
        finally {
            this.sessionFinished(session);
        }
        return result;
    }

    @Override
    public void setWorklistConfiguration(SessionToken session, UUID worklistID, Map<String, String> worklistConfiguration) {
        this.sessionActive(session);
        try {
            try {
                this.getWorklistStorage().setWorklistConfiguration(worklistID, worklistConfiguration);
            }
            catch (DataSourceException e) {
                this.logger.log(Level.SEVERE, "DataSource Exception while accessing Worklist Configuration", e);
                throw new InternalServiceException("DataSource Exception while accessing Worklist Configuration", e);
            }
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public WorklistAdministration getAdministration() {
        return this.worklistAdministration;
    }

    @Override
    public DelegationManager getDelegationManager() {
        return this.delegationManager;
    }

    @Override
    public URI[] getOrgModelManager(SessionToken session) {
        this.sessionActive(session);
        try {
            URI[] uRIArray = this.getOrgModelManager().getURIs();
            return uRIArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public DefaultWorklistUpdateManager getWorklistUpdateManager() {
        return this.worklistUpdateManager;
    }

    @Override
    protected boolean isActive() {
        return super.isActive();
    }

    protected OrgModelManager getOrgModelManager() {
        return this.orgModelManager;
    }

    protected WorklistManagerStorage getWorklistManagerStorage() {
        return this.storage;
    }

    protected WorklistStorage getWorklistStorage() {
        return this.storage.getWorklistStorage();
    }

    protected WorklistItemStorage getWorklistItemStorage() {
        return this.storage.getWorklistItemStorage();
    }

    protected ClientStorage getClientStorage() {
        return this.storage.getClientStorage();
    }

    @Override
    public SessionFactory getSessionFactory() {
        return super.getSessionFactory();
    }

    protected DelayedUpdateHandler getDelayedUpdateHandler() {
        return this.delayedUpdateHandler;
    }

    protected EscalationManager getEscalationManager() {
        return this.escalationManager;
    }

    public AvailabilityManager getAvailabilityManager() {
        return this.availabilityManager;
    }

    protected InstanceManager getInstanceManager(SessionToken session) {
        return this.getProcessManager(session).getInstanceManager();
    }

    protected ProcessManager getProcessManager(SessionToken session) {
        super.sessionActive(session);
        try {
            ProcessManager processManager = this.registry.getServiceOfType(session, "ProcessManager", ProcessManager.class);
            return processManager;
        }
        catch (ServiceNotKnownException snke) {
            throw new RTServiceNotKnownException(snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected SessionToken getChildSession(SessionToken session) {
        return this.getSessionFactory().getChildSession(session, this.getURIs());
    }

    protected SessionToken getSessionToken() {
        return this.getSessionFactory().getSessionToken(this.getURIs());
    }

    public QualifiedAgent checkAndGetTopLevelAgent(SessionToken parentSession) {
        super.sessionActive(parentSession);
        try {
            QualifiedAgent qualifiedAgent = this.getSessionFactory().checkAndGetTopLevelAgent(parentSession);
            return qualifiedAgent;
        }
        catch (SecurityTokenIntegrityException e) {
            throw new ServiceAccessControlException("The agent could not be retrieved from the session token!", e);
        }
        finally {
            super.sessionFinished(parentSession);
        }
    }

    protected UUID getFallbackWorklistID() {
        return this.fallbackWorklistID;
    }

    protected UUID getGlobalWorklistID() {
        return this.globalWorklistID;
    }

    protected UUID getSupervisorWorklistID() {
        return this.supervisorWorklistID;
    }

    protected UUID createWorklistForAgent(QualifiedAgent qualifiedAgent, URI[] clientURIs) throws DataSourceException {
        UUID worklistID = this.getWorklistStorage().getWorklistID(qualifiedAgent);
        if (worklistID == null) {
            long revision = 0L;
            HashMap<String, String> userAttributes = new HashMap<String, String>();
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().createInternalWorklist(qualifiedAgent, revision, userAttributes);
            if (clientURIs != null) {
                this.getClientStorage().addClientURIsToAgent(qualifiedAgent, clientURIs);
            }
            return worklist.getID();
        }
        if (clientURIs != null) {
            this.getClientStorage().addClientURIsToAgent(qualifiedAgent, clientURIs);
        }
        return worklistID;
    }

    protected void logoffAgent(QualifiedAgent qualifiedAgent, URI[] clientURIs, boolean longterm) {
        try {
            UUID worklistID;
            boolean clientsRemaining = this.getClientStorage().removeClientURIsFromAgent(qualifiedAgent, clientURIs, longterm);
            if (!clientsRemaining && longterm && (worklistID = this.getWorklistStorage().getWorklistID(qualifiedAgent)) == null) {
                return;
            }
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Failed to logoff Agent!", e);
        }
    }

    protected UUID getWorklistID(QualifiedAgent qualifiedAgent) throws DataSourceException {
        UUID worklistID = this.getWorklistStorage().getWorklistID(qualifiedAgent);
        if (worklistID == null) {
            return this.createWorklistForAgent(qualifiedAgent, null);
        }
        return worklistID;
    }

    public void asyncNotifyClientsAboutUpdate(InternalWorklist<InternalWorklistItem> worklist) {
        this.logger.finer(String.format("Notifying client of worklist %s about updates", worklist.getID()));
        Map<ClientWorklist, Long> updateableClientWorklists = worklist.getUpdateableClientWorklists();
        if (updateableClientWorklists.size() > 0) {
            for (Map.Entry<ClientWorklist, Long> clientWorklist : updateableClientWorklists.entrySet()) {
                ClientWorklistUpdateRunnable updateRunnable = new ClientWorklistUpdateRunnable(worklist, clientWorklist.getKey(), clientWorklist.getValue());
                try {
                    this.updateExecutor.execute(updateRunnable);
                }
                catch (RejectedExecutionException e) {
                    this.logger.log(Level.SEVERE, "Update Executor Rejected new Update!\nPlease have a look at the Update Request Configuration (e.g. increase UpdateRequestMaxThreadCount)", e);
                }
            }
        }
    }

    public void asyncNotifyClientAboutUpdate(InternalWorklist<InternalWorklistItem> worklist, ClientWorklist clientWorklist) {
        Long clientWorklistID = worklist.getUpdateableClientWorklists().get(clientWorklist);
        ClientWorklistUpdateRunnable updateRunnable = new ClientWorklistUpdateRunnable(worklist, clientWorklist, clientWorklistID);
        try {
            this.updateExecutor.execute(updateRunnable);
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.SEVERE, "Update Executor Rejected new Update!\nPlease have a look at the Update Request Configuration (e.g. increase UpdateRequestMaxThreadCount)", e);
        }
    }

    protected void updateAndNotifyGlobalWorklist(InternalWorklistItem worklistItem) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> globalWorklist = this.getWorklistStorage().getInternalWorklistReadonly(this.getGlobalWorklistID());
        globalWorklist.updateWorklistItem(worklistItem);
        this.asyncNotifyClientsAboutUpdate(globalWorklist);
    }

    public void notifyWorklistsAboutUpdate(InternalWorklistItem worklistItem) throws DataSourceException {
        this.logger.finer(String.format("Notifying worklist of item %s", worklistItem.getID()));
        UUID[] uUIDArray = worklistItem.getWorklistIDs();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistID = uUIDArray[n2];
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
            worklist.updateWorklistItem(worklistItem);
            this.asyncNotifyClientsAboutUpdate(worklist);
            ++n2;
        }
    }

    protected void notifyClientAboutUpdate(InternalWorklist<InternalWorklistItem> worklist, ClientWorklist clientWorklist, long clientWorklistID) {
        try {
            boolean retryConnection;
            int connectionRetry = 0;
            do {
                try {
                    this.notifyClientAboutUpdate(worklist, clientWorklist);
                    retryConnection = false;
                }
                catch (ServiceConnectionException e) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.logger.log(Level.INFO, "Aborting client worklist update. Reason: Shutting Down!");
                        retryConnection = false;
                        continue;
                    }
                    if (connectionRetry < this.UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES) {
                        retryConnection = worklist.getUpdateableClientWorklists().containsValue(clientWorklistID);
                        if (!retryConnection) continue;
                        this.logger.log(Level.INFO, String.format("Couldn't update the Client Worklist because the connection failed. %d retries left", this.UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES - ++connectionRetry), e);
                        continue;
                    }
                    this.logger.log(Level.INFO, String.format("Removing client worklist after %d retries!", this.UPDATE_REQUEST_MAXIMUM_CONNECTION_RETRIES), e);
                    SessionToken session = this.getSessionFactory().getSessionToken(this.getURIs());
                    try {
                        this.clientWorklistTimedOut(session, worklist.getID(), clientWorklistID);
                    }
                    catch (DataSourceException e1) {
                        this.logger.log(Level.WARNING, "Could not remove dead worklist due to DataSourceException", e1);
                    }
                    catch (LockException e1) {
                        this.logger.log(Level.WARNING, "Could not remove dead worklist due to LockException", e1);
                    }
                    retryConnection = false;
                }
            } while (retryConnection);
        }
        catch (IllegalStateException e) {
            this.logger.log(Level.INFO, "Couldn't update the Client Worklist because the Update was outdated!", e);
        }
        catch (IllegalArgumentException e) {
            this.logger.log(Level.SEVERE, "Couldn't update Client Worklist '" + clientWorklist.getID() + "' because it doesn't belong to the Internal Worklist '" + worklist.getID() + "'", e);
        }
    }

    protected void clientWorklistTimedOut(SessionToken session, UUID worklistID, long clientWorklistID) throws DataSourceException, LockException {
        this.sessionActive(session);
        try {
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getAndLockInternalWorklist(session, worklistID);
            try {
                worklist.removeUpdateableClientWorklist(clientWorklistID);
                this.getWorklistStorage().updateInternalWorklist(session, worklist);
            }
            finally {
                this.getWorklistStorage().unlockInternalWorklist(session, worklistID);
            }
        }
        finally {
            this.sessionFinished(session);
        }
    }

    protected void notifyClientAboutUpdate(InternalWorklist<InternalWorklistItem> worklist, ClientWorklist clientWorklist) {
        boolean retryUpdate;
        this.logger.fine(String.format("Sending update from internal worklist '%s' (revision %d) to client worklist '%s' (revision %d).", worklist.getID(), worklist.getRevision(), clientWorklist.getID(), clientWorklist.getRevision()));
        int tries = 0;
        WorklistUpdateConfiguration wuc = clientWorklist.getWorklistUpdateConfiguration();
        int updateModeThreshold = wuc.getUpdateModeThreshold();
        do {
            WorklistUpdate updates;
            if ((updates = worklist.getUpdates(clientWorklist.getRevision(), wuc.getWorklistFilter())).getItemUpdates().size() == 0 && updates.getSourceRevision() != 0L) {
                retryUpdate = false;
                this.logger.finer(String.format("Updates from internal worklist '%s' to client worklist '%s' was empty. Skipping it.", worklist.getID(), clientWorklist.getID()));
                continue;
            }
            int maxPriority = updates.getMaxPriority();
            this.logger.finest(String.format("Maximum priority of updates from internal worklist '%s' to client worklist '%s' is %d, the threshold is %d.", worklist.getID(), clientWorklist.getID(), maxPriority, updateModeThreshold));
            if (maxPriority >= updateModeThreshold) {
                long interval = clientWorklist.getWorklistUpdateConfiguration().getUpdateInterval(maxPriority);
                if (interval == 0L) {
                    try {
                        this.logger.info("Pushing update to Worklist");
                        this.delayedUpdateHandler.cancelUpdate(clientWorklist);
                        clientWorklist.updateWorklist(updates);
                        retryUpdate = false;
                    }
                    catch (IllegalStateException e) {
                        this.logger.log(Level.INFO, "Couldn't update the Client Worklist because the Update was outdated!", e);
                        if (Thread.currentThread().isInterrupted()) {
                            this.logger.log(Level.INFO, "Aborting client worklist update. Reason: Shutting Down!");
                            retryUpdate = false;
                            continue;
                        }
                        if (clientWorklist.getRevision() >= updates.getTargetRevision()) {
                            retryUpdate = false;
                            continue;
                        }
                        if (tries++ >= 5) {
                            throw e;
                        }
                        retryUpdate = true;
                    }
                    continue;
                }
                if (interval < 0L) {
                    this.logger.log(Level.WARNING, String.format("WorklistUpdateConfiguration indicates PUSH for Priority '%d' but the update intervall indicates PULL. Assuming PULL for now. Please check the Configuration!", maxPriority));
                    retryUpdate = false;
                    continue;
                }
                this.logger.info(String.format("Delaying update for %d ms.", interval));
                this.delayedUpdateHandler.scheduleUpdate(interval, clientWorklist);
                retryUpdate = false;
                continue;
            }
            retryUpdate = false;
        } while (retryUpdate);
    }

    protected void distribute(SessionToken session, InternalWorklistItem worklistItem, String staffAssignmentRule) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        Set<QualifiedAgent> possibleAgents;
        try {
            possibleAgents = OrgModelTools.resolveStaffAssignmentRule(this.getChildSession(session), this.getOrgModelManager(), staffAssignmentRule);
        }
        catch (DataSourceException e) {
            String msg;
            if (worklistItem.getActivityReference() instanceof ADEPT2EBPReference) {
                ADEPT2EBPReference ebpRef = (ADEPT2EBPReference)worklistItem.getActivityReference();
                msg = "A DataSourceException occured while trying to resolve the Staff Assignment Rule at node #%d in instance '%s'!";
                msg = String.format(msg, ebpRef.getNodeID(), ebpRef.getInstanceID());
            } else {
                msg = "A DataSourceException occured while trying to resolve a Staff Assignment Rule!";
            }
            this.logger.log(Level.SEVERE, msg, e);
            this.escalateToInstanceSupervisor(this.getChildSession(session), worklistItem, "Staff Assignment Rule not resolveable! (See log for details)");
            return;
        }
        catch (PolicyResolutionException e) {
            if (this.TEST_MODE && staffAssignmentRule.trim().length() == 0) {
                String msg;
                if (worklistItem.getActivityReference() instanceof ADEPT2EBPReference) {
                    ADEPT2EBPReference ebpRef = (ADEPT2EBPReference)worklistItem.getActivityReference();
                    msg = "Ignoring blank Staff Assignment Rule at node #%d in instance '%s'.";
                    msg = String.format(msg, ebpRef.getNodeID(), ebpRef.getInstanceID());
                } else {
                    msg = "Ignoring blank Staff Assignment Rule.";
                }
                this.logger.info(msg);
            } else {
                String msg;
                Level level;
                Level level2 = level = this.TEST_MODE ? Level.INFO : Level.SEVERE;
                if (worklistItem.getActivityReference() instanceof ADEPT2EBPReference) {
                    ADEPT2EBPReference ebpRef = (ADEPT2EBPReference)worklistItem.getActivityReference();
                    msg = "The Staff Assignment Rule of node #%d in instance '%s' was not resolvable!";
                    msg = String.format(msg, ebpRef.getNodeID(), ebpRef.getInstanceID());
                } else {
                    msg = "Encountered a Staff Assignment Rule that was not resolvable!";
                }
                this.logger.log(level, msg, e);
            }
            this.escalateToInstanceSupervisor(this.getChildSession(session), worklistItem, "Staff Assignment Rule not resolveable! (See log for details)");
            return;
        }
        Set<QualifiedAgent> distributionAgents = this.getDistributionRecipients(this.getChildSession(session), worklistItem, possibleAgents);
        this.distributeToWorklists(this.getChildSession(session), worklistItem, distributionAgents);
    }

    protected Set<QualifiedAgent> getDistributionRecipients(SessionToken session, InternalWorklistItem worklistItem, Set<QualifiedAgent> possibleAgents) throws DataSourceException {
        if (possibleAgents == null) {
            return Collections.emptySet();
        }
        if (possibleAgents.size() == 0) {
            return Collections.emptySet();
        }
        String distributionHandlingID = worklistItem.getDistributionHandlingProcedureID();
        if (distributionHandlingID == null || distributionHandlingID.length() == 0) {
            return possibleAgents;
        }
        DistributionHandling distributionHandling = this.getDistributionHandling(distributionHandlingID);
        if (distributionHandling == null) {
            this.logger.log(Level.WARNING, String.format("Couldn't find DistributionHandling with ID '%s'! Distributing to all possible Agents", distributionHandlingID));
            return possibleAgents;
        }
        HashMap<QualifiedAgent, Worklist<? extends WorklistItem>> worklists = new HashMap<QualifiedAgent, Worklist<? extends WorklistItem>>(possibleAgents.size());
        for (QualifiedAgent agent : possibleAgents) {
            UUID agentWorklistID = this.getWorklistID(agent);
            InternalWorklist<InternalWorklistItem> agentWorklist = this.getWorklistStorage().getInternalWorklistReadonly(agentWorklistID);
            worklists.put(agent, agentWorklist);
        }
        Set<QualifiedAgent> distributionAgents = distributionHandling.distribute(this.getChildSession(session), worklistItem, worklists);
        return distributionAgents;
    }

    private QualifiedAgent getInstanceSupervisor(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
        EBPInstanceReference ebp = this.getWorklistItemStorage().getEBPInstanceReference(worklistItem.getID());
        InstanceManager instanceManager = this.getInstanceManager(this.getChildSession(session));
        Instance instance = instanceManager.getInstance(this.getChildSession(session), ebp.getInstanceID());
        QualifiedAgent instanceSupervisor = instance.getSupervisorAgent();
        return instanceSupervisor;
    }

    private QualifiedAgent getTemplateSupervisor(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
        EBPInstanceReference ebp = this.getWorklistItemStorage().getEBPInstanceReference(worklistItem.getID());
        InstanceManager instanceManager = this.getInstanceManager(this.getChildSession(session));
        Instance instance = instanceManager.getInstance(this.getChildSession(session), ebp.getInstanceID());
        QualifiedAgent templateSupervisor = instance.getTemplate().getSupervisorAgent();
        return templateSupervisor;
    }

    protected void escalateToInstanceSupervisor(SessionToken session, InternalWorklistItem worklistItem, String cause) throws DataSourceException, InvalidWorklistItemStateException {
        worklistItem.escalated();
        QualifiedAgent instanceSupervisor = this.getInstanceSupervisor(session, worklistItem);
        if (instanceSupervisor != null) {
            HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
            recipients.add(instanceSupervisor);
            this.delegationManager.delegateWorkItem(session, worklistItem, recipients, String.format("Escalation to Instance Supervisor! Cause: %s", cause));
        } else {
            this.escalateToTemplateSupervisor(session, worklistItem, cause);
        }
    }

    private void escalateToTemplateSupervisor(SessionToken session, InternalWorklistItem worklistItem, String cause) throws DataSourceException, InvalidWorklistItemStateException {
        worklistItem.escalated();
        QualifiedAgent templateSupervisor = this.getTemplateSupervisor(session, worklistItem);
        if (templateSupervisor != null) {
            HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
            recipients.add(templateSupervisor);
            this.delegationManager.delegateWorkItem(session, worklistItem, recipients, String.format("Escalation to Template Supervisor! Cause: %s", cause));
        } else {
            this.escalateToFallbackAgent(session, worklistItem, cause);
        }
    }

    private void escalateToFallbackAgent(SessionToken session, InternalWorklistItem worklistItem, String cause) throws InvalidWorklistItemStateException {
        worklistItem.escalated();
        HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
        recipients.add(this.fallbackWorklistAgent);
        this.delegationManager.delegateWorkItem(session, worklistItem, recipients, String.format("Escalation to fallback worklist! Cause: %s", cause));
    }

    protected boolean addItemToWorklist(SessionToken session, UUID worklistID, InternalWorklistItem worklistItem, boolean substitute) throws DataSourceException, LockException {
        InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
        this.getWorklistItemStorage().lockInternalWorklistItem(session, worklistItem.getID());
        try {
            worklist.addWorklistItem(worklistItem);
            worklistItem.addedToWorklist(worklist.getID());
            this.getEscalationManager().worklistItemAddedToWorklist(worklistItem, worklist);
            this.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
        }
        finally {
            this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItem.getID());
        }
        this.asyncNotifyClientsAboutUpdate(worklist);
        return worklist.isPresentNow() && this.isUserKnown(worklist.getAgent());
    }

    private boolean isUserKnown(QualifiedAgent agent) throws DataSourceException {
        boolean ret;
        boolean bl = ret = this.getGlobalWorklistAgent().equals(agent) || this.getFallbackWorklistAgent().equals(agent);
        if (!ret) {
            ret = this.getClientStorage().isUserKnown(agent);
        }
        if (!ret) {
            boolean agentValid;
            PolicyResolution resolution = this.getOrgModelManager().getPolicyResolution();
            String validPolicy = String.format(this.PRESENT_PREDICATE, agent.getAgentID());
            try {
                agentValid = resolution.isMember(this.getSessionToken(), agent.getOrgPositionID(), agent.getAgentUserName(), validPolicy);
            }
            catch (PolicyResolutionException pre) {
                agentValid = false;
                String msg = "Could not determine whether the agent '%s' is valid with respect to the organisational model since the policy for this '%s' is not a valid policy. Expecting the agent to be invalid.";
                this.logger.log(Level.WARNING, String.format(msg, agent, validPolicy), pre);
            }
            if (agentValid) {
                this.createWorklistForAgent(agent, null);
                ret = true;
            }
        }
        return ret;
    }

    protected void addItemToWorklists(SessionToken session, InternalWorklistItem worklistItem, Set<QualifiedAgent> recipients, boolean substitute) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        boolean userPresent = false;
        for (QualifiedAgent agent : recipients) {
            UUID worklistID = this.getWorklistID(agent);
            userPresent |= this.addItemToWorklist(session, worklistID, worklistItem, substitute);
        }
        if (!userPresent) {
            HashSet<QualifiedAgent> substitutes = new HashSet<QualifiedAgent>();
            if (this.isSubstitutionAllowed(worklistItem)) {
                for (QualifiedAgent agent : recipients) {
                    if (!this.isUserKnown(agent)) continue;
                    UUID worklistID = this.getWorklistID(agent);
                    InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                    substitutes.addAll(this.resolveStaffAssignmentRule(session, worklist.getSubstitutionRule()));
                }
            }
            this.addToSubstitutes(session, worklistItem, substitutes);
        }
    }

    public void applySubstitutionRule(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        if (!this.isSubstitutionAllowed(worklistItem)) {
            return;
        }
        HashSet<QualifiedAgent> substitutes = new HashSet<QualifiedAgent>();
        UUID[] uUIDArray = worklistItem.getWorklistIDs();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistID = uUIDArray[n2];
            if (!worklistID.equals(this.getGlobalWorklistID())) {
                InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                if (worklist.isPresentNow()) {
                    String msg;
                    if (this.isUserKnown(worklist.getAgent())) {
                        msg = String.format("Tried to do a Substitution for Item '%s' but worklist '%s' is present! Aborting!", worklistItem, worklist);
                        this.logger.warning(msg);
                        return;
                    }
                    msg = String.format("Tried apply a substitution for item '%s' for agent with worklist '%s'. But the agent has  not been logged on before. Ignoring worklist.", worklistItem, worklist);
                    this.logger.info(msg);
                } else {
                    substitutes.addAll(this.resolveStaffAssignmentRule(session, worklist.getSubstitutionRule()));
                }
            }
            ++n2;
        }
        this.addToSubstitutes(session, worklistItem, substitutes);
    }

    protected boolean isSubstitutionAllowed(InternalWorklistItem worklistItem) {
        return !WorklistConstants.WorklistItemState.ENQUIRED.equals((Object)worklistItem.getState());
    }

    private void addToSubstitutes(SessionToken session, InternalWorklistItem worklistItem, Set<QualifiedAgent> substitutes) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        Object[] worklistIDs = worklistItem.getWorklistIDs();
        Arrays.sort(worklistIDs);
        if (this.isSubSet((UUID[])worklistIDs, substitutes)) {
            String msg = substitutes.size() == 0 ? String.format("There is no recipient (no assigned agent and no substitutes logged on for item '%s' with SAR: %s.", worklistItem, worklistItem.getStaffAssignmentRule()) : String.format("Substitution Rules for item '%s' are having a loop! The original SAR (without subsitution) is: %s", worklistItem, worklistItem.getStaffAssignmentRule());
            this.logger.info(String.valueOf(msg) + " Escalating!");
            QualifiedAgent supervisor = this.getInstanceSupervisor(session, worklistItem);
            if (supervisor != null) {
                UUID supervisorWorklistID = this.getWorklistID(supervisor);
                if (Arrays.binarySearch(worklistIDs, supervisorWorklistID) < 0) {
                    this.escalateToInstanceSupervisor(session, worklistItem, msg);
                    return;
                }
                String msg2 = String.format("Could not escalate to Instance Supervisor because Instance Supervisor '%s' is part of the Loop! Trying Template Supervisor.", supervisor);
                this.logger.info(msg2);
                supervisor = this.getTemplateSupervisor(session, worklistItem);
                if (supervisor != null) {
                    supervisorWorklistID = this.getWorklistID(supervisor);
                    if (Arrays.binarySearch(worklistIDs, supervisorWorklistID) < 0) {
                        this.escalateToTemplateSupervisor(session, worklistItem, msg);
                        return;
                    }
                    msg2 = String.format("Could not escalate to Template Supervisor becauseTemplate Supervisor '%s' is part of the Loop! Trying fallback worklist.", supervisor);
                    this.logger.info(msg2);
                }
            }
            this.escalateToFallbackAgent(session, worklistItem, msg);
        } else {
            this.addItemToWorklists(session, worklistItem, substitutes, true);
        }
    }

    private boolean isSubSet(UUID[] worklistIDs, Set<QualifiedAgent> substitutes) throws DataSourceException {
        for (QualifiedAgent agent : substitutes) {
            UUID worklistID = this.getWorklistID(agent);
            if (Arrays.binarySearch(worklistIDs, worklistID) >= 0) continue;
            return false;
        }
        return true;
    }

    protected void distributeToWorklists(SessionToken session, InternalWorklistItem worklistItem, Set<QualifiedAgent> agents) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        if (agents == null || agents.isEmpty()) {
            this.logger.info("No Agents given for Distribution! Escalating!");
            this.escalateToInstanceSupervisor(session, worklistItem, "No Agents available to distribute to!");
            return;
        }
        this.addItemToWorklists(session, worklistItem, agents, false);
    }

    protected DistributionHandling getDistributionHandling(String distributionHandlingID) {
        if ("Broadcast".equals(distributionHandlingID)) {
            return new BroadcastDistributionHandling();
        }
        return null;
    }

    protected DelegationHandling getDelegationHandling(String delegationHandlingID) {
        DelegationHandling plugin = null;
        try {
            plugin = this.registry.getConfiguredPlugin(this.sessionFactory.getSessionToken(this.getURIs()), this, "DelegationHandling", DelegationHandling.class, delegationHandlingID);
        }
        catch (ServiceNotKnownException skne) {
            String message = String.format("Could not retrieve the handling plug-in from the registry.", new Object[0]);
            this.logger.log(Level.SEVERE, message, skne);
        }
        return plugin;
    }

    public EscalationHandling getEscalationHandling(String escalationHandlingID) {
        EscalationHandling plugin = null;
        try {
            plugin = this.registry.getConfiguredPlugin(this.sessionFactory.getSessionToken(this.getURIs()), this, "EscalationHandling", EscalationHandling.class, escalationHandlingID);
        }
        catch (ServiceNotKnownException skne) {
            String message = String.format("Could not retrieve the handling plug-in from the registry.", new Object[0]);
            this.logger.log(Level.SEVERE, message, skne);
        }
        return plugin;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    protected WorklistModelFactory getWorklistModelFactory() {
        return this.worklistModelFactory;
    }

    protected FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    protected Set<QualifiedAgent> resolveStaffAssignmentRule(SessionToken session, String staffAssignmentRule) {
        try {
            return OrgModelTools.resolveStaffAssignmentRule(this.getChildSession(session), this.getOrgModelManager(), staffAssignmentRule);
        }
        catch (DataSourceException e) {
            String message = "Unrecoverable DataSourceException while trying to resolve Staff Assignment Rule!";
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        catch (PolicyResolutionException e) {
            String message = "Unrecoverable PolicyResolutionException while trying to resolve Staff Assignment Rule!";
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
    }

    protected QualifiedAgent getGlobalWorklistAgent() {
        return this.globalWorklistAgent;
    }

    protected QualifiedAgent getFallbackWorklistAgent() {
        return this.fallbackWorklistAgent;
    }

    protected QualifiedAgent getSupervisorWorklistAgent() {
        return this.supervisorWorklistAgent;
    }

    protected void addMailingClientWorklist(SessionToken session, UUID worklistID, boolean mailNotify, WorklistUpdateConfiguration configuration, QualifiedAgent agent) throws DataSourceException {
        RichAgent richAgent = this.getOrgModelManager().getModelExplorer().getRichAgent(session, agent);
        if (richAgent.getMailAddress() == null || richAgent.getMailAddress().equals("")) {
            String msg = String.format("Cannot set a mail notification for %s since there no mail address is provided.", richAgent);
            this.logger.severe(msg);
        } else {
            this.addMailingClientWorklist(session, worklistID, mailNotify, configuration, richAgent);
        }
    }

    protected void addMailingClientWorklist(SessionToken session, UUID worklistID, boolean mailNotify, WorklistUpdateConfiguration configuration, RichAgent agent) throws DataSourceException {
        WorklistUpdateConfiguration oldConfig = this.getWorklistStorage().getMailingClientWorklistConfig(worklistID);
        if (oldConfig != null) {
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
            for (ClientWorklist cw : worklist.getUpdateableClientWorklists().keySet()) {
                if (!(cw instanceof MailingClientWorklist) && !(cw instanceof OrderedMailingClientWorklist)) continue;
                worklist.removeUpdateableClientWorklist(cw);
                break;
            }
            this.getWorklistStorage().setMailingClientWorklistConfig(worklistID, null);
        }
        if (mailNotify) {
            DefaultClientWorklist clientWorklist;
            WorklistUpdateConfiguration config;
            if (this.USE_ORDERED_MAILING_WORKLIST) {
                if (configuration != null) {
                    HashMap<Integer, Long> updateInterval = new HashMap<Integer, Long>();
                    int[] nArray = configuration.getUpdateIntervalThresholds();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int priority = nArray[n2];
                        updateInterval.put(priority, configuration.getUpdateInterval(priority));
                        ++n2;
                    }
                    config = this.getWorklistModelFactory().createWorklistConfiguration(configuration.getUpdateModeThreshold(), updateInterval, null, configuration.getUserAttributes());
                } else {
                    config = this.getWorklistModelFactory().createPullWorklistConfiguration(null);
                }
            } else if (configuration != null) {
                config = configuration;
            } else {
                Filter filter = WorklistFilters.noTopLevelInstances(this.getFilterFactory());
                config = this.getWorklistModelFactory().createPullWorklistConfiguration(filter);
            }
            if (this.USE_ORDERED_MAILING_WORKLIST) {
                CompositeConfiguration mailConf = new CompositeConfiguration();
                List<String> locales = AristaFlowBundle.getBundleKeyNames(agent.getLocale());
                String infix = "%s.%s";
                int i = locales.size();
                while (i > 0) {
                    String key = String.format(infix, ORDERED_MAILING_WORKLIST_PREFIX, locales.get(--i));
                    mailConf.addConfiguration(this.configuration.subset(key));
                }
                mailConf.addConfiguration(this.configuration.subset(ORDERED_MAILING_WORKLIST_PREFIX));
                clientWorklist = new OrderedMailingClientWorklist(worklistID, agent, config, (Configuration)mailConf, 0L, null, this.getSessionFactory(), this.getURIs(), this.registry);
            } else {
                HashMap<String, String> userAttributes = new HashMap<String, String>();
                userAttributes.put(CFG_MAILNOTIFICATION_SUBJECT, this.MAIL_SUBJECT);
                userAttributes.put(CFG_MAILNOTIFICATION_BODY, this.MAIL_BODY);
                userAttributes.put(CFG_MAILNOTIFICATION_ITEM_TEXT, this.MAIL_ITEM_TEXT);
                clientWorklist = new MailingClientWorklist(worklistID, agent, config, 0L, userAttributes, this.getSessionFactory(), this.getURIs(), this.registry);
            }
            this.getWorklistStorage().setMailingClientWorklistConfig(worklistID, config);
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
            this.updateExecutor.execute(new UpdateRunnable(worklist, clientWorklist, config.getWorklistFilter()));
        }
    }

    public void ensureWorklistExists(QualifiedAgent qualifiedAgent) {
        try {
            this.createWorklistForAgent(qualifiedAgent, null);
        }
        catch (DataSourceException e) {
            String message = "DataSourceException while checking that agent exists!";
            this.logger.log(Level.SEVERE, message, e);
        }
    }

    private class ClientWorklistUpdateRunnable
    implements Runnable {
        private final InternalWorklist<InternalWorklistItem> worklist;
        private final ClientWorklist clientWorklist;
        private final long clientWorklistID;

        public ClientWorklistUpdateRunnable(InternalWorklist<InternalWorklistItem> worklist, ClientWorklist clientWorklist, long clientWorklistID) {
            this.worklist = worklist;
            this.clientWorklist = clientWorklist;
            this.clientWorklistID = clientWorklistID;
        }

        @Override
        public void run() {
            AbstractWorklistManager.this.notifyClientAboutUpdate(this.worklist, this.clientWorklist, this.clientWorklistID);
        }
    }

    private static class UpdateRunnable
    implements Runnable {
        private InternalWorklist<InternalWorklistItem> worklist;
        private ClientWorklist clientWorklist;
        private Filter worklistFilter;

        UpdateRunnable(InternalWorklist<InternalWorklistItem> worklist, ClientWorklist clientWorklist, Filter worklistFilter) {
            this.worklist = worklist;
            this.clientWorklist = clientWorklist;
            this.worklistFilter = worklistFilter;
        }

        @Override
        public void run() {
            WorklistUpdate update = this.worklist.getUpdates(0L, this.worklistFilter);
            this.clientWorklist.updateWorklist(update);
            this.worklist.addUpdateableClientWorklist(this.clientWorklist);
        }
    }
}

