/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class AvailabilityManager {
    final Logger logger = LoggerTools.getLogger(this);
    protected final ScheduledExecutorService scheduler;
    protected final Map<QualifiedAgent, ScheduledFuture<?>> absentFutures;
    protected final Map<QualifiedAgent, ScheduledFuture<?>> presentFutures;
    private final AbstractWorklistManager worklistManager;

    public AvailabilityManager(AbstractWorklistManager worklistManager, String threadName) {
        this.worklistManager = worklistManager;
        Adept2ThreadFactory factory = new Adept2ThreadFactory(threadName, this.logger);
        this.scheduler = ExecutorTools.createScheduledExecutor(1, factory);
        this.absentFutures = new Hashtable();
        this.presentFutures = new Hashtable();
    }

    protected void setQAAbsent(QualifiedAgent qualifiedAgent, long from, long to, String substitutionRule) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        UUID worklistID = this.getWorklistManager().getWorklistID(qualifiedAgent);
        InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
        for (InternalWorklistItem worklistItem : worklist.getWorklistItems()) {
            if (!this.isItemLonely(worklistItem)) continue;
            this.worklistManager.applySubstitutionRule(this.worklistManager.getSessionToken(), worklistItem);
        }
        this.getWorklistManager().asyncNotifyClientsAboutUpdate(worklist);
    }

    private boolean isItemLonely(InternalWorklistItem worklistItem) throws DataSourceException {
        UUID[] uUIDArray = worklistItem.getWorklistIDs();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalWorklist<InternalWorklistItem> worklist;
            UUID worklistID = uUIDArray[n2];
            if (!worklistID.equals(this.worklistManager.getGlobalWorklistID()) && (worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID)).isPresentNow()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void setQAPresent(QualifiedAgent qualifiedAgent) throws DataSourceException, LockException {
        ScheduledFuture<?> absentFuture = this.absentFutures.remove(qualifiedAgent);
        if (absentFuture != null) {
            absentFuture.cancel(true);
        }
        this.worklistManager.getSessionToken();
        UUID worklistID = this.getWorklistManager().getWorklistID(qualifiedAgent);
        InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
        this.getWorklistManager().asyncNotifyClientsAboutUpdate(worklist);
    }

    public void setPresent(QualifiedAgent qualifiedAgent) {
        ScheduledFuture<?> presentFuture = this.presentFutures.remove(qualifiedAgent);
        if (presentFuture != null) {
            presentFuture.cancel(true);
        }
        try {
            this.setQAPresent(qualifiedAgent);
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not set Worklist Present!", e);
        }
        catch (LockException e) {
            throw new InternalServiceException("Could not set Worklist Present!", e);
        }
    }

    public void setAbsent(QualifiedAgent qualifiedAgent, long from, long to, String substitutionRule) {
        ScheduledFuture<?> future = this.absentFutures.remove(qualifiedAgent);
        if (future != null) {
            future.cancel(true);
        }
        if ((future = this.presentFutures.remove(qualifiedAgent)) != null) {
            future.cancel(true);
        }
        try {
            if (from <= 0L || from < System.currentTimeMillis() + 5000L) {
                this.scheduler.execute(new AbsentExecutor(qualifiedAgent, from, to, substitutionRule));
            } else {
                if (this.isAbsent(qualifiedAgent)) {
                    this.scheduler.execute(new PresentExecutor(qualifiedAgent));
                }
                future = this.scheduler.schedule(new AbsentExecutor(qualifiedAgent, from, to, substitutionRule), from - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                this.absentFutures.put(qualifiedAgent, future);
            }
            if (to > 0L) {
                future = this.scheduler.schedule(new PresentExecutor(qualifiedAgent), to - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                this.presentFutures.put(qualifiedAgent, future);
            }
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could no set Agent absent!", e);
        }
    }

    private boolean isAbsent(QualifiedAgent qualifiedAgent) throws DataSourceException {
        UUID worklistID = this.getWorklistManager().getWorklistID(qualifiedAgent);
        InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
        return !worklist.isPresentNow();
    }

    protected AbstractWorklistManager getWorklistManager() {
        return this.worklistManager;
    }

    private WorklistStorage getWorklistStorage() {
        return this.getWorklistManager().getWorklistStorage();
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
        try {
            if (!this.scheduler.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Scheduler didn't terminate in time.");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private final class AbsentExecutor
    implements Runnable {
        private final QualifiedAgent qualifiedAgent;
        private final long from;
        private final long to;
        private final String substitutionRule;

        public AbsentExecutor(QualifiedAgent qualifiedAgent, long from, long to, String substitutionRule) {
            this.qualifiedAgent = qualifiedAgent;
            this.from = from;
            this.to = to;
            this.substitutionRule = substitutionRule;
        }

        @Override
        public void run() {
            AvailabilityManager.this.absentFutures.remove(this.qualifiedAgent);
            try {
                AvailabilityManager.this.setQAAbsent(this.qualifiedAgent, this.from, this.to, this.substitutionRule);
            }
            catch (DataSourceException e) {
                AvailabilityManager.this.logger.log(Level.WARNING, "Could not set agent Absent due to a DataSourceException!", e);
            }
            catch (LockException e) {
                AvailabilityManager.this.logger.log(Level.WARNING, "Could not set agent Absent due to a LockException!", e);
            }
            catch (InvalidWorklistItemStateException e) {
                AvailabilityManager.this.logger.log(Level.WARNING, "Could not set agent Absent due to an InvalidWorklistItemStateException!", e);
            }
        }
    }

    public final class PresentExecutor
    implements Runnable {
        private final QualifiedAgent qualifiedAgent;

        public PresentExecutor(QualifiedAgent qualifiedAgent) {
            this.qualifiedAgent = qualifiedAgent;
        }

        @Override
        public void run() {
            AvailabilityManager.this.presentFutures.remove(this.qualifiedAgent);
            try {
                AvailabilityManager.this.setQAPresent(this.qualifiedAgent);
            }
            catch (DataSourceException e) {
                AvailabilityManager.this.logger.log(Level.WARNING, "Could not set agent Absent due to a DataSourceException!", e);
            }
            catch (LockException e) {
                AvailabilityManager.this.logger.log(Level.WARNING, "Could not set agent Absent due to a LockException!", e);
            }
        }
    }
}

