/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.processmanager.InstanceManager;
import de.aristaflow.adept2.core.worklistmanager.DelegationHandling;
import de.aristaflow.adept2.core.worklistmanager.DelegationManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.OrgModelTools;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.common.plugindata.SchedulerData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class DefaultDelegationManager
implements DelegationManager {
    protected static final String CFG_MAXIMUM_DELEGATION_LEVEL = "maximumDelegationLevel";
    protected static final String CFG_DEFAULT_DELEGATION_RECIPIENTS = "defaultDelegationRecipients";
    protected static final String CFG_DEFAULT_DELEGATION_FOR_GLOBAL_WORKLIST = "globalWorklistDelegationRecipients";
    protected static final String CFG_DEFAULT_DELEGATION_FOR_FALLBACK_WORKLIST = "fallbackWorklistDelegationRecipients";
    protected static final String CFG_DEFAULT_DELEGATION_FOR_SUPERVISOR_WORKLIST = "supervisorWorklistDelegationRecipients";
    protected Logger logger = LoggerTools.getLogger(this);
    protected final int MAXIMUM_DELEGATION_LEVEL;
    private final String DEFAULT_DELEGATION_RECIPIENTS;
    private final String DEFAULT_DELEGATION_FOR_GLOBAL_WORKLIST;
    private final String DEFAULT_DELEGATION_FOR_FALLBACK_WORKLIST;
    private final String DEFAULT_DELEGATION_FOR_SUPERVISOR_WORKLIST;
    private final AbstractWorklistManager worklistManager;

    public DefaultDelegationManager(Configuration configuration, AbstractWorklistManager worklistManager) {
        this.MAXIMUM_DELEGATION_LEVEL = configuration.getInt(CFG_MAXIMUM_DELEGATION_LEVEL);
        this.DEFAULT_DELEGATION_RECIPIENTS = configuration.getString(CFG_DEFAULT_DELEGATION_RECIPIENTS);
        this.DEFAULT_DELEGATION_FOR_GLOBAL_WORKLIST = configuration.getString(CFG_DEFAULT_DELEGATION_FOR_GLOBAL_WORKLIST);
        this.DEFAULT_DELEGATION_FOR_FALLBACK_WORKLIST = configuration.getString(CFG_DEFAULT_DELEGATION_FOR_FALLBACK_WORKLIST);
        this.DEFAULT_DELEGATION_FOR_SUPERVISOR_WORKLIST = configuration.getString(CFG_DEFAULT_DELEGATION_FOR_SUPERVISOR_WORKLIST);
        this.worklistManager = worklistManager;
    }

    @Override
    public Set<QualifiedAgent> getDelegationRecipients(SessionToken session, WorklistItem workItem) throws InternalServiceException {
        this.getWorklistManager().sessionActive(session);
        try {
            QualifiedAgent delegatingAgent = this.getWorklistManager().checkAndGetTopLevelAgent(session);
            InternalWorklistItem item = this.getWorklistItemStorage().getInternalWorklistItemReadonly(workItem.getID());
            PolicyResolution policyResolution = this.getOrgModelManager().getPolicyResolution();
            String delegationHandlingID = item.getDelegationHandlingProcedureID();
            if (delegationHandlingID != null && delegationHandlingID.length() > 0) {
                DelegationHandling delegationHandling = this.getWorklistManager().getDelegationHandling(delegationHandlingID);
                if (delegationHandling != null) {
                    EBPInstanceReference ebp = this.getWorklistItemStorage().getEBPInstanceReference(item.getID());
                    InstanceManager instanceManager = this.getWorklistManager().getInstanceManager(this.getWorklistManager().getChildSession(session));
                    Instance instance = instanceManager.getInstance(this.getWorklistManager().getChildSession(session), ebp.getInstanceID());
                    QualifiedAgent templateSupervisor = instance.getTemplate().getSupervisorAgent();
                    QualifiedAgent instanceSupervisor = instance.getSupervisorAgent();
                    QualifiedAgent instanceInitiator = instance.getInitiatorAgent();
                    Set<QualifiedAgent> set = delegationHandling.getDelegationRecipients(item, delegatingAgent, templateSupervisor, instanceSupervisor, instanceInitiator, policyResolution);
                    return set;
                }
                String msg = "Couldn't find DelegationHandling with ID '%s'! Using default delegation handling.";
                msg = String.format(msg, delegationHandlingID);
                this.logger.warning(msg);
                Set<QualifiedAgent> set = this.getDefaultDelegationRecipients(session, item, delegatingAgent);
                return set;
            }
            Set<QualifiedAgent> set = this.getDefaultDelegationRecipients(session, item, delegatingAgent);
            return set;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not get Delegation Recipients due to a DataSource Exception!", e);
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public void delegateWorkItem(SessionToken session, WorklistItem workItem, Set<QualifiedAgent> recipients, String comment) throws InvalidWorklistItemStateException {
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                QualifiedAgent delegatingAgent = this.getWorklistManager().checkAndGetTopLevelAgent(session);
                InternalWorklistItem worklistItem = this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, workItem.getID());
                try {
                    if (WorklistConstants.WorklistItemState.ASSIGNED.equals((Object)worklistItem.getState()) || WorklistConstants.WorklistItemState.STARTED.equals((Object)worklistItem.getState())) {
                        throw new InvalidWorklistItemStateException(worklistItem.getState().name());
                    }
                    if (this.isDelegationAllowed(worklistItem)) {
                        UUID[] uUIDArray = worklistItem.getWorklistIDs();
                        int n = uUIDArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            UUID worklistID = uUIDArray[n2];
                            if (!this.isSpecialWorklist(worklistID)) {
                                InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                                worklist.removeWorklistItem(worklistItem);
                                worklistItem.removedFromWorklist(worklist.getID());
                                this.getWorklistManager().getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
                                this.getWorklistManager().asyncNotifyClientsAboutUpdate(worklist);
                            }
                            ++n2;
                        }
                        worklistItem.delegateTo(recipients, delegatingAgent, comment);
                        worklistItem.setAssignedAgent(null);
                        worklistItem.setAssignmentDate(0L);
                        this.getWorklistManager().addItemToWorklists(session, worklistItem, recipients, false);
                        this.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
                        this.getWorklistManager().updateAndNotifyGlobalWorklist(worklistItem);
                        worklistItem.storeCurrentState(true);
                    }
                }
                finally {
                    this.getWorklistItemStorage().unlockInternalWorklistItem(session, workItem.getID());
                }
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("Could not delegate Work Item due to a DataSource Exception!", e);
            }
            catch (LockException e) {
                throw new InternalServiceException("Could not delegate Work Item due to a Lock Exception!", e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    private boolean isDelegationAllowed(InternalWorklistItem worklistItem) {
        return worklistItem.getCurrentDelegationLevel() < this.MAXIMUM_DELEGATION_LEVEL && !WorklistConstants.WorklistItemState.ENQUIRED.equals((Object)worklistItem.getState());
    }

    protected boolean isSpecialWorklist(UUID worklistID) {
        return worklistID.equals(this.getWorklistManager().getGlobalWorklistID());
    }

    @Override
    public void delegateBack(SessionToken session, WorklistItem item, String reply) throws InvalidWorklistItemStateException {
        this.getWorklistManager().sessionActive(session);
        try {
            HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
            recipients.add(item.getCurrentDelegation().getDelegator());
            this.delegateWorkItem(session, item, recipients, reply);
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    protected Set<QualifiedAgent> getDefaultDelegationRecipients(SessionToken session, InternalWorklistItem item, QualifiedAgent delegatingAgent) {
        SchedulerData schedulerData;
        if (this.worklistManager.getGlobalWorklistAgent().equals(delegatingAgent)) {
            return this.worklistManager.resolveStaffAssignmentRule(this.getWorklistManager().getChildSession(session), OrgModelTools.fillStaffAssigmentRule(this.DEFAULT_DELEGATION_FOR_GLOBAL_WORKLIST, delegatingAgent));
        }
        if (this.worklistManager.getFallbackWorklistAgent().equals(delegatingAgent)) {
            return this.worklistManager.resolveStaffAssignmentRule(this.getWorklistManager().getChildSession(session), OrgModelTools.fillStaffAssigmentRule(this.DEFAULT_DELEGATION_FOR_FALLBACK_WORKLIST, delegatingAgent));
        }
        if (this.worklistManager.getSupervisorWorklistAgent().equals(delegatingAgent)) {
            return this.worklistManager.resolveStaffAssignmentRule(this.getWorklistManager().getChildSession(session), OrgModelTools.fillStaffAssigmentRule(this.DEFAULT_DELEGATION_FOR_SUPERVISOR_WORKLIST, delegatingAgent));
        }
        String delegationRule = null;
        if (item.getPluginData("SchedulerData") != null && (schedulerData = ModelViewer.createView(item.getPluginData("SchedulerData").getPluginData(), SchedulerData.class)).getDelegationRule() != null) {
            delegationRule = schedulerData.getDelegationRule();
        }
        if (delegationRule == null || delegationRule.length() == 0) {
            delegationRule = this.DEFAULT_DELEGATION_RECIPIENTS;
        }
        return this.worklistManager.resolveStaffAssignmentRule(this.getWorklistManager().getChildSession(session), OrgModelTools.fillStaffAssigmentRule(delegationRule, delegatingAgent));
    }

    protected WorklistStorage getWorklistStorage() {
        return this.getWorklistManager().getWorklistStorage();
    }

    protected AbstractWorklistManager getWorklistManager() {
        return this.worklistManager;
    }

    protected WorklistItemStorage getWorklistItemStorage() {
        return this.getWorklistManager().getWorklistItemStorage();
    }

    protected OrgModelManager getOrgModelManager() {
        return this.getWorklistManager().getOrgModelManager();
    }
}

