/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.EscalationManager;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.time.DateTimeFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultEscalationManager
implements EscalationManager {
    protected Logger logger = LoggerTools.getLogger(this);
    protected final AbstractWorklistManager worklistManager;
    private final ScheduledExecutorService executor;
    private final Map<UUID, ScheduledFuture<?>> internalWorklistItemEscalation;
    private final Map<UUID, Map<UUID, ScheduledFuture<?>>> clientWorklistItemEscalation;

    public DefaultEscalationManager(AbstractWorklistManager worklistManager) {
        this.worklistManager = worklistManager;
        Adept2ThreadFactory factory = new Adept2ThreadFactory("EscalationManager", this.logger);
        this.executor = ExecutorTools.createScheduledExecutor(1, factory);
        this.internalWorklistItemEscalation = new HashMap();
        this.clientWorklistItemEscalation = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void worklistItemAdded(InternalWorklistItem item) {
        if (item.getEscalationDate() <= 0L) {
            return;
        }
        if (this.convertTime(item.getEscalationDate()) < 200L) {
            String msg = String.format("Item due date '%s (%s)' has already passed for '%s' (%s)! Escalating now!", DateTimeFormat.formatDateTime(item.getEscalationDate()), item.getEscalationDate(), item.getTitle(), item.getID());
            this.logger.info(msg);
            this.executor.execute(new InternalWorklistItemEscalation(item.getID()));
        } else {
            Map<UUID, ScheduledFuture<?>> map = this.internalWorklistItemEscalation;
            synchronized (map) {
                String msg = "Scheduling internal worklist item escalation for '%s' (%s) at '%s (%s)'";
                msg = String.format(msg, item.getTitle(), item.getID(), DateTimeFormat.formatDateTime(item.getEscalationDate()), item.getEscalationDate());
                this.logger.fine(msg);
                ScheduledFuture<?> escalationHandling = this.executor.schedule(new InternalWorklistItemEscalation(item.getID()), this.convertTime(item.getEscalationDate()), TimeUnit.MILLISECONDS);
                this.internalWorklistItemEscalation.put(item.getID(), escalationHandling);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void worklistItemRemoved(InternalWorklistItem item) {
        Map<UUID, ScheduledFuture<?>> map = this.internalWorklistItemEscalation;
        synchronized (map) {
            String msg = "Remove internal worklist item escalation for '%s' (%s)";
            msg = String.format(msg, item.getTitle(), item.getID());
            this.logger.fine(msg);
            ScheduledFuture<?> scheduled = this.internalWorklistItemEscalation.remove(item.getID());
            if (scheduled != null) {
                scheduled.cancel(false);
            }
            Map<UUID, Map<UUID, ScheduledFuture<?>>> map2 = this.clientWorklistItemEscalation;
            synchronized (map2) {
                Map<UUID, ScheduledFuture<?>> remove = this.clientWorklistItemEscalation.get(item.getID());
                if (remove != null && remove.size() > 0) {
                    for (UUID worklistID : remove.keySet()) {
                        this.clientWorklistItemRemoved(worklistID, item.getID());
                    }
                }
                this.clientWorklistItemEscalation.remove(item.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void worklistItemUpdated(InternalWorklistItem item) {
        Map<UUID, ScheduledFuture<?>> map = this.internalWorklistItemEscalation;
        synchronized (map) {
            String msg = "Update internal worklist item escalation for '%s' (%s), set escalation time to '%s (%s)'";
            msg = String.format(msg, item.getTitle(), item.getID(), DateTimeFormat.formatDateTime(item.getEscalationDate()), item.getEscalationDate());
            this.logger.finer(msg);
            ScheduledFuture<?> scheduled = this.internalWorklistItemEscalation.get(item.getID());
            if (scheduled != null) {
                if (Math.abs(scheduled.getDelay(TimeUnit.MILLISECONDS) - this.convertTime(item.getEscalationDate())) > 2000L) {
                    scheduled.cancel(false);
                    this.worklistItemAdded(item);
                } else {
                    msg = "Ignore worklist item '%s' (%s), the escalation time will not be set to '%s (%s)'!";
                    msg = String.format(msg, item.getTitle(), item.getID(), DateTimeFormat.formatDateTime(item.getEscalationDate()), item.getEscalationDate());
                    this.logger.finest(msg);
                }
            } else {
                this.worklistItemAdded(item);
            }
        }
    }

    @Override
    public void worklistItemAddedToWorklist(InternalWorklistItem item, InternalWorklist<InternalWorklistItem> worklist) {
        IndividualWorklistItemSettings individualWorklistItemSettings = item.getIndividualWorklistItemSettings(worklist.getID());
        this.clientWorklistItemAdded(item.getID(), individualWorklistItemSettings);
    }

    @Override
    public void worklistItemRemovedFromWorklist(InternalWorklistItem item, InternalWorklist<InternalWorklistItem> worklist) {
        this.clientWorklistItemRemoved(item.getID(), worklist.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientWorklistItemAdded(UUID itemID, IndividualWorklistItemSettings itemSettings) {
        if (itemSettings.getIndividualEscalationDate() <= 0L) {
            return;
        }
        if (this.convertTime(itemSettings.getIndividualEscalationDate()) < 200L) {
            this.logger.info("Individual Item due date has already passed! Escalating now!");
            this.executor.execute(new ClientWorklistItemEscalation(itemID, itemSettings.getWorklistID()));
            return;
        }
        Map<UUID, Map<UUID, ScheduledFuture<?>>> map = this.clientWorklistItemEscalation;
        synchronized (map) {
            Map<UUID, ScheduledFuture<?>> worklistSchedules = this.clientWorklistItemEscalation.get(itemID);
            if (worklistSchedules == null) {
                worklistSchedules = new HashMap();
                this.clientWorklistItemEscalation.put(itemID, worklistSchedules);
            }
            ScheduledFuture<?> escalationHandling = this.executor.schedule(new ClientWorklistItemEscalation(itemID, itemSettings.getWorklistID()), this.convertTime(itemSettings.getIndividualEscalationDate()), TimeUnit.MILLISECONDS);
            worklistSchedules.put(itemSettings.getWorklistID(), escalationHandling);
        }
    }

    private long convertTime(long time) {
        return time - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientWorklistItemRemoved(UUID worklistID, UUID worklistItemID) {
        Map<UUID, Map<UUID, ScheduledFuture<?>>> map = this.clientWorklistItemEscalation;
        synchronized (map) {
            Map<UUID, ScheduledFuture<?>> worklistSchedules = this.clientWorklistItemEscalation.get(worklistItemID);
            if (worklistSchedules == null) {
                return;
            }
            ScheduledFuture<?> scheduled = worklistSchedules.remove(worklistID);
            if (scheduled != null) {
                scheduled.cancel(false);
            }
            if (worklistSchedules.size() == 0) {
                this.clientWorklistItemEscalation.remove(worklistID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientWorklistItemUpdated(ClientWorklistItem item) {
        Map<UUID, Map<UUID, ScheduledFuture<?>>> map = this.clientWorklistItemEscalation;
        synchronized (map) {
            Map<UUID, ScheduledFuture<?>> worklistSchedules = this.clientWorklistItemEscalation.get(item.getID());
            ScheduledFuture<?> scheduled = null;
            if (worklistSchedules != null) {
                scheduled = worklistSchedules.get(item.getWorklistID());
            }
            if (scheduled != null) {
                if (Math.abs(scheduled.getDelay(TimeUnit.MILLISECONDS) - this.convertTime(item.getIndividualEscalationDate())) > 2000L) {
                    scheduled.cancel(false);
                    this.clientWorklistItemAdded(item.getID(), item);
                }
            } else {
                this.clientWorklistItemAdded(item.getID(), item);
            }
        }
    }

    public void shutdown() {
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Scheduler didn't terminate in time.");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static class ClientEscalationMeasures
    implements EscalationHandling.EscalationMeasures {
        private final AbstractWorklistManager worklistManager;

        public ClientEscalationMeasures(AbstractWorklistManager worklistManager) {
            this.worklistManager = worklistManager;
        }

        @Override
        public void setDueDate(SessionToken session, WorklistItem worklistItem, long dueDate) {
            if (!(worklistItem instanceof ClientWorklistItem)) {
                throw new RuntimeException(String.format("Expected ClientWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            ClientWorklistItem item = (ClientWorklistItem)worklistItem;
            item.setIndividualDueDate(dueDate);
            this.updateClientWorklistItem(session, item);
        }

        @Override
        public void setPriority(SessionToken session, WorklistItem worklistItem, int priority) {
            if (!(worklistItem instanceof ClientWorklistItem)) {
                throw new RuntimeException(String.format("Expected ClientWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            ClientWorklistItem item = (ClientWorklistItem)worklistItem;
            item.setIndividualPriority(priority);
            this.updateClientWorklistItem(session, item);
        }

        @Override
        public void delegateWorkItem(SessionToken session, WorklistItem item, Set<QualifiedAgent> recipients, String comment) throws InvalidWorklistItemStateException {
            this.worklistManager.getDelegationManager().delegateWorkItem(session, item, recipients, comment);
        }

        @Override
        public Set<QualifiedAgent> getDelegationRecipients(SessionToken session, WorklistItem item) {
            return this.worklistManager.getDelegationManager().getDelegationRecipients(session, item);
        }

        @Override
        public void delegateBack(SessionToken session, WorklistItem item, String reply) throws InvalidWorklistItemStateException {
            this.worklistManager.getDelegationManager().delegateBack(session, item, reply);
        }

        protected void updateClientWorklistItem(SessionToken session, ClientWorklistItem clientItem) {
            try {
                InternalWorklist<InternalWorklistItem> worklist = this.worklistManager.getWorklistStorage().getInternalWorklistReadonly(clientItem.getWorklistID());
                InternalWorklistItem item = this.worklistManager.getWorklistItemStorage().getAndLockInternalWorklistItem(session, clientItem.getID());
                try {
                    item.updateIndividualWorklistItemSettings(clientItem);
                    worklist.updateIndividualSettings(clientItem);
                    this.worklistManager.getEscalationManager().clientWorklistItemUpdated(clientItem);
                    this.worklistManager.getWorklistItemStorage().updateInternalWorklistItem(session, item);
                }
                finally {
                    this.worklistManager.getWorklistItemStorage().unlockInternalWorklistItem(session, clientItem.getID());
                }
                this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("Could not update client worklist Item due to a DataSource Exception!", e);
            }
            catch (LockException e) {
                throw new InternalServiceException("Could not update client worklist Item due to a Lock Exception!", e);
            }
        }

        @Override
        public void setEscalation(SessionToken session, WorklistItem worklistItem, long escalationDate, String escalationHandlingProcedureID) {
            if (!(worklistItem instanceof ClientWorklistItem)) {
                throw new RuntimeException(String.format("Expected ClientWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            ClientWorklistItem item = (ClientWorklistItem)worklistItem;
            item.setIndividualEscalation(escalationDate, escalationHandlingProcedureID);
            this.updateClientWorklistItem(session, item);
        }

        @Override
        public void updateIndividualSettings(SessionToken session, ClientWorklistItem worklistItem) {
            this.updateClientWorklistItem(session, worklistItem);
        }

        @Override
        public void updatePluginData(SessionToken session, WorklistItem worklistItem, PluginData pluginData) {
            if (!(worklistItem instanceof ClientWorklistItem)) {
                throw new RuntimeException(String.format("Expected ClientWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            ClientWorklistItem item = (ClientWorklistItem)worklistItem;
            item.setIndividualPluginData(pluginData);
            this.updateClientWorklistItem(session, item);
        }

        @Override
        public void updateUserAttributes(SessionToken session, WorklistItem worklistItem) {
            if (!(worklistItem instanceof ClientWorklistItem)) {
                throw new RuntimeException(String.format("Expected ClientWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            ClientWorklistItem item = (ClientWorklistItem)worklistItem;
            this.updateClientWorklistItem(session, item);
        }
    }

    public class ClientWorklistItemEscalation
    implements Runnable {
        private final UUID itemID;
        private final UUID worklistID;

        public ClientWorklistItemEscalation(UUID itemID, UUID worklistID) {
            this.itemID = itemID;
            this.worklistID = worklistID;
        }

        @Override
        public void run() {
            DefaultEscalationManager.this.logger.info("Escalating Worklist Item " + this.itemID);
            try {
                SessionToken session = DefaultEscalationManager.this.worklistManager.getSessionToken();
                InternalWorklistItem worklistItem = DefaultEscalationManager.this.worklistManager.getWorklistItemStorage().getAndLockInternalWorklistItem(session, this.itemID);
                try {
                    IndividualWorklistItemSettings itemSettings = worklistItem.getIndividualWorklistItemSettings(this.worklistID);
                    String escalationHandlingID = itemSettings.getIndividualEscalationHandlingProcedureID();
                    if (escalationHandlingID != null) {
                        EscalationHandling escalationHandling = DefaultEscalationManager.this.worklistManager.getEscalationHandling(escalationHandlingID);
                        if (escalationHandling != null) {
                            PolicyResolution policyResolution = DefaultEscalationManager.this.worklistManager.getOrgModelManager().getPolicyResolution();
                            ClientEscalationMeasures escalationMeasures = new ClientEscalationMeasures(DefaultEscalationManager.this.worklistManager);
                            long deadline = itemSettings.getIndividualEscalationDate();
                            itemSettings.setIndividualEscalation(0L, null);
                            escalationHandling.deadlineReached(worklistItem, worklistItem.getStaffAssignmentRule(), deadline, escalationMeasures, session, policyResolution);
                        } else {
                            DefaultEscalationManager.this.logger.info("Couldn't find Escalation Handling with ID '" + escalationHandlingID + "' using default Escalation Handling");
                            this.defaultEscalationHandling(worklistItem, itemSettings);
                        }
                    } else {
                        this.defaultEscalationHandling(worklistItem, itemSettings);
                    }
                    worklistItem.escalated();
                    DefaultEscalationManager.this.worklistManager.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
                }
                finally {
                    DefaultEscalationManager.this.worklistManager.getWorklistItemStorage().unlockInternalWorklistItem(session, this.itemID);
                }
                DefaultEscalationManager.this.worklistManager.notifyWorklistsAboutUpdate(worklistItem);
            }
            catch (DataSourceException e) {
                DefaultEscalationManager.this.logger.log(Level.WARNING, "Could not escalate Client Worklist Item due to DataSourceException!", e);
            }
            catch (LockException e) {
                DefaultEscalationManager.this.logger.log(Level.WARNING, "Could not escalate Client Worklist Item due to Lock Exception!", e);
            }
        }

        private void defaultEscalationHandling(InternalWorklistItem worklistItem, IndividualWorklistItemSettings itemSettings) {
            SessionToken session = DefaultEscalationManager.this.worklistManager.getSessionToken();
            ClientEscalationMeasures escalationMeasures = new ClientEscalationMeasures(DefaultEscalationManager.this.worklistManager);
            escalationMeasures.setPriority(session, worklistItem, itemSettings.getIndividualPriority() + 1000);
            escalationMeasures.setDueDate(session, worklistItem, itemSettings.getIndividualEscalationDate() + 3600000L);
        }
    }

    public static class InternalEscalationMeasures
    implements EscalationHandling.EscalationMeasures {
        private final AbstractWorklistManager worklistManager;

        public InternalEscalationMeasures(AbstractWorklistManager worklistManager) {
            this.worklistManager = worklistManager;
        }

        @Override
        public void setDueDate(SessionToken session, WorklistItem worklistItem, long dueDate) {
            if (!(worklistItem instanceof InternalWorklistItem)) {
                throw new RuntimeException(String.format("Expected InternalWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            InternalWorklistItem item = (InternalWorklistItem)worklistItem;
            item.setDueDate(dueDate);
            this.updateInternalWorklistItem(session, item);
        }

        @Override
        public void setPriority(SessionToken session, WorklistItem worklistItem, int priority) {
            if (!(worklistItem instanceof InternalWorklistItem)) {
                throw new RuntimeException(String.format("Expected InternalWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            InternalWorklistItem item = (InternalWorklistItem)worklistItem;
            item.setPriority(priority);
            this.updateInternalWorklistItem(session, item);
        }

        @Override
        public void delegateWorkItem(SessionToken session, WorklistItem item, Set<QualifiedAgent> recipients, String comment) throws InvalidWorklistItemStateException {
            this.worklistManager.getDelegationManager().delegateWorkItem(session, item, recipients, comment);
        }

        @Override
        public void delegateBack(SessionToken session, WorklistItem item, String reply) throws InvalidWorklistItemStateException {
            this.worklistManager.getDelegationManager().delegateBack(session, item, reply);
        }

        @Override
        public Set<QualifiedAgent> getDelegationRecipients(SessionToken session, WorklistItem item) {
            return this.worklistManager.getDelegationManager().getDelegationRecipients(session, item);
        }

        protected void updateInternalWorklistItem(SessionToken session, InternalWorklistItem item) {
            try {
                this.worklistManager.getWorklistItemStorage().updateInternalWorklistItem(session, item);
                this.worklistManager.getEscalationManager().worklistItemUpdated(item);
                this.worklistManager.notifyWorklistsAboutUpdate(item);
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("Could not update Worklist Item dueto a DataSource Exception!", e);
            }
            catch (LockException e) {
                throw new InternalServiceException("Could not update Worklist Item dueto a Lock Exception!", e);
            }
        }

        protected void updateClientWorklistItem(SessionToken session, ClientWorklistItem clientItem) {
            try {
                InternalWorklist<InternalWorklistItem> worklist = this.worklistManager.getWorklistStorage().getInternalWorklistReadonly(clientItem.getWorklistID());
                InternalWorklistItem item = this.worklistManager.getWorklistItemStorage().getAndLockInternalWorklistItem(session, clientItem.getID());
                try {
                    item.updateIndividualWorklistItemSettings(clientItem);
                    worklist.updateIndividualSettings(clientItem);
                    this.worklistManager.getEscalationManager().clientWorklistItemUpdated(clientItem);
                    this.worklistManager.getWorklistItemStorage().updateInternalWorklistItem(session, item);
                }
                finally {
                    this.worklistManager.getWorklistItemStorage().unlockInternalWorklistItem(session, clientItem.getID());
                }
                this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("Could not update client worklist Item due to a DataSource Exception!", e);
            }
            catch (LockException e) {
                throw new InternalServiceException("Could not update client worklist Item due to a Lock Exception!", e);
            }
        }

        @Override
        public void setEscalation(SessionToken session, WorklistItem worklistItem, long escalationDate, String escalationHandlingProcedureID) {
            if (!(worklistItem instanceof InternalWorklistItem)) {
                throw new RuntimeException(String.format("Expected InternalWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            InternalWorklistItem item = (InternalWorklistItem)worklistItem;
            item.setEscalation(escalationDate, escalationHandlingProcedureID);
            this.updateInternalWorklistItem(session, item);
        }

        @Override
        public void updateIndividualSettings(SessionToken session, ClientWorklistItem worklistItem) {
            throw new RuntimeException(String.format("Expected InternalWorklistItem but got '%s'!", worklistItem.getClass()));
        }

        @Override
        public void updatePluginData(SessionToken session, WorklistItem worklistItem, PluginData pluginData) {
            if (!(worklistItem instanceof InternalWorklistItem)) {
                throw new RuntimeException(String.format("Expected InternalWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            InternalWorklistItem item = (InternalWorklistItem)worklistItem;
            item.setPluginData(pluginData);
            this.updateInternalWorklistItem(session, item);
        }

        @Override
        public void updateUserAttributes(SessionToken session, WorklistItem worklistItem) {
            if (!(worklistItem instanceof InternalWorklistItem)) {
                throw new RuntimeException(String.format("Expected InternalWorklistItem but got '%s'!", worklistItem.getClass()));
            }
            InternalWorklistItem item = (InternalWorklistItem)worklistItem;
            this.updateInternalWorklistItem(session, item);
        }
    }

    public class InternalWorklistItemEscalation
    implements Runnable {
        private final UUID itemID;

        public InternalWorklistItemEscalation(UUID itemID) {
            this.itemID = itemID;
        }

        @Override
        public void run() {
            try {
                SessionToken session = DefaultEscalationManager.this.worklistManager.getSessionToken();
                DefaultEscalationManager.this.logger.info("Escalating Worklist Item " + this.itemID);
                InternalWorklistItem item = DefaultEscalationManager.this.worklistManager.getWorklistItemStorage().getAndLockInternalWorklistItem(session, this.itemID);
                try {
                    String escalationHandlingID = item.getEscalationHandlingProcedureID();
                    if (escalationHandlingID != null) {
                        EscalationHandling escalationHandling = DefaultEscalationManager.this.worklistManager.getEscalationHandling(escalationHandlingID);
                        if (escalationHandling != null) {
                            PolicyResolution policyResolution = DefaultEscalationManager.this.worklistManager.getOrgModelManager().getPolicyResolution();
                            InternalEscalationMeasures escalationMeasures = new InternalEscalationMeasures(DefaultEscalationManager.this.worklistManager);
                            try {
                                long deadline = item.getEscalationDate();
                                item.setEscalation(0L, null);
                                escalationHandling.deadlineReached(item, item.getStaffAssignmentRule(), deadline, escalationMeasures, session, policyResolution);
                            }
                            catch (RuntimeException e) {
                                String message = String.format("Caught a runtime exception while executing escalation plug-in %s.", escalationHandlingID);
                                DefaultEscalationManager.this.logger.log(Level.SEVERE, message, e);
                                throw e;
                            }
                        } else {
                            DefaultEscalationManager.this.logger.info("Couldn't find Escalation Handling with ID '" + escalationHandlingID + "' using default Escalation Handling");
                            this.defaultEscalationHandling(session, item);
                        }
                    } else {
                        this.defaultEscalationHandling(session, item);
                    }
                    item.escalated();
                    DefaultEscalationManager.this.worklistManager.getWorklistItemStorage().updateInternalWorklistItem(session, item);
                }
                finally {
                    DefaultEscalationManager.this.worklistManager.getWorklistItemStorage().unlockInternalWorklistItem(session, this.itemID);
                }
                DefaultEscalationManager.this.worklistManager.notifyWorklistsAboutUpdate(item);
            }
            catch (DataSourceException e) {
                DefaultEscalationManager.this.logger.log(Level.WARNING, "Could not escalate Worklist Item due to DataSource exception!", e);
            }
            catch (LockException e) {
                DefaultEscalationManager.this.logger.log(Level.WARNING, "Could not escalate Worklist Item due to Lock exception!", e);
            }
        }

        private void defaultEscalationHandling(SessionToken session, WorklistItem item) {
            InternalEscalationMeasures escalationMeasures = new InternalEscalationMeasures(DefaultEscalationManager.this.worklistManager);
            escalationMeasures.setPriority(session, item, item.getPriority() + 1000);
            escalationMeasures.setDueDate(session, item, item.getEscalationDate() + 3600000L);
        }
    }
}

