/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractSubService;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.WorklistAdministration;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.AdministrativeWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.Worklist;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWorklistAdministration
extends AbstractSubService
implements WorklistAdministration {
    private final AbstractWorklistManager worklistManager;
    protected ExecutorService executorService;

    public DefaultWorklistAdministration(AbstractWorklistManager worklistManager) {
        super(worklistManager);
        this.worklistManager = worklistManager;
    }

    @Override
    public void init() throws AbortServiceException {
        this.executorService = Executors.newCachedThreadPool(new Adept2ThreadFactory("RedistributeWLItems", this.logger));
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        ExecutorTools.awaitTermination(this.executorService);
    }

    @Override
    public void emergencyShutdown() {
        this.executorService.shutdownNow();
        ExecutorTools.awaitTermination(this.executorService);
    }

    public Worklist<AdministrativeWorklistItem> getInternalWorklist(SessionToken session, UUID worklistID) {
        this.worklistManager.sessionActive(session);
        try {
            Worklist<AdministrativeWorklistItem> worklist = this.createAdministrativeWorklist(worklistID);
            return worklist;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not retrive Worklist due to a DataSource Exception!", e);
        }
        finally {
            this.worklistManager.sessionFinished(session);
        }
    }

    public Worklist<AdministrativeWorklistItem> getGlobalWorklist(SessionToken session) {
        this.worklistManager.sessionActive(session);
        try {
            Worklist<AdministrativeWorklistItem> worklist = this.getInternalWorklist(session, this.worklistManager.getGlobalWorklistID());
            return worklist;
        }
        finally {
            this.worklistManager.sessionFinished(session);
        }
    }

    @Override
    public UUID getWorklistID(SessionToken session, QualifiedAgent agent) {
        this.worklistManager.sessionActive(session);
        try {
            UUID uUID = this.worklistManager.getWorklistID(agent);
            return uUID;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not retrieve Worklist ID due to a DataSource Exception", e);
        }
        finally {
            this.worklistManager.sessionFinished(session);
        }
    }

    @Override
    public Map<QualifiedAgent, UUID> getWorklistsContaining(SessionToken session, EBPInstanceReference activity) {
        this.worklistManager.sessionActive(session);
        try {
            Map<QualifiedAgent, UUID> ret;
            WorklistItemStorage itemStorage = this.worklistManager.getWorklistItemStorage();
            UUID itemID = itemStorage.getInternalWorklistItemID(activity);
            if (itemID != null) {
                InternalWorklistItem item = itemStorage.getInternalWorklistItemReadonly(itemID);
                UUID[] worklistIDs = item.getWorklistIDs();
                UUID globalWorklistID = this.worklistManager.getGlobalWorklistID();
                WorklistStorage listStorage = this.worklistManager.getWorklistStorage();
                ret = new HashMap<QualifiedAgent, UUID>(worklistIDs.length);
                UUID[] uUIDArray = worklistIDs;
                int n = worklistIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    UUID worklistID = uUIDArray[n2];
                    if (!worklistID.equals(globalWorklistID)) {
                        InternalWorklist<InternalWorklistItem> worklist = listStorage.getInternalWorklistReadonly(worklistID);
                        ret.put(worklist.getAgent(), worklistID);
                    }
                    ++n2;
                }
                ret = Collections.unmodifiableMap(ret);
            } else {
                ret = Collections.emptyMap();
            }
            Map<QualifiedAgent, UUID> map = ret;
            return map;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not retrieve worklist (item ID) due to a DataSourceException", e);
        }
        finally {
            this.worklistManager.sessionFinished(session);
        }
    }

    private Worklist<AdministrativeWorklistItem> createAdministrativeWorklist(UUID worklistID) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> internalWorklist = this.worklistManager.getWorklistStorage().getInternalWorklistReadonly(worklistID);
        ArrayList<AdministrativeWorklistItem> worklistItems = new ArrayList<AdministrativeWorklistItem>();
        for (InternalWorklistItem item : internalWorklist.getWorklistItems()) {
            worklistItems.add(this.worklistManager.getWorklistModelFactory().createAdministrativeWorklistItem(item.getID(), item.getWorklistIDs(), item.getTitle(), item.getDescription(), item.getActivityReference(), item.getIconID(), item.getPriority(), item.getEscalationDate(), item.getDueDate(), item.getState(), item.getAssignedAgent(), item.getCurrentEscalationLevel(), item.getEscalationHandlingProcedureID(), item.getDistributionHandlingProcedureID(), item.getStaffAssignmentRule(), item.getActivationDate(), item.getAssignmentDate(), item.getComplexity(), item.getCurrentDelegationLevel(), item.getDelegationHistory(), item.getDelegationHandlingProcedureID(), item.getRepliedEnquiry(), item.getEnquiryStack(), item.getProcessTemplateName(), item.getProcessInstanceName(), item.getAttachedDataContext(), item.getSupportedPlugins(), item.getPluginDatas(), item.getUserAttributes()));
        }
        return this.worklistManager.getWorklistModelFactory().createAdministrativeWorklist(worklistID, internalWorklist.getAgent(), worklistItems, internalWorklist.getRevision(), internalWorklist.getUserAttributes());
    }

    @Override
    public void redistributeItems(SessionToken session, String staffAssignmentRule) {
        this.worklistManager.sessionActive(session);
        try {
            String msg = "Asynchronously redistributing worklist items containing staff assignment rule '%s'.";
            this.logger.fine(String.format(msg, staffAssignmentRule));
            RedistributeItems redistributor = new RedistributeItems(this.worklistManager, staffAssignmentRule, this.executorService);
            this.executorService.execute(redistributor);
        }
        finally {
            this.worklistManager.sessionFinished(session);
        }
    }

    static class DistributeItem
    implements Runnable {
        protected final Logger logger = LoggerTools.getLogger(this);
        protected final SessionToken session;
        protected final AbstractWorklistManager worklistManager;
        protected final UUID itemID;

        protected DistributeItem(SessionToken session, AbstractWorklistManager worklistManager, UUID itemID) {
            this.session = session;
            this.worklistManager = worklistManager;
            this.itemID = itemID;
        }

        @Override
        public void run() {
            WorklistItemStorage itemStorage = this.worklistManager.getWorklistItemStorage();
            try {
                InternalWorklistItem item = itemStorage.getAndLockInternalWorklistItem(this.session, this.itemID);
                try {
                    if (WorklistConstants.WorklistItemState.AVAILABLE.equals((Object)item.getState()) && item.getCurrentDelegationLevel() < 1 && item.getCurrentEnquiry() == null && item.getStaffAssignmentRule() != null) {
                        this.worklistManager.distribute(this.session, item, item.getStaffAssignmentRule());
                    }
                }
                finally {
                    itemStorage.unlockInternalWorklistItem(this.session, this.itemID);
                }
            }
            catch (DataSourceException dse) {
                String msg = "Accessing the worklist storage for locking or distributing the internal worklist item '%s' failed. The worklst item will not be (re-)distributed.";
                this.logger.log(Level.WARNING, String.format(msg, this.itemID), dse);
            }
            catch (LockException le) {
                String msg = "Could not (un-)lock internal internal worklist item '%s' for (re-)distribution. The worklst item will not be (re-)distributed.";
                this.logger.log(Level.WARNING, String.format(msg, this.itemID), le);
            }
            catch (InvalidWorklistItemStateException iwise) {
                String msg = "Could not (re-)distribute internal internal worklist item '%s' since it is in the wrong state. However, the state has been checked before while having the lock. The worklst item will not be (re-)distributed.";
                this.logger.log(Level.SEVERE, String.format(msg, this.itemID), iwise);
            }
        }
    }

    static class RedistributeItems
    implements Runnable {
        protected final Logger logger = LoggerTools.getLogger(this);
        protected final AbstractWorklistManager worklistManager;
        protected final String staffAssignmentRule;
        protected final ExecutorService executorService;

        protected RedistributeItems(AbstractWorklistManager worklistManager, String staffAssignmentRule, ExecutorService executorService) {
            this.worklistManager = worklistManager;
            this.staffAssignmentRule = staffAssignmentRule;
            this.executorService = executorService;
        }

        @Override
        public void run() {
            SessionToken session = this.worklistManager.getSessionToken();
            HashSet<UUID> affectedItems = new HashSet<UUID>();
            String msg = "Filtering all worklist items for redistribution of items that contain the staff assignment rule '%s'.";
            this.logger.fine(String.format(msg, this.staffAssignmentRule));
            try {
                UUID[] items;
                WorklistItemStorage itemStorage = this.worklistManager.getWorklistItemStorage();
                UUID[] uUIDArray = items = itemStorage.getInternalWorklistItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    UUID itemID = uUIDArray[n2];
                    if (Thread.interrupted()) {
                        msg = "Interrupted while retrieving worklists for SAR '%s' for redistribution. Aborting redistribution, no redistribution has occurred yet.";
                        this.logger.info(String.format(msg, this.staffAssignmentRule));
                        return;
                    }
                    InternalWorklistItem item = itemStorage.getInternalWorklistItemReadonly(itemID);
                    if (item != null && WorklistConstants.WorklistItemState.AVAILABLE.equals((Object)item.getState()) && item.getCurrentDelegationLevel() < 1 && item.getCurrentEnquiry() == null && item.getStaffAssignmentRule() != null && item.getStaffAssignmentRule().contains(this.staffAssignmentRule)) {
                        affectedItems.add(itemID);
                    }
                    ++n2;
                }
                msg = "Adding all worklist items that qualify for redistribution in respect of the staff assignment rule '%s'.";
                this.logger.fine(String.format(msg, this.staffAssignmentRule));
                for (UUID itemID : affectedItems) {
                    if (Thread.interrupted()) {
                        msg = "Interrupted while marking worklist items for SAR '%s' for redistribution. Aborting redistribution. However, some of the corresponding items may have been redistributed already.";
                        this.logger.warning(String.format(msg, this.staffAssignmentRule));
                        return;
                    }
                    session = this.worklistManager.getChildSession(session);
                    DistributeItem redistributor = new DistributeItem(session, this.worklistManager, itemID);
                    this.executorService.execute(redistributor);
                }
            }
            catch (DataSourceException dse) {
                msg = "Could not retrive worklist items for SAR '%s' for redistribution due to problems with the storage";
                msg = String.format(msg, this.staffAssignmentRule);
                throw new InternalServiceException(msg, dse);
            }
        }
    }
}

