/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistNotification;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.common.plugindata.EscalationData;
import de.aristaflow.adept2.model.common.plugindata.SchedulerData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.LightWeightProcessInstance;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.LWPActivityReference;
import de.aristaflow.adept2.model.worklistmodel.TLPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class DefaultWorklistNotification
implements WorklistNotification {
    protected static final String MSG_SERVICE_NOT_ACTIVE = "Service is not active, ignoring.";
    protected static final String CFG_DISTRIBUTION_HANDLING_ID = "distributionHandlingID";
    protected static final String CFG_DELEGATION_HANDLING_ID = "delegationHandlingID";
    protected static final String CFG_ESCALATION_PROCEDURE_ID = "escalationProcedureID";
    protected final String DEFAULT_ESCALATION_PROCEDURE_ID;
    protected final String DEFAULT_DELEGATION_PROCEDURE_ID;
    protected final String DEFAULT_DISTRIBUTION_HANDLING_ID;
    protected Logger logger = LoggerTools.getLogger(this);
    protected final AbstractWorklistManager worklistManager;
    protected ExecutorService executor;
    protected boolean initialUpdateActive = true;

    public DefaultWorklistNotification(Configuration configuration, AbstractWorklistManager worklistManager) {
        this.worklistManager = worklistManager;
        this.executor = Executors.newSingleThreadExecutor(new Adept2ThreadFactory("WorklistNotification.ExecutorThread"));
        this.DEFAULT_DISTRIBUTION_HANDLING_ID = configuration.getString(CFG_DISTRIBUTION_HANDLING_ID);
        this.DEFAULT_DELEGATION_PROCEDURE_ID = configuration.getString(CFG_DELEGATION_HANDLING_ID);
        this.DEFAULT_ESCALATION_PROCEDURE_ID = configuration.getString(CFG_ESCALATION_PROCEDURE_ID);
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Thread pool for worklist updates did not shut down in time! Continuing service shutdown.");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void emergencyShutdown() {
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(2000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Thread pool for worklist updates did not urgently shut down! Continuing service shutdown.");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void addActivity(ExecutableBusinessProcessInstance ebpInstance, ProcessConstants.NodeState state, EBPInstanceReference ebpInstanceReference, String staffAssignmentRule) {
        this.logger.fine("Asynchronously adding Activity (" + ebpInstanceReference + ")");
        AddActivity run = new AddActivity(ebpInstance, ebpInstanceReference, this.getWorklistItemState(state), staffAssignmentRule);
        this.executor.execute(run);
    }

    @Override
    public void assignAndUpdateActivity(EBPInstanceReference activity, ProcessConstants.NodeState state, QualifiedAgent agent) {
        this.logger.fine("Asynchronously assigning and updating Activity (" + activity + ")");
        AssignAndUpdateActivity run = new AssignAndUpdateActivity(agent, activity, this.getWorklistItemState(state));
        this.executor.execute(run);
    }

    @Override
    public void addAndAssignActivity(ExecutableBusinessProcessInstance ebpInstance, ProcessConstants.NodeState state, EBPInstanceReference ebpInstanceReference, String staffAssignmentRule, QualifiedAgent agent) {
        this.logger.fine("Asynchronously adding and assigning Activity (" + ebpInstanceReference + ")");
        AddAndAssignActivity run = new AddAndAssignActivity(ebpInstance, ebpInstanceReference, staffAssignmentRule, this.getWorklistItemState(state), agent);
        this.executor.execute(run);
    }

    @Override
    public void removeActivity(EBPInstanceReference activity) {
        this.logger.fine("Asynchronously removing Activity (" + activity + ")");
        RemoveActivity run = new RemoveActivity(activity);
        this.executor.execute(run);
    }

    @Override
    public void updateActivityState(EBPInstanceReference activity, ProcessConstants.NodeState state) {
        this.logger.fine("Asynchronously updating Activity state for (" + activity + ") to " + (Object)((Object)state));
        UpdateActivityState run = new UpdateActivityState(activity, this.getWorklistItemState(state));
        this.executor.execute(run);
    }

    @Override
    public void removeAllActivities() {
        this.logger.fine("Asynchronously removing all Activity ");
        RemoveAllActivities run = new RemoveAllActivities();
        this.executor.execute(run);
    }

    @Override
    public void enquireActivity(EBPInstanceReference activity, Enquiry enquiry) {
        this.logger.fine("Asynchronously enquiring Activity (" + activity + ")");
        EnquiryActivity run = new EnquiryActivity(activity, enquiry);
        this.executor.execute(run);
    }

    @Override
    public void replyEnquiry(EBPInstanceReference activity, Enquiry enquiry) {
        this.logger.fine("Asynchronously reply to Enquiry for Activity (" + activity + ")");
        ReplyEnquiry run = new ReplyEnquiry(activity, enquiry);
        this.executor.execute(run);
    }

    @Override
    public void initialUpdateComplete() {
        this.logger.fine("Asynchronously telling the Worklist Manager that the Initial Update is complete");
        InitialUpdateComplete run = new InitialUpdateComplete();
        this.executor.execute(run);
    }

    protected WorklistItemStorage getWorklistItemStorage() {
        return this.worklistManager.getWorklistItemStorage();
    }

    protected WorklistStorage getWorklistStorage() {
        return this.worklistManager.getWorklistStorage();
    }

    void removeWorklistItem(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
        UUID[] uUIDArray = worklistItem.getWorklistIDs();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistID = uUIDArray[n2];
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
            worklist.removeWorklistItem(worklistItem);
            worklistItem.removedFromWorklist(worklist.getID());
            this.worklistManager.getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
            this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
            ++n2;
        }
        this.worklistManager.getEscalationManager().worklistItemRemoved(worklistItem);
        this.postRemoveWorklistItemHook(session, worklistItem);
        this.getWorklistItemStorage().removeInternalWorklistItem(worklistItem.getID());
    }

    protected void distributeToGlobalWorklist(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException, LockException {
        this.worklistManager.addItemToWorklist(session, this.worklistManager.getGlobalWorklistID(), worklistItem, false);
    }

    protected boolean isSpecialWorklist(UUID worklistID) {
        return worklistID.equals(this.worklistManager.getGlobalWorklistID());
    }

    protected OrgModelManager getOrgModelManager() {
        return this.worklistManager.getOrgModelManager();
    }

    protected InternalWorklistItem createInternalWorklistItem(ExecutableBusinessProcessInstance ebpInstance, EBPInstanceReference ebpInstanceReference, WorklistConstants.WorklistItemState state, String staffAssignmentRule) throws DataSourceException {
        long dueDate;
        PluginData pluginDataDist = ebpInstance.getPluginData("SchedulerData");
        Map<String, String> schedulerAttribs = pluginDataDist == null ? new HashMap<String, String>() : pluginDataDist.getPluginData();
        SchedulerData schedulerData = ModelViewer.createView(schedulerAttribs, SchedulerData.class);
        int priority = schedulerData.getPriority();
        long complexity = schedulerData.getComplexity();
        long activationDate = System.currentTimeMillis();
        if (schedulerData.getDueDate() < 0L) {
            long dueDateReference = schedulerData.getDueDateReference();
            if (dueDateReference == 0L) {
                dueDateReference = activationDate;
            }
            dueDate = dueDateReference + -schedulerData.getDueDate();
        } else {
            dueDate = schedulerData.getDueDate() > 0L ? schedulerData.getDueDate() : 0L;
        }
        PluginData pluginDataEsc = ebpInstance.getPluginData("EscalationData");
        Map<String, String> escalationAttribs = pluginDataEsc == null ? new HashMap<String, String>() : pluginDataEsc.getPluginData();
        EscalationData escalationData = ModelViewer.createView(escalationAttribs, EscalationData.class);
        long escalationDate = escalationData.getEscalationDate() < 0L ? activationDate + -escalationData.getEscalationDate() : escalationData.getEscalationDate();
        String escalationHandlingProcedureID = escalationData.getEscalationHandlingProcedureID() != null ? escalationData.getEscalationHandlingProcedureID() : this.DEFAULT_ESCALATION_PROCEDURE_ID;
        String delegationHandlingProcedureID = schedulerData.getDelegationHandlingProcedureID() != null ? schedulerData.getDelegationHandlingProcedureID() : this.DEFAULT_DELEGATION_PROCEDURE_ID;
        String distributionHandlingProcedureID = schedulerData.getDistributionHandlingProcedureID() != null ? schedulerData.getDistributionHandlingProcedureID() : this.DEFAULT_DISTRIBUTION_HANDLING_ID;
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        PluginData instanceTranslationData = ebpInstance.getPluginData("ProcessLocalisation");
        DefaultPluginData translationData = null;
        if (instanceTranslationData != null) {
            HashMap<String, String> translationAttributes = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : instanceTranslationData.getPluginData().entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("Name.")) {
                    key = key.replace("Name", "Title");
                }
                translationAttributes.put(key, entry.getValue());
            }
            if (translationAttributes.size() > 0) {
                translationData = new DefaultPluginData("ProcessLocalisation", translationAttributes);
            }
        }
        ActivityReference activityReference = this.createActivityReference(ebpInstance, ebpInstanceReference);
        HashMap<String, PluginData> pluginDatas = new HashMap<String, PluginData>(ebpInstance.getPluginDatas());
        if (translationData != null) {
            pluginDatas.put("ProcessLocalisation", translationData);
        }
        InternalWorklistItem item = this.getWorklistItemStorage().createInternalWorklistItem(ebpInstance.getName(), ebpInstance.getDescription(), activityReference, ebpInstance.getIconID(), staffAssignmentRule, state, priority, complexity, activationDate, escalationDate, dueDate, escalationHandlingProcedureID, delegationHandlingProcedureID, distributionHandlingProcedureID, ebpInstance.getProcessTemplateName(), ebpInstance.getProcessInstanceName(), ebpInstance.getSupportedPlugins(), pluginDatas, ebpInstance.getAttachedDataContext(), userAttributes, ebpInstanceReference);
        return item;
    }

    protected ActivityReference createActivityReference(ExecutableBusinessProcessInstance ebpInstance, EBPInstanceReference ebpInstanceReference) {
        DefaultUserAttributeContainer activityReference;
        Map<String, String> userAttributes = ebpInstanceReference instanceof UserAttributeContainer ? ((UserAttributeContainer)((Object)ebpInstanceReference)).getUserAttributes() : new HashMap<String, String>();
        if (ebpInstance instanceof ActivityInstance) {
            ActivityInstance activityInstance = (ActivityInstance)ebpInstance;
            activityReference = new ADEPT2ActivityReference(ebpInstanceReference, activityInstance, userAttributes);
        } else if (ebpInstance instanceof LightWeightProcessInstance) {
            if (ebpInstance.getType() == EBPType.TLPI) {
                activityReference = new TLPInstanceReference(ebpInstanceReference.getInstanceID(), ebpInstanceReference.getExecutionManagerURIs(), ebpInstanceReference.getBaseTemplateID(), null);
            } else {
                LightWeightProcessInstance lwpInstance = (LightWeightProcessInstance)ebpInstance;
                activityReference = new LWPActivityReference(ebpInstanceReference, lwpInstance, userAttributes);
            }
        } else {
            this.logger.severe(String.format("Unkown ExecutableBusinessProcessInstance type '%s'!", ebpInstance.getClass()));
            activityReference = null;
        }
        return activityReference;
    }

    protected WorklistConstants.WorklistItemState getWorklistItemState(ProcessConstants.NodeState state) {
        switch (state) {
            case NS_ACTIVATED: {
                return WorklistConstants.WorklistItemState.AVAILABLE;
            }
            case NS_RUNNING: {
                return WorklistConstants.WorklistItemState.STARTED;
            }
            case NS_SELECTED: {
                return WorklistConstants.WorklistItemState.ASSIGNED;
            }
            case NS_SUSPENDED: {
                return WorklistConstants.WorklistItemState.SUSPENDED;
            }
            case NS_ENQUIRED: {
                return WorklistConstants.WorklistItemState.ENQUIRED;
            }
        }
        this.logger.warning("Can't map node state '" + (Object)((Object)state) + "'!");
        return null;
    }

    protected void internalAssignAndUpdate(SessionToken session, InternalWorklistItem worklistItem, QualifiedAgent agent, EBPInstanceReference activity, WorklistConstants.WorklistItemState state) throws DataSourceException, LockException, InvalidWorklistItemStateException {
        this.logger.finer(String.format("Assigning and Updating WorklistItem %s to Agent %s", worklistItem.getID(), agent));
        worklistItem.storeCurrentState(false);
        worklistItem.setAssignedAgent(agent);
        worklistItem.setAssignmentDate(System.currentTimeMillis());
        worklistItem.setState(state);
        if (worklistItem.getActivityReference() instanceof ADEPT2EBPReference) {
            ((ADEPT2EBPReference)worklistItem.getActivityReference()).setRuntimeManagerURIs(activity.getRuntimeManagerURIs());
        }
        boolean alreadyInAgentWorklist = false;
        UUID[] uUIDArray = worklistItem.getWorklistIDs();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistID = uUIDArray[n2];
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
            if (worklist.getAgent().equals(agent)) {
                alreadyInAgentWorklist = true;
            } else if (!this.isSpecialWorklist(worklistID)) {
                worklist.removeWorklistItem(worklistItem);
                worklistItem.removedFromWorklist(worklistID);
                this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                this.worklistManager.getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
            }
            ++n2;
        }
        UUID agentWorklistID = this.worklistManager.getWorklistID(agent);
        InternalWorklist<InternalWorklistItem> agentWorklist = this.getWorklistStorage().getInternalWorklistReadonly(agentWorklistID);
        if (!alreadyInAgentWorklist) {
            this.logger.warning(String.format("Assigning Worklist Item '%s' to Agent '%s' although the item hasn't previously been on the agent worklist!", worklistItem.getID(), agent));
            agentWorklist.addWorklistItem(worklistItem);
            worklistItem.addedToWorklist(agentWorklist.getID());
            this.worklistManager.getEscalationManager().worklistItemAddedToWorklist(worklistItem, agentWorklist);
            if (!agentWorklist.isPresentNow()) {
                this.logger.severe(String.format("Assigning Worklist Item '%s' to Agent '%s' which is currently absent. Escalating Item!", worklistItem.getID(), agent));
                this.worklistManager.escalateToInstanceSupervisor(this.worklistManager.getChildSession(session), worklistItem, "Tried to assigning Worklist Item to Agent which is currently absent.");
            }
        } else {
            agentWorklist.updateWorklistItem(worklistItem);
        }
        this.postAssignAndUpdateActivityHook(session, worklistItem);
        this.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
        this.worklistManager.asyncNotifyClientsAboutUpdate(agentWorklist);
        this.worklistManager.updateAndNotifyGlobalWorklist(worklistItem);
    }

    protected void postAssignAndUpdateActivityHook(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
    }

    public void postUpdateActivityStateHook(SessionToken session, InternalWorklistItem worklistItem) throws DataSourceException {
    }

    public void postAddActivityHook(SessionToken session, InternalWorklistItem item) throws DataSourceException {
    }

    protected void postRemoveWorklistItemHook(SessionToken session, InternalWorklistItem worklistItem) {
    }

    class AddActivity
    extends ExecutorRunnable {
        private final ExecutableBusinessProcessInstance ebpInstance;
        private final EBPInstanceReference ebpInstanceReference;
        private final WorklistConstants.WorklistItemState state;
        private final String staffAssignmentRule;

        public AddActivity(ExecutableBusinessProcessInstance ebpInstance, EBPInstanceReference ebpInstanceReference, WorklistConstants.WorklistItemState state, String staffAssignmentRule) {
            super("WorklistNotification.addActivity(" + ebpInstanceReference + ")");
            this.ebpInstance = ebpInstance;
            this.ebpInstanceReference = ebpInstanceReference;
            this.state = state;
            this.staffAssignmentRule = staffAssignmentRule;
        }

        @Override
        public void run() {
            block18: {
                if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                    DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                    return;
                }
                DefaultWorklistNotification.this.logger.info("Adding Activity (" + this.ebpInstanceReference + ") to Worklist");
                try {
                    UUID itemID = DefaultWorklistNotification.this.worklistManager.getWorklistItemStorage().getInternalWorklistItemID(this.ebpInstanceReference);
                    if (itemID != null && !DefaultWorklistNotification.this.initialUpdateActive) {
                        DefaultWorklistNotification.this.logger.info(String.format("There already exists a worklist item with ID %sfor Activity '%s'! Skipping add.", itemID, this.ebpInstanceReference));
                        break block18;
                    }
                    InternalWorklistItem item = DefaultWorklistNotification.this.createInternalWorklistItem(this.ebpInstance, this.ebpInstanceReference, this.state, this.staffAssignmentRule);
                    SessionToken childSession = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                    DefaultWorklistNotification.this.getWorklistItemStorage().lockInternalWorklistItem(childSession, item.getID());
                    try {
                        DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(childSession, item.getID());
                        try {
                            DefaultWorklistNotification.this.postAddActivityHook(childSession, item);
                        }
                        finally {
                            DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(childSession, item.getID());
                        }
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(childSession, item.getID());
                    }
                    DefaultWorklistNotification.this.logger.fine(String.format("Adding worklistItem %s for Activity %s", item.getID(), this.ebpInstanceReference));
                    if (DefaultWorklistNotification.this.initialUpdateActive && itemID != null) break block18;
                    SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                    DefaultWorklistNotification.this.getWorklistItemStorage().lockInternalWorklistItem(session, item.getID());
                    DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemAdded(item);
                    try {
                        DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, item.getID());
                        try {
                            DefaultWorklistNotification.this.distributeToGlobalWorklist(DefaultWorklistNotification.this.worklistManager.getChildSession(session), item);
                            DefaultWorklistNotification.this.worklistManager.distribute(DefaultWorklistNotification.this.worklistManager.getChildSession(session), item, this.staffAssignmentRule);
                        }
                        finally {
                            DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, item.getID());
                        }
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, item.getID());
                    }
                }
                catch (DataSourceException e) {
                    DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not add Activity", e);
                }
                catch (LockException e) {
                    DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not add Activity", e);
                }
                catch (InvalidWorklistItemStateException e) {
                    DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not add Activity", e);
                }
            }
        }
    }

    class AddAndAssignActivity
    extends ExecutorRunnable {
        private final ExecutableBusinessProcessInstance ebpInstance;
        private final EBPInstanceReference ebpInstanceReference;
        private final String staffAssignmentRule;
        private final WorklistConstants.WorklistItemState state;
        private final QualifiedAgent agent;

        public AddAndAssignActivity(ExecutableBusinessProcessInstance ebpInstance, EBPInstanceReference ebpInstanceReference, String staffAssignmentRule, WorklistConstants.WorklistItemState state, QualifiedAgent agent) {
            super("WorklistNotification.addAndAssignActivity(" + ebpInstanceReference + ")");
            this.ebpInstance = ebpInstance;
            this.ebpInstanceReference = ebpInstanceReference;
            this.staffAssignmentRule = staffAssignmentRule;
            this.state = state;
            this.agent = agent;
        }

        @Override
        public void run() {
            block19: {
                if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                    DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                    return;
                }
                DefaultWorklistNotification.this.logger.info("Adding Activity " + this.ebpInstanceReference + " to Worklist");
                try {
                    UUID itemID = DefaultWorklistNotification.this.worklistManager.getWorklistItemStorage().getInternalWorklistItemID(this.ebpInstanceReference);
                    SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                    if (itemID != null && !DefaultWorklistNotification.this.initialUpdateActive) {
                        DefaultWorklistNotification.this.logger.info(String.format("There already exists a worklist item for Activity '%s'! Skipping add.", this.ebpInstanceReference));
                        InternalWorklistItem item = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, itemID);
                        try {
                            DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, item.getID());
                            try {
                                DefaultWorklistNotification.this.internalAssignAndUpdate(DefaultWorklistNotification.this.worklistManager.getChildSession(session), item, this.agent, this.ebpInstanceReference, this.state);
                                break block19;
                            }
                            finally {
                                DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, item.getID());
                            }
                        }
                        finally {
                            DefaultWorklistNotification.this.worklistManager.getWorklistItemStorage().unlockInternalWorklistItem(session, itemID);
                        }
                    }
                    UUID agentWorklistID = DefaultWorklistNotification.this.worklistManager.getWorklistID(this.agent);
                    InternalWorklist<InternalWorklistItem> agentWorklist = DefaultWorklistNotification.this.getWorklistStorage().getInternalWorklistReadonly(agentWorklistID);
                    InternalWorklistItem item = DefaultWorklistNotification.this.createInternalWorklistItem(this.ebpInstance, this.ebpInstanceReference, this.state, this.staffAssignmentRule);
                    DefaultWorklistNotification.this.logger.fine(String.format("Adding worklistItem %s for Activity %s", item.getID(), this.ebpInstanceReference));
                    DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemAdded(item);
                    DefaultWorklistNotification.this.getWorklistItemStorage().lockInternalWorklistItem(session, item.getID());
                    try {
                        if (DefaultWorklistNotification.this.initialUpdateActive && itemID != null && item.getDelegationHistory().size() == 0) {
                            UUID[] uUIDArray = item.getWorklistIDs();
                            int n = uUIDArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                UUID wID = uUIDArray[n2];
                                item.removedFromWorklist(wID);
                                ++n2;
                            }
                        }
                        DefaultWorklistNotification.this.distributeToGlobalWorklist(DefaultWorklistNotification.this.worklistManager.getChildSession(session), item);
                        DefaultWorklistNotification.this.logger.fine(String.format("Assigning worklistItem %s to Agent %s", item.getID(), this.agent));
                        if (item.getDelegationHistory().size() == 0) {
                            agentWorklist.addWorklistItem(item);
                            item.addedToWorklist(agentWorklist.getID());
                            item.setAssignedAgent(this.agent);
                            item.setAssignmentDate(System.currentTimeMillis());
                        }
                        DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemAddedToWorklist(item, agentWorklist);
                        if (!agentWorklist.isPresentNow()) {
                            DefaultWorklistNotification.this.logger.warning(String.format("Adding and assigning worklist item '%s' to worklist '%s' which is marked as absent!", item.getID(), agentWorklist.getID()));
                            DefaultWorklistNotification.this.worklistManager.escalateToInstanceSupervisor(DefaultWorklistNotification.this.worklistManager.getChildSession(session), item, "Tried to assigning Worklist Item to Agent which is currently absent.");
                        }
                        DefaultWorklistNotification.this.getWorklistItemStorage().updateInternalWorklistItem(session, item);
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, item.getID());
                    }
                    DefaultWorklistNotification.this.worklistManager.asyncNotifyClientsAboutUpdate(agentWorklist);
                    DefaultWorklistNotification.this.worklistManager.updateAndNotifyGlobalWorklist(item);
                }
                catch (DataSourceException e) {
                    DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not add and assign activity due to a DataSource Exception!", e);
                }
                catch (LockException e) {
                    DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not add and assign activity due to a Lock Exception!", e);
                }
                catch (InvalidWorklistItemStateException e) {
                    DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not add and assign activity due to an Invalid Worklist Item State Exception!", e);
                }
            }
        }
    }

    class AssignAndUpdateActivity
    extends ExecutorRunnable {
        private final QualifiedAgent agent;
        private final EBPInstanceReference activity;
        private final WorklistConstants.WorklistItemState state;

        public AssignAndUpdateActivity(QualifiedAgent agent, EBPInstanceReference activity, WorklistConstants.WorklistItemState state) {
            super("WorklistNotification.assignAndUpdateActivity(" + activity + ")");
            this.agent = agent;
            this.activity = activity;
            this.state = state;
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            try {
                UUID worklistItemID = DefaultWorklistNotification.this.getWorklistItemStorage().getInternalWorklistItemID(this.activity);
                if (worklistItemID == null) {
                    String message = String.format("Can't assign Activity '%s' to user '%s'! Reason: No corresponding Worklist Item!", this.activity, this.agent);
                    DefaultWorklistNotification.this.logger.severe(message);
                    throw new InternalServiceException(message);
                }
                DefaultWorklistNotification.this.logger.finer(String.format("Found WorklistItem %s for Activity %s", worklistItemID, this.activity));
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                InternalWorklistItem worklistItem = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, worklistItemID);
                try {
                    DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, worklistItemID);
                    try {
                        DefaultWorklistNotification.this.internalAssignAndUpdate(DefaultWorklistNotification.this.worklistManager.getChildSession(session), worklistItem, this.agent, this.activity, this.state);
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, worklistItemID);
                    }
                }
                finally {
                    DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItemID);
                }
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not assign and update Activity due to a DataSource Exception!", e);
            }
            catch (LockException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not assign and update Activity due to a Lock Exception!", e);
            }
            catch (InvalidWorklistItemStateException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not assign and update Activity due to an Invalid Worklist Item State Exception!", e);
            }
        }
    }

    public class EnquiryActivity
    extends ExecutorRunnable {
        private final EBPInstanceReference activity;
        private final Enquiry enquiry;

        public EnquiryActivity(EBPInstanceReference activity, Enquiry enquiry) {
            super("WorklistNotification.EnquiryActivity(" + activity + ")");
            this.activity = activity;
            this.enquiry = enquiry;
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            try {
                UUID worklistItemID = DefaultWorklistNotification.this.getWorklistItemStorage().getInternalWorklistItemID(this.activity);
                if (worklistItemID == null) {
                    String message = String.format("Can't update Activity '%s'! Reason: No corresponding Worklist Item!", this.activity);
                    DefaultWorklistNotification.this.logger.severe(message);
                    throw new RuntimeException(message);
                }
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                InternalWorklistItem worklistItem = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, worklistItemID);
                try {
                    DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, worklistItemID);
                    try {
                        UUID[] uUIDArray = worklistItem.getWorklistIDs();
                        int n = uUIDArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            UUID worklistID = uUIDArray[n2];
                            if (!DefaultWorklistNotification.this.isSpecialWorklist(worklistID)) {
                                InternalWorklist<InternalWorklistItem> worklist = DefaultWorklistNotification.this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                                worklistItem.removedFromWorklist(worklistID);
                                worklist.removeWorklistItem(worklistItem);
                                DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
                                DefaultWorklistNotification.this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                            }
                            ++n2;
                        }
                        worklistItem.enquireItem(this.enquiry);
                        worklistItem.setAssignedAgent(null);
                        worklistItem.setAssignmentDate(0L);
                        for (QualifiedAgent agent : this.enquiry.getRecipients()) {
                            UUID worklistID = DefaultWorklistNotification.this.worklistManager.getWorklistID(agent);
                            DefaultWorklistNotification.this.worklistManager.addItemToWorklist(DefaultWorklistNotification.this.worklistManager.getChildSession(session), worklistID, worklistItem, false);
                        }
                        DefaultWorklistNotification.this.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, worklistItemID);
                    }
                }
                finally {
                    DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItemID);
                }
                DefaultWorklistNotification.this.worklistManager.updateAndNotifyGlobalWorklist(worklistItem);
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not start enquiry for Activity due toa DataSource Exception", e);
            }
            catch (LockException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not start enquiry for Activity due toa Lock Exception", e);
            }
        }
    }

    public static abstract class ExecutorRunnable
    implements Runnable {
        private final String description;

        public ExecutorRunnable(String description) {
            this.description = description;
        }

        @Override
        public abstract void run();

        public String getDescription() {
            return this.description;
        }
    }

    public class InitialUpdateComplete
    extends ExecutorRunnable {
        public InitialUpdateComplete() {
            super("WorklistNotification.initalUpdateComplete");
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            DefaultWorklistNotification.this.logger.info("Initial Update of the Worklist Manager completed.");
            DefaultWorklistNotification.this.initialUpdateActive = false;
            try {
                UUID[] worklists;
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                DefaultWorklistNotification.this.worklistManager.getWorklistManagerStorage().initialUpdateComplete();
                UUID[] uUIDArray = worklists = DefaultWorklistNotification.this.worklistManager.getWorklistStorage().getInternalWorklists();
                int n = worklists.length;
                int n2 = 0;
                while (n2 < n) {
                    UUID worklistID = uUIDArray[n2];
                    InternalWorklist<InternalWorklistItem> worklist = DefaultWorklistNotification.this.worklistManager.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                    WorklistUpdateConfiguration config = DefaultWorklistNotification.this.worklistManager.getWorklistStorage().getMailingClientWorklistConfig(worklistID);
                    if (config != null) {
                        DefaultWorklistNotification.this.worklistManager.addMailingClientWorklist(DefaultWorklistNotification.this.worklistManager.getChildSession(session), worklistID, true, config, worklist.getAgent());
                    }
                    for (InternalWorklistItem item : worklist.getWorklistItems()) {
                        DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemAddedToWorklist(item, worklist);
                    }
                    if (worklist.getSubstitutionRule().length() > 0) {
                        DefaultWorklistNotification.this.worklistManager.getAvailabilityManager().setAbsent(worklist.getAgent(), worklist.getAbsenceFromDate(), worklist.getAbsenceToDate(), worklist.getSubstitutionRule());
                    }
                    ++n2;
                }
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not finish inital Update due toa DataSource Exception!", e);
            }
        }
    }

    class RemoveActivity
    extends ExecutorRunnable {
        private final EBPInstanceReference ebpInstanceReference;

        public RemoveActivity(EBPInstanceReference activity) {
            super("WorklistInteraction.RemoveActivity(" + activity + ")");
            this.ebpInstanceReference = activity;
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            try {
                UUID worklistItemID = DefaultWorklistNotification.this.getWorklistItemStorage().getInternalWorklistItemID(this.ebpInstanceReference);
                if (worklistItemID == null) {
                    String message = String.format("Can't remove Activity '%s'! Reason: No corresponding Worklist Item!", this.ebpInstanceReference);
                    DefaultWorklistNotification.this.logger.severe(message);
                    throw new RuntimeException(message);
                }
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                InternalWorklistItem worklistItem = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, worklistItemID);
                try {
                    DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, worklistItemID);
                    try {
                        DefaultWorklistNotification.this.logger.info("Removing Activity " + worklistItem + " (" + this.ebpInstanceReference + ") from Worklist");
                        DefaultWorklistNotification.this.removeWorklistItem(DefaultWorklistNotification.this.worklistManager.getChildSession(session), worklistItem);
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, worklistItemID);
                    }
                }
                finally {
                    DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItemID);
                }
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not remove Activity due to a DataSource exception", e);
            }
            catch (LockException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not remove Activity due to a Lock exception", e);
            }
        }
    }

    class RemoveAllActivities
    extends ExecutorRunnable {
        public RemoveAllActivities() {
            super("WorklistNotification.RemoveAllActivities");
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            try {
                UUID[] items = DefaultWorklistNotification.this.getWorklistItemStorage().getInternalWorklistItems();
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                UUID[] uUIDArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    UUID worklistItemID = uUIDArray[n2];
                    InternalWorklistItem item = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, worklistItemID);
                    try {
                        DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, worklistItemID);
                        try {
                            DefaultWorklistNotification.this.removeWorklistItem(DefaultWorklistNotification.this.worklistManager.getChildSession(session), item);
                        }
                        finally {
                            DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, worklistItemID);
                        }
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItemID);
                    }
                    ++n2;
                }
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not remove all activities!", e);
            }
            catch (LockException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not remove all activities!", e);
            }
        }
    }

    public class ReplyEnquiry
    extends ExecutorRunnable {
        private final EBPInstanceReference activity;
        private final Enquiry enquiry;

        public ReplyEnquiry(EBPInstanceReference activity, Enquiry enquiry) {
            super("WorklistNotification.ReplyEnquiry(" + activity + ")");
            this.activity = activity;
            this.enquiry = enquiry;
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            try {
                UUID worklistItemID = DefaultWorklistNotification.this.getWorklistItemStorage().getInternalWorklistItemID(this.activity);
                if (worklistItemID == null) {
                    String message = String.format("Can't update Activity '%s'! Reason: No corresponding Worklist Item!", this.activity);
                    DefaultWorklistNotification.this.logger.severe(message);
                    throw new RuntimeException(message);
                }
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                UUID orgWorklistID = DefaultWorklistNotification.this.worklistManager.getWorklistID(this.enquiry.getOriginator());
                InternalWorklist<InternalWorklistItem> orgWorklist = DefaultWorklistNotification.this.getWorklistStorage().getInternalWorklistReadonly(orgWorklistID);
                InternalWorklistItem worklistItem = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, worklistItemID);
                try {
                    DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, worklistItemID);
                    try {
                        UUID[] uUIDArray = worklistItem.getWorklistIDs();
                        int n = uUIDArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            UUID worklistID = uUIDArray[n2];
                            if (!DefaultWorklistNotification.this.isSpecialWorklist(worklistID)) {
                                InternalWorklist<InternalWorklistItem> worklist = DefaultWorklistNotification.this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                                worklist.removeWorklistItem(worklistItem);
                                worklistItem.removedFromWorklist(worklist.getID());
                                DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
                                DefaultWorklistNotification.this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                            }
                            ++n2;
                        }
                        worklistItem.replyEnquiry(this.enquiry);
                        orgWorklist.addWorklistItem(worklistItem);
                        worklistItem.addedToWorklist(orgWorklistID);
                        DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemAddedToWorklist(worklistItem, orgWorklist);
                        if (!orgWorklist.isPresentNow()) {
                            DefaultWorklistNotification.this.worklistManager.applySubstitutionRule(DefaultWorklistNotification.this.worklistManager.getChildSession(session), worklistItem);
                        }
                        DefaultWorklistNotification.this.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, worklistItemID);
                    }
                }
                finally {
                    DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItemID);
                }
                DefaultWorklistNotification.this.worklistManager.asyncNotifyClientsAboutUpdate(orgWorklist);
                DefaultWorklistNotification.this.worklistManager.updateAndNotifyGlobalWorklist(worklistItem);
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not reply to Enquiry", e);
            }
            catch (LockException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not reply to Enquiry", e);
            }
            catch (InvalidWorklistItemStateException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not reply to Enquiry", e);
            }
        }
    }

    protected class UpdateActivityState
    extends ExecutorRunnable {
        private final EBPInstanceReference activity;
        private final WorklistConstants.WorklistItemState state;

        public UpdateActivityState(EBPInstanceReference activity, WorklistConstants.WorklistItemState state) {
            super("WorklistNotification.UpdateActivityState(" + activity + ")");
            this.activity = activity;
            this.state = state;
        }

        @Override
        public void run() {
            if (!DefaultWorklistNotification.this.worklistManager.isActive()) {
                DefaultWorklistNotification.this.logger.info(DefaultWorklistNotification.MSG_SERVICE_NOT_ACTIVE);
                return;
            }
            try {
                UUID worklistItemID = DefaultWorklistNotification.this.getWorklistItemStorage().getInternalWorklistItemID(this.activity);
                if (worklistItemID == null) {
                    String message = String.format("Can't update Activity '%s'! Reason: No corresponding Worklist Item!", this.activity);
                    DefaultWorklistNotification.this.logger.severe(message);
                    throw new RuntimeException(message);
                }
                DefaultWorklistNotification.this.logger.finer(String.format("Found WorklistItem %s for Activity %s.", worklistItemID, this.activity));
                SessionToken session = DefaultWorklistNotification.this.worklistManager.getSessionToken();
                InternalWorklistItem worklistItem = DefaultWorklistNotification.this.getWorklistItemStorage().getAndLockInternalWorklistItem(session, worklistItemID);
                try {
                    DefaultWorklistNotification.this.getWorklistItemStorage().startTransaction(session, worklistItemID);
                    try {
                        DefaultWorklistNotification.this.logger.finer(String.format("Setting State of Worklist Item %1$s to %2$s", new Object[]{worklistItem, this.state}));
                        worklistItem.setState(this.state);
                        if (worklistItem.getActivityReference() instanceof ADEPT2EBPReference) {
                            ((ADEPT2EBPReference)worklistItem.getActivityReference()).setRuntimeManagerURIs(this.activity.getRuntimeManagerURIs());
                        }
                        DefaultWorklistNotification.this.postUpdateActivityStateHook(session, worklistItem);
                        if (WorklistConstants.WorklistItemState.AVAILABLE.equals((Object)this.state) && worklistItem.getAvailableStateWorklistIDs() != null) {
                            InternalWorklist<InternalWorklistItem> worklist;
                            UUID worklistID;
                            DefaultWorklistNotification.this.logger.finer(String.format("Setting worklist item %s back to available.", worklistItem.getID()));
                            UUID[] uUIDArray = worklistItem.getWorklistIDs();
                            int n = uUIDArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                worklistID = uUIDArray[n2];
                                worklist = DefaultWorklistNotification.this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                                if (!DefaultWorklistNotification.this.isSpecialWorklist(worklistID)) {
                                    worklist.removeWorklistItem(worklistItem);
                                    worklistItem.removedFromWorklist(worklistID);
                                    DefaultWorklistNotification.this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                                    DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
                                }
                                ++n2;
                            }
                            worklistItem.restoreAvailableState();
                            worklistItem.setAssignedAgent(null);
                            worklistItem.setAssignmentDate(0L);
                            uUIDArray = worklistItem.getWorklistIDs();
                            n = uUIDArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                worklistID = uUIDArray[n2];
                                worklist = DefaultWorklistNotification.this.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                                if (!DefaultWorklistNotification.this.isSpecialWorklist(worklistID)) {
                                    worklist.addWorklistItem(worklistItem);
                                    DefaultWorklistNotification.this.worklistManager.getEscalationManager().worklistItemAddedToWorklist(worklistItem, worklist);
                                }
                                ++n2;
                            }
                        }
                        DefaultWorklistNotification.this.getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
                    }
                    finally {
                        DefaultWorklistNotification.this.getWorklistItemStorage().finishTransaction(session, worklistItemID);
                    }
                }
                finally {
                    DefaultWorklistNotification.this.getWorklistItemStorage().unlockInternalWorklistItem(session, worklistItemID);
                }
                DefaultWorklistNotification.this.worklistManager.notifyWorklistsAboutUpdate(worklistItem);
            }
            catch (DataSourceException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not update activity state due to a DataSource exception!", e);
            }
            catch (LockException e) {
                DefaultWorklistNotification.this.logger.log(Level.SEVERE, "Could not update activity state due to a Lock exception!", e);
            }
        }
    }
}

