/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.worklistmanager.DefaultAbsenceInformation;
import de.aristaflow.adept2.core.worklistmanager.WorklistUpdateManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.OrgModelTools;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.WorklistFilters;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class DefaultWorklistUpdateManager
implements WorklistUpdateManager {
    public static final String CFG_POSSIBLE_ABSENTEES = "possibleAbsentees";
    public static final String CFG_POSSIBLE_ABSENTEES_FOR_GLOBAL_WORKLIST_AGENT = "possibleAbsenteesGlobalWorklistAgent";
    public static final String CFG_POSSIBLE_ABSENTEES_FOR_FALLBACK_WORKLIST_AGENT = "possibleAbsenteesFallbackWorklistAgent";
    public static final String CFG_POSSIBLE_ABSENTEES_FOR_SUPERVISOR_WORKLIST_AGENT = "possibleAbsenteesSupervisorWorklistAgent";
    protected Logger logger = LoggerTools.getLogger(this);
    private final AbstractWorklistManager worklistManager;
    private final String POSSIBLE_ABSENTEES;
    private final String POSSIBLE_ABSENTEES_FOR_GLOBAL_WORKLIST_AGENT;
    private final String POSSIBLE_ABSENTEES_FOR_FALLBACK_WORKLIST_AGENT;
    private final String POSSIBLE_ABSENTEES_FOR_SUPERVISOR_WORKLIST_AGENT;

    public DefaultWorklistUpdateManager(Configuration configuration, AbstractWorklistManager worklistManager) {
        this.worklistManager = worklistManager;
        this.POSSIBLE_ABSENTEES = configuration.getString(CFG_POSSIBLE_ABSENTEES);
        this.POSSIBLE_ABSENTEES_FOR_GLOBAL_WORKLIST_AGENT = configuration.getString(CFG_POSSIBLE_ABSENTEES_FOR_GLOBAL_WORKLIST_AGENT);
        this.POSSIBLE_ABSENTEES_FOR_FALLBACK_WORKLIST_AGENT = configuration.getString(CFG_POSSIBLE_ABSENTEES_FOR_FALLBACK_WORKLIST_AGENT);
        this.POSSIBLE_ABSENTEES_FOR_SUPERVISOR_WORKLIST_AGENT = configuration.getString(CFG_POSSIBLE_ABSENTEES_FOR_SUPERVISOR_WORKLIST_AGENT);
    }

    @Override
    public void addUpdateableClientWorklist(SessionToken session, ClientWorklist clientWorklist) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(clientWorklist, "clientWorklist");
        this.getWorklistManager().sessionActive(session);
        try {
            InternalWorklist<InternalWorklistItem> worklist;
            try {
                worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(clientWorklist.getID());
                worklist.addUpdateableClientWorklist(clientWorklist);
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("Could not add updateable Clientworklist!", e);
            }
            this.getWorklistManager().asyncNotifyClientAboutUpdate(worklist, clientWorklist);
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public WorklistUpdate getWorklistUpdates(SessionToken session, UUID worklistID, long sinceRevision, Filter worklistFilter) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(worklistID, "worklistID");
        ArgChecks.checkForNegative(sinceRevision, "sinceRevision");
        this.getWorklistManager().sessionActive(session);
        try {
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(worklistID);
            WorklistUpdate worklistUpdate = worklist.getUpdates(sinceRevision, worklistFilter);
            return worklistUpdate;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("Could not retrieve update!", e);
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public void rejectWorklistItem(SessionToken session, UUID worklistID, WorklistItem item) {
        block13: {
            ArgChecks.checkForNull(session, "session");
            ArgChecks.checkForNull(worklistID, "worklistID");
            ArgChecks.checkForNull(item, "item");
            this.getWorklistManager().sessionActive(session);
            try {
                try {
                    InternalWorklist<InternalWorklistItem> worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(worklistID);
                    InternalWorklistItem worklistItem = this.getWorklistManager().getWorklistItemStorage().getAndLockInternalWorklistItem(session, item.getID());
                    if (worklistItem != null) {
                        try {
                            worklist.removeWorklistItem(worklistItem);
                            worklistItem.removedFromWorklist(worklistID);
                            this.getWorklistManager().getEscalationManager().worklistItemRemovedFromWorklist(worklistItem, worklist);
                            if (worklistItem.getWorklistIDs().length <= 1) {
                                this.worklistManager.escalateToInstanceSupervisor(session, worklistItem, "Rejected by last remaining Worklist!");
                            }
                            this.getWorklistManager().getWorklistItemStorage().updateInternalWorklistItem(session, worklistItem);
                        }
                        finally {
                            this.getWorklistManager().getWorklistItemStorage().unlockInternalWorklistItem(session, item.getID());
                        }
                        this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                        break block13;
                    }
                    this.logger.info(String.format("Could not reject worklist item '%1$s' for worklist '%2$s'. Reason: Item no longer exists.", item.getID(), worklistID));
                }
                catch (DataSourceException e) {
                    throw new InternalServiceException("DataSourceException while rejecting worklist item!", e);
                }
                catch (LockException e) {
                    throw new InternalServiceException("LockException while rejecting worklist item!", e);
                }
                catch (InvalidWorklistItemStateException e) {
                    throw new InternalServiceException("InvalidWorklistItemStateException while rejecting worklist item!", e);
                }
            }
            finally {
                this.getWorklistManager().sessionFinished(session);
            }
        }
    }

    @Override
    public void removeUpdateableClientWorklist(SessionToken session, ClientWorklist clientWorklist) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(clientWorklist, "clientWorklist");
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                InternalWorklist<InternalWorklistItem> worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(clientWorklist.getID());
                worklist.removeUpdateableClientWorklist(clientWorklist);
                this.getWorklistManager().getDelayedUpdateHandler().cancelUpdate(clientWorklist);
                clientWorklist.updateWorklist(null);
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("DataSourceException while removing updateable clientworklist!", e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public ClientWorklist createClientWorklist(SessionToken session, UUID worklistID, WorklistUpdateConfiguration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(worklistID, "worklistID");
        this.getWorklistManager().sessionActive(session);
        try {
            WorklistUpdateConfiguration config;
            QualifiedAgent agent = this.getWorklistManager().checkAndGetTopLevelAgent(session);
            if (configuration != null) {
                config = configuration;
            } else {
                Filter filter = WorklistFilters.noTopLevelInstances(this.worklistManager.getFilterFactory());
                config = this.worklistManager.getWorklistModelFactory().createPullWorklistConfiguration(filter);
            }
            HashMap<String, String> userAttributes = new HashMap<String, String>();
            ClientWorklist clientWorklist = this.getWorklistManager().getWorklistModelFactory().createClientWorklist(worklistID, agent, 0L, config, userAttributes);
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(worklistID);
            WorklistUpdate update = worklist.getUpdates(0L, config.getWorklistFilter());
            clientWorklist.updateWorklist(update);
            ClientWorklist clientWorklist2 = clientWorklist;
            return clientWorklist2;
        }
        catch (DataSourceException e) {
            throw new InternalServiceException("DataSourceException while creating client worklist!", e);
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public void updateIndividualSettings(SessionToken session, ClientWorklistItem clientItem) {
        block11: {
            ArgChecks.checkForNull(session, "session");
            ArgChecks.checkForNull(clientItem, "clientItem");
            this.getWorklistManager().sessionActive(session);
            try {
                try {
                    InternalWorklist<InternalWorklistItem> worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(clientItem.getWorklistID());
                    InternalWorklistItem item = this.getWorklistManager().getWorklistItemStorage().getAndLockInternalWorklistItem(session, clientItem.getID());
                    if (item != null) {
                        try {
                            item.updateIndividualWorklistItemSettings(clientItem);
                            worklist.updateIndividualSettings(clientItem);
                            this.getWorklistManager().getEscalationManager().clientWorklistItemUpdated(clientItem);
                            this.getWorklistManager().getWorklistItemStorage().updateInternalWorklistItem(session, item);
                        }
                        finally {
                            this.getWorklistManager().getWorklistItemStorage().unlockInternalWorklistItem(session, clientItem.getID());
                        }
                        this.getWorklistManager().asyncNotifyClientsAboutUpdate(worklist);
                        break block11;
                    }
                    this.logger.info(String.format("Could not Update Individual Settings for Client Worklist Item '%1$s'. Reason: Worklist Item no longer exists!", clientItem.getID()));
                }
                catch (DataSourceException e) {
                    throw new InternalServiceException("DataSourceException while updating individual worklist item settings!", e);
                }
                catch (LockException e) {
                    throw new InternalServiceException("LockException while updating individual worklist item settings!", e);
                }
            }
            finally {
                this.getWorklistManager().sessionFinished(session);
            }
        }
    }

    @Override
    public ParameterDataContext getAttachedDataContext(SessionToken session, UUID worklistItemID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(worklistItemID, "worklistItemID");
        ParameterDataContext dataContext = null;
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                InternalWorklistItem item = this.getWorklistManager().getWorklistItemStorage().getInternalWorklistItemReadonly(worklistItemID);
                if (item != null) {
                    dataContext = item.getAttachedDataContext();
                }
            }
            catch (DataSourceException e) {
                throw new InternalServiceException("DataSourceException while retrieving attached data context!", e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
        return dataContext;
    }

    @Override
    public Set<QualifiedAgent> getPossibleAbsentees(SessionToken session) {
        Set<QualifiedAgent> possibleAbsentees;
        ArgChecks.checkForNull(session, "session");
        this.getWorklistManager().sessionActive(session);
        try {
            String possibleAbsenteesRule;
            QualifiedAgent agent = this.getWorklistManager().checkAndGetTopLevelAgent(session);
            try {
                possibleAbsenteesRule = agent.equals(this.getWorklistManager().getGlobalWorklistAgent()) ? OrgModelTools.fillStaffAssigmentRule(this.POSSIBLE_ABSENTEES_FOR_GLOBAL_WORKLIST_AGENT, agent) : (agent.equals(this.getWorklistManager().getFallbackWorklistAgent()) ? OrgModelTools.fillStaffAssigmentRule(this.POSSIBLE_ABSENTEES_FOR_FALLBACK_WORKLIST_AGENT, agent) : (agent.equals(this.getWorklistManager().getSupervisorWorklistAgent()) ? OrgModelTools.fillStaffAssigmentRule(this.POSSIBLE_ABSENTEES_FOR_SUPERVISOR_WORKLIST_AGENT, agent) : OrgModelTools.fillStaffAssigmentRule(this.POSSIBLE_ABSENTEES, agent)));
            }
            catch (IllegalArgumentException e) {
                String message = "Could not Parse the Possible Absentees Rule due to a Illegal Argument Exception! Please check the Configuration!";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            try {
                possibleAbsentees = OrgModelTools.resolveStaffAssignmentRule(session, this.worklistManager.getOrgModelManager(), possibleAbsenteesRule);
                possibleAbsentees.remove(this.getWorklistManager().getGlobalWorklistAgent());
                possibleAbsentees.remove(this.getWorklistManager().getFallbackWorklistAgent());
            }
            catch (DataSourceException e) {
                String message = "Could not resolve Possible Absentees due to a Data Source Exception";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            catch (PolicyResolutionException e) {
                String message = "Could not resolve Possible Absentees due to a Policy Resolution Exception";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
        return possibleAbsentees;
    }

    @Override
    public void setAbsent(SessionToken session, QualifiedAgent absentee, long from, long to, String substitutionRule) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(absentee, "absentee");
        ArgChecks.checkForNegative(from, "from");
        ArgChecks.checkForNegative(to, "to");
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                QualifiedAgent agent = this.getWorklistManager().checkAndGetTopLevelAgent(session);
                if (from == 0L) {
                    from = System.currentTimeMillis();
                }
                if (to != 0L && to < from) {
                    throw new IllegalArgumentException("To-Time cannot be smaller than from time. Change and try again!");
                }
                if (substitutionRule == null) {
                    throw new NullArgumentException("Substitution Rule cannot be null");
                }
                if (!OrgModelTools.verifyStaffAssignmentRule(session, substitutionRule, this.getWorklistManager().getOrgModelManager())) {
                    throw new IllegalArgumentException("Substitution Rule not valid! Please verify the staff assignment rule!");
                }
                if (!this.getPossibleAbsentees(session).contains(absentee)) {
                    throw new IllegalArgumentException(String.format("Agent '%s' cannot set Agent '%s' absent!", agent, absentee));
                }
                UUID worklistID = this.getWorklistManager().getWorklistID(absentee);
                InternalWorklist<InternalWorklistItem> worklist = this.worklistManager.getWorklistStorage().getAndLockInternalWorklist(session, worklistID);
                try {
                    worklist.setAbsent(from, to, substitutionRule);
                    this.worklistManager.getWorklistStorage().updateInternalWorklist(session, worklist);
                }
                finally {
                    this.worklistManager.getWorklistStorage().unlockInternalWorklist(session, worklistID);
                }
                this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                this.worklistManager.getAvailabilityManager().setAbsent(absentee, from, to, substitutionRule);
            }
            catch (DataSourceException e) {
                String message = "Could not set worklist absent due to a DataSourceException";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            catch (LockException e) {
                String message = "Could not set worklist absent due to a LockException";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public void setPresent(SessionToken session, QualifiedAgent absentee) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(absentee, "absentee");
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                QualifiedAgent agent = this.getWorklistManager().checkAndGetTopLevelAgent(session);
                if (!this.getPossibleAbsentees(session).contains(absentee)) {
                    throw new IllegalArgumentException(String.format("Agent '%s' cannot set Agent '%s' present!", agent, absentee));
                }
                UUID worklistID = this.getWorklistManager().getWorklistID(absentee);
                InternalWorklist<InternalWorklistItem> worklist = this.worklistManager.getWorklistStorage().getAndLockInternalWorklist(session, worklistID);
                try {
                    worklist.setPresent();
                    this.worklistManager.getWorklistStorage().updateInternalWorklist(session, worklist);
                }
                finally {
                    this.worklistManager.getWorklistStorage().unlockInternalWorklist(session, worklistID);
                }
                this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
                this.worklistManager.getAvailabilityManager().setPresent(absentee);
            }
            catch (DataSourceException e) {
                String message = "Could not set worklist present due to a DataSourceException";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            catch (LockException e) {
                String message = "Could not set worklist present due to a LockException";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public WorklistUpdateManager.AbsenceInformation getAbsenceInformation(SessionToken session, QualifiedAgent absentee) {
        DefaultAbsenceInformation absenceInformation;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(absentee, "absentee");
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                UUID worklistID = this.getWorklistManager().getWorklistStorage().getWorklistID(absentee);
                if (worklistID == null) {
                    this.logger.info(String.format("No AbsenceInformation for Agent '%s'. Reason: No Worklist for Agent!", absentee));
                    absenceInformation = null;
                } else {
                    InternalWorklist<InternalWorklistItem> worklist = this.getWorklistManager().getWorklistStorage().getInternalWorklistReadonly(worklistID);
                    absenceInformation = worklist.getSubstitutionRule().length() == 0 ? null : new DefaultAbsenceInformation(absentee, worklist.getAbsenceFromDate(), worklist.getAbsenceToDate(), worklist.getSubstitutionRule());
                }
            }
            catch (DataSourceException e) {
                String message = "DataSourceException while retrieving absence information!";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
        return absenceInformation;
    }

    @Override
    public void setMailNotification(SessionToken session, RichAgent mailReceiver, boolean mailNotify, WorklistUpdateConfiguration configuration) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(mailReceiver, "mailReceiver");
        if (mailNotify) {
            ArgChecks.checkForBlank(mailReceiver.getMailAddress(), "mailReceiver.getMailAddress()");
        }
        this.getWorklistManager().sessionActive(session);
        try {
            try {
                UUID worklistID = this.getWorklistManager().getWorklistID(mailReceiver.getQualifiedAgent());
                this.worklistManager.addMailingClientWorklist(session, worklistID, mailNotify, configuration, mailReceiver);
            }
            catch (DataSourceException e) {
                String message = "Could not update Mail Notification due to a Data Source Exception!";
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    @Override
    public WorklistUpdateConfiguration getMailNotificationInformation(SessionToken session, QualifiedAgent mailReceiver) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(mailReceiver, "mailReceiver");
        this.getWorklistManager().sessionActive(session);
        try {
            WorklistUpdateConfiguration config;
            UUID worklistID = this.getWorklistManager().getWorklistID(mailReceiver);
            WorklistUpdateConfiguration worklistUpdateConfiguration = config = this.getWorklistManager().getWorklistStorage().getMailingClientWorklistConfig(worklistID);
            return worklistUpdateConfiguration;
        }
        catch (DataSourceException e) {
            String message = "Could retrieve Mail Notification information due to a Data Source Exception!";
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        finally {
            this.getWorklistManager().sessionFinished(session);
        }
    }

    protected AbstractWorklistManager getWorklistManager() {
        return this.worklistManager;
    }
}

