/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelayedUpdateHandler {
    private final ScheduledExecutorService executor;
    protected final Map<ClientWorklist, ScheduledFuture<?>> scheduledUpdates;
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final WorklistStorage worklistStorage;

    public DelayedUpdateHandler(String name, WorklistStorage worklistStorage) {
        this.worklistStorage = worklistStorage;
        Adept2ThreadFactory factory = new Adept2ThreadFactory(name, this.logger);
        this.executor = ExecutorTools.createScheduledExecutor(1, factory);
        this.scheduledUpdates = new IdentityHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean scheduleUpdate(long interval, ClientWorklist clientWorklist) {
        if (interval < 0L) {
            throw new IllegalArgumentException("Illegal Delay.");
        }
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("Executor already cancelled.");
        }
        Map<ClientWorklist, ScheduledFuture<?>> map = this.scheduledUpdates;
        synchronized (map) {
            ScheduledFuture<?> scheduled = this.scheduledUpdates.get(clientWorklist);
            if (scheduled != null) {
                if (!scheduled.isCancelled() && scheduled.getDelay(TimeUnit.MILLISECONDS) <= interval) {
                    return false;
                }
                scheduled.cancel(false);
            }
            ScheduledFuture<?> update = this.executor.schedule(new DelayedUpdate(clientWorklist), interval, TimeUnit.MILLISECONDS);
            this.scheduledUpdates.put(clientWorklist, update);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelUpdate(ClientWorklist clientWorklist) {
        Map<ClientWorklist, ScheduledFuture<?>> map = this.scheduledUpdates;
        synchronized (map) {
            block4: {
                ScheduledFuture<?> scheduled = this.scheduledUpdates.remove(clientWorklist);
                if (scheduled == null) break block4;
                scheduled.cancel(false);
                return true;
            }
            return false;
        }
    }

    public void shutdown() {
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Scheduler didn't terminate in time.");
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public class DelayedUpdate
    implements Runnable {
        private ClientWorklist clientWorklist;

        public DelayedUpdate(ClientWorklist clientWorklist) {
            this.clientWorklist = clientWorklist;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<ClientWorklist, ScheduledFuture<?>> map = DelayedUpdateHandler.this.scheduledUpdates;
            synchronized (map) {
                DelayedUpdateHandler.this.scheduledUpdates.remove(this.clientWorklist);
            }
            this.updateWorklist();
        }

        private void updateWorklist() {
            try {
                InternalWorklist<InternalWorklistItem> internalWorklist = DelayedUpdateHandler.this.worklistStorage.getInternalWorklistReadonly(this.clientWorklist.getID());
                int tries = 0;
                while (tries < 5) {
                    WorklistUpdate updates = internalWorklist.getUpdates(this.clientWorklist.getRevision(), this.clientWorklist.getWorklistUpdateConfiguration().getWorklistFilter());
                    if (updates.getItemUpdates().size() == 0 && updates.getSourceRevision() != 0L) {
                        return;
                    }
                    try {
                        this.clientWorklist.updateWorklist(updates);
                        return;
                    }
                    catch (IllegalStateException e) {
                        DelayedUpdateHandler.this.logger.log(Level.INFO, "Couldn't update the Client Worklist because the Update was outdated!", e);
                        if (tries++ < 5) continue;
                        return;
                    }
                }
            }
            catch (DataSourceException e) {
                DelayedUpdateHandler.this.logger.log(Level.WARNING, "DataSourceException while updating Client Worklist", e);
            }
        }
    }
}

