/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.mailservice.MailService;
import de.aristaflow.adept2.model.common.systemdata.BasicSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultClientWorklist;
import java.net.URI;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class MailingClientWorklist
extends DefaultClientWorklist {
    public static final String MAIL_NOTIFICATION_SUBJECT = "mailNotification.subject";
    public static final String MAIL_NOTIFICATION_ITEM_TEXT = "mailNotification.itemText";
    public static final String MAIL_NOTIFICATION_BODY = "mailNotification.body";
    private static final Class<? extends SystemDataFormatter> FORMATTER_CLASS = BasicSystemDataFormatter.class;
    private static final String DEFAULT_SUBJECT = "Worklist Update (%i:itemsUpdated% Item(s) changed)";
    private static final String DEFAULT_ITEM_TEXT = "%i:index%.)  %s:title% \n\t%s:description%\n\tDue Date: %s:dueDate%\n\tAssigned Agent: %s:assignedAgent.agentUserName% - %s:assignedAgent.orgPositionName%\n-------------------------------------------------------\n";
    private static final String DEFAULT_BODY = "Worklist for: %s:agentUserName% - %s:orgPositionName%\n\n%s:items%\n(%i:itemsAdded% Item(s) Added, %i:itemsChanged% Item(s) Changed, %i:itemsRemoved% Item(s) Removed)\n\nTime Stamp: %s:currentTime%";
    private static final long serialVersionUID = 6797992291614020360L;
    private final String mailAddress;
    private final DateFormat dateFormatter;
    private transient MailService mailService;
    private final SessionFactory sessionFactory;
    private final URI[] worklistManagerURIs;
    private final Registry registry;

    public MailingClientWorklist(UUID worklistID, RichAgent agent, WorklistUpdateConfiguration worklistConfiguration, long revision, Map<String, String> userAttributes, SessionFactory sessionFactory, URI[] worklistManagerURIs, Registry registry) {
        super(worklistID, agent.getQualifiedAgent(), worklistConfiguration, revision, userAttributes);
        this.mailAddress = agent.getMailAddress();
        this.sessionFactory = sessionFactory;
        this.worklistManagerURIs = (URI[])worklistManagerURIs.clone();
        this.registry = registry;
        this.dateFormatter = DateFormat.getDateTimeInstance(0, 0, agent.getLocale() != null ? agent.getLocale() : Locale.getDefault());
    }

    @Override
    public void updateWorklist(WorklistUpdate update) {
        super.updateWorklist(update);
        if (update != null && update.getItemUpdates().size() > 0) {
            this.sendUpdateMail(update);
        }
    }

    protected MailService getMailService() {
        if (this.mailService == null) {
            try {
                this.mailService = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(this.worklistManagerURIs), "MailService", MailService.class);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
        }
        return this.mailService;
    }

    protected void sendUpdateMail(WorklistUpdate update) {
        String subject = this.formatSubject(update);
        StringBuilder itemTexts = new StringBuilder();
        int index = 1;
        for (ClientWorklistItem item : this.getWorklistItems()) {
            itemTexts.append(this.formatWorklistItem(index++, item));
        }
        String body = this.formatBody(update, itemTexts.toString());
        try {
            this.logger.info("Sending update Message by Mail to " + this.mailAddress);
            SessionToken session = this.sessionFactory.getSessionToken(this.worklistManagerURIs);
            this.getMailService().sendMail(session, Collections.singletonList(this.mailAddress), subject, body);
        }
        catch (RuntimeException e) {
            String message = String.format("Email Exception while trying to send a mail to '%s'!", this.mailAddress);
            this.logger.log(Level.SEVERE, message, e);
        }
    }

    protected String formatSubject(WorklistUpdate update) {
        Map<String, Object> values = this.getWorklistValues();
        values.putAll(this.getWorklistUpdateValues(update));
        return SystemDataTools.format(FORMATTER_CLASS, this.getParameterisedSubject(), values);
    }

    protected String formatBody(WorklistUpdate update, String itemTexts) {
        Map<String, Object> values = this.getWorklistValues();
        values.putAll(this.getWorklistUpdateValues(update));
        values.put("items", itemTexts);
        String body = SystemDataTools.format(FORMATTER_CLASS, this.getParameterisedBodyText(), values);
        return body;
    }

    protected String formatWorklistItem(int index, ClientWorklistItem item) {
        return SystemDataTools.format(FORMATTER_CLASS, this.getParameterisedWorklistItemText(), this.getWorklistItemValues(index, item));
    }

    protected Map<String, Object> getWorklistItemValues(int index, ClientWorklistItem item) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("index", Long.valueOf(index));
        result.put("id", item.getID());
        result.put("title", item.getTitle());
        result.put("individualTitle", item.getIndividualTitle());
        result.put("description", item.getDescription());
        result.put("priority", Long.valueOf(item.getPriority()));
        result.put("dueDate", this.getDateString(item.getDueDate()));
        result.put("escalationDate", this.getDateString(item.getEscalationDate()));
        result.put("state", item.getState().toString());
        result.put("assignedAgent.agentID", item.getAssignedAgent() == null ? null : Long.valueOf(item.getAssignedAgent().getAgentID()));
        result.put("assignedAgent.agentUserName", item.getAssignedAgent() == null ? null : item.getAssignedAgent().getAgentUserName());
        result.put("assignedAgent.orgPositionID", item.getAssignedAgent() == null ? null : Long.valueOf(item.getAssignedAgent().getOrgPositionID()));
        result.put("assignedAgent.orgPositionName", item.getAssignedAgent() == null ? null : item.getAssignedAgent().getOrgPositionName());
        result.put("escalationLevel", Long.valueOf(item.getCurrentEscalationLevel()));
        result.put("activationDate", this.getDateString(item.getActivationDate()));
        result.put("assignmentDate", this.getDateString(item.getAssignmentDate()));
        result.put("complexity", item.getComplexity());
        result.put("delegationLevel", Long.valueOf(item.getCurrentDelegationLevel()));
        result.put("repliedEnquiry", item.getRepliedEnquiry() == null ? null : item.getRepliedEnquiry().toString());
        result.put("processTemplateName", item.getProcessTemplateName());
        result.put("processInstanceName", item.getProcessInstanceName());
        result.put("individualTitle", item.getIndividualTitle());
        result.put("individualPriority", Long.valueOf(item.getIndividualPriority()));
        result.put("individualDueDate", item.getIndividualDueDate());
        result.put("individualEscalationDate", item.getIndividualEscalationDate());
        result.put("individualEscalationHandlingProcedureID", item.getIndividualEscalationHandlingProcedureID());
        return result;
    }

    protected Map<String, Object> getWorklistUpdateValues(WorklistUpdate update) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("itemsUpdated", Long.valueOf(update.getItemUpdates().size()));
        int deleted = 0;
        int updated = 0;
        int added = 0;
        for (WorklistConstants.WorklistItemUpdateType type : update.getItemUpdates().values()) {
            switch (type) {
                case ADDED: {
                    ++added;
                    break;
                }
                case CHANGED: {
                    ++updated;
                    break;
                }
                case REMOVED: {
                    ++deleted;
                    break;
                }
                default: {
                    String msg = String.format("Unexpected worklist item update type '%s' occurred!", new Object[]{type});
                    this.logger.warning(msg);
                }
            }
        }
        result.put("itemsAdded", Long.valueOf(added));
        result.put("itemsChanged", Long.valueOf(updated));
        result.put("itemsRemoved", Long.valueOf(deleted));
        return result;
    }

    protected Map<String, Object> getWorklistValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", this.getID().toString());
        result.put("revision", this.getRevision());
        result.put("agentID", this.getAgent().getAgentID());
        result.put("agentUserName", this.getAgent().getAgentUserName());
        result.put("orgPositionID", this.getAgent().getOrgPositionID());
        result.put("orgPositionName", this.getAgent().getOrgPositionName());
        result.put("currentTime", this.getDateString(new Date()));
        result.put("itemCount", Long.valueOf(this.getWorklistItems().size()));
        return result;
    }

    private String getParameterisedSubject() {
        String subject = this.getUserAttributeValue(MAIL_NOTIFICATION_SUBJECT);
        if (subject == null || "".equals(subject)) {
            subject = DEFAULT_SUBJECT;
        }
        return subject;
    }

    private String getParameterisedWorklistItemText() {
        String itemText = this.getUserAttributeValue(MAIL_NOTIFICATION_ITEM_TEXT);
        if (itemText == null || "".equals(itemText)) {
            itemText = DEFAULT_ITEM_TEXT;
        }
        return itemText;
    }

    private String getParameterisedBodyText() {
        String body = this.getUserAttributeValue(MAIL_NOTIFICATION_BODY);
        if (body == null || "".equals(body)) {
            body = DEFAULT_BODY;
        }
        return body;
    }

    private String getDateString(long date) {
        if (date <= 0L) {
            return "none";
        }
        return this.getDateString(new Date(date));
    }

    private String getDateString(Date date) {
        return this.dateFormatter.format(date);
    }
}

