/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.service.RTServiceNotKnownException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.mailservice.MailService;
import de.aristaflow.adept2.model.common.systemdata.BasicSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultClientWorklist;
import java.net.URI;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class OrderedMailingClientWorklist
extends DefaultClientWorklist {
    private static final long serialVersionUID = 6756819656979594905L;
    public static final String CONF_SUBJECT = "Subject";
    public static final String CONF_BODY = "Body";
    public static final String CONF_ITEM_TEXT = "ItemText";
    public static final String CONF_ADDED_HEADER = "AddedItemsHeader";
    public static final String CONF_CHANGED_HEADER = "ChangedItemsHeader";
    public static final String CONF_REMOVED_HEADER = "RemovedItemsHeader";
    public static final String CONF_UNCHANGED_HEADER = "UnchangedItemsHeader";
    public static final String CONF_DUE_DATE_TEXT = "DueDateText";
    public static final String CONF_DELEGATION_TEXT = "DelegationText";
    public static final String CONF_ENQUIRY_TEXT = "EnquiryText";
    public static final String CONF_REPLY_TEXT = "ReplyText";
    private static final Class<? extends SystemDataFormatter> FORMATTER_CLASS = BasicSystemDataFormatter.class;
    private final String mailAddress;
    private final DateFormat dateFormatter;
    private transient MailService mailService;
    private final SessionFactory sessionFactory;
    private final URI[] worklistManagerURIs;
    private final Registry registry;
    private final Map<String, String> mailText = new HashMap<String, String>();

    public OrderedMailingClientWorklist(UUID worklistID, RichAgent agent, WorklistUpdateConfiguration worklistConfiguration, Configuration mailText, long revision, Map<String, String> userAttributes, SessionFactory sessionFactory, URI[] worklistManagerURIs, Registry registry) {
        super(worklistID, agent.getQualifiedAgent(), worklistConfiguration, revision, userAttributes);
        Iterator it = mailText.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String text = mailText.getString(key);
            if (text == null) continue;
            int beginIndex = 0;
            int endIndex = text.length();
            if (text.startsWith("|")) {
                ++beginIndex;
            }
            if (text.endsWith("|")) {
                --endIndex;
            }
            text = text.substring(beginIndex, endIndex);
            this.mailText.put(key, text);
        }
        this.mailAddress = agent.getMailAddress();
        this.sessionFactory = sessionFactory;
        this.worklistManagerURIs = (URI[])worklistManagerURIs.clone();
        this.registry = registry;
        this.dateFormatter = DateFormat.getDateTimeInstance(0, 0, agent.getLocale() != null ? agent.getLocale() : Locale.getDefault());
    }

    @Override
    public void updateWorklist(WorklistUpdate update) {
        super.updateWorklist(update);
        if (update != null && update.getItemUpdates().size() > 0) {
            this.sendUpdateMail(update);
        }
    }

    protected MailService getMailService() {
        if (this.mailService == null) {
            try {
                this.mailService = this.registry.getServiceOfType(this.sessionFactory.getSessionToken(this.worklistManagerURIs), "MailService", MailService.class);
            }
            catch (ServiceNotKnownException snke) {
                throw new RTServiceNotKnownException(snke);
            }
        }
        return this.mailService;
    }

    protected void sendUpdateMail(WorklistUpdate update) {
        Map<String, Object> wlValues = this.getWorklistValues(update);
        String subject = this.formatSubject(update, wlValues);
        StringBuilder addedItems = new StringBuilder(this.mailText.get(CONF_ADDED_HEADER));
        addedItems.append('\n');
        StringBuilder changedItems = new StringBuilder(this.mailText.get(CONF_CHANGED_HEADER));
        changedItems.append('\n');
        StringBuilder removedItems = new StringBuilder(this.mailText.get(CONF_REMOVED_HEADER));
        removedItems.append('\n');
        StringBuilder unchangedItems = new StringBuilder(this.mailText.get(CONF_UNCHANGED_HEADER));
        unchangedItems.append('\n');
        HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> itemUpdates = new HashMap<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType>(update.getItemUpdates());
        for (ClientWorklistItem item : this.getWorklistItems()) {
            if ("de.aristaflow.TLPInstanceReference".equals(item.getActivityReference().getActivityReferenceType())) continue;
            WorklistConstants.WorklistItemUpdateType updateType = (WorklistConstants.WorklistItemUpdateType)((Object)itemUpdates.remove(item));
            String itemText = this.formatWorklistItem(item, updateType);
            if (updateType == null) {
                unchangedItems.append(itemText);
                continue;
            }
            switch (updateType) {
                case ADDED: {
                    addedItems.append(itemText);
                    break;
                }
                case CHANGED: {
                    changedItems.append(itemText);
                }
            }
        }
        for (ClientWorklistItem item : itemUpdates.keySet()) {
            if ("de.aristaflow.TLPInstanceReference".equals(item.getActivityReference().getActivityReferenceType())) continue;
            String itemText = this.formatWorklistItem(item, WorklistConstants.WorklistItemUpdateType.REMOVED);
            removedItems.append(itemText);
        }
        addedItems.append(changedItems.toString());
        addedItems.append(removedItems.toString());
        addedItems.append(unchangedItems.toString());
        wlValues.put("items", addedItems.toString());
        String body = this.formatBody(update, wlValues);
        try {
            this.logger.info("Sending update Message by Mail to " + this.mailAddress);
            SessionToken session = this.sessionFactory.getSessionToken(this.worklistManagerURIs);
            this.getMailService().sendMail(session, Collections.singletonList(this.mailAddress), subject, body);
        }
        catch (RuntimeException e) {
            String message = String.format("Email Exception while trying to send a mail to '%s'!", this.mailAddress);
            this.logger.log(Level.SEVERE, message, e);
        }
    }

    protected String formatSubject(WorklistUpdate update, Map<String, Object> wlValues) {
        return SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_SUBJECT), wlValues);
    }

    protected String formatBody(WorklistUpdate update, Map<String, Object> wlValues) {
        String body = SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_BODY), wlValues);
        return body;
    }

    protected String formatWorklistItem(ClientWorklistItem item, WorklistConstants.WorklistItemUpdateType updateType) {
        Map<String, Object> values = this.getWorklistItemValues(item, updateType);
        values.put("dueDateLine", this.formatDueDateLine(item, values));
        values.put("delegationLine", this.formatDelegationLine(item, values));
        values.put("enquiryLine", this.formatEnquiryLine(item, values));
        values.put("replyLine", this.formatReplyLine(item, values));
        return SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_ITEM_TEXT), values);
    }

    protected String formatDueDateLine(ClientWorklistItem item, Map<String, Object> itemValues) {
        String ret = "";
        if (item.getDueDate() > 0L) {
            ret = SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_DUE_DATE_TEXT), itemValues);
        }
        return ret;
    }

    protected String formatDelegationLine(ClientWorklistItem item, Map<String, Object> itemValues) {
        String ret = "";
        if (item.getCurrentDelegation() != null) {
            ret = SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_DELEGATION_TEXT), itemValues);
        }
        return ret;
    }

    protected String formatEnquiryLine(ClientWorklistItem item, Map<String, Object> itemValues) {
        String ret = "";
        if (item.getCurrentEnquiry() != null) {
            ret = SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_ENQUIRY_TEXT), itemValues);
        }
        return ret;
    }

    protected String formatReplyLine(ClientWorklistItem item, Map<String, Object> itemValues) {
        String ret = "";
        if (item.getRepliedEnquiry() != null) {
            ret = SystemDataTools.format(FORMATTER_CLASS, this.mailText.get(CONF_REPLY_TEXT), itemValues);
        }
        return ret;
    }

    protected Map<String, Object> getWorklistItemValues(ClientWorklistItem item, WorklistConstants.WorklistItemUpdateType updateType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", item.getID().toString());
        result.put("title", item.getTitle());
        result.put("individualTitle", item.getIndividualTitle());
        result.put("description", item.getDescription());
        result.put("priority", item.getPriority());
        result.put("dueDate", this.getDateString(item.getDueDate()));
        result.put("escalationDate", this.getDateString(item.getEscalationDate()));
        result.put("state", item.getState().toString());
        QualifiedAgent agent = item.getAssignedAgent();
        result.put("assignedAgent.agentID", agent == null ? null : Long.valueOf(agent.getAgentID()));
        result.put("assignedAgent.agentUserName", agent == null ? null : agent.getAgentUserName());
        result.put("assignedAgent.orgPositionID", agent == null ? null : Long.valueOf(agent.getOrgPositionID()));
        result.put("assignedAgent.orgPositionName", agent == null ? null : agent.getOrgPositionName());
        result.put("escalationLevel", item.getCurrentEscalationLevel());
        result.put("activationDate", this.getDateString(item.getActivationDate()));
        result.put("assignmentDate", this.getDateString(item.getAssignmentDate()));
        result.put("complexity", item.getComplexity());
        result.put("delegationLevel", item.getCurrentDelegationLevel());
        WorklistItem.Delegation del = item.getCurrentDelegation();
        result.put("delegation.agentID", del == null ? null : Long.valueOf(del.getDelegator().getAgentID()));
        result.put("delegation.agentUserName", del == null ? null : del.getDelegator().getAgentUserName());
        result.put("delegation.orgPositionID", del == null ? null : Long.valueOf(del.getDelegator().getOrgPositionID()));
        result.put("delegation.orgPositionName", del == null ? null : del.getDelegator().getOrgPositionName());
        result.put("delegation.comment", del == null ? null : del.getComment());
        Enquiry enq = item.getCurrentEnquiry();
        result.put("currentEnquiry", enq == null ? null : enq.toString());
        result.put("currentEnquiry.question", enq == null ? null : enq.getQuestion());
        agent = enq == null ? null : enq.getOriginator();
        result.put("currentEnquiry.originator.agentID", agent == null ? null : Long.valueOf(agent.getAgentID()));
        result.put("currentEnquiry.originator.agentUserName", agent == null ? null : agent.getAgentUserName());
        result.put("currentEnquiry.originator.orgPositionID", agent == null ? null : Long.valueOf(agent.getOrgPositionID()));
        result.put("currentEnquiry.originator.orgPositionName", agent == null ? null : agent.getOrgPositionName());
        enq = item.getRepliedEnquiry();
        result.put("repliedEnquiry", enq == null ? null : enq.toString());
        result.put("repliedEnquiry.question", enq == null ? null : enq.getQuestion());
        agent = enq == null ? null : enq.getOriginator();
        result.put("repliedEnquiry.originator.agentID", agent == null ? null : Long.valueOf(agent.getAgentID()));
        result.put("repliedEnquiry.originator.agentUserName", agent == null ? null : agent.getAgentUserName());
        result.put("repliedEnquiry.originator.orgPositionID", agent == null ? null : Long.valueOf(agent.getOrgPositionID()));
        result.put("repliedEnquiry.originator.orgPositionName", agent == null ? null : agent.getOrgPositionName());
        agent = enq == null ? null : enq.getReplier();
        result.put("repliedEnquiry.reply", enq == null ? null : enq.getReply());
        result.put("repliedEnquiry.replier.agentID", agent == null ? null : Long.valueOf(agent.getAgentID()));
        result.put("repliedEnquiry.replier.agentUserName", agent == null ? null : agent.getAgentUserName());
        result.put("repliedEnquiry.replier.orgPositionID", agent == null ? null : Long.valueOf(agent.getOrgPositionID()));
        result.put("repliedEnquiry.replier.orgPositionName", agent == null ? null : agent.getOrgPositionName());
        result.put("processTemplateName", item.getProcessTemplateName());
        result.put("processInstanceName", item.getProcessInstanceName());
        result.put("updateType", updateType == null ? "unchanged" : updateType.toString());
        result.put("individualTitle", item.getIndividualTitle());
        result.put("individualPriority", item.getIndividualPriority());
        result.put("individualDueDate", item.getIndividualDueDate());
        result.put("individualEscalationDate", item.getIndividualEscalationDate());
        result.put("individualEscalationHandlingProcedureID", item.getIndividualEscalationHandlingProcedureID());
        return result;
    }

    protected Map<String, Object> getWorklistValues(WorklistUpdate update) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", this.getID().toString());
        result.put("revision", this.getRevision());
        result.put("agentID", this.getAgent().getAgentID());
        result.put("agentUserName", this.getAgent().getAgentUserName());
        result.put("orgPositionID", this.getAgent().getOrgPositionID());
        result.put("orgPositionName", this.getAgent().getOrgPositionName());
        result.put("currentTime", this.getDateString(new Date()));
        result.put("itemCount", Long.valueOf(this.getWorklistItems().size()));
        result.put("sourceRevision", update.getSourceRevision());
        result.put("targetRevision", update.getTargetRevision());
        result.put("itemsUpdated", Long.valueOf(update.getItemUpdates().size()));
        long deleted = 0L;
        long updated = 0L;
        long added = 0L;
        for (Map.Entry<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> entry : update.getItemUpdates().entrySet()) {
            ClientWorklistItem item = entry.getKey();
            WorklistConstants.WorklistItemUpdateType type = entry.getValue();
            if ("de.aristaflow.TLPInstanceReference".equals(item.getActivityReference().getActivityReferenceType())) continue;
            switch (type) {
                case ADDED: {
                    ++added;
                    break;
                }
                case CHANGED: {
                    ++updated;
                    break;
                }
                case REMOVED: {
                    ++deleted;
                    break;
                }
                default: {
                    String msg = String.format("Unexpected worklist item update type '%s' occurred!", new Object[]{type});
                    this.logger.warning(msg);
                }
            }
        }
        result.put("itemsAdded", added);
        result.put("itemsChanged", updated);
        result.put("itemsRemoved", deleted);
        return result;
    }

    private String getDateString(long date) {
        if (date <= 0L) {
            return "<not set>";
        }
        return this.getDateString(new Date(date));
    }

    private String getDateString(Date date) {
        return this.dateFormatter.format(date);
    }
}

