/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.orgmodel.OrgPolicyReport;
import de.aristaflow.adept2.model.orgmodel.OrgPolicySystemDataFormatter;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class OrgModelTools {
    public static final int MAX_STAFF_ASSIGNMENT_RESOLUTION_TRIES = 5;
    protected static Logger logger = LoggerTools.getLogger(OrgModelTools.class);

    OrgModelTools() {
    }

    public static Set<QualifiedAgent> resolveStaffAssignmentRule(SessionToken session, OrgModelManager orgModelManager, String staffAssignmentRule) throws DataSourceException, PolicyResolutionException {
        PolicyResolution policyResolution = orgModelManager.getPolicyResolution();
        int tries = 0;
        while (true) {
            try {
                return policyResolution.resolvePolicy(session, staffAssignmentRule);
            }
            catch (DataSourceException ex) {
                if (++tries <= 5) {
                    logger.log(Level.WARNING, "Unable to resolve StaffAssignmentRule due to a DataSourceException. Retrying...", ex);
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    public static String fillStaffAssigmentRule(String staffAssignmentRule, QualifiedAgent agent) {
        HashMap<String, Object> value = new HashMap<String, Object>(4);
        value.put("agentID", agent.getAgentID());
        value.put("agentUserName", agent.getAgentUserName());
        value.put("orgPositionID", agent.getOrgPositionID());
        value.put("orgPositionName", agent.getOrgPositionName());
        return SystemDataTools.format(OrgPolicySystemDataFormatter.class, staffAssignmentRule, value);
    }

    public static boolean verifyStaffAssignmentRule(SessionToken session, String staffAssignmentRule, OrgModelManager orgModelManager) {
        boolean result = false;
        try {
            OrgPolicyReport report = orgModelManager.getPolicyResolution().checkResolvability(session, staffAssignmentRule, false, true);
            if (report.getOverallResult().equals((Object)OrgPolicyReport.ResultType.OK) || report.getOverallResult().equals((Object)OrgPolicyReport.ResultType.INFO)) {
                result = true;
            }
        }
        catch (DataSourceException e) {
            logger.log(Level.SEVERE, "Data Source Exception while trying to verify Substitution Rule!", e);
            result = false;
        }
        return result;
    }
}

