/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.defaultimplementation;

import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistManagerStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLWorklistManagerStorage;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="StorageDataDir", type=Property.Type.STRING, isRequired=true, description="Save Path for Worklist Manager Persistence.")})
public class XMLWorklistManager
extends AbstractWorklistManager {
    public XMLWorklistManager(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry);
    }

    @Override
    protected WorklistManagerStorage createStorageFacility(SessionToken session, Configuration configuration) throws ServiceNotKnownException, ConfigurationException {
        WorklistModelFactory worklistModelFactory = this.registry.getModelFactory("WorklistModelFactory", WorklistModelFactory.class);
        FilterFactory filterFactory = this.registry.getModelFactory("FilterFactory", FilterFactory.class);
        return new SimpleXMLWorklistManagerStorage(configuration, worklistModelFactory, filterFactory, this);
    }
}

