/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ActivityExecutionControl;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.TLPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class AbortProcessStepMeasure
extends AbstractEscalationHandling {
    public static final String ID = "AbortProcessStepMeasure";

    public AbortProcessStepMeasure(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager, ID);
    }

    public AbortProcessStepMeasure(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) {
        this(configuration, worklistManager);
    }

    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken measuresSession, PolicyResolution orgModel) {
        String activityReferenceType = item.getActivityReference().getActivityReferenceType();
        if ("de.aristaflow.ADEPT2ActivityReference".equals(activityReferenceType) || "de.aristaflow.LWPActivityReference".equals(activityReferenceType)) {
            ADEPT2EBPReference reference = (ADEPT2EBPReference)item.getActivityReference();
            this.logger.fine("Abort process step escalation for item " + item + " triggered.");
            if (item.getState() == WorklistConstants.WorklistItemState.STARTED) {
                this.logger.info("The activity of item '%s' is started already, doing nothing.");
            } else {
                SessionToken session = this.createSessionToken();
                this.logger.info("Failing item " + item);
                try {
                    ExecutionManager executionManager = this.getExecutionMananger(session, reference.getExecutionManagerURIs());
                    ActivityExecutionControl executionControl = executionManager.getActivityExecutionControl();
                    executionControl.abortActivity(session, reference, "Killed by escalation measure", 1400000L, true);
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Could not retrieve execution manager for fail the activity '%s' as escalation measure. It is not escalated!";
                    this.logger.log(Level.WARNING, String.format(msg, reference), snke);
                }
                catch (InvalidActivityStateException ex) {
                    String message = "Could not fail the activity as escalation measure.";
                    this.logger.log(Level.INFO, message, ex);
                }
            }
        } else if (activityReferenceType.equals("de.aristaflow.TLPInstanceReference")) {
            SessionToken session = this.createSessionToken();
            TLPInstanceReference reference = (TLPInstanceReference)item.getActivityReference();
            try {
                ExecutionManager exMgr = this.getExecutionMananger(session, reference.getExecutionManagerURIs());
                exMgr.getInstanceControl().stopAndAbortInstance(session, reference.getInstanceID(), true, "Killed by escalation measure", null, 1400000L);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve execution manager for failing the instance '%s' as escalation measure. It is not escalated!";
                this.logger.log(Level.WARNING, String.format(msg, reference.getInstanceID()), snke);
            }
            catch (InvalidInstanceStateException ex) {
                String message = "Could not fail the instance as escalation measure.";
                this.logger.log(Level.INFO, message, ex);
            }
        } else {
            String msg = "Unknown/unsupported activity reference type encountered: " + activityReferenceType;
            this.logger.warning(msg);
        }
    }
}

