/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures;

import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ExecutionManager;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public abstract class AbstractEscalationHandling
implements EscalationHandling {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final String id;
    protected final Configuration configuration;
    protected final SessionFactory sessionFactory;
    private final URI[] worklistManagerURIs;
    protected final AbstractWorklistManager worklistManager;

    protected AbstractEscalationHandling(Configuration configuration, AbstractWorklistManager worklistManager, String id) {
        this.configuration = configuration;
        this.sessionFactory = worklistManager.getSessionFactory();
        this.worklistManagerURIs = worklistManager.getURIs();
        this.worklistManager = worklistManager;
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    protected SessionToken createSessionToken() {
        return this.sessionFactory.getSessionToken(this.worklistManagerURIs);
    }

    protected ExecutionManager getExecutionMananger(SessionToken session, URI[] exMgrURIs) throws ServiceNotKnownException {
        return this.worklistManager.getRegistry().getService(session, exMgrURIs, ExecutionManager.class);
    }
}

