/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.model.common.plugindata.DelegationMeasureData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.DataSourceException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DelegationMeasure
extends AbstractEscalationHandling {
    public static final String MANAGER_OF = "OrgPosition(id=%d).getOrgUnit().getManagerPosition()";

    public DelegationMeasure(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager, "DelegationMeasure");
    }

    public DelegationMeasure(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) {
        this(configuration, worklistManager);
    }

    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken session, PolicyResolution orgModel) {
        HashSet<QualifiedAgent> recipients;
        DelegationMeasureData data = ModelViewer.createView(item.getPluginData("DelegationMeasure").getPluginData(), DelegationMeasureData.class);
        if (item.getState() == WorklistConstants.WorklistItemState.STARTED) {
            String msg = "The item %s has been started already, can't delegate it.";
            this.logger.info(String.format(msg, item));
            return;
        }
        if (WorklistConstants.WorklistItemState.ASSIGNED.equals((Object)item.getState())) {
            this.logger.info(String.format("Deselecting item '%s' before delegating it as escalation.", item.getTitle()));
            String activityReferenceType = item.getActivityReference().getActivityReferenceType();
            if ("de.aristaflow.ADEPT2ActivityReference".equals(activityReferenceType) || "de.aristaflow.LWPActivityReference".equals(activityReferenceType)) {
                ADEPT2EBPReference activity = (ADEPT2EBPReference)item.getActivityReference();
                try {
                    URI[] exMgrURIs = activity.getExecutionManagerURIs();
                    ActivityStarting activityStarting = this.getExecutionMananger(session, exMgrURIs).getActivityStarting();
                    activityStarting.deselectActivity(session, activity);
                }
                catch (ServiceNotKnownException snke) {
                    String msg = "Cannot delegate selected item '%s' as escalation since its execution manager cannot be retrieved.";
                    this.logger.log(Level.WARNING, String.format(msg, item), snke);
                    return;
                }
                catch (InvalidActivityStateException iase) {
                    String msg = "Cannot delegate selected item '%s' as escalation since it has the wrong state to be deselected.";
                    this.logger.log(Level.WARNING, String.format(msg, item), iase);
                    return;
                }
                catch (InvalidInstanceStateException iise) {
                    String msg = "Cannot delegate selected item '%s' as escalation since its process instance has the wrong state to deselect the activity.";
                    this.logger.log(Level.WARNING, String.format(msg, item), iise);
                    return;
                }
            } else {
                String msg = "Cannot delegate item '%s' as escalation since it has an unknown or unsupported activity reference type '%s'.";
                this.logger.warning(String.format(msg, item, activityReferenceType));
                return;
            }
        }
        this.logger.info("Triggered delegation escalation of item " + item);
        String currentRule = "";
        try {
            if (item.getAssignedAgent() != null && data.getAssignedDelegationRule() == null) {
                long assignedOrgPos = item.getAssignedAgent().getOrgPositionID();
                currentRule = String.format(MANAGER_OF, assignedOrgPos);
                recipients = orgModel.resolvePolicy(session, currentRule);
            } else if (item.getAssignedAgent() != null && data.getAssignedDelegationRule() != null) {
                currentRule = data.getAssignedDelegationRule();
                recipients = orgModel.resolvePolicy(session, currentRule);
            } else if (data.getUnassignedDelegationRule() != null) {
                currentRule = data.getUnassignedDelegationRule();
                recipients = orgModel.resolvePolicy(session, currentRule);
            } else {
                recipients = new HashSet();
                Set<QualifiedAgent> staff = item.getCurrentEnquiry() != null ? item.getCurrentEnquiry().getRecipients() : (item.getCurrentDelegation() != null ? item.getCurrentDelegation().getRecipients() : orgModel.resolvePolicy(session, staffAssignmentRule));
                for (QualifiedAgent agent : staff) {
                    currentRule = String.format(MANAGER_OF, agent.getOrgPositionID());
                    Set<QualifiedAgent> manager = orgModel.resolvePolicy(session, currentRule);
                    recipients.addAll(manager);
                }
            }
        }
        catch (PolicyResolutionException e) {
            String msg = String.format("Unable to resolve SAR: '%s'.", currentRule);
            this.logger.log(Level.SEVERE, msg, e);
            return;
        }
        catch (DataSourceException e) {
            String msg = String.format("Unable to resolve SAR: '%s'.", currentRule);
            this.logger.log(Level.SEVERE, msg, e);
            return;
        }
        this.logger.info(String.format("Delegating item to '%s'.", recipients));
        try {
            measures.delegateWorkItem(session, item, recipients, data.getDelegationComment());
        }
        catch (InvalidWorklistItemStateException invalidWorklistItemStateException) {
            this.logger.info("Could not delegate work list item.");
        }
    }
}

