/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.model.common.plugindata.InstantiateProcessMeasureData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.datamanagement.InstanceDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ExecutionContext;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class InstantiateProcessMeasure
extends AbstractEscalationHandling {
    private static final String ESCALATION_API_TEMPLATE = "EscalationTemplateProcess.template";
    private static final String PROC_PARAM_NAME_TITLE = "Title";
    private static final String PROC_PARAM_NAME_DUE_DATE = "DueDate";
    private static final String PROC_PARAM_NAME_PRIORITY = "Priority";
    private static final String PROC_PARAM_NAME_STAFF_ASSIGNMENT_RULE = "StaffAssignmentRule";
    private static final String PROC_PARAM_NAME_ASSIGNED_AGENT_ID = "AssignedAgentID";
    private static final String PROC_PARAM_NAME_ASSIGNED_ORG_POSITION_ID = "AssignedOrgPositionID";
    private static final String PROC_PARAM_NAME_ASSIGNMENT_DATE = "AssignmentDate";
    private static final String PROC_PARAM_NAME_INSTANCE_ID = "InstanceID";
    private static final String PROC_PARAM_NAME_NODE_ID = "NodeID";
    private static final String PROC_PARAM_NAME_NODE_ITERATION = "NodeIteration";
    private static final String PROC_PARAM_NAME_EXECUTION_MANAGER_URI = "ExecutionManagerURI";
    private static Template apiTemplate;

    public InstantiateProcessMeasure(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager, "InstantiateProcessMeasure");
    }

    public InstantiateProcessMeasure(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) {
        this(configuration, worklistManager);
    }

    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken wmSession, PolicyResolution orgModel) {
        InstantiateProcessMeasureData data = ModelViewer.createView(item.getPluginData(this.id).getPluginData(), InstantiateProcessMeasureData.class);
        UUID templateID = data.getTemplateID();
        String activityReferenceType = item.getActivityReference().getActivityReferenceType();
        if ("de.aristaflow.ADEPT2ActivityReference".equals(activityReferenceType) || "de.aristaflow.LWPActivityReference".equals(activityReferenceType)) {
            ExecutionContext executionContext;
            InstanceDataContainer dataContainer;
            InstanceControl instanceControl;
            ADEPT2EBPReference reference = (ADEPT2EBPReference)item.getActivityReference();
            SessionToken mySession = this.createSessionToken();
            try {
                URI[] emURIs = reference.getExecutionManagerURIs();
                instanceControl = this.getExecutionMananger(mySession, emURIs).getInstanceControl();
                dataContainer = instanceControl.createInstanceDataContainer(mySession, templateID);
                dataContainer.setString(PROC_PARAM_NAME_TITLE, item.getTitle());
                dataContainer.setInteger(PROC_PARAM_NAME_DUE_DATE, item.getDueDate());
                dataContainer.setInteger(PROC_PARAM_NAME_PRIORITY, item.getPriority());
                dataContainer.setString(PROC_PARAM_NAME_STAFF_ASSIGNMENT_RULE, staffAssignmentRule);
                if (item.getAssignedAgent() != null) {
                    dataContainer.setInteger(PROC_PARAM_NAME_ASSIGNED_AGENT_ID, item.getAssignedAgent().getAgentID());
                    dataContainer.setInteger(PROC_PARAM_NAME_ASSIGNED_ORG_POSITION_ID, item.getAssignedAgent().getOrgPositionID());
                    dataContainer.setInteger(PROC_PARAM_NAME_ASSIGNMENT_DATE, item.getAssignmentDate());
                }
                dataContainer.setString(PROC_PARAM_NAME_INSTANCE_ID, reference.getInstanceID().toString());
                dataContainer.setInteger(PROC_PARAM_NAME_NODE_ID, reference.getNodeID());
                dataContainer.setInteger(PROC_PARAM_NAME_NODE_ITERATION, reference.getNodeIteration());
                dataContainer.setURI(PROC_PARAM_NAME_EXECUTION_MANAGER_URI, reference.getExecutionManagerURIs()[0]);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve execution manager for creating a data container to create a new instance of template '%s'.";
                throw new InternalServiceException(String.format(msg, templateID), snke);
            }
            catch (InvalidDataTypeException e) {
                String message = String.format("The template with ID '%s' has an invalid API, can't use it as escalation measure.", data.getTemplateID());
                this.logger.log(Level.SEVERE, message, e);
                return;
            }
            catch (NoSuchParameterException e) {
                String message = String.format("The template with ID '%s' has an invalid API, can't use it as escalation measure.", data.getTemplateID());
                this.logger.log(Level.SEVERE, message, e);
                return;
            }
            Registry registry = this.worklistManager.getRegistry();
            mySession = this.createSessionToken();
            try {
                executionContext = registry.getModelFactory("ExecutionFactory", ExecutionFactory.class).getExecutionContext(this.sessionFactory.checkAndGetAgent(mySession), null, dataContainer, ProcessConstants.ExecutionMode.PRODUCTION, null, null);
            }
            catch (ServiceNotKnownException snke) {
                String msg = "Could not retrieve execution factory for creating the execution context for starting an instance of template '%s'.";
                throw new InternalServiceException(String.format(msg, templateID), snke);
            }
            catch (SecurityTokenIntegrityException stie) {
                throw new InternalServiceException("Failed to verify the security token to be used for deserialising.", stie);
            }
            mySession = this.createSessionToken();
            try {
                instanceControl.createAndStartInstance(mySession, templateID, executionContext, null);
            }
            catch (InvalidTemplateStateException e) {
                String message = String.format("The process template to be instantiated for escalation has an invalid status.", new Object[0]);
                this.logger.log(Level.SEVERE, message, e);
            }
            catch (InvalidDataContainerException e) {
                String message = "The process to be instantiated does not have the right input parameters.";
                this.logger.log(Level.SEVERE, message, e);
            }
        } else {
            String msg = "Unknown/unsupported activity reference type encountered: " + activityReferenceType;
            this.logger.warning(msg);
        }
    }

    public static boolean isValidEscalationProcess(TemplateReference templateRef, ProcessModelFactory pmf) {
        if (apiTemplate == null) {
            ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
            try {
                apiTemplate = xmlImport.getTemplateFromStream(InstantiateProcessMeasure.class.getResourceAsStream(ESCALATION_API_TEMPLATE));
            }
            catch (VersionException e) {
                e.printStackTrace();
            }
            catch (XMLFormatException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ProcessModelParameter> params = new HashMap<String, ProcessModelParameter>();
        for (ProcessModelParameter param : templateRef.getInputParameters()) {
            params.put(param.getName(), param);
        }
        for (ProcessModelParameter param : apiTemplate.getParameters(ActivityConstants.AccessType.READ)) {
            if (!params.containsKey(param.getName())) {
                return false;
            }
            ProcessModelParameter param2 = (ProcessModelParameter)params.get(param.getName());
            if (!param.getName().equals(param2.getName()) || param.getDataType() != param2.getDataType() || param.isOptional() != param2.isOptional() || param.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED && !param.getUDTName().equals(param2.getUDTName())) {
                return false;
            }
            params.remove(param.getName());
        }
        return params.size() == 0;
    }
}

