/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.mailservice.MailService;
import de.aristaflow.adept2.core.orgmodelmanager.ModelExplorer;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelException;
import de.aristaflow.adept2.core.orgmodelmanager.OrgModelManager;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolutionException;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.WorklistAdministration;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.model.common.plugindata.MailNotificationData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.orgmodel.Entity;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.DataSourceException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;

public class MailNotificationMeasure
extends AbstractEscalationHandling {
    private static final String DEFAULT_MAILBODY = "Dear Sir or Madam,\n\n" + MailNotificationData.MailField.TITLE.variable + " is due on " + MailNotificationData.MailField.DUE_DATE.variable + "\n\n" + "Summary for " + MailNotificationData.MailField.TITLE.variable + ":\n" + MailNotificationData.MailField.DESCRIPTION.variable + "\n\n" + "Priority:\t" + MailNotificationData.MailField.PRIORITY.variable + "\n" + "Due Date:\t" + MailNotificationData.MailField.DUE_DATE.variable + "\n" + "Process:\t" + MailNotificationData.MailField.PROCESS_TEMPLATE.variable + "\n" + "Instance:\t" + MailNotificationData.MailField.PROCESS_INSTANCE.variable + "\n" + "Open Enquriy:\t" + MailNotificationData.MailField.OPEN_ENQUIRY.variable + "\n" + "Replied Enquiry:\t" + MailNotificationData.MailField.ENQUIRY_QUESTION.variable + "\n" + "Answered with:\t" + MailNotificationData.MailField.ENQUIRY_REPLY.variable + "\n" + "Delegation:\t" + MailNotificationData.MailField.DELEGATION.variable + "\n" + "Process Variable Values:\t" + MailNotificationData.MailField.PUBLIC_DATA_ELEMENTS.variable + "\n";
    private static final String DEFAULT_MAILSUBJECT = "Reminder for " + MailNotificationData.MailField.TITLE.variable + " (due " + MailNotificationData.MailField.DUE_DATE.variable + ")";
    private MailService mailService;
    protected final ModelExplorer modelExplorer;
    private static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees;

    public MailNotificationMeasure(Configuration configuration, AbstractWorklistManager worklistManager) throws ServiceNotKnownException {
        super(configuration, worklistManager, "MailNotificationMeasure");
        this.modelExplorer = worklistManager.getRegistry().getServiceOfType(this.createSessionToken(), "OrgModelManager", OrgModelManager.class).getModelExplorer();
        this.mailService = worklistManager.getRegistry().getServiceOfType(this.createSessionToken(), "MailService", MailService.class);
    }

    public MailNotificationMeasure(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) throws ServiceNotKnownException {
        this(configuration, worklistManager);
    }

    public MailService getMailService() {
        return this.mailService;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken session, PolicyResolution orgModel) {
        block30: {
            data = ModelViewer.createView(item.getPluginData("MailNotificationMeasure").getPluginData(), MailNotificationData.class);
            assignedRecipients = new HashSet<E>();
            if (data.getAddressees() == MailNotificationData.Addressees.MailAddresses) break block30;
            switch (MailNotificationMeasure.$SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees()[data.getAddressees().ordinal()]) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (data.getAddressees() == MailNotificationData.Addressees.AssignmentMembers || data.getAddressees() == MailNotificationData.Addressees.AssignmentMembersAndMail) ** GOTO lbl41
                    if (item.getAssignedAgent() == null) ** GOTO lbl11
                    supervisorAgents = this.getSupervisor(item.getAssignedAgent(), orgModel);
                    assignedRecipients = this.getEmailAddressesForAgents(supervisorAgents);
                    ** GOTO lbl41
lbl11:
                    // 1 sources

                    if (item.getCurrentEnquiry() == null) ** GOTO lbl20
                    recipientsSupervisor = new HashSet<QualifiedAgent>();
                    for (QualifiedAgent enquiryAgent : item.getCurrentEnquiry().getRecipients()) {
                        supervisorAgents = this.getSupervisor(enquiryAgent, orgModel);
                        recipientsSupervisor.addAll(supervisorAgents);
                    }
                    assignedRecipients = this.getEmailAddressesForAgents(recipientsSupervisor);
                    ** GOTO lbl41
lbl20:
                    // 1 sources

                    if (item.getCurrentDelegation() == null) ** GOTO lbl29
                    delegationsSupervisor = new HashSet<QualifiedAgent>();
                    for (QualifiedAgent delegationAgent : item.getCurrentDelegation().getRecipients()) {
                        supervisorAgents = this.getSupervisor(delegationAgent, orgModel);
                        delegationsSupervisor.addAll(supervisorAgents);
                    }
                    assignedRecipients = this.getEmailAddressesForAgents(delegationsSupervisor);
                    ** GOTO lbl41
lbl29:
                    // 1 sources

                    try {
                        agents = orgModel.resolvePolicy(session, staffAssignmentRule);
                        assignedRecipients = this.getSupervisorEmailAddressesForAgents(agents, orgModel);
                    }
                    catch (PolicyResolutionException pre) {
                        message = String.format("Could not resolve staff assignment rule '%s' while escalating worklist item '%s'.addresses for notification, SAR='%s'.", new Object[]{staffAssignmentRule, item, staffAssignmentRule});
                        this.logger.log(Level.SEVERE, message, pre);
                        throw new InternalServiceException(message, pre);
                    }
                    catch (DataSourceException dse) {
                        message = String.format("Data source problems while resolving staff assignment rule '%s' for sending mail notification for worklist item '%s'.", new Object[]{staffAssignmentRule, item});
                        this.logger.log(Level.SEVERE, message, dse);
                        throw new InternalServiceException(message, dse);
                    }
                }
lbl41:
                // 6 sources

                case 2: 
                case 3: {
                    if (data.getAddressees() == MailNotificationData.Addressees.AssignmentSupervisorMembers || data.getAddressees() == MailNotificationData.Addressees.AssignmentSupervisorMembersAndMail) break;
                    if (item.getAssignedAgent() != null) {
                        address = this.getEmailAddressForAgent(item.getAssignedAgent());
                        if (address == null || address.equals("")) {
                            throw new RuntimeException("Can't notify agent since the email address is missing.");
                        }
                        temp = new HashSet<String>();
                        temp.add(address);
                    } else if (item.getCurrentEnquiry() != null) {
                        temp = this.getEmailAddressesForAgents(item.getCurrentEnquiry().getRecipients());
                    } else if (item.getCurrentDelegation() != null) {
                        temp = this.getEmailAddressesForAgents(item.getCurrentDelegation().getRecipients());
                    } else {
                        try {
                            agents = orgModel.resolvePolicy(session, staffAssignmentRule);
                            temp = this.getEmailAddressesForAgents(agents);
                        }
                        catch (PolicyResolutionException pre) {
                            message = String.format("Could not resolve staff assignment rule '%s' while escalating worklist item '%s'.addresses for notification, SAR='%s'.", new Object[]{staffAssignmentRule, item, staffAssignmentRule});
                            this.logger.log(Level.SEVERE, message, pre);
                            throw new InternalServiceException(message, pre);
                        }
                        catch (DataSourceException dse) {
                            message = String.format("Data source problems while resolving staff assignment rule '%s' for sending mail notification for worklist item '%s'.", new Object[]{staffAssignmentRule, item});
                            this.logger.log(Level.SEVERE, message, dse);
                            throw new InternalServiceException(message, dse);
                        }
                    }
                    assignedRecipients.addAll(temp);
                    break;
                }
                default: {
                    msg = String.format("Unsupported case '%s'!", new Object[]{data.getAddressees()});
                    this.logger.warning(msg);
                }
            }
        }
        mailAddressArray = data.getMailAddresses();
        mailAddresses = new ArrayList<String>(mailAddressArray.length);
        var15_21 = mailAddressArray;
        var14_22 = mailAddressArray.length;
        message = 0;
        while (message < var14_22) {
            mail = var15_21[message];
            mailAddresses.addAll(Arrays.asList(mail.split(";")));
            ++message;
        }
        recipients = new HashSet<Object>();
        switch (MailNotificationMeasure.$SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees()[data.getAddressees().ordinal()]) {
            case 2: 
            case 4: 
            case 6: {
                recipients.addAll(assignedRecipients);
                break;
            }
            case 1: {
                recipients.addAll(mailAddresses);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                recipients.addAll(mailAddresses);
                recipients.addAll(assignedRecipients);
                break;
            }
            default: {
                this.logger.severe("Unknown ");
                if (!MailNotificationMeasure.$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        body = data.getMailBody() != null && data.getMailBody().equals("") == false ? data.getMailBody() : MailNotificationMeasure.DEFAULT_MAILBODY;
        subject = data.getMailSubject() != null && data.getMailSubject().equals("") == false ? data.getMailSubject() : MailNotificationMeasure.DEFAULT_MAILSUBJECT;
        subject = this.replaceFields(item, subject);
        body = this.replaceFields(item, body);
        for (String mail : recipients) {
            this.logger.info(String.format("Sending email notification for item %s (%s) to %s.", new Object[]{item.getTitle(), item.getID(), mail}));
            try {
                this.getMailService().sendMail(session, Collections.singletonList(mail), subject, body);
            }
            catch (RuntimeException e) {
                message = String.format("Failed to send mail to " + mail, new Object[0]);
                this.logger.log(Level.WARNING, message, e);
            }
        }
        if (recipients.size() == 0) {
            this.logger.warning("No mail recipients could be found for notification in item " + item);
        }
    }

    private Collection<QualifiedAgent> getSupervisor(QualifiedAgent assignedAgent, PolicyResolution policyResolution) {
        Set<QualifiedAgent> supervisorAgents;
        SessionToken session = this.createSessionToken();
        try {
            String policy = String.format("OrgPosition(id=%d).getOrgUnit().getManagerPosition()", assignedAgent.getOrgPositionID());
            supervisorAgents = policyResolution.resolvePolicy(session, policy);
        }
        catch (OrgModelException e) {
            String message = String.format("Policy resolution exception while retrieving mail addresses for notification, agent ID '%s'.", assignedAgent.getAgentID());
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        catch (DataSourceException e) {
            String message = String.format("Data source problems while retrieving mail addresses for notification, agent ID '%s'.", assignedAgent.getAgentID());
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        catch (PolicyResolutionException pre) {
            String message = String.format("Could not resolve supervisor for agent '%s'.", assignedAgent);
            this.logger.log(Level.SEVERE, message, pre);
            throw new InternalServiceException(message, pre);
        }
        return supervisorAgents;
    }

    private String replaceFields(WorklistItem item, String s) {
        String result = s;
        MailNotificationData.MailField[] mailFieldArray = MailNotificationData.MailField.values();
        int n = mailFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            String replacement;
            MailNotificationData.MailField field = mailFieldArray[n2];
            switch (field) {
                case TITLE: {
                    replacement = item.getTitle();
                    break;
                }
                case DESCRIPTION: {
                    replacement = item.getDescription();
                    break;
                }
                case DUE_DATE: {
                    replacement = new Date(item.getDueDate()).toString();
                    if (item.getDueDate() != 0L) break;
                    replacement = "<not set>";
                    break;
                }
                case PRIORITY: {
                    replacement = WorklistConstants.Priority.toString(null, item.getPriority());
                    break;
                }
                case PROCESS_INSTANCE: {
                    replacement = item.getProcessInstanceName();
                    break;
                }
                case PROCESS_TEMPLATE: {
                    replacement = item.getProcessTemplateName();
                    break;
                }
                case DELEGATION: {
                    WorklistItem.Delegation delegation = item.getCurrentDelegation();
                    if (delegation != null) {
                        replacement = String.valueOf(delegation.getDelegator().getAgentUserName()) + ": " + delegation.getComment();
                        break;
                    }
                    replacement = "(-)";
                    break;
                }
                case OPEN_ENQUIRY: {
                    if (item.getCurrentEnquiry() != null) {
                        replacement = item.getCurrentEnquiry().getQuestion();
                        break;
                    }
                    replacement = "(-)";
                    break;
                }
                case ENQUIRY_REPLY: {
                    if (item.getRepliedEnquiry() != null) {
                        replacement = item.getRepliedEnquiry().getReply();
                        break;
                    }
                    replacement = "(-)";
                    break;
                }
                case ENQUIRY_QUESTION: {
                    if (item.getRepliedEnquiry() != null) {
                        replacement = item.getRepliedEnquiry().getQuestion();
                        break;
                    }
                    replacement = "(-)";
                    break;
                }
                case PUBLIC_DATA_ELEMENTS: {
                    ParameterDataContext data = this.worklistManager.getWorklistUpdateManager().getAttachedDataContext(this.createSessionToken(), item.getID());
                    if (data != null) {
                        StringBuilder builder = new StringBuilder();
                        Map<String, ProcessConstants.AdeptDataType> params = data.getParameters();
                        for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : params.entrySet()) {
                            String message;
                            String paramName = entry.getKey();
                            String stringValue = "";
                            try {
                                if (!data.isNull(paramName)) {
                                    switch (entry.getValue()) {
                                        case BOOLEAN: {
                                            stringValue = Boolean.toString(data.retrieveBooleanParameterValue(paramName));
                                            break;
                                        }
                                        case DATE: {
                                            DateFormat dataFormat = DateFormat.getDateInstance(3);
                                            stringValue = dataFormat.format(data.retrieveDateParameterValue(paramName));
                                            break;
                                        }
                                        case FLOAT: {
                                            stringValue = Double.toString(data.retrieveFloatParameterValue(paramName));
                                            break;
                                        }
                                        case INTEGER: {
                                            stringValue = Long.toString(data.retrieveIntegerParameterValue(paramName));
                                            break;
                                        }
                                        case STRING: {
                                            stringValue = data.retrieveStringParameterValue(paramName);
                                            break;
                                        }
                                        case URI: {
                                            stringValue = data.retrieveURIParameterValue(paramName).toString();
                                            break;
                                        }
                                        default: {
                                            String msg = String.format("Unsupported data type '%s'!", new Object[]{entry.getValue()});
                                            this.logger.warning(msg);
                                            break;
                                        }
                                    }
                                }
                            }
                            catch (InvalidDataTypeException idte) {
                                message = String.format("Could not retrieve value of public data '%s' for usage in a mail notification when escalating worklist item '%s'. The data type is wrong, ignoring the data element.", paramName, item);
                                this.logger.log(Level.WARNING, message, idte);
                            }
                            catch (NoSuchParameterException nspe) {
                                message = String.format("Could not retrieve value of public data '%s' for usage in a mail notification when escalating worklist item '%s'. The data does not exist, ignoring it.", paramName, item);
                                this.logger.log(Level.WARNING, message, nspe);
                            }
                            builder.append(paramName);
                            builder.append(": ");
                            builder.append(stringValue);
                            builder.append("\n");
                        }
                        replacement = builder.toString();
                        break;
                    }
                    replacement = "(-)";
                    break;
                }
                case WORKLIST_OWNER: {
                    if (item.getActivityReference() instanceof EBPInstanceReference) {
                        EBPInstanceReference ebpir = (EBPInstanceReference)((Object)item.getActivityReference());
                        SessionToken session = this.createSessionToken();
                        WorklistAdministration admin = this.worklistManager.getAdministration();
                        Map<QualifiedAgent, UUID> owner = admin.getWorklistsContaining(session, ebpir);
                        StringBuilder ownerString = new StringBuilder();
                        for (QualifiedAgent agent : owner.keySet()) {
                            ownerString.append(agent.getAgentUserName());
                            ownerString.append(" (");
                            ownerString.append(agent.getOrgPositionName());
                            ownerString.append(")\n");
                        }
                        replacement = ownerString.toString();
                        break;
                    }
                    replacement = "(-)";
                    break;
                }
                default: {
                    replacement = field.variable;
                }
            }
            result = result.replaceAll(Pattern.quote(field.variable), replacement);
            ++n2;
        }
        return result;
    }

    private String getEmailAddressForAgent(QualifiedAgent agent) {
        Entity entity;
        SessionToken session = this.createSessionToken();
        try {
            entity = this.modelExplorer.getEntity(session, EntityType.AGENT, agent.getAgentID(), new String[0]);
        }
        catch (OrgModelException e) {
            String message = String.format("Policy resolution exception while retrieving mail addresses for notification, agent ID '%s'.", agent.getAgentID());
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        catch (DataSourceException e) {
            String message = String.format("Data source problems while retrieving mail addresses for notification, agent ID '%s'.", agent.getAgentID());
            this.logger.log(Level.SEVERE, message, e);
            throw new InternalServiceException(message, e);
        }
        String email = entity.getString("email");
        if (email == null || email.length() == 0) {
            String msg = String.format("No email address found for agent '%s'!", agent);
            this.logger.warning(msg);
        }
        return email;
    }

    private Collection<String> getEmailAddressesForAgents(Collection<QualifiedAgent> agents) {
        LinkedList<String> mailAddresses = new LinkedList<String>();
        for (QualifiedAgent agent : agents) {
            String email = this.getEmailAddressForAgent(agent);
            if (email == null || email.equals("")) continue;
            mailAddresses.add(email);
        }
        return mailAddresses;
    }

    private Collection<String> getSupervisorEmailAddressesForAgents(Collection<QualifiedAgent> agents, PolicyResolution policyResolution) {
        LinkedList<String> mailAddresses = new LinkedList<String>();
        for (QualifiedAgent agent : agents) {
            for (QualifiedAgent supervisorAgent : this.getSupervisor(agent, policyResolution)) {
                String email = this.getEmailAddressForAgent(supervisorAgent);
                if (email == null || email.equals("")) continue;
                mailAddresses.add(email);
            }
        }
        return mailAddresses;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees() {
        if ($SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees != null) {
            return $SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees;
        }
        int[] nArray = new int[MailNotificationData.Addressees.values().length];
        try {
            nArray[MailNotificationData.Addressees.AssignmentMembers.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MailNotificationData.Addressees.AssignmentMembersAndMail.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MailNotificationData.Addressees.AssignmentMembersAndSupervisors.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MailNotificationData.Addressees.AssignmentSupervisorMembers.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MailNotificationData.Addressees.AssignmentSupervisorMembersAndMail.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MailNotificationData.Addressees.Both.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MailNotificationData.Addressees.MailAddresses.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$aristaflow$adept2$model$common$plugindata$MailNotificationData$Addressees = nArray;
        return nArray;
    }
}

