/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.model.common.plugindata.PriorityIncreaseData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import org.apache.commons.configuration.Configuration;

public class PriorityIncreaseMeasure
extends AbstractEscalationHandling {
    public PriorityIncreaseMeasure(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager, "PriorityIncreaseMeasure");
    }

    public PriorityIncreaseMeasure(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) {
        this(configuration, worklistManager);
    }

    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken session, PolicyResolution orgModel) {
        PriorityIncreaseData data = ModelViewer.createView(item.getPluginData(this.id).getPluginData(), PriorityIncreaseData.class);
        int priority = data.getType() == PriorityIncreaseData.Type.IncreaseBy ? item.getPriority() + data.getValue() : (item.getPriority() < data.getValue() ? data.getValue() : item.getPriority());
        measures.setPriority(session, item, priority);
    }
}

