/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures.multilevelescalation;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.ActivityStarting;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.model.execution.InvalidActivityStateException;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.InvalidInstanceStateException;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import java.net.URI;
import java.util.HashSet;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class InternalExceptionMeasure
extends AbstractEscalationHandling {
    public static final String ID = "SupervisorDelegationMeasure";

    public InternalExceptionMeasure(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager, ID);
    }

    public InternalExceptionMeasure(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) {
        this(configuration, worklistManager);
    }

    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken session, PolicyResolution orgModel) {
        String comment = "An error ocurred during the multilevel escalation of this item.";
        HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
        recipients.add(new QualifiedAgent(-2L, "system", -2L, "system"));
        if (WorklistConstants.WorklistItemState.ASSIGNED.equals((Object)item.getState())) {
            String msg = "Deselecting item '%s' before delegating it as escalation.";
            this.logger.info(String.format(msg, item.getTitle()));
            String activityReferenceType = item.getActivityReference().getActivityReferenceType();
            if ("de.aristaflow.ADEPT2ActivityReference".equals(activityReferenceType) || "de.aristaflow.LWPActivityReference".equals(activityReferenceType)) {
                ADEPT2EBPReference activity = (ADEPT2EBPReference)item.getActivityReference();
                try {
                    URI[] exMgrURIs = activity.getExecutionManagerURIs();
                    ActivityStarting activityStarting = this.getExecutionMananger(session, exMgrURIs).getActivityStarting();
                    activityStarting.deselectActivity(session, activity);
                }
                catch (ServiceNotKnownException snke) {
                    msg = "Delegating item '%s' to the system agent as last resort after an exception occurred while escalating also failed. Its execution manager cannot be retrieved for deselecting it. The item remains without escalation.";
                    this.logger.log(Level.WARNING, String.format(msg, item), snke);
                    return;
                }
                catch (InvalidActivityStateException iase) {
                    msg = "Delegating item '%s' to the system agent as last resort after an exception occurred while escalating also failed. It has the wrong state to be deselected. The item remains without escalation.";
                    this.logger.log(Level.WARNING, String.format(msg, item), iase);
                    return;
                }
                catch (InvalidInstanceStateException iise) {
                    msg = "Delegating item '%s' to the system agent as last resort after an exception occurred while escalating also failed. Its process instance has the wrong state to deselect the activity. The item remains without escalation.";
                    this.logger.log(Level.WARNING, String.format(msg, item), iise);
                    return;
                }
            } else {
                msg = "Delegating item '%s' to the system agent as last resort after an exception occurred while escalating also failed. It has an unknown or unsupported activity reference type '%s'. The item remains without escalation.";
                this.logger.warning(String.format(msg, item, activityReferenceType));
                return;
            }
        }
        try {
            measures.delegateWorkItem(session, item, recipients, comment);
        }
        catch (InvalidWorklistItemStateException invalidWorklistItemStateException) {
            comment = "Delegating item '%s' to the system agent as last resort after an exception occurred while escalating also failed. It has an invalid state. The item remains without escalation.";
            this.logger.log(Level.WARNING, String.format(comment, item));
        }
    }
}

