/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures.multilevelescalation;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.orgmodelmanager.PolicyResolution;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.AbstractEscalationHandling;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.multilevelescalation.InternalExceptionMeasure;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.multilevelescalation.WrappedMultiLevelMeasures;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.multilevelescalation.WrappedWorklistItem;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.plugindata.MultiLevelEscalationData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.time.DateTimeFormat;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class MultiLevelEscalationHandling
extends AbstractEscalationHandling {
    private final Logger logger = LoggerTools.getLogger(this);
    public static final String ID = "MultiLevelEscalationHandling";
    private static final String PD_FIRST_ESCALATION = "FirstEscalation";

    public MultiLevelEscalationHandling(Configuration configuration, AbstractWorklistManager worklistManager) {
        super(configuration, worklistManager, ID);
    }

    public MultiLevelEscalationHandling(Configuration configuration, AbstractWorklistManager worklistManager, Registry registry) {
        this(configuration, worklistManager);
    }

    @Override
    public void deadlineReached(WorklistItem item, String staffAssignmentRule, long deadline, EscalationHandling.EscalationMeasures measures, SessionToken session, PolicyResolution orgModel) {
        boolean firstEscalation;
        long currentTimeMillis = System.currentTimeMillis();
        String msg = String.format("MLEH for '%s' (%s): Deadline '%s' reached, current time is '%s', difference: %s", item.getTitle(), item.getID(), deadline, currentTimeMillis, currentTimeMillis - deadline);
        this.logger.fine(msg);
        Map<String, String> pluginDataAttributes = item.getPluginData(ID).getPluginData();
        HashMap<String, String> attributes = new HashMap<String, String>(pluginDataAttributes);
        MultiLevelEscalationData data = ModelViewer.createView(attributes, MultiLevelEscalationData.class);
        MultiLevelEscalationData.LevelData[] levelData = data.getLevelData();
        boolean bl = firstEscalation = !pluginDataAttributes.containsKey(PD_FIRST_ESCALATION);
        if (firstEscalation) {
            msg = String.format("MLEH for '%s' (%s): First escalation, calculating further escalation thresholds.", item.getTitle(), item.getID());
            this.logger.fine(msg);
            MultiLevelEscalationData.LevelData[] levelDataArray = levelData;
            int n = levelData.length;
            int n2 = 0;
            while (n2 < n) {
                MultiLevelEscalationData.LevelData ld = levelDataArray[n2];
                if (ld.getThreshold() <= 0L) {
                    long ref = ld.getThresholdReference();
                    if (ref == 0L) {
                        ref = item.getActivationDate();
                    }
                    long absolute = ref + -ld.getThreshold();
                    msg = String.format("MLEH for '%s' (%s): Transformed relative threshold '%s' to absolute threshold '%s'.", item.getTitle(), item.getID(), ld.getThreshold(), absolute);
                    this.logger.fine(msg);
                    ld.setThreshold(absolute);
                }
                ++n2;
            }
            Arrays.sort(levelData, new LevelDataComparator());
            data.setLevelData(levelData);
            levelData = data.getLevelData();
            long lastThreshold = 0L;
            msg = String.format("MLEH for '%s' (%s): First Escalation, listing levels...", item.getTitle(), item.getID());
            this.logger.fine(msg);
            int i = 0;
            while (i < levelData.length) {
                long threshold = levelData[i].getThreshold();
                msg = String.format("MLEH for '%s' (%s): Escalation %s will be '%s' at %s (%s)", item.getTitle(), item.getID(), i, levelData[i].getEscalationPluginData().getPluginID(), DateTimeFormat.formatDateTime(threshold), threshold);
                this.logger.fine(msg);
                if (threshold == lastThreshold) {
                    levelData[i].setThreshold(threshold + 1L);
                    msg = String.format("MLEH for '%s' (%s): Escalations %s and %s have the exact same time, adding an extra millisecond to %s", item.getTitle(), item.getID(), i - 1, i, i);
                    this.logger.fine(msg);
                }
                lastThreshold = threshold;
                ++i;
            }
        }
        int currentDeadlineIndex = -1;
        int i = 0;
        while (i < levelData.length) {
            MultiLevelEscalationData.LevelData ld = levelData[i];
            if (ld.getThreshold() == deadline) {
                currentDeadlineIndex = i;
                msg = String.format("MLEH for '%s' (%s): Current escalation level: %s.", item.getTitle(), item.getID(), i);
                this.logger.fine(msg);
                break;
            }
            ++i;
        }
        if (currentDeadlineIndex == -1 && !firstEscalation) {
            String message = String.format("MLEH for '%s' (%s): Could not find the exact deadline and no further escalations are available.", item.getTitle(), item.getID());
            this.logger.severe(message);
            return;
        }
        if (currentDeadlineIndex == data.getLevelData().length - 1) {
            msg = String.format("MLEH for '%s' (%s): No further escalation levels available.", item.getTitle(), item.getID());
            this.logger.info(msg);
        } else {
            long newEscalationDate = levelData[currentDeadlineIndex + 1].getThreshold();
            msg = String.format("MLEH for '%s' (%s): Setting next escalation time to %s (%s).", item.getTitle(), item.getID(), DateTimeFormat.formatDateTime(newEscalationDate), newEscalationDate);
            this.logger.info(msg);
            measures.setEscalation(session, item, newEscalationDate, ID);
        }
        if (currentDeadlineIndex != -1) {
            MultiLevelEscalationData.LevelData currentEscalation = data.getLevelData()[currentDeadlineIndex];
            PluginData pluginData = currentEscalation.getEscalationPluginData();
            String pluginID = pluginData.getPluginID();
            EscalationHandling levelHandling = this.getEscalationHandlingPlugin(pluginID);
            WrappedWorklistItem wrappedItem = new WrappedWorklistItem(item, pluginData);
            WrappedMultiLevelMeasures wrappedMeasures = new WrappedMultiLevelMeasures(measures, pluginID, item);
            msg = String.format("MLEH for '%s' (%s): Calling escalation plug-in %s now.", item.getTitle(), item.getID(), pluginID);
            this.logger.info(msg);
            levelHandling.deadlineReached(wrappedItem, staffAssignmentRule, deadline, wrappedMeasures, session, orgModel);
            msg = String.format("MLEH for '%s' (%s): Escalation plug-in %s finished.", item.getTitle(), item.getID(), pluginID);
            this.logger.info(msg);
            PluginData updatedLevelPluginData = wrappedMeasures.getPluginData();
            if (updatedLevelPluginData != null) {
                levelData[currentDeadlineIndex].setEscalationPluginData(updatedLevelPluginData);
                msg = String.format("MLEH for '%s' (%s): Plug-in %s changed the plug-in data.", item.getTitle(), item.getID(), pluginID);
                this.logger.fine(msg);
            }
        }
        attributes.put(PD_FIRST_ESCALATION, "false");
        data.setLevelData(levelData);
        DefaultPluginData updatedPluginData = new DefaultPluginData(ID, attributes);
        measures.updatePluginData(session, item, updatedPluginData);
    }

    private EscalationHandling getEscalationHandlingPlugin(String escalationHandlingID) {
        EscalationHandling ret = this.worklistManager.getEscalationHandling(escalationHandlingID);
        if (ret == null) {
            ret = new InternalExceptionMeasure(this.configuration, this.worklistManager);
        }
        return ret;
    }

    public static class LevelDataComparator
    implements Comparator<MultiLevelEscalationData.LevelData>,
    Serializable {
        private static final long serialVersionUID = 8108478745608238628L;

        @Override
        public int compare(MultiLevelEscalationData.LevelData o1, MultiLevelEscalationData.LevelData o2) {
            return (int)(o1.getThreshold() - o2.getThreshold());
        }
    }
}

