/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.escalationmeasures.multilevelescalation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.EscalationHandling;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.InvalidWorklistItemStateException;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Set;
import java.util.logging.Logger;

class WrappedMultiLevelMeasures
implements EscalationHandling.EscalationMeasures {
    private final Logger logger = LoggerTools.getLogger(this);
    private final EscalationHandling.EscalationMeasures measures;
    private final String pluginID;
    private PluginData pluginData;
    private final WorklistItem realItem;

    public WrappedMultiLevelMeasures(EscalationHandling.EscalationMeasures measures, String pluginID, WorklistItem realItem) {
        this.measures = measures;
        this.pluginID = pluginID;
        this.realItem = realItem;
    }

    @Override
    public void setDueDate(SessionToken session, WorklistItem worklistItem, long dueDate) {
        this.measures.setDueDate(session, this.realItem, dueDate);
    }

    @Override
    public void setEscalation(SessionToken session, WorklistItem worklistItem, long escalationDate, String escalationHandlingProcedureID) {
        String message = String.format("Escalation handling plug-in with ID '%s' tried to set a new escalation time / procedure, ignoring", this.pluginID);
        this.logger.warning(message);
    }

    @Override
    public void setPriority(SessionToken session, WorklistItem worklistItem, int priority) {
        this.measures.setPriority(session, this.realItem, priority);
    }

    @Override
    public void updateIndividualSettings(SessionToken session, ClientWorklistItem worklistItem) {
        this.measures.updateIndividualSettings(session, worklistItem);
    }

    @Override
    public void updatePluginData(SessionToken session, WorklistItem worklistItem, PluginData pluginData) {
        this.pluginData = pluginData;
    }

    @Override
    public void updateUserAttributes(SessionToken session, WorklistItem worklistItem) {
        this.measures.updateUserAttributes(session, worklistItem);
    }

    @Override
    public void delegateBack(SessionToken session, WorklistItem item, String reply) throws InvalidWorklistItemStateException {
        this.measures.delegateBack(session, this.realItem, reply);
    }

    @Override
    public void delegateWorkItem(SessionToken session, WorklistItem item, Set<QualifiedAgent> recipients, String comment) throws InvalidWorklistItemStateException {
        this.measures.delegateWorkItem(session, this.realItem, recipients, comment);
    }

    @Override
    public Set<QualifiedAgent> getDelegationRecipients(SessionToken session, WorklistItem item) {
        return this.measures.getDelegationRecipients(session, this.realItem);
    }

    public PluginData getPluginData() {
        return this.pluginData;
    }
}

