/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWorklistItemStorage
implements WorklistItemStorage {
    protected final ReentrantReadWriteLock worklistItemsLock;
    protected final Map<UUID, InternalWorklistItem> worklistItems;
    protected final Map<UUID, EBPInstanceReference> worklistItemsToEBP;
    protected final ObjectLockManager<UUID, SessionToken> lockManager;
    protected final long lockTimeout;
    protected boolean initialUpdateActive = true;
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Map<UUID, StorageTransaction> transactions;

    public AbstractWorklistItemStorage(long lockTimeout) {
        this.worklistItemsLock = new ReentrantReadWriteLock();
        this.worklistItems = new HashMap<UUID, InternalWorklistItem>();
        this.worklistItemsToEBP = new HashMap<UUID, EBPInstanceReference>();
        try {
            this.lockManager = new ObjectLockManager(SessionLock.SubsessionLockCount.class, SessionLock.class, "worklist manager item storage");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising storage of worklist items. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
        this.lockTimeout = lockTimeout;
        this.transactions = new HashMap<UUID, StorageTransaction>();
    }

    @Override
    public EBPInstanceReference getEBPInstanceReference(UUID worklistItemID) throws DataSourceException {
        EBPInstanceReference ebpInstanceReference;
        this.worklistItemsLock.readLock().lock();
        try {
            ebpInstanceReference = this.worklistItemsToEBP.get(worklistItemID);
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
        return ebpInstanceReference;
    }

    @Override
    public InternalWorklistItem getAndLockInternalWorklistItem(SessionToken session, UUID worklistItemID) throws DataSourceException, LockException {
        this.lockInternalWorklistItem(session, worklistItemID);
        return this.getInternalWorklistItemReadonly(worklistItemID);
    }

    @Override
    public InternalWorklistItem getInternalWorklistItemReadonly(UUID worklistItemID) throws DataSourceException {
        InternalWorklistItem worklistItem;
        this.worklistItemsLock.readLock().lock();
        try {
            worklistItem = this.worklistItems.get(worklistItemID);
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
        return worklistItem;
    }

    @Override
    public UUID getInternalWorklistItemID(EBPInstanceReference ebpInstanceReference) {
        this.worklistItemsLock.readLock().lock();
        try {
            for (Map.Entry<UUID, EBPInstanceReference> entry : this.worklistItemsToEBP.entrySet()) {
                if (!entry.getValue().equals(ebpInstanceReference)) continue;
                UUID uUID = entry.getKey();
                return uUID;
            }
            return null;
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
    }

    @Override
    public UUID[] getInternalWorklistItems() {
        this.worklistItemsLock.readLock().lock();
        try {
            UUID[] uUIDArray = this.worklistItems.keySet().toArray(new UUID[this.worklistItems.size()]);
            return uUIDArray;
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
    }

    @Override
    public void finishTransaction(SessionToken session, UUID worklistItemID) throws LockException, DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, worklistItemID)) {
                String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, worklistItemID);
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)worklistItemID, "InternalWorklistItemUpdate");
            }
            StorageTransaction transaction = this.transactions.get(worklistItemID);
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("No Active Transaction for Worklist Item %s", worklistItemID));
            }
            if (!transaction.decrementTransactionCount()) {
                this.transactions.remove(worklistItemID);
                if (transaction.hasChanges()) {
                    InternalWorklistItem item = this.getInternalWorklistItemReadonly(worklistItemID);
                    this.updateInternalWorklistItem(session, item);
                }
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void startTransaction(SessionToken session, UUID worklistItemID) throws LockException {
        this.worklistItemsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, worklistItemID)) {
                String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, worklistItemID);
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)worklistItemID, "InternalWorklistItemUpdate");
            }
            StorageTransaction transaction = this.transactions.get(worklistItemID);
            if (transaction == null) {
                transaction = new StorageTransaction();
                this.transactions.put(worklistItemID, transaction);
            }
            transaction.incrementTransactionCount();
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void unlockInternalWorklistItem(SessionToken session, UUID worklistItemID) throws LockException {
        this.worklistItemsLock.writeLock().lock();
        try {
            this.logger.fine(String.format("Session '%s' releasing lock for worklist item '%s'", session, worklistItemID));
            this.lockManager.unlockObject(true, session, worklistItemID);
            if (!this.lockManager.hasLock(true, session, worklistItemID) && this.transactions.containsKey(worklistItemID)) {
                String msg = String.format("Released Lock on worklist item %s but there is still a transaction active!", worklistItemID);
                this.logger.log(Level.SEVERE, msg);
                assert (false) : msg;
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void lockInternalWorklistItem(SessionToken session, UUID worklistItemID) {
        this.logger.fine(String.format("Session '%s' aquiring lock for worklist item '%s'", session, worklistItemID));
        try {
            this.lockManager.getLockForObject(true, session, worklistItemID, this.lockTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            String msg = String.format("Got a timeout while waiting to lock the internal worklist item '%s' for session '%s'. This is possibly a deadlock.", worklistItemID, session);
            throw new InvalidServiceStateException(msg, te);
        }
    }

    @Override
    public void removeInternalWorklistItem(UUID worklistItemID) throws DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            this.worklistItems.remove(worklistItemID);
            this.worklistItemsToEBP.remove(worklistItemID);
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    public abstract void initialUpdateComplete() throws DataSourceException;

    protected abstract WorklistModelFactory getWorklistModelFactory();

    public static final class StorageTransaction {
        private int transactionCount = 0;
        private boolean changes = false;

        public boolean hasChanges() {
            return this.changes;
        }

        public void changed() {
            this.changes = true;
        }

        public void incrementTransactionCount() {
            ++this.transactionCount;
        }

        public boolean decrementTransactionCount() {
            --this.transactionCount;
            return this.transactionCount > 0;
        }
    }
}

