/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWorklistItemStorage2
implements WorklistItemStorage {
    protected final Logger logger = LoggerTools.getLogger(this);
    private final ReentrantReadWriteLock worklistItemsLock = new ReentrantReadWriteLock();
    private final ObjectLockManager<UUID, SessionToken> lockManager;
    private final long lockTimeout;
    private boolean initialUpdateActive = true;
    private final Map<UUID, StorageTransaction> transactions;
    private Set<UUID> worklistItemIDs;
    private Set<UUID> worklistItemIDsWhileInitialUpdate;

    public AbstractWorklistItemStorage2(long lockTimeout) {
        this.lockTimeout = lockTimeout;
        this.transactions = new HashMap<UUID, StorageTransaction>();
        this.worklistItemIDs = new HashSet<UUID>();
        this.worklistItemIDsWhileInitialUpdate = new HashSet<UUID>();
        try {
            this.lockManager = new ObjectLockManager(SessionLock.SubsessionLockCount.class, SessionLock.class, "worklist manager item storage");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising storage of worklist items. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
    }

    protected void initWorklistItemIDcache() throws DataSourceException {
        this.worklistItemsLock.readLock().lock();
        try {
            this.worklistItemIDs = this.getInternalWorklistItems_internal();
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
    }

    public void initialUpdateComplete() throws DataSourceException {
        this.initialUpdateActive = false;
        HashSet<UUID> itemsToRemove = new HashSet<UUID>(this.worklistItemIDs);
        itemsToRemove.removeAll(this.worklistItemIDsWhileInitialUpdate);
        for (UUID itemID : itemsToRemove) {
            this.removeInternalWorklistItem(itemID);
        }
        this.worklistItemIDs.removeAll(itemsToRemove);
    }

    @Override
    public final EBPInstanceReference getEBPInstanceReference(UUID worklistItemID) throws DataSourceException {
        EBPInstanceReference ebpInstanceReference;
        this.worklistItemsLock.readLock().lock();
        try {
            ebpInstanceReference = this.getEBPInstanceReference_internal(worklistItemID);
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
        return ebpInstanceReference;
    }

    @Override
    public final InternalWorklistItem getAndLockInternalWorklistItem(SessionToken session, UUID worklistItemID) throws DataSourceException, LockException {
        this.lockInternalWorklistItem(session, worklistItemID);
        return this.getInternalWorklistItemReadonly(worklistItemID);
    }

    @Override
    public final InternalWorklistItem getInternalWorklistItemReadonly(UUID worklistItemID) throws DataSourceException {
        InternalWorklistItem worklistItem;
        this.worklistItemsLock.readLock().lock();
        try {
            worklistItem = this.getInternalWorklistItem_internal(worklistItemID);
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
        return worklistItem;
    }

    @Override
    public final UUID getInternalWorklistItemID(EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        this.worklistItemsLock.readLock().lock();
        try {
            UUID uuid;
            UUID uUID = uuid = this.getInternalWorklistItemID_internal(ebpInstanceReference);
            return uUID;
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
    }

    @Override
    public final UUID[] getInternalWorklistItems() {
        UUID[] uuids = new UUID[]{};
        uuids = this.worklistItemIDs.toArray(uuids);
        return uuids;
    }

    @Override
    public final void removeInternalWorklistItem(UUID worklistItemID) throws DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            this.removeInternalWorklistItem_internal(worklistItemID);
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public final InternalWorklistItem createInternalWorklistItem(String name, String description, ActivityReference activityReference, UUID iconID, String staffAssignmentRule, WorklistConstants.WorklistItemState state, int priority, long complexity, long activationDate, long escalationDate, long dueDate, String escalationHandlingProcedureID, String delegationHandlingProcedureID, String distributionHandlingProcedureID, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, ParameterDataContext parameterDataContext, Map<String, String> userAttributes, EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        InternalWorklistItem worklistItem;
        this.worklistItemsLock.writeLock().lock();
        try {
            UUID worklistItemID = this.getInternalWorklistItemID(ebpInstanceReference);
            if (worklistItemID != null) {
                if (!this.initialUpdateActive) {
                    throw new DataSourceException("Can't create worklist item. Item with same EBP instance reference already in storage.");
                }
                this.worklistItemIDsWhileInitialUpdate.add(worklistItemID);
                this.worklistItemIDs.add(worklistItemID);
                worklistItem = this.getInternalWorklistItem_internal(worklistItemID);
                worklistItem.setTitle(name);
                worklistItem.setDescription(description);
                worklistItem.setState(state);
                worklistItem.setPriority(priority);
                worklistItem.setAttachedDataContext(parameterDataContext);
                try {
                    this.updateInternalWorklistItem_internal(worklistItem);
                }
                catch (LockException e) {
                    this.logger.severe("A LockException occuredd, while updating a worklistitem during an update from the execution manager. This should not have been happend, since we have the lock. The worklist item, the execution manager tells us to update is not updated in the database.");
                    e.printStackTrace();
                }
            } else {
                worklistItem = this.createInternalWorklistItem_internal(name, description, activityReference, iconID, staffAssignmentRule, state, priority, complexity, activationDate, escalationDate, dueDate, escalationHandlingProcedureID, delegationHandlingProcedureID, distributionHandlingProcedureID, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, parameterDataContext, userAttributes, ebpInstanceReference);
                worklistItemID = worklistItem.getID();
                if (this.initialUpdateActive) {
                    this.worklistItemIDsWhileInitialUpdate.add(worklistItemID);
                    this.logger.info(String.format("Could not restore Worklist Item '%s'. Not in database!", ebpInstanceReference));
                }
                this.worklistItemIDs.add(worklistItemID);
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
        return worklistItem;
    }

    @Override
    public final void updateInternalWorklistItem(SessionToken session, InternalWorklistItem item) throws DataSourceException, LockException {
        this.worklistItemsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, item.getID())) {
                String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, item.getID());
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)item.getID(), "InternalWorklistItemUpdate");
            }
            if (this.transactions.containsKey(item.getID())) {
                StorageTransaction transaction = this.transactions.get(item.getID());
                transaction.setWorklistItemUpdate(item);
            } else {
                this.updateInternalWorklistItem_internal(item);
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void startTransaction(SessionToken session, UUID worklistItemID) throws LockException {
        this.worklistItemsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, worklistItemID)) {
                String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, worklistItemID);
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)worklistItemID, "InternalWorklistItemUpdate");
            }
            StorageTransaction transaction = this.transactions.get(worklistItemID);
            String msg = String.format("Start transaction for worklist item %s.", worklistItemID);
            this.logger.fine(msg);
            if (transaction == null) {
                transaction = new StorageTransaction();
                this.transactions.put(worklistItemID, transaction);
                msg = String.format("Added a transaction for worklist item %s!", worklistItemID);
                this.logger.finer(msg);
            }
            transaction.incrementTransactionCount();
            msg = String.format("Increased the transaction counter for worklist item %s!", worklistItemID);
            this.logger.finest(msg);
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void finishTransaction(SessionToken session, UUID worklistItemID) throws LockException, DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, worklistItemID)) {
                String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, worklistItemID);
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)worklistItemID, "InternalWorklistItemUpdate");
            }
            StorageTransaction transaction = this.transactions.get(worklistItemID);
            String msg = String.format("Finish transaction for worklist item %s.", worklistItemID);
            this.logger.fine(msg);
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("No Active Transaction for Worklist Item %s", worklistItemID));
            }
            msg = String.format("Decrease the transaction counter for worklist item %s!", worklistItemID);
            this.logger.finest(msg);
            if (!transaction.decrementTransactionCount()) {
                this.transactions.remove(worklistItemID);
                msg = String.format("Removed the transaction for worklist item %s!", worklistItemID);
                this.logger.finer(msg);
                if (transaction.hasChanges()) {
                    InternalWorklistItem item = transaction.getWorklistItem();
                    this.updateInternalWorklistItem(session, item);
                }
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void lockInternalWorklistItem(SessionToken session, UUID worklistItemID) {
        this.logger.fine(String.format("Session '%s' aquiring lock for worklist item '%s'", session, worklistItemID));
        try {
            this.lockManager.getLockForObject(true, session, worklistItemID, this.lockTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            String msg = String.format("Got a timeout while waiting to lock the internal worklist item '%s' for session '%s'. This is possibly a deadlock.", worklistItemID, session);
            throw new InvalidServiceStateException(msg, te);
        }
    }

    @Override
    public void unlockInternalWorklistItem(SessionToken session, UUID worklistItemID) throws LockException {
        this.worklistItemsLock.writeLock().lock();
        try {
            this.logger.fine(String.format("Session '%s' releasing lock for worklist item '%s'", session, worklistItemID));
            this.lockManager.unlockObject(true, session, worklistItemID);
            if (!this.lockManager.hasLock(true, session, worklistItemID) && this.transactions.containsKey(worklistItemID)) {
                String msg = String.format("Released Lock on worklist item %s but there is still a transaction active!", worklistItemID);
                this.logger.log(Level.SEVERE, msg, new Throwable().getStackTrace());
                assert (false) : msg;
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    protected abstract InternalWorklistItem getInternalWorklistItem_internal(UUID var1) throws DataSourceException;

    protected abstract EBPInstanceReference getEBPInstanceReference_internal(UUID var1) throws DataSourceException;

    protected abstract UUID getInternalWorklistItemID_internal(EBPInstanceReference var1) throws DataSourceException;

    protected abstract Set<UUID> getInternalWorklistItems_internal() throws DataSourceException;

    protected abstract void removeInternalWorklistItem_internal(UUID var1) throws DataSourceException;

    protected abstract InternalWorklistItem createInternalWorklistItem_internal(String var1, String var2, ActivityReference var3, UUID var4, String var5, WorklistConstants.WorklistItemState var6, int var7, long var8, long var10, long var12, long var14, String var16, String var17, String var18, String var19, String var20, Map<String, Set<String>> var21, Map<String, PluginData> var22, ParameterDataContext var23, Map<String, String> var24, EBPInstanceReference var25) throws DataSourceException;

    protected abstract void updateInternalWorklistItem_internal(InternalWorklistItem var1) throws DataSourceException, LockException;

    public static final class StorageTransaction {
        private AtomicInteger transactionCount = new AtomicInteger(0);
        private InternalWorklistItem worklistItem = null;

        public boolean hasChanges() {
            return this.worklistItem != null;
        }

        public void incrementTransactionCount() {
            this.transactionCount.getAndIncrement();
        }

        public boolean decrementTransactionCount() {
            int i = this.transactionCount.decrementAndGet();
            return i > 0;
        }

        public InternalWorklistItem getWorklistItem() {
            return this.worklistItem;
        }

        public void setWorklistItemUpdate(InternalWorklistItem worklistItem) {
            this.worklistItem = worklistItem;
        }
    }
}

