/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage;

import de.aristaflow.adept2.core.worklistmanager.storage.WorklistManagerStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistItemStorage2;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class AbstractWorklistItemStorageWithCaching
extends AbstractWorklistItemStorage2 {
    private final Map<UUID, EBPInstanceReference> ebpInstances = new HashMap<UUID, EBPInstanceReference>();
    private final Map<EBPInstanceReference, UUID> worklistItemIDs = new HashMap<EBPInstanceReference, UUID>();
    private final Map<UUID, InternalWorklistItem> worklistItems = new HashMap<UUID, InternalWorklistItem>();
    private final WorklistManagerStorage worklistManagerStorage;

    public AbstractWorklistItemStorageWithCaching(WorklistManagerStorage storageManager, long lockTimeout) {
        super(lockTimeout);
        this.worklistManagerStorage = storageManager;
    }

    @Override
    protected InternalWorklistItem createInternalWorklistItem_internal(String name, String description, ActivityReference activityReference, UUID iconID, String staffAssignmentRule, WorklistConstants.WorklistItemState state, int priority, long complexity, long activationDate, long escalationDate, long dueDate, String escalationHandlingProcedureID, String delegationHandlingProcedureID, String distributionHandlingProcedureID, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, ParameterDataContext parameterDataContext, Map<String, String> userAttributes, EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        return null;
    }

    @Override
    protected EBPInstanceReference getEBPInstanceReference_internal(UUID worklistItemID) throws DataSourceException {
        return this.ebpInstances.get(worklistItemID);
    }

    @Override
    protected UUID getInternalWorklistItemID_internal(EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        return this.worklistItemIDs.get(ebpInstanceReference);
    }

    @Override
    protected InternalWorklistItem getInternalWorklistItem_internal(UUID worklistItemID) throws DataSourceException {
        return this.worklistItems.get(worklistItemID);
    }

    @Override
    protected Set<UUID> getInternalWorklistItems_internal() throws DataSourceException {
        return null;
    }

    @Override
    protected void removeInternalWorklistItem_internal(UUID worklistItemID) throws DataSourceException {
        EBPInstanceReference ref = this.ebpInstances.get(worklistItemID);
        this.worklistItemIDs.remove(ref);
        this.worklistItems.remove(worklistItemID);
        this.ebpInstances.remove(worklistItemID);
    }

    @Override
    protected void updateInternalWorklistItem_internal(InternalWorklistItem item) throws DataSourceException, LockException {
        UUID itemID = item.getID();
        EBPInstanceReference newRef = null;
        EBPInstanceReference oldRef = this.ebpInstances.get(itemID);
        if (item.getActivityReference() instanceof ADEPT2EBPReference) {
            newRef = (EBPInstanceReference)((Object)item.getActivityReference());
        }
        this.worklistItemIDs.remove(oldRef);
        this.worklistItemIDs.put(newRef, itemID);
        this.worklistItems.put(itemID, item);
        if (newRef != null) {
            this.ebpInstances.put(itemID, newRef);
        } else {
            this.ebpInstances.remove(itemID);
        }
        this.updateWorklistsOfItem(item);
    }

    protected void createWorklistItemCacheEntry(InternalWorklistItem worklistItem) {
        if (worklistItem == null) {
            return;
        }
        UUID itemID = worklistItem.getID();
        if (worklistItem.getActivityReference() instanceof ADEPT2EBPReference) {
            EBPInstanceReference ref = (EBPInstanceReference)((Object)worklistItem.getActivityReference());
            this.ebpInstances.put(itemID, ref);
            this.worklistItemIDs.put(ref, itemID);
        }
        this.worklistItems.put(itemID, worklistItem);
    }

    private void updateWorklistsOfItem(InternalWorklistItem item) throws DataSourceException {
        Set<IndividualWorklistItemSettings> settings = item.getIndividualWorklistItemSettings();
        for (IndividualWorklistItemSettings setting : settings) {
            UUID worklistID = setting.getWorklistID();
            InternalWorklist<InternalWorklistItem> worklist = this.worklistManagerStorage.getWorklistStorage().getInternalWorklistReadonly(worklistID);
            worklist.getWorklistItems().contains(item);
        }
    }
}

