/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWorklistStorage
implements WorklistStorage {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final ReentrantReadWriteLock worklistsLock = new ReentrantReadWriteLock();
    protected final Map<UUID, InternalWorklist<InternalWorklistItem>> worklists = new HashMap<UUID, InternalWorklist<InternalWorklistItem>>();
    protected final Map<QualifiedAgent, UUID> worklistByAgent = new HashMap<QualifiedAgent, UUID>();
    protected final Map<UUID, WorklistUpdateConfiguration> mailingClientWorklists = new HashMap<UUID, WorklistUpdateConfiguration>();
    protected final Map<UUID, Map<String, String>> worklistConfigurations = new HashMap<UUID, Map<String, String>>();
    protected final ObjectLockManager<UUID, SessionToken> lockManager;
    protected final long lockTimeout;

    public AbstractWorklistStorage(long lockTimeout) {
        try {
            this.lockManager = new ObjectLockManager(SessionLock.SubsessionLockCount.class, SessionLock.class, "worklist manager worklist storage");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising storage of worklists. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
        this.lockTimeout = lockTimeout;
    }

    protected abstract WorklistModelFactory getWorklistModelFactory();

    protected UUID getNextWorklistID() {
        return UUID.randomUUID();
    }

    @Override
    public InternalWorklist<InternalWorklistItem> getAndLockInternalWorklist(SessionToken session, UUID worklistID) throws DataSourceException {
        this.lockInternalWorklist(session, worklistID);
        return this.getInternalWorklistReadonly(worklistID);
    }

    @Override
    public void lockInternalWorklist(SessionToken session, UUID worklistID) {
        this.logger.fine(String.format("Session '%s' aquiring lock for worklist '%s'", session, worklistID));
        try {
            this.lockManager.getLockForObject(true, session, worklistID, this.lockTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            String msg = String.format("Got a timeout while waiting to lock the internal worklist '%s' for session '%s'. This is possibly a deadlock.", worklistID, session);
            throw new InvalidServiceStateException(msg, te);
        }
    }

    @Override
    public void unlockInternalWorklist(SessionToken session, UUID worklistID) throws LockException {
        this.logger.fine(String.format("Session '%s' releasing lock for worklist '%s'", session, worklistID));
        this.lockManager.unlockObject(true, session, worklistID);
    }

    @Override
    public UUID[] getInternalWorklists() {
        this.worklistsLock.readLock().lock();
        try {
            Set<UUID> uuids = this.worklists.keySet();
            UUID[] uUIDArray = uuids.toArray(new UUID[uuids.size()]);
            return uUIDArray;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public InternalWorklist<InternalWorklistItem> getInternalWorklistReadonly(UUID worklistID) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        this.worklistsLock.readLock().lock();
        try {
            worklist = this.worklists.get(worklistID);
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return worklist;
    }

    @Override
    public void removeInternalWorklist(UUID worklistID) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            InternalWorklist<InternalWorklistItem> worklist = this.worklists.remove(worklistID);
            this.worklistByAgent.remove(worklist.getAgent());
            this.worklistConfigurations.remove(worklistID);
            this.mailingClientWorklists.remove(worklistID);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public UUID getWorklistID(QualifiedAgent agent) {
        this.worklistsLock.readLock().lock();
        try {
            UUID uUID = this.worklistByAgent.get(agent);
            return uUID;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public Set<QualifiedAgent> getQualifiedAgents() {
        this.worklistsLock.readLock().lock();
        try {
            HashSet<QualifiedAgent> hashSet = new HashSet<QualifiedAgent>(this.worklistByAgent.keySet());
            return hashSet;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public WorklistUpdateConfiguration getMailingClientWorklistConfig(UUID worklistID) {
        this.worklistsLock.readLock().lock();
        try {
            WorklistUpdateConfiguration worklistUpdateConfiguration = this.mailingClientWorklists.get(worklistID);
            return worklistUpdateConfiguration;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public void setMailingClientWorklistConfig(UUID worklistID, WorklistUpdateConfiguration config) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            if (config != null) {
                this.mailingClientWorklists.put(worklistID, config);
            } else {
                this.mailingClientWorklists.remove(worklistID);
            }
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, String> getWorklistConfiguration(UUID worklistID) {
        HashMap<String, String> result = new HashMap<String, String>();
        this.worklistsLock.readLock().lock();
        try {
            if (this.worklistConfigurations.containsKey(worklistID)) {
                result.putAll(this.worklistConfigurations.get(worklistID));
            }
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return result;
    }

    @Override
    public void setWorklistConfiguration(UUID worklistID, Map<String, String> worklistConfiguration) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            if (worklistConfiguration != null) {
                this.worklistConfigurations.put(worklistID, new HashMap<String, String>(worklistConfiguration));
            } else {
                this.worklistConfigurations.remove(worklistID);
            }
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }
}

