/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionLock;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.locking.ObjectLockManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWorklistStorage2
implements WorklistStorage {
    protected final Logger logger = LoggerTools.getLogger(this);
    private final ReentrantReadWriteLock worklistsLock = new ReentrantReadWriteLock();
    private final ObjectLockManager<UUID, SessionToken> lockManager;
    private final long lockTimeout;
    private Set<UUID> worklistIDs;
    private Map<QualifiedAgent, UUID> agentsWorklist;
    private Map<UUID, Map<ClientWorklist, Long>> clientWorklists;

    public AbstractWorklistStorage2(long lockTimeout) {
        this.lockTimeout = lockTimeout;
        this.worklistIDs = new HashSet<UUID>();
        this.agentsWorklist = new HashMap<QualifiedAgent, UUID>();
        this.clientWorklists = new HashMap<UUID, Map<ClientWorklist, Long>>();
        try {
            this.lockManager = new ObjectLockManager(SessionLock.SubsessionLockCount.class, SessionLock.class, "worklist manager worklist storage");
        }
        catch (InvocationTargetException ite) {
            String msg = "Can not instantiate object lock manager for synchronising storage of worklists. There were problems instantiating the lock count manager and/or the session locks.";
            this.logger.log(Level.SEVERE, msg, ite);
            throw new InternalServiceException(msg, ite);
        }
    }

    protected UUID getNextWorklistID() {
        return UUID.randomUUID();
    }

    protected void initWorklistIDcache() throws DataSourceException {
        this.worklistsLock.readLock().lock();
        try {
            this.agentsWorklist = this.getAgentAndWorklistIDs_internal();
            for (QualifiedAgent agent : this.agentsWorklist.keySet()) {
                this.worklistIDs.add(this.agentsWorklist.get(agent));
            }
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public final Set<QualifiedAgent> getQualifiedAgents() {
        this.worklistsLock.readLock().lock();
        try {
            HashSet<QualifiedAgent> hashSet = new HashSet<QualifiedAgent>(this.agentsWorklist.keySet());
            return hashSet;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public final UUID getWorklistID(QualifiedAgent agent) {
        this.worklistsLock.readLock().lock();
        try {
            UUID uuid;
            UUID uUID = uuid = this.agentsWorklist.get(agent);
            return uUID;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public final UUID[] getInternalWorklists() {
        this.worklistsLock.readLock().lock();
        try {
            UUID[] uUIDArray = this.worklistIDs.toArray(new UUID[this.worklistIDs.size()]);
            return uUIDArray;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public final InternalWorklist<InternalWorklistItem> getAndLockInternalWorklist(SessionToken session, UUID worklistID) throws DataSourceException {
        this.lockInternalWorklist(session, worklistID);
        return this.getInternalWorklistReadonly(worklistID);
    }

    @Override
    public final InternalWorklist<InternalWorklistItem> getInternalWorklistReadonly(UUID worklistID) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        this.worklistsLock.readLock().lock();
        try {
            worklist = this.getInternalWorklist_internal(worklistID);
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return worklist;
    }

    @Override
    public InternalWorklist<InternalWorklistItem> createInternalWorklist(QualifiedAgent agent, long revision, Map<String, String> userAttributes) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        this.worklistsLock.writeLock().lock();
        try {
            if (this.agentsWorklist.containsKey(agent)) {
                InternalWorklist<InternalWorklistItem> internalWorklist = this.getInternalWorklist_internal(this.agentsWorklist.get(agent));
                return internalWorklist;
            }
            worklist = this.createInternalWorklist_internal(agent, revision, userAttributes);
            this.worklistIDs.add(worklist.getID());
            this.agentsWorklist.put(worklist.getAgent(), worklist.getID());
            this.clientWorklists.put(worklist.getID(), worklist.getUpdateableClientWorklists());
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
        return worklist;
    }

    @Override
    public void updateInternalWorklist(SessionToken session, InternalWorklist<InternalWorklistItem> worklist) throws DataSourceException, LockException {
        this.worklistsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, worklist.getID())) {
                String message = String.format("Session '%s' is not holiding any lock on worklist '%s'!", session, worklist.getID());
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)worklist.getID(), "InternalWorklistUpdate");
            }
            this.updateInternalWorklist_internal(worklist);
            HashMap<ClientWorklist, Long> newClientWorklists = new HashMap<ClientWorklist, Long>(worklist.getUpdateableClientWorklists());
            this.clientWorklists.put(worklist.getID(), newClientWorklists);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public final void removeInternalWorklist(UUID worklistID) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            this.removeInternalWorklist_internal(worklistID);
            this.worklistIDs.remove(worklistID);
            this.clientWorklists.remove(worklistID);
            ArrayList<QualifiedAgent> agentsToRemove = new ArrayList<QualifiedAgent>();
            for (QualifiedAgent agent : this.agentsWorklist.keySet()) {
                if (!this.agentsWorklist.get(agent).equals(worklistID)) continue;
                agentsToRemove.add(agent);
            }
            for (QualifiedAgent agentToRemove : agentsToRemove) {
                this.agentsWorklist.remove(agentToRemove);
            }
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public final WorklistUpdateConfiguration getMailingClientWorklistConfig(UUID worklistID) throws DataSourceException {
        this.worklistsLock.readLock().lock();
        try {
            WorklistUpdateConfiguration worklistUpdateConfiguration = this.getMailingClientWorklistConfig_internal(worklistID);
            return worklistUpdateConfiguration;
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
    }

    @Override
    public void setMailingClientWorklistConfig(UUID worklistID, WorklistUpdateConfiguration config) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            this.setMailingClientWorklistConfig_internal(worklistID, config);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public Map<String, String> getWorklistConfiguration(UUID worklistID) throws DataSourceException {
        Map<String, String> result;
        this.worklistsLock.readLock().lock();
        try {
            result = this.getWorklistConfiguration_internal(worklistID);
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return result;
    }

    @Override
    public void setWorklistConfiguration(UUID worklistID, Map<String, String> worklistConfiguration) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            this.setWorklistConfiguration_internal(worklistID, worklistConfiguration);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public final void lockInternalWorklist(SessionToken session, UUID worklistID) {
        this.logger.fine(String.format("Session '%s' aquiring lock for worklist '%s'", session, worklistID));
        try {
            this.lockManager.getLockForObject(true, session, worklistID, this.lockTimeout);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            String msg = String.format("Got a timeout while waiting to lock the internal worklist '%s' for session '%s'. This is possibly a deadlock.", worklistID, session);
            throw new InvalidServiceStateException(msg, te);
        }
    }

    @Override
    public final void unlockInternalWorklist(SessionToken session, UUID worklistID) throws LockException {
        this.logger.fine(String.format("Session '%s' releasing lock for worklist '%s'", session, worklistID));
        this.lockManager.unlockObject(true, session, worklistID);
    }

    protected Map<ClientWorklist, Long> getClientWorklists(UUID worklistID) {
        if (!this.clientWorklists.containsKey(worklistID)) {
            return new HashMap<ClientWorklist, Long>();
        }
        return this.clientWorklists.get(worklistID);
    }

    protected abstract Map<QualifiedAgent, UUID> getAgentAndWorklistIDs_internal() throws DataSourceException;

    protected abstract InternalWorklist<InternalWorklistItem> getInternalWorklist_internal(UUID var1) throws DataSourceException;

    protected abstract InternalWorklist<InternalWorklistItem> createInternalWorklist_internal(QualifiedAgent var1, long var2, Map<String, String> var4) throws DataSourceException;

    protected abstract void updateInternalWorklist_internal(InternalWorklist<InternalWorklistItem> var1) throws DataSourceException;

    protected abstract void removeInternalWorklist_internal(UUID var1) throws DataSourceException;

    protected abstract WorklistUpdateConfiguration getMailingClientWorklistConfig_internal(UUID var1) throws DataSourceException;

    protected abstract void setMailingClientWorklistConfig_internal(UUID var1, WorklistUpdateConfiguration var2) throws DataSourceException;

    protected abstract Map<String, String> getWorklistConfiguration_internal(UUID var1) throws DataSourceException;

    protected abstract void setWorklistConfiguration_internal(UUID var1, Map<String, String> var2) throws DataSourceException;
}

