/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistStorage2;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.DataSourceException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AbstractWorklistStorageWithCaching
extends AbstractWorklistStorage2 {
    private final Map<UUID, InternalWorklist<InternalWorklistItem>> worklists = new HashMap<UUID, InternalWorklist<InternalWorklistItem>>();
    private final Map<UUID, WorklistUpdateConfiguration> updateConfigurations = new HashMap<UUID, WorklistUpdateConfiguration>();
    private final Map<UUID, Map<String, String>> worklistConfigurations = new HashMap<UUID, Map<String, String>>();

    public AbstractWorklistStorageWithCaching(long lockTimeout) {
        super(lockTimeout);
    }

    @Override
    protected InternalWorklist<InternalWorklistItem> createInternalWorklist_internal(QualifiedAgent agent, long revision, Map<String, String> userAttributes) throws DataSourceException {
        return null;
    }

    @Override
    protected Map<QualifiedAgent, UUID> getAgentAndWorklistIDs_internal() throws DataSourceException {
        return null;
    }

    @Override
    protected InternalWorklist<InternalWorklistItem> getInternalWorklist_internal(UUID worklistID) throws DataSourceException {
        return this.worklists.get(worklistID);
    }

    @Override
    protected WorklistUpdateConfiguration getMailingClientWorklistConfig_internal(UUID worklistID) throws DataSourceException {
        return this.updateConfigurations.get(worklistID);
    }

    @Override
    protected Map<String, String> getWorklistConfiguration_internal(UUID worklistID) throws DataSourceException {
        return this.worklistConfigurations.get(worklistID);
    }

    @Override
    protected void removeInternalWorklist_internal(UUID worklistID) throws DataSourceException {
        this.worklists.remove(worklistID);
        this.updateConfigurations.remove(worklistID);
        this.worklistConfigurations.remove(worklistID);
    }

    @Override
    protected void setMailingClientWorklistConfig_internal(UUID worklistID, WorklistUpdateConfiguration config) throws DataSourceException {
        this.updateConfigurations.put(worklistID, config);
    }

    @Override
    protected void setWorklistConfiguration_internal(UUID worklistID, Map<String, String> worklistConfiguration) throws DataSourceException {
        HashMap<String, String> configMap = new HashMap<String, String>(worklistConfiguration);
        this.worklistConfigurations.put(worklistID, configMap);
    }

    @Override
    protected void updateInternalWorklist_internal(InternalWorklist<InternalWorklistItem> worklist) throws DataSourceException {
        this.worklists.put(worklist.getID(), worklist);
    }

    protected void createWorklistCacheEntry(InternalWorklist<InternalWorklistItem> worklist) {
        this.worklists.put(worklist.getID(), worklist);
    }

    protected void createWorklistConfigurationCachEntry(UUID worklistID, Map<String, String> configuration) {
        this.worklistConfigurations.put(worklistID, configuration);
    }

    protected void createUpdateConfigurationCacheEntry(UUID worklistID, WorklistUpdateConfiguration updateConfiguration) {
        this.updateConfigurations.put(worklistID, updateConfiguration);
    }
}

