/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.dbstorage;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.storage.ClientStorage;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class DBClientStorage
implements ClientStorage {
    private static final String SEPARATOR = "%|";
    private final Logger logger = LoggerTools.getLogger(this);
    private JDBCDataSource dataSource;

    public DBClientStorage(JDBCDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public synchronized void addClientURIsToAgent(QualifiedAgent agent, URI[] clientURIs) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String msg;
                long clientID;
                con = this.dataSource.getConnection();
                con.setAutoCommit(false);
                String uriString = this.getStringFromURIs(clientURIs);
                stmt = con.prepareStatement("SELECT clientID FROM wl_uri WHERE uriString LIKE ?");
                stmt.setString(1, uriString);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    clientID = con.nextID("ClientID");
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement("INSERT INTO wl_uri (uriString, clientID) VALUES (?, ?)");
                    stmt.setString(1, uriString);
                    stmt.setLong(2, clientID);
                    stmt.execute();
                    msg = String.format("Added uris '%s' with id '%s' to DB.", Arrays.toString(clientURIs), clientID);
                    this.logger.finer(msg);
                } else {
                    clientID = rs.getLong(1);
                    rs = JDBCTools.close(rs);
                }
                stmt = JDBCTools.close(stmt);
                if (!this.isUserKnown(agent)) {
                    stmt = con.prepareStatement("INSERT INTO wl_qa (agentID, orgPositionID) VALUES (?, ?)");
                    stmt.setLong(1, agent.getAgentID());
                    stmt.setLong(2, agent.getOrgPositionID());
                    stmt.execute();
                    msg = String.format("Added agent '%s' to DB.", agent);
                    this.logger.finer(msg);
                    stmt = JDBCTools.close(stmt);
                }
                stmt = con.prepareStatement("SELECT counter FROM wl_hasc WHERE agentID = ? AND orgPositionID = ? AND clientID = ?");
                stmt.setLong(1, agent.getAgentID());
                stmt.setLong(2, agent.getOrgPositionID());
                stmt.setLong(3, clientID);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement("INSERT INTO wl_hasc (agentID, orgPositionID, clientID, counter) VALUES (?, ?, ?, ?)");
                    stmt.setLong(1, agent.getAgentID());
                    stmt.setLong(2, agent.getOrgPositionID());
                    stmt.setLong(3, clientID);
                    stmt.setLong(4, 1L);
                    msg = String.format("Added '%s' with id '%s' to DB.", agent, clientID);
                    this.logger.finer(msg);
                } else {
                    long counter = rs.getLong("counter");
                    rs = JDBCTools.close(rs);
                    stmt = JDBCTools.close(stmt);
                    stmt = con.prepareStatement("UPDATE wl_hasc SET counter = ? WHERE agentID = ? AND orgPositionID = ? AND clientID = ?");
                    stmt.setLong(1, ++counter);
                    stmt.setLong(2, agent.getAgentID());
                    stmt.setLong(3, agent.getOrgPositionID());
                    stmt.setLong(4, clientID);
                    String msg2 = String.format("Increased counter (%s) for '%s' with id '%s'.", counter, agent, clientID);
                    this.logger.finer(msg2);
                }
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
    }

    @Override
    public synchronized List<URI[]> getClientURIs(QualifiedAgent agent) throws DataSourceException {
        ArrayList<URI[]> arrayList;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<URI[]> ret = new ArrayList<URI[]>();
        try {
            con = this.dataSource.getConnection();
            stmt = con.prepareStatement("SELECT uriString FROM wl_hasc CL JOIN wl_uri CU ON CL.clientID = CU.clientID WHERE agentID = ? AND orgPositionID = ?");
            stmt.setLong(1, agent.getAgentID());
            stmt.setLong(2, agent.getOrgPositionID());
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(this.getURIsFromString(rs.getString(1)));
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            arrayList = ret;
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new DataSourceException(ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return arrayList;
    }

    @Override
    public synchronized boolean removeClientURIsFromAgent(QualifiedAgent agent, URI[] clientURIs, boolean longterm) throws DataSourceException {
        boolean bl;
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.dataSource.getConnection();
            con.setAutoCommit(false);
            stmt = con.prepareStatement("SELECT clientID FROM wl_uri WHERE uriString LIKE ?");
            String uriString = this.getStringFromURIs(clientURIs);
            stmt.setString(1, uriString);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                rs = JDBCTools.close(rs);
                String msg = String.format("No clientID found for uris '%s' (and '%s')!", Arrays.toString(clientURIs), agent);
                this.logger.warning(msg);
                throw new DataSourceException(msg);
            }
            long clientID = rs.getLong(1);
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            stmt = con.prepareStatement("SELECT counter FROM wl_hasc WHERE agentID = ? AND orgPositionID = ? AND clientID = ?");
            stmt.setLong(1, agent.getAgentID());
            stmt.setLong(2, agent.getOrgPositionID());
            stmt.setLong(3, clientID);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                rs = JDBCTools.close(rs);
                String msg = String.format("No entry found for '%s' with uris '%s'!", agent, Arrays.toString(clientURIs));
                this.logger.warning(msg);
                throw new DataSourceException(msg);
            }
            long counter = rs.getLong("counter") - 1L;
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            if (counter > 0L) {
                stmt = con.prepareStatement("UPDATE wl_hasc SET counter = ? WHERE agentID = ? AND orgPositionID = ? AND clientID = ?");
                stmt.setLong(1, counter);
                stmt.setLong(2, agent.getAgentID());
                stmt.setLong(3, agent.getOrgPositionID());
                stmt.setLong(4, clientID);
                stmt.execute();
                String msg = String.format("Decreased counter (%s) for '%s' with id '%s'.", counter, agent, clientID);
                this.logger.finer(msg);
            } else {
                stmt = con.prepareStatement("DELETE FROM wl_hasc WHERE agentID = ? AND orgPositionID = ? AND clientID = ?");
                stmt.setLong(1, agent.getAgentID());
                stmt.setLong(2, agent.getOrgPositionID());
                stmt.setLong(3, clientID);
                stmt.execute();
                JDBCTools.close(stmt);
                String msg = String.format("Removed '%s' with id '%s' from DB.", agent, clientID);
                this.logger.finer(msg);
                if (longterm) {
                    stmt = con.prepareStatement("SELECT agentID, orgPositionID FROM wl_hasc WHERE agentID = ? AND orgPositionID = ?");
                    stmt.setLong(1, agent.getAgentID());
                    stmt.setLong(2, agent.getOrgPositionID());
                    rs = stmt.executeQuery();
                    if (!rs.next()) {
                        JDBCTools.close(rs);
                        JDBCTools.close(stmt);
                        stmt = con.prepareStatement("DELETE FROM wl_qa WHERE agentID = ? AND orgPositionID = ?");
                        stmt.setLong(1, agent.getAgentID());
                        stmt.setLong(2, agent.getOrgPositionID());
                        stmt.execute();
                        msg = String.format("Removed agent '%s' (longterm).", agent);
                        this.logger.finer(msg);
                        stmt = JDBCTools.close(stmt);
                    }
                }
                stmt = con.prepareStatement("SELECT clientID FROM wl_hasc WHERE clientID = ?");
                stmt.setLong(1, clientID);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    JDBCTools.close(rs);
                    JDBCTools.close(stmt);
                    stmt = con.prepareStatement("DELETE FROM wl_uri WHERE clientID = ?");
                    stmt.setLong(1, clientID);
                    stmt.execute();
                    msg = String.format("Removed uri '%s' with id '%s'.", Arrays.toString(clientURIs), clientID);
                    this.logger.finer(msg);
                } else {
                    rs = JDBCTools.close(rs);
                }
            }
            stmt = JDBCTools.close(stmt);
            con = JDBCTools.close(con);
            bl = counter == 0L;
        }
        catch (SQLException ex) {
            try {
                throw new DataSourceException(ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(con, stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return bl;
    }

    @Override
    public synchronized boolean isUserKnown(QualifiedAgent agent) throws DataSourceException {
        ExtendedConnection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean ret = false;
        try {
            try {
                con = this.dataSource.getConnection();
                stmt = con.prepareStatement("SELECT agentID, orgPositionID FROM wl_qa WHERE agentID = ? AND orgPositionID = ?");
                stmt.setLong(1, agent.getAgentID());
                stmt.setLong(2, agent.getOrgPositionID());
                rs = stmt.executeQuery();
                ret = rs.next();
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
                con = JDBCTools.close(con);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(con, stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly(con, (Statement)stmt, rs);
        return ret;
    }

    private String getStringFromURIs(URI[] clientURIs) {
        StringBuilder ret = new StringBuilder();
        URI[] uRIArray = clientURIs;
        int n = clientURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            ret.append(uri);
            ret.append(SEPARATOR);
            ++n2;
        }
        ret.delete(ret.length() - 2, ret.length());
        String msg = String.format("Converted uris: '%s' to string: '%s'", Arrays.toString(clientURIs), ret.toString());
        this.logger.finest(msg);
        return ret.toString();
    }

    private URI[] getURIsFromString(String string) throws DataSourceException {
        String[] strings = string.split(SEPARATOR);
        Object[] uris = new URI[strings.length];
        int i = 0;
        while (i < strings.length) {
            try {
                uris[i] = new URI(strings[i]);
            }
            catch (URISyntaxException e) {
                String msg = String.format("Wrong URI syntax in client storage detected: %s", strings[i]);
                throw new DataSourceException(msg, e);
            }
            ++i;
        }
        String msg = String.format("Converted string: '%s' to uris: '%s'", string, Arrays.toString(uris));
        this.logger.finest(msg);
        return uris;
    }
}

