/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.dbstorage;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistItemStorageWithCaching;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBStorageTools;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBWorklistManagerStorage;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.LWPActivityReference;
import de.aristaflow.adept2.model.worklistmodel.TLPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.defaultimplementation.DefaultInternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLExport;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLImport;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.types.Pair;
import java.io.InputStream;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.w3c.dom.Document;

public class DBWorklistItemStorage
extends AbstractWorklistItemStorageWithCaching {
    private final WorklistModelFactory worklistModelFactory;
    private ExecutionFactory executionFactory;
    private DBWorklistManagerStorage manager;
    private WorklistModelXMLExport xmlExport;
    private WorklistModelXMLImport xmlImport;

    public DBWorklistItemStorage(DBWorklistManagerStorage worklistManagerStorage, long lockTimeout) throws DataSourceException {
        super(worklistManagerStorage, lockTimeout);
        this.worklistModelFactory = worklistManagerStorage.getWorklistModelFactory();
        this.executionFactory = worklistManagerStorage.getExecutionFactory();
        this.xmlExport = new WorklistModelXMLExport();
        this.xmlImport = new WorklistModelXMLImport(this.worklistModelFactory, worklistManagerStorage.getFilterFactory());
        this.manager = worklistManagerStorage;
        this.initWorklistItemIDcache();
    }

    public WorklistModelFactory getWorklistModelFactory() {
        return this.worklistModelFactory;
    }

    @Override
    protected InternalWorklistItem createInternalWorklistItem_internal(String name, String description, ActivityReference activityReference, UUID iconID, String staffAssignmentRule, WorklistConstants.WorklistItemState state, int priority, long complexity, long activationDate, long escalationDate, long dueDate, String escalationHandlingProcedureID, String delegationHandlingProcedureID, String distributionHandlingProcedureID, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, ParameterDataContext parameterDataContext, Map<String, String> userAttributes, EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        InternalWorklistItem worklistItem;
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                UUID worklistItemID = this.getNextWorklistItemID();
                worklistItem = this.getWorklistModelFactory().createInternalWorklistItem(worklistItemID, name, description, activityReference, iconID, staffAssignmentRule, state, new UUID[0], null, -1, new HashSet<IndividualWorklistItemSettings>(), priority, complexity, activationDate, 0L, null, escalationDate, dueDate, 0, escalationHandlingProcedureID, 0, delegationHandlingProcedureID, new ArrayList<WorklistItem.Delegation>(), null, new ArrayList<Enquiry>(), distributionHandlingProcedureID, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, parameterDataContext, userAttributes);
                this.createDBEntryForWorklistItem(worklistItem, con);
                this.createDBEntryForIndividualSettings(worklistItem, con);
                this.createDBEntryForActivity(worklistItem, con);
                this.createDBEntryForStateWorklistIDs(worklistItem, con);
                this.createDbEntryForDelegationHistroy(worklistItem, con);
                this.createDBEntryForEnquiryStack(worklistItem, con);
                this.manager.releaseConnection(con, true);
                this.createWorklistItemCacheEntry(worklistItem);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't create new worklist item. Anerror in the database occurs.", e);
        }
        return worklistItem;
    }

    @Override
    protected EBPInstanceReference getEBPInstanceReference_internal(UUID worklistItemID) throws DataSourceException {
        ExtendedConnection con = null;
        EBPInstanceReference ref = super.getEBPInstanceReference_internal(worklistItemID);
        if (ref != null) {
            return ref;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                ref = (EBPInstanceReference)((Object)this.getActivityReferenceFromDB(worklistItemID, con));
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the EBPInstanceReference. An error in the database occurs.", e);
        }
        return ref;
    }

    @Override
    protected InternalWorklistItem getInternalWorklistItem_internal(UUID worklistItemID) throws DataSourceException {
        ExtendedConnection con = null;
        InternalWorklistItem item = super.getInternalWorklistItem_internal(worklistItemID);
        if (item != null) {
            return item;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                item = this.getWorklistItemFromDB(worklistItemID, con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the worklist item. An error in the database occurs.", e);
        }
        this.createWorklistItemCacheEntry(item);
        return item;
    }

    @Override
    protected UUID getInternalWorklistItemID_internal(EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        ExtendedConnection con = null;
        UUID worklistItemID = super.getInternalWorklistItemID_internal(ebpInstanceReference);
        if (worklistItemID != null) {
            return worklistItemID;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                worklistItemID = this.getUUIDByEBPFromDB(ebpInstanceReference, con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the worklist item. Anerror in the database occurs.", e);
        }
        return worklistItemID;
    }

    @Override
    protected Set<UUID> getInternalWorklistItems_internal() throws DataSourceException {
        ExtendedConnection con = null;
        Set<UUID> uuids = super.getInternalWorklistItems_internal();
        if (uuids != null) {
            return uuids;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                uuids = this.getWorklistItemIDsFromDB(con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retreive the worklist item IDs. Anerror during a database access", e);
        }
        return uuids;
    }

    @Override
    protected void removeInternalWorklistItem_internal(UUID worklistItemID) throws DataSourceException {
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                this.removeDBEntryForEnquiryStack(worklistItemID, con);
                this.removeDBEntryForDelegationHistory(worklistItemID, con);
                this.removeDBEntryForAvailableStateIDs(worklistItemID, con);
                this.removeDBEntryForActivity(worklistItemID, con);
                this.removeDBEntryForIndividualSettings(worklistItemID, con);
                this.removeDBEntryForWorklistItem(worklistItemID, con);
                this.manager.releaseConnection(con, true);
                super.removeInternalWorklistItem_internal(worklistItemID);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't remove worklist item. Anerror in the database occurs.", e);
        }
    }

    @Override
    protected void updateInternalWorklistItem_internal(InternalWorklistItem item) throws DataSourceException, LockException {
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                UUID worklistItemID = item.getID();
                this.removeDBEntryForEnquiryStack(worklistItemID, con);
                this.removeDBEntryForDelegationHistory(worklistItemID, con);
                this.removeDBEntryForAvailableStateIDs(worklistItemID, con);
                this.removeDBEntryForIndividualSettings(worklistItemID, con);
                this.updateDBEntryForWorklistItem(item, con);
                this.updateDBEntryForActivity(item, con);
                this.createDBEntryForIndividualSettings(item, con);
                this.createDBEntryForStateWorklistIDs(item, con);
                this.createDbEntryForDelegationHistroy(item, con);
                this.createDBEntryForEnquiryStack(item, con);
                this.manager.releaseConnection(con, true);
                super.updateInternalWorklistItem_internal(item);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't update worklist item. Anerror in the database occurs.", e);
        }
    }

    private UUID getNextWorklistItemID() {
        UUID worklistItemID = UUID.randomUUID();
        List<UUID> worklistItemIDs = Arrays.asList(this.getInternalWorklistItems());
        if (worklistItemIDs.contains(worklistItemID)) {
            String message = String.format("A worklist item with ID '%s' exists already!", worklistItemID);
            this.logger.warning(message);
            throw new RuntimeException(message);
        }
        return worklistItemID;
    }

    protected Set<UUID> getWorklistItemIDsFromDB(ExtendedConnection con) throws DataSourceException {
        HashSet<UUID> worklistItems = new HashSet<UUID>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT idH, idL FROM wl_iwli");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long msb = rs.getLong("idH");
                    long lsb = rs.getLong("idL");
                    UUID worklistItemID = new UUID(msb, lsb);
                    worklistItems.add(worklistItemID);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return worklistItems;
    }

    protected InternalWorklistItem getWorklistItemFromDB(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        InternalWorklistItem worklistItem;
        ResultSet rs;
        PreparedStatement stmt;
        WorklistModelFactory wmf;
        block15: {
            wmf = this.getWorklistModelFactory();
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT WLI.*, A.*, A.serializedUserAttributes AS actserializedUserAttributes FROM wl_iwli WLI LEFT OUTER JOIN wl_act A ON WLI.idH = A.idH AND WLI.idL = A.idL WHERE WLI.idH = ? AND WLI.idL = ?");
            stmt.setLong(1, worklistItemID.getMostSignificantBits());
            stmt.setLong(2, worklistItemID.getLeastSignificantBits());
            rs = stmt.executeQuery();
            if (rs.next()) break block15;
            JDBCTools.closeQuietly((Statement)stmt, rs);
            return null;
        }
        try {
            try {
                String title = rs.getString("title");
                String desc = rs.getString("description");
                if (desc == null) {
                    desc = "";
                }
                long iconIDH = rs.getLong("iconIDH");
                boolean noIcon = rs.wasNull();
                long iconIDL = rs.getLong("iconIDL");
                noIcon |= rs.wasNull();
                String procTemplate = rs.getString("processTemplateName");
                String procInstance = rs.getString("processInstanceName");
                String state = rs.getString("state");
                int priority = rs.getInt("priority");
                long complexity = rs.getLong("complexity");
                long actDate = rs.getLong("activationDate");
                long assignmentDate = rs.getLong("assignmentDate");
                long escalationDate = rs.getLong("escalationDate");
                long dueDate = rs.getLong("dueDate");
                long agentID = rs.getLong("assignedAgentID");
                boolean noAgent = rs.wasNull();
                long orgPosID = rs.getLong("assignedOrgPositionID");
                String agentName = rs.getString("assignedAgentName");
                String orgPosName = rs.getString("assignedOrgPositionName");
                int escLevel = rs.getInt("currentEscalationLevel");
                int delLevel = rs.getInt("currentDelegationLevel");
                InputStream userAttr = rs.getBinaryStream("actserializedUserAttributes");
                Map<String, String> userAttributes = this.xmlImport.getStringMapFromInputStream(userAttr);
                String staffAssignmentRule = rs.getString("staffAssignmentRule");
                String escalationID = rs.getString("escalationHandlingProcedureID");
                String distribID = rs.getString("distribHandlingProcedureID");
                String delegationID = rs.getString("delegationHandlingProcedureID");
                int stateDelegation = rs.getInt("availableStateDelegationIndex");
                ParameterDataContext parameter = this.executionFactory.createParameterDataContext(null, null);
                InputStream supportedPluginBlob = rs.getBinaryStream("supportedPlugins");
                Map<String, Set<String>> supportedPlugins = this.xmlImport.getSupportedPluginsFromStream(supportedPluginBlob);
                InputStream pluginDatasBlob = rs.getBinaryStream("pluginDatas");
                Map<String, PluginData> pluginDatas = this.xmlImport.getPluginDatasFromStream(pluginDatasBlob);
                QualifiedAgent qa = null;
                if (!noAgent) {
                    qa = new QualifiedAgent(agentID, agentName, orgPosID, orgPosName);
                }
                UUID iconID = null;
                if (!noIcon) {
                    iconID = new UUID(iconIDH, iconIDL);
                }
                List<WorklistItem.Delegation> delegationHistory = this.getDelegationHistoryFromDB(worklistItemID, con);
                Pair<List<Enquiry>, Enquiry> enquries = this.getEnquriesFromDB(worklistItemID, con);
                List<Enquiry> enquiryStack = enquries.getFirst();
                Enquiry repliedEnquiry = enquries.getSecond();
                UUID[] stateWorklistIDs = this.getAvailableStateWorklistIDFromDB(worklistItemID, con);
                DefaultUserAttributeContainer activityReference = null;
                String type = rs.getString("activityType");
                if (type != null) {
                    long instanceID_h = rs.getLong("instanceID_h");
                    long instanceID_l = rs.getLong("instanceID_l");
                    long baseTempalateID_h = rs.getLong("baseTemplateID_h");
                    long baseTempalateID_l = rs.getLong("baseTemplateID_l");
                    int nodeID = rs.getInt("nodeID");
                    int iteration = rs.getInt("iteration");
                    InputStream execManURIstream = rs.getBinaryStream("executionManagerURIs");
                    URI[] executionManagerURIs = this.xmlImport.getURIsFromInputStream(execManURIstream);
                    InputStream runtimeManURIstream = rs.getBinaryStream("runtimeManagerURIs");
                    URI[] runtimeManagerURIs = this.xmlImport.getURIsFromInputStream(runtimeManURIstream);
                    boolean isSuspensable = rs.getBoolean("isSuspensable");
                    boolean isResetable = rs.getBoolean("isResetable");
                    boolean isCloseable = rs.getBoolean("isCloseable");
                    InputStream actUserAttr = rs.getBinaryStream("serializedUserAttributes");
                    Map<String, String> actUserAttributes = this.xmlImport.getStringMapFromInputStream(actUserAttr);
                    boolean supportViewOnly = rs.getBoolean("supportsViewOnly");
                    String executableComponentName = rs.getString("executableComponentName");
                    String guiContextID = rs.getString("guiContextID");
                    UUID instanceID = new UUID(instanceID_h, instanceID_l);
                    UUID baseTemplateID = new UUID(baseTempalateID_h, baseTempalateID_l);
                    ExecutionControlProperties execControlProps = new ExecutionControlProperties(isSuspensable, isResetable, isCloseable);
                    if (type.equals("de.aristaflow.ADEPT2ActivityReference")) {
                        if (guiContextID == null) {
                            this.logger.warning("Retrieved an ADEPT2Activity without a valid GUI context ID");
                        }
                        activityReference = new ADEPT2ActivityReference(instanceID, baseTemplateID, nodeID, iteration, executableComponentName, guiContextID, supportViewOnly, executionManagerURIs, runtimeManagerURIs, execControlProps, actUserAttributes);
                    } else if (type.equals("de.aristaflow.LWPActivityReference")) {
                        activityReference = new LWPActivityReference(instanceID, baseTemplateID, nodeID, iteration, executionManagerURIs, runtimeManagerURIs, execControlProps, actUserAttributes);
                    } else if (type.equals("de.aristaflow.TLPInstanceReference")) {
                        activityReference = new TLPInstanceReference(instanceID, executionManagerURIs, baseTemplateID);
                    }
                }
                Pair<Set<IndividualWorklistItemSettings>, UUID[]> itemSettings = this.getIndividualSettingsFromDB(worklistItemID, con);
                UUID[] worklistIDs = itemSettings.getSecond();
                Set<IndividualWorklistItemSettings> individualSettings = itemSettings.getFirst();
                worklistItem = wmf.createInternalWorklistItem(worklistItemID, title, desc, (ActivityReference)((Object)activityReference), iconID, staffAssignmentRule, WorklistConstants.WorklistItemState.valueOf(state), worklistIDs, stateWorklistIDs, stateDelegation, individualSettings, priority, complexity, actDate, assignmentDate, qa, escalationDate, dueDate, escLevel, escalationID, delLevel, delegationID, delegationHistory, repliedEnquiry, enquiryStack, distribID, procTemplate, procInstance, supportedPlugins, pluginDatas, parameter, userAttributes);
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return worklistItem;
    }

    protected Pair<Set<IndividualWorklistItemSettings>, UUID[]> getIndividualSettingsFromDB(UUID id, ExtendedConnection con) throws DataSourceException {
        HashSet<IndividualWorklistItemSettings> settings = new HashSet<IndividualWorklistItemSettings>();
        ArrayList<UUID> worklistIDs = new ArrayList<UUID>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        WorklistModelFactory wmf = this.getWorklistModelFactory();
        try {
            try {
                stmt = con.prepareStatement("SELECT * FROM wl_iwlis WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String title = rs.getString("title");
                    String description = rs.getString("description");
                    if (description == null) {
                        description = "";
                    }
                    int priority = rs.getInt("priority");
                    long dueDate = rs.getLong("dueDate");
                    String dueDateEscalationID = rs.getString("dueDateEscalationID");
                    long resubmissionDate = rs.getLong("resubmissionDate");
                    long escalationDate = rs.getLong("escalationDate");
                    InputStream userAttr = rs.getBinaryStream("serializedUserAttributes");
                    Map<String, String> userAttributes = this.xmlImport.getStringMapFromInputStream(userAttr);
                    long msb = rs.getLong("worklistID_h");
                    long lsb = rs.getLong("worklistID_l");
                    InputStream supportedPluginBlob = rs.getBinaryStream("supportedPlugins");
                    Map<String, Set<String>> supportedPlugins = this.xmlImport.getSupportedPluginsFromStream(supportedPluginBlob);
                    InputStream pluginDatasBlob = rs.getBinaryStream("pluginDatas");
                    Map<String, PluginData> pluginDatas = this.xmlImport.getPluginDatasFromStream(pluginDatasBlob);
                    UUID worklistID = new UUID(msb, lsb);
                    IndividualWorklistItemSettings setting = wmf.createIndividualWorklistItemSettings(worklistID, title, description, escalationDate, dueDate, dueDateEscalationID, priority, resubmissionDate, supportedPlugins, pluginDatas, userAttributes);
                    settings.add(setting);
                    worklistIDs.add(worklistID);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return new Pair<Set<IndividualWorklistItemSettings>, UUID[]>(settings, ArrayTools.toArray(worklistIDs, UUID.class));
    }

    protected List<WorklistItem.Delegation> getDelegationHistoryFromDB(UUID id, ExtendedConnection con) throws DataSourceException {
        ArrayList<WorklistItem.Delegation> history = new ArrayList<WorklistItem.Delegation>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT * FROM wl_del DEL WHERE DEL.itemID_h = ? AND DEL.itemID_l = ? ORDER BY seqNr ASC");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long delAgentID = rs.getLong("delegatorAgentID");
                    long delOrgPosID = rs.getLong("delegatorOrgPositionID");
                    String delAgentName = rs.getString("delegatorAgentName");
                    String delOrgPosName = rs.getString("delegatorOrgPositionName");
                    String delComment = rs.getString("comment_");
                    int seqID = rs.getInt("seqNr");
                    QualifiedAgent delQA = new QualifiedAgent(delAgentID, delAgentName, delOrgPosID, delOrgPosName);
                    HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
                    PreparedStatement stmt2 = con.prepareStatement("SELECT agentID, orgPositionID, agentName, orgPositionName  FROM wl_hasdr WHERE itemID_h = ? AND itemID_l = ? AND seqNr = ?");
                    stmt2.setLong(1, id.getMostSignificantBits());
                    stmt2.setLong(2, id.getLeastSignificantBits());
                    stmt2.setLong(3, seqID);
                    ResultSet rs2 = stmt2.executeQuery();
                    while (rs2.next()) {
                        long recAgentID = rs2.getLong("agentID");
                        long recOrgPosID = rs2.getLong("orgPositionID");
                        String recAgentName = rs2.getString("agentName");
                        String recOrgPosName = rs2.getString("orgPositionName");
                        QualifiedAgent recipient = new QualifiedAgent(recAgentID, recAgentName, recOrgPosID, recOrgPosName);
                        recipients.add(recipient);
                    }
                    JDBCTools.close(rs2);
                    JDBCTools.close(stmt2);
                    DefaultInternalWorklistItem.DefaultDelegation delegation = new DefaultInternalWorklistItem.DefaultDelegation(delQA, recipients, delComment);
                    history.add(delegation);
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return history;
    }

    protected Pair<List<Enquiry>, Enquiry> getEnquriesFromDB(UUID id, ExtendedConnection con) throws DataSourceException {
        ArrayList<Enquiry> enquiries = new ArrayList<Enquiry>();
        Enquiry repliedEnquiry = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT ENQ.*, agentID, orgPositionID, agentName, orgPositionName FROM wl_enq ENQ JOIN wl_haser REC ON ENQ.itemID_h = REC.itemID_h AND ENQ.itemID_l = REC.itemID_l AND ENQ.seqNr = REC.seqNr WHERE ENQ.itemID_h = ? AND ENQ.itemID_l = ? ORDER BY ENQ.seqNr ASC");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                rs = stmt.executeQuery();
                boolean more = rs.next();
                while (more) {
                    long originatorAgentID = rs.getLong("originatorAgentID");
                    long originatorOrgPosID = rs.getLong("originatorOrgPositionID");
                    String originatorAgentName = rs.getString("originatorAgentName");
                    String originatorOrgPosName = rs.getString("originatorOrgPositionName");
                    String question = rs.getString("question");
                    int seqNr = rs.getInt("seqNr");
                    QualifiedAgent originator = new QualifiedAgent(originatorAgentID, originatorAgentName, originatorOrgPosID, originatorOrgPosName);
                    boolean hasReply = rs.getBoolean("hasReply");
                    String reply = null;
                    QualifiedAgent replier = null;
                    if (hasReply) {
                        reply = rs.getString("reply");
                        if (reply == null) {
                            reply = "";
                        }
                        long replierAgentID = rs.getLong("replierAgentID");
                        long replierOrgPosID = rs.getLong("replierOrgPositionID");
                        String replierAgentName = rs.getString("replierAgentName");
                        String replierOrgPosName = rs.getString("replierOrgPositionName");
                        replier = new QualifiedAgent(replierAgentID, replierAgentName, replierOrgPosID, replierOrgPosName);
                    }
                    HashSet<QualifiedAgent> recipients = new HashSet<QualifiedAgent>();
                    int newSeqNr = seqNr;
                    do {
                        long agentID = rs.getLong("agentID");
                        long orgPosID = rs.getLong("orgPositionID");
                        String agentName = rs.getString("agentName");
                        String orgPosName = rs.getString("orgPositionName");
                        QualifiedAgent qa = new QualifiedAgent(agentID, agentName, orgPosID, orgPosName);
                        recipients.add(qa);
                        more = rs.next();
                        if (!more) continue;
                        newSeqNr = rs.getInt("seqNr");
                    } while (more && newSeqNr == seqNr);
                    if (hasReply) {
                        repliedEnquiry = this.executionFactory.createEnquiry(originator, recipients, question, reply, replier);
                        continue;
                    }
                    enquiries.add(this.executionFactory.createEnquiry(originator, recipients, question));
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return new Pair(enquiries, repliedEnquiry);
    }

    protected UUID[] getAvailableStateWorklistIDFromDB(UUID id, ExtendedConnection con) throws DataSourceException {
        UUID[] availabeStateWorklistIDs;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT idH, idL FROM wl_asw ASW WHERE ASW.itemID_h = ? AND ASW.itemID_l = ?");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                rs = stmt.executeQuery();
                ArrayList<UUID> worklistIDs = new ArrayList<UUID>();
                while (rs.next()) {
                    long idH = rs.getLong("idH");
                    long idL = rs.getLong("idL");
                    UUID uuid = new UUID(idH, idL);
                    worklistIDs.add(uuid);
                }
                availabeStateWorklistIDs = new UUID[worklistIDs.size()];
                int i = 0;
                while (i < worklistIDs.size()) {
                    availabeStateWorklistIDs[i] = (UUID)worklistIDs.get(i);
                    ++i;
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        if (availabeStateWorklistIDs.length == 0) {
            return null;
        }
        return availabeStateWorklistIDs;
    }

    protected ActivityReference getActivityReferenceFromDB(UUID id, ExtendedConnection con) throws DataSourceException {
        DefaultUserAttributeContainer activityReference = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT wi.activityType, a.* FROM wl_iwli wi JOIN wl_act a ON wi.idH = a.idH AND wi.idL = a.idL WHERE wi.idH = ? AND wi.idL = ?");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    String type = rs.getString("activityType");
                    long instanceID_h = rs.getLong("instanceID_h");
                    long instanceID_l = rs.getLong("instanceID_l");
                    long baseTempalateID_h = rs.getLong("baseTemplateID_h");
                    long baseTempalateID_l = rs.getLong("baseTemplateID_l");
                    int nodeID = rs.getInt("nodeID");
                    int iteration = rs.getInt("iteration");
                    InputStream execManURIstream = rs.getBinaryStream("executionManagerURIs");
                    URI[] executionManagerURIs = this.xmlImport.getURIsFromInputStream(execManURIstream);
                    InputStream runtimeManURIstream = rs.getBinaryStream("runtimeManagerURIs");
                    URI[] runtimeManagerURIs = this.xmlImport.getURIsFromInputStream(runtimeManURIstream);
                    boolean isSuspensable = rs.getBoolean("isSuspensable");
                    boolean isResetable = rs.getBoolean("isResetable");
                    boolean isCloseable = rs.getBoolean("isCloseable");
                    InputStream userAttr = rs.getBinaryStream("serializedUserAttributes");
                    Map<String, String> userAttributes = this.xmlImport.getStringMapFromInputStream(userAttr);
                    boolean supportViewOnly = rs.getBoolean("supportsViewOnly");
                    String executableComponentName = rs.getString("executableComponentName");
                    String guiContextID = rs.getString("guiContextID");
                    UUID instanceID = new UUID(instanceID_h, instanceID_l);
                    UUID baseTemplateID = new UUID(baseTempalateID_h, baseTempalateID_l);
                    ExecutionControlProperties execControlProps = new ExecutionControlProperties(isSuspensable, isResetable, isCloseable);
                    if (type.equals("de.aristaflow.ADEPT2ActivityReference")) {
                        if (guiContextID == null) {
                            this.logger.warning("Retrieved an ADEPT2Activity without a valid GUI context ID");
                        }
                        activityReference = new ADEPT2ActivityReference(instanceID, baseTemplateID, nodeID, iteration, executableComponentName, guiContextID, supportViewOnly, executionManagerURIs, runtimeManagerURIs, execControlProps, userAttributes);
                    } else if (type.equals("de.aristaflow.LWPActivityReference")) {
                        activityReference = new LWPActivityReference(instanceID, baseTemplateID, nodeID, iteration, executionManagerURIs, runtimeManagerURIs, execControlProps, userAttributes);
                    } else if (type.equals("de.aristaflow.TLPInstanceReference")) {
                        activityReference = new TLPInstanceReference(instanceID, executionManagerURIs, baseTemplateID);
                    }
                }
                rs = JDBCTools.close(rs);
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        if (activityReference == null) {
            this.logger.severe("The database has stored a worklistitem without an valid activity.");
        }
        return activityReference;
    }

    protected UUID getUUIDByEBPFromDB(EBPInstanceReference ebp, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        UUID uuid = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT idH, idL FROM wl_act WHERE instanceID_h = ? AND instanceID_l = ? AND nodeID = ? AND iteration = ?");
                stmt.setLong(1, ebp.getInstanceID().getMostSignificantBits());
                stmt.setLong(2, ebp.getInstanceID().getLeastSignificantBits());
                stmt.setInt(3, ebp.getNodeID());
                stmt.setInt(4, ebp.getNodeIteration());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    long msb = rs.getLong("idH");
                    long lsb = rs.getLong("idL");
                    uuid = new UUID(msb, lsb);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return uuid;
    }

    protected void createDBEntryForWorklistItem(InternalWorklistItem worklistItem, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                Map<String, String> attributes = worklistItem.getUserAttributes();
                Document userAttributes = null;
                if (attributes.size() > 0) {
                    userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                }
                Map<String, Set<String>> plugins = worklistItem.getSupportedPlugins();
                Document supportedPlugins = null;
                if (plugins.size() > 0) {
                    supportedPlugins = this.xmlExport.getDocumentForSupportedPlugins(plugins);
                }
                Map<String, PluginData> pluginDatas = worklistItem.getPluginDatas();
                Document pluginData = null;
                if (pluginDatas.size() > 0) {
                    pluginData = this.xmlExport.getDocumentForPluginDatas(pluginDatas);
                }
                long assignedAgentID = 0L;
                long assignedOrgPosID = 0L;
                String assignedAgentName = null;
                String assignedOrgPosName = null;
                QualifiedAgent assignedAgent = worklistItem.getAssignedAgent();
                if (assignedAgent != null) {
                    assignedAgentID = assignedAgent.getAgentID();
                    assignedOrgPosID = assignedAgent.getOrgPositionID();
                    assignedAgentName = assignedAgent.getAgentUserName();
                    assignedOrgPosName = assignedAgent.getOrgPositionName();
                }
                stmt = con.prepareStatement("INSERT INTO wl_iwli (idH, idL, title, description, iconIDH, iconIDL, processTemplateName, processInstanceName, state, priority, complexity, activationDate, assignmentDate, escalationDate, dueDate, assignedAgentID, assignedOrgPositionID, assignedAgentName, assignedOrgPositionName, currentEscalationLevel, currentDelegationLevel, serializedUserAttributes, staffAssignmentRule, escalationHandlingProcedureID, distribHandlingProcedureID, delegationHandlingProcedureID, availableStateDelegationIndex, parameterDataContext, activityType, supportedPlugins, pluginDatas, itemStored) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                stmt.setLong(1, worklistItem.getID().getMostSignificantBits());
                stmt.setLong(2, worklistItem.getID().getLeastSignificantBits());
                stmt.setString(3, worklistItem.getTitle());
                stmt.setString(4, worklistItem.getDescription());
                if (worklistItem.getIconID() != null) {
                    stmt.setLong(5, worklistItem.getIconID().getMostSignificantBits());
                    stmt.setLong(6, worklistItem.getIconID().getLeastSignificantBits());
                } else {
                    stmt.setNull(5, -5);
                    stmt.setNull(6, -5);
                }
                stmt.setString(7, worklistItem.getProcessTemplateName());
                stmt.setString(8, worklistItem.getProcessInstanceName());
                stmt.setString(9, worklistItem.getState().toString());
                stmt.setInt(10, worklistItem.getPriority());
                stmt.setLong(11, worklistItem.getComplexity());
                stmt.setLong(12, worklistItem.getActivationDate());
                stmt.setLong(13, worklistItem.getAssignmentDate());
                stmt.setLong(14, worklistItem.getEscalationDate());
                stmt.setLong(15, worklistItem.getDueDate());
                if (assignedAgent == null) {
                    stmt.setNull(16, -5);
                    stmt.setNull(17, -5);
                } else {
                    stmt.setLong(16, assignedAgentID);
                    stmt.setLong(17, assignedOrgPosID);
                }
                stmt.setString(18, assignedAgentName);
                stmt.setString(19, assignedOrgPosName);
                stmt.setInt(20, worklistItem.getCurrentEscalationLevel());
                stmt.setInt(21, worklistItem.getCurrentDelegationLevel());
                DBStorageTools.setStatementBlobParameter(stmt, 22, userAttributes);
                stmt.setString(23, worklistItem.getStaffAssignmentRule());
                if (worklistItem.getEscalationHandlingProcedureID() != null) {
                    stmt.setString(24, worklistItem.getEscalationHandlingProcedureID());
                } else {
                    stmt.setNull(24, -1);
                }
                if (worklistItem.getDistributionHandlingProcedureID() != null) {
                    stmt.setString(25, worklistItem.getDistributionHandlingProcedureID());
                } else {
                    stmt.setNull(25, -1);
                }
                if (worklistItem.getDelegationHandlingProcedureID() != null) {
                    stmt.setString(26, worklistItem.getDelegationHandlingProcedureID());
                } else {
                    stmt.setNull(26, -1);
                }
                stmt.setInt(27, worklistItem.getAvailableStateDelegationIndex());
                DBStorageTools.setStatementBlobParameter(stmt, 28, null);
                stmt.setString(29, worklistItem.getActivityReference().getActivityReferenceType());
                DBStorageTools.setStatementBlobParameter(stmt, 30, supportedPlugins);
                DBStorageTools.setStatementBlobParameter(stmt, 31, pluginData);
                stmt.setBoolean(32, worklistItem.getAvailableStateWorklistIDs() != null);
                stmt.execute();
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void createDBEntryForEnquiryStack(InternalWorklistItem item, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        int seqNr = 0;
        try {
            try {
                for (Enquiry enquiry : item.getEnquiryStack()) {
                    stmt = con.prepareStatement("INSERT INTO wl_enq( originatorAgentID, originatorOrgPositionID, originatorAgentName, originatorOrgPositionName, question, reply, hasReply, replierAgentID, replierOrgPositionID, replierAgentName, replierOrgPositionName, seqNr, itemID_h, itemID_l) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    stmt.setLong(1, enquiry.getOriginator().getAgentID());
                    stmt.setLong(2, enquiry.getOriginator().getOrgPositionID());
                    stmt.setString(3, enquiry.getOriginator().getAgentUserName());
                    stmt.setString(4, enquiry.getOriginator().getOrgPositionName());
                    stmt.setString(5, enquiry.getQuestion());
                    if (enquiry.getReply() != null) {
                        stmt.setString(6, enquiry.getReply());
                        stmt.setBoolean(7, true);
                        stmt.setLong(8, enquiry.getReplier().getAgentID());
                        stmt.setLong(9, enquiry.getReplier().getOrgPositionID());
                        stmt.setString(10, enquiry.getReplier().getAgentUserName());
                        stmt.setString(11, enquiry.getReplier().getOrgPositionName());
                    } else {
                        stmt.setString(6, null);
                        stmt.setBoolean(7, false);
                        stmt.setLong(8, 0L);
                        stmt.setLong(9, 0L);
                        stmt.setString(10, null);
                        stmt.setString(11, null);
                    }
                    stmt.setLong(12, seqNr);
                    stmt.setLong(13, item.getID().getMostSignificantBits());
                    stmt.setLong(14, item.getID().getLeastSignificantBits());
                    stmt.execute();
                    this.createDBEntryForEnquiryRecipient(enquiry, seqNr++, item.getID(), con);
                    stmt = JDBCTools.close(stmt);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void createDBEntryForEnquiryRecipient(Enquiry enquiry, int seqNr, UUID itemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                for (QualifiedAgent recipient : enquiry.getRecipients()) {
                    stmt = con.prepareStatement("INSERT INTO wl_haser (itemID_h, itemID_l, seqNr, agentID, orgPositionID, agentName, orgPositionName) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    stmt.setLong(1, itemID.getMostSignificantBits());
                    stmt.setLong(2, itemID.getLeastSignificantBits());
                    stmt.setInt(3, seqNr);
                    stmt.setLong(4, recipient.getAgentID());
                    stmt.setLong(5, recipient.getOrgPositionID());
                    stmt.setString(6, recipient.getAgentUserName());
                    stmt.setString(7, recipient.getOrgPositionName());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void createDbEntryForDelegationHistroy(InternalWorklistItem item, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        int seqNr = 0;
        try {
            try {
                for (WorklistItem.Delegation delegation : item.getDelegationHistory()) {
                    stmt = con.prepareStatement("INSERT INTO wl_del (delegatorAgentID, delegatorOrgPositionID, delegatorAgentName, delegatorOrgPositionName, comment_, seqNr, itemID_h, itemID_l) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                    stmt.setLong(1, delegation.getDelegator().getAgentID());
                    stmt.setLong(2, delegation.getDelegator().getOrgPositionID());
                    stmt.setString(3, delegation.getDelegator().getAgentUserName());
                    stmt.setString(4, delegation.getDelegator().getOrgPositionName());
                    stmt.setString(5, delegation.getComment().length() == 0 ? " " : delegation.getComment());
                    stmt.setInt(6, seqNr);
                    stmt.setLong(7, item.getID().getMostSignificantBits());
                    stmt.setLong(8, item.getID().getLeastSignificantBits());
                    stmt.execute();
                    this.createDBEntryForDelegationRecipient(delegation, seqNr++, item.getID(), con);
                    stmt = JDBCTools.close(stmt);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void createDBEntryForDelegationRecipient(WorklistItem.Delegation delegation, int seqNr, UUID itemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                for (QualifiedAgent recipient : delegation.getRecipients()) {
                    stmt = con.prepareStatement("INSERT INTO wl_hasdr (itemID_h, itemID_l, seqNr, agentID, orgPositionID, agentName, orgPositionName) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    stmt.setLong(1, itemID.getMostSignificantBits());
                    stmt.setLong(2, itemID.getLeastSignificantBits());
                    stmt.setInt(3, seqNr);
                    stmt.setLong(4, recipient.getAgentID());
                    stmt.setLong(5, recipient.getOrgPositionID());
                    stmt.setString(6, recipient.getAgentUserName());
                    stmt.setString(7, recipient.getOrgPositionName());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void createDBEntryForStateWorklistIDs(InternalWorklistItem item, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        if (item.getAvailableStateWorklistIDs() == null) {
            return;
        }
        try {
            try {
                UUID[] uUIDArray = item.getAvailableStateWorklistIDs();
                int n = uUIDArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UUID worklistID = uUIDArray[n2];
                    stmt = con.prepareStatement("INSERT INTO wl_asw (idH, idL, itemID_h, itemID_l) VALUES (?, ?, ?, ?)");
                    stmt.setLong(1, worklistID.getMostSignificantBits());
                    stmt.setLong(2, worklistID.getLeastSignificantBits());
                    stmt.setLong(3, item.getID().getMostSignificantBits());
                    stmt.setLong(4, item.getID().getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    ++n2;
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void createDBEntryForActivity(InternalWorklistItem item, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                String activityReferenceType;
                stmt = con.prepareStatement("INSERT INTO wl_act (instanceID_h ,instanceID_l ,baseTemplateID_h ,baseTemplateID_l ,nodeID ,iteration ,executionManagerURIs ,runtimeManagerURIs ,isSuspensable ,isResetable ,isCloseable ,serializedUserAttributes ,supportsViewOnly ,executableComponentName ,idH ,idL, guiContextID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                Map<String, String> attributes = item.getActivityReference().getUserAttributes();
                Document userAttributes = null;
                if (attributes.size() > 0) {
                    userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                }
                if ((activityReferenceType = item.getActivityReference().getActivityReferenceType()).equals("de.aristaflow.ADEPT2ActivityReference") || activityReferenceType.equals("de.aristaflow.LWPActivityReference")) {
                    ADEPT2EBPReference reference = (ADEPT2EBPReference)item.getActivityReference();
                    URI[] emURIs = reference.getExecutionManagerURIs();
                    Document executionManagerURIs = null;
                    if (emURIs != null && emURIs.length > 0) {
                        executionManagerURIs = this.xmlExport.getDocumentForExecutionMangerURIs(emURIs);
                    }
                    URI[] rmURIs = reference.getRuntimeManagerURIs();
                    Document runtimeManagerURIs = null;
                    if (rmURIs != null && rmURIs.length > 0) {
                        runtimeManagerURIs = this.xmlExport.getDocumentForRuntimeMangerURIs(rmURIs);
                    }
                    boolean viewOnlySupport = false;
                    if (reference instanceof ADEPT2ActivityReference) {
                        viewOnlySupport = ((ADEPT2ActivityReference)reference).supportsViewOnly();
                    }
                    stmt.setLong(1, reference.getInstanceID().getMostSignificantBits());
                    stmt.setLong(2, reference.getInstanceID().getLeastSignificantBits());
                    stmt.setLong(3, reference.getBaseTemplateID().getMostSignificantBits());
                    stmt.setLong(4, reference.getBaseTemplateID().getLeastSignificantBits());
                    stmt.setInt(5, reference.getNodeID());
                    stmt.setInt(6, reference.getNodeIteration());
                    DBStorageTools.setStatementBlobParameter(stmt, 7, executionManagerURIs);
                    DBStorageTools.setStatementBlobParameter(stmt, 8, runtimeManagerURIs);
                    stmt.setBoolean(9, reference.getExecutionControlProperties().isSuspensible());
                    stmt.setBoolean(10, reference.getExecutionControlProperties().isResettable());
                    stmt.setBoolean(11, reference.getExecutionControlProperties().isClosable());
                    DBStorageTools.setStatementBlobParameter(stmt, 12, userAttributes);
                    stmt.setBoolean(13, viewOnlySupport);
                    if (reference.getExecutableComponentName() != null) {
                        stmt.setString(14, reference.getExecutableComponentName());
                    } else {
                        stmt.setNull(14, 12);
                    }
                    stmt.setLong(15, item.getID().getMostSignificantBits());
                    stmt.setLong(16, item.getID().getLeastSignificantBits());
                    stmt.setString(17, reference.getGUIContextID());
                } else if (activityReferenceType.equals("de.aristaflow.TLPInstanceReference")) {
                    TLPInstanceReference reference = (TLPInstanceReference)item.getActivityReference();
                    URI[] emURIs = reference.getExecutionManagerURIs();
                    Document executionManagerURIs = null;
                    if (emURIs != null && emURIs.length > 0) {
                        executionManagerURIs = this.xmlExport.getDocumentForExecutionMangerURIs(emURIs);
                    }
                    stmt.setLong(1, reference.getInstanceID().getMostSignificantBits());
                    stmt.setLong(2, reference.getInstanceID().getLeastSignificantBits());
                    stmt.setLong(3, reference.getBaseTemplateID().getMostSignificantBits());
                    stmt.setLong(4, reference.getBaseTemplateID().getLeastSignificantBits());
                    stmt.setInt(5, Integer.MIN_VALUE);
                    stmt.setInt(6, Integer.MIN_VALUE);
                    DBStorageTools.setStatementBlobParameter(stmt, 7, executionManagerURIs);
                    DBStorageTools.setStatementBlobParameter(stmt, 8, null);
                    stmt.setBoolean(9, false);
                    stmt.setBoolean(10, false);
                    stmt.setBoolean(11, false);
                    DBStorageTools.setStatementBlobParameter(stmt, 12, userAttributes);
                    stmt.setBoolean(13, false);
                    stmt.setString(14, "TLPI");
                    stmt.setLong(15, item.getID().getMostSignificantBits());
                    stmt.setLong(16, item.getID().getLeastSignificantBits());
                    stmt.setNull(17, 12);
                } else {
                    throw new DataSourceException("Invalid data for the database. The storage implementation is not able to store the instance of the ActivityReference of a internal worklist item (ID:" + item.getID().toString() + ").");
                }
                stmt.execute();
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void createDBEntryForIndividualSettings(InternalWorklistItem item, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                UUID[] uUIDArray = item.getWorklistIDs();
                int n = uUIDArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UUID worklistID = uUIDArray[n2];
                    IndividualWorklistItemSettings setting = item.getIndividualWorklistItemSettings(worklistID);
                    Map<String, String> attributes = setting.getUserAttributes();
                    Document userAttributes = null;
                    if (attributes.size() > 0) {
                        userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                    }
                    Map<String, Set<String>> plugins = setting.getSupportedPlugins();
                    Document supportedPlugins = null;
                    if (plugins.size() > 0) {
                        supportedPlugins = this.xmlExport.getDocumentForSupportedPlugins(plugins);
                    }
                    Map<String, PluginData> pluginDatas = setting.getPluginDatas();
                    Document pluginData = null;
                    if (pluginDatas.size() > 0) {
                        pluginData = this.xmlExport.getDocumentForPluginDatas(pluginDatas);
                    }
                    stmt = con.prepareStatement("INSERT INTO wl_iwlis (title, description, priority, dueDate, dueDateEscalationID, resubmissionDate, escalationDate, serializedUserAttributes, supportedPlugins, pluginDatas, worklistID_h, worklistID_l, itemID_h, itemID_l) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    stmt.setString(1, setting.getIndividualTitle());
                    stmt.setString(2, setting.getDescription());
                    stmt.setInt(3, setting.getIndividualPriority());
                    stmt.setLong(4, setting.getIndividualDueDate());
                    if (setting.getIndividualEscalationHandlingProcedureID() != null) {
                        stmt.setString(5, setting.getIndividualEscalationHandlingProcedureID());
                    } else {
                        stmt.setNull(5, -1);
                    }
                    stmt.setLong(6, setting.getResubmissionDate());
                    stmt.setLong(7, setting.getIndividualEscalationDate());
                    DBStorageTools.setStatementBlobParameter(stmt, 8, userAttributes);
                    DBStorageTools.setStatementBlobParameter(stmt, 9, supportedPlugins);
                    DBStorageTools.setStatementBlobParameter(stmt, 10, pluginData);
                    stmt.setLong(11, worklistID.getMostSignificantBits());
                    stmt.setLong(12, worklistID.getLeastSignificantBits());
                    stmt.setLong(13, item.getID().getMostSignificantBits());
                    stmt.setLong(14, item.getID().getLeastSignificantBits());
                    stmt.execute();
                    stmt = JDBCTools.close(stmt);
                    ++n2;
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected void removeDBEntryForWorklistItem(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_iwli WHERE idH = ? AND idL = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForActivity(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_act WHERE idH = ? AND idL = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForAvailableStateIDs(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_asw WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForIndividualSettings(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_iwlis WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForDelegationHistory(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_hasdr WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement("DELETE FROM wl_del WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForEnquiryStack(UUID worklistItemID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_haser WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement("DELETE FROM wl_enq WHERE itemID_h = ? AND itemID_l = ?");
                stmt.setLong(1, worklistItemID.getMostSignificantBits());
                stmt.setLong(2, worklistItemID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void updateDBEntryForWorklistItem(InternalWorklistItem worklistItem, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                Map<String, String> attributes = worklistItem.getUserAttributes();
                Document userAttributes = null;
                if (attributes.size() > 0) {
                    userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                }
                Map<String, Set<String>> plugins = worklistItem.getSupportedPlugins();
                Document supportedPlugins = null;
                if (plugins.size() > 0) {
                    supportedPlugins = this.xmlExport.getDocumentForSupportedPlugins(plugins);
                }
                Map<String, PluginData> pluginDatas = worklistItem.getPluginDatas();
                Document pluginData = null;
                if (pluginDatas.size() > 0) {
                    pluginData = this.xmlExport.getDocumentForPluginDatas(pluginDatas);
                }
                long assignedAgentID = 0L;
                long assignedOrgPosID = 0L;
                String assignedAgentName = null;
                String assignedOrgPosName = null;
                QualifiedAgent assignedAgent = worklistItem.getAssignedAgent();
                if (assignedAgent != null) {
                    assignedAgentID = assignedAgent.getAgentID();
                    assignedOrgPosID = assignedAgent.getOrgPositionID();
                    assignedAgentName = assignedAgent.getAgentUserName();
                    assignedOrgPosName = assignedAgent.getOrgPositionName();
                }
                stmt = con.prepareStatement("UPDATE wl_iwli SET title = ?, description = ?, iconIDH = ?, iconIDL = ?, processTemplateName = ?, processInstanceName = ?, state = ?, priority = ?, complexity = ?, activationDate = ?, assignmentDate = ?, escalationDate = ?, dueDate = ?, assignedAgentID = ?, assignedOrgPositionID = ?, assignedAgentName = ?, assignedOrgPositionName = ?, currentEscalationLevel = ?, currentDelegationLevel = ?, serializedUserAttributes = ?, staffAssignmentRule = ?, escalationHandlingProcedureID = ?, distribHandlingProcedureID = ?, delegationHandlingProcedureID = ?, availableStateDelegationIndex = ?, parameterDataContext = ?, activityType = ?, supportedPlugins = ?, pluginDatas = ?, itemStored = ? WHERE idH = ? AND idL = ?");
                stmt.setString(1, worklistItem.getTitle());
                stmt.setString(2, worklistItem.getDescription());
                if (worklistItem.getIconID() != null) {
                    stmt.setLong(3, worklistItem.getIconID().getMostSignificantBits());
                    stmt.setLong(4, worklistItem.getIconID().getLeastSignificantBits());
                } else {
                    stmt.setNull(3, -5);
                    stmt.setNull(4, -5);
                }
                stmt.setString(5, worklistItem.getProcessTemplateName());
                stmt.setString(6, worklistItem.getProcessInstanceName());
                stmt.setString(7, worklistItem.getState().toString());
                stmt.setInt(8, worklistItem.getPriority());
                stmt.setLong(9, worklistItem.getComplexity());
                stmt.setLong(10, worklistItem.getActivationDate());
                stmt.setLong(11, worklistItem.getAssignmentDate());
                stmt.setLong(12, worklistItem.getEscalationDate());
                stmt.setLong(13, worklistItem.getDueDate());
                if (assignedAgent == null) {
                    stmt.setNull(14, -5);
                    stmt.setNull(15, -5);
                } else {
                    stmt.setLong(14, assignedAgentID);
                    stmt.setLong(15, assignedOrgPosID);
                }
                stmt.setString(16, assignedAgentName);
                stmt.setString(17, assignedOrgPosName);
                stmt.setInt(18, worklistItem.getCurrentEscalationLevel());
                stmt.setInt(19, worklistItem.getCurrentDelegationLevel());
                DBStorageTools.setStatementBlobParameter(stmt, 20, userAttributes);
                stmt.setString(21, worklistItem.getStaffAssignmentRule());
                if (worklistItem.getEscalationHandlingProcedureID() != null) {
                    stmt.setString(22, worklistItem.getEscalationHandlingProcedureID());
                } else {
                    stmt.setNull(22, -1);
                }
                if (worklistItem.getDistributionHandlingProcedureID() != null) {
                    stmt.setString(23, worklistItem.getDistributionHandlingProcedureID());
                } else {
                    stmt.setNull(23, -1);
                }
                if (worklistItem.getDelegationHandlingProcedureID() != null) {
                    stmt.setString(24, worklistItem.getDelegationHandlingProcedureID());
                } else {
                    stmt.setNull(24, -1);
                }
                stmt.setInt(25, worklistItem.getAvailableStateDelegationIndex());
                DBStorageTools.setStatementBlobParameter(stmt, 26, null);
                stmt.setString(27, worklistItem.getActivityReference().getActivityReferenceType());
                DBStorageTools.setStatementBlobParameter(stmt, 28, supportedPlugins);
                DBStorageTools.setStatementBlobParameter(stmt, 29, pluginData);
                stmt.setBoolean(30, worklistItem.getAvailableStateWorklistIDs() != null);
                stmt.setLong(31, worklistItem.getID().getMostSignificantBits());
                stmt.setLong(32, worklistItem.getID().getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void updateDBEntryForActivity(InternalWorklistItem item, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                String activityReferenceType;
                stmt = con.prepareStatement("UPDATE wl_act SET instanceID_h = ? ,instanceID_l = ? ,baseTemplateID_h = ? ,baseTemplateID_l = ? ,nodeID = ? ,iteration = ? ,executionManagerURIs = ? ,runtimeManagerURIs = ? ,isSuspensable = ? ,isResetable = ? ,isCloseable = ? ,serializedUserAttributes = ? ,supportsViewOnly = ? ,executableComponentName = ?, guiContextID = ? WHERE idH = ? AND idL = ?");
                Map<String, String> attributes = item.getActivityReference().getUserAttributes();
                Document userAttributes = null;
                if (attributes.size() > 0) {
                    userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                }
                if ((activityReferenceType = item.getActivityReference().getActivityReferenceType()).equals("de.aristaflow.ADEPT2ActivityReference") || activityReferenceType.equals("de.aristaflow.LWPActivityReference")) {
                    ADEPT2EBPReference reference = (ADEPT2EBPReference)item.getActivityReference();
                    boolean viewSupportOnly = false;
                    if (reference instanceof ADEPT2ActivityReference) {
                        viewSupportOnly = ((ADEPT2ActivityReference)reference).supportsViewOnly();
                    }
                    URI[] emURIs = reference.getExecutionManagerURIs();
                    Document executionManagerURIs = null;
                    if (emURIs != null && emURIs.length > 0) {
                        executionManagerURIs = this.xmlExport.getDocumentForExecutionMangerURIs(emURIs);
                    }
                    URI[] rmURIs = reference.getRuntimeManagerURIs();
                    Document runtimeManagerURIs = null;
                    if (rmURIs != null && rmURIs.length > 0) {
                        runtimeManagerURIs = this.xmlExport.getDocumentForRuntimeMangerURIs(rmURIs);
                    }
                    stmt.setLong(1, reference.getInstanceID().getMostSignificantBits());
                    stmt.setLong(2, reference.getInstanceID().getLeastSignificantBits());
                    stmt.setLong(3, reference.getBaseTemplateID().getMostSignificantBits());
                    stmt.setLong(4, reference.getBaseTemplateID().getLeastSignificantBits());
                    stmt.setInt(5, reference.getNodeID());
                    stmt.setInt(6, reference.getNodeIteration());
                    DBStorageTools.setStatementBlobParameter(stmt, 7, executionManagerURIs);
                    DBStorageTools.setStatementBlobParameter(stmt, 8, runtimeManagerURIs);
                    stmt.setBoolean(9, reference.getExecutionControlProperties().isSuspensible());
                    stmt.setBoolean(10, reference.getExecutionControlProperties().isResettable());
                    stmt.setBoolean(11, reference.getExecutionControlProperties().isClosable());
                    DBStorageTools.setStatementBlobParameter(stmt, 12, userAttributes);
                    stmt.setBoolean(13, viewSupportOnly);
                    if (reference.getExecutableComponentName() != null) {
                        stmt.setString(14, reference.getExecutableComponentName());
                    } else {
                        stmt.setNull(14, 12);
                    }
                    stmt.setString(15, reference.getGUIContextID());
                    stmt.setLong(16, item.getID().getMostSignificantBits());
                    stmt.setLong(17, item.getID().getLeastSignificantBits());
                } else if (activityReferenceType.equals("de.aristaflow.TLPInstanceReference")) {
                    TLPInstanceReference reference = (TLPInstanceReference)item.getActivityReference();
                    URI[] emURIs = reference.getExecutionManagerURIs();
                    Document executionManagerURIs = null;
                    if (emURIs != null && emURIs.length > 0) {
                        executionManagerURIs = this.xmlExport.getDocumentForExecutionMangerURIs(emURIs);
                    }
                    stmt.setLong(1, reference.getInstanceID().getMostSignificantBits());
                    stmt.setLong(2, reference.getInstanceID().getLeastSignificantBits());
                    stmt.setLong(3, reference.getBaseTemplateID().getMostSignificantBits());
                    stmt.setLong(4, reference.getBaseTemplateID().getLeastSignificantBits());
                    stmt.setInt(5, Integer.MIN_VALUE);
                    stmt.setInt(6, Integer.MIN_VALUE);
                    DBStorageTools.setStatementBlobParameter(stmt, 7, executionManagerURIs);
                    DBStorageTools.setStatementBlobParameter(stmt, 8, null);
                    stmt.setBoolean(9, false);
                    stmt.setBoolean(10, false);
                    stmt.setBoolean(11, false);
                    DBStorageTools.setStatementBlobParameter(stmt, 12, userAttributes);
                    stmt.setBoolean(13, false);
                    stmt.setString(14, "TLPI");
                    stmt.setNull(15, 12);
                    stmt.setLong(16, item.getID().getMostSignificantBits());
                    stmt.setLong(17, item.getID().getLeastSignificantBits());
                } else {
                    throw new DataSourceException("Invalid data for the database. The storage implementation is not able to update the instance of the Activityreference of a internal worklist item (ID:" + item.getID().toString() + ").");
                }
                stmt.execute();
                stmt = JDBCTools.close(stmt);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }
}

