/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.dbstorage;

import de.aristaflow.adept2.base.dbaccess.DBSpecificTools;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.internal.DbUpdateManager;
import de.aristaflow.adept2.core.internal.UpdateException;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.storage.ClientStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistManagerStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBClientStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBWorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBWorklistStorage;
import de.aristaflow.adept2.model.execution.ExecutionFactory;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class DBWorklistManagerStorage
implements WorklistManagerStorage {
    private final AbstractWorklistManager worklistManager;
    private final WorklistModelFactory worklistModelFactory;
    private final FilterFactory filterFactory;
    private final ExecutionFactory executionFactory;
    private final DBClientStorage clientStorage;
    private final DBWorklistItemStorage worklistItemStorage;
    private final DBWorklistStorage worklistStorage;
    private final JDBCDataSource dataSource;
    protected static final long LOCK_TIMEOUT = 60000L;
    private int readConnectionCounter;
    private ExtendedConnection readConnection;
    private Set<ExtendedConnection> writeConnections;
    private static final String CREATE_STATEMENTS = "sqlscripts/wm-create.sql";

    public DBWorklistManagerStorage(SessionToken session, Registry registry, AbstractWorklistManager worklistManager) throws ServiceNotKnownException {
        this.worklistManager = worklistManager;
        this.writeConnections = new HashSet<ExtendedConnection>();
        this.readConnection = null;
        this.readConnectionCounter = 0;
        this.dataSource = registry.getServiceOfType(session, "JDBCDataSource", JDBCDataSource.class);
        this.worklistModelFactory = registry.getModelFactory("WorklistModelFactory", WorklistModelFactory.class);
        this.filterFactory = registry.getModelFactory("FilterFactory", FilterFactory.class);
        this.executionFactory = registry.getModelFactory("ExecutionFactory", ExecutionFactory.class);
        DbUpdateManager um = new DbUpdateManager(WorklistManager.class, LoggerTools.getLogger(this));
        ExtendedConnection con = null;
        try {
            try {
                con = this.requestConnection(true);
                um.registerUpdate(new DbUpdateManager.Update(0, 1){

                    @Override
                    public void performUpdate(ExtendedConnection con) throws SQLException {
                        Statement stmt = null;
                        try {
                            stmt = con.createStatement();
                            stmt.executeUpdate("CREATE INDEX wl_iwlis_itemID ON wl_iwlis (itemID_h ASC, itemID_l ASC)");
                            stmt = JDBCTools.close(stmt);
                        }
                        finally {
                            JDBCTools.closeQuietly(stmt);
                        }
                    }
                });
                um.registerUpdate(new DbUpdateManager.Update(1, 2){

                    @Override
                    public void performUpdate(ExtendedConnection con) throws SQLException {
                        DBSpecificTools.updateColumnNullable(con, "wl_enq", "reply", true);
                        DBSpecificTools.updateColumnNullable(con, "wl_enq", "replierAgentName", true);
                        DBSpecificTools.updateColumnNullable(con, "wl_enq", "replierOrgPositionName", true);
                    }
                });
                if (!this.allTablesInDB(con)) {
                    int latestVersion = Math.max(um.getLatestVersion(), 0);
                    um.registerUpdate(new DbUpdateManager.Update(-1, latestVersion){

                        @Override
                        public void performUpdate(ExtendedConnection con) throws SQLException, IOException {
                            this.getLogger().warning("Creating and initialising database structure.");
                            try {
                                SQLTools.runSQLScript(con, DBWorklistManagerStorage.class.getResourceAsStream(DBWorklistManagerStorage.CREATE_STATEMENTS), true);
                            }
                            catch (Exception ex) {
                                this.getLogger().log(Level.SEVERE, "Creating and initialising database structure failed!.", ex);
                            }
                        }
                    });
                } else {
                    um.registerUpdate(new DbUpdateManager.Update(-1, 0){

                        @Override
                        public void performUpdate(ExtendedConnection con) throws SQLException {
                        }
                    });
                }
                um.performUpdates(con);
                this.releaseConnection(con, true);
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not create tables for worklist storage.", e);
            }
            catch (UpdateException e) {
                throw new RuntimeException("Could not create tables for worklist storage.", e);
            }
        }
        finally {
            this.releaseConnectionFinally(con);
        }
        try {
            this.worklistItemStorage = new DBWorklistItemStorage(this, 60000L);
            this.worklistStorage = new DBWorklistStorage(this, 60000L, this.worklistItemStorage);
            this.clientStorage = new DBClientStorage(this.dataSource);
        }
        catch (DataSourceException e) {
            throw new RuntimeException("Could not initiate the worklist storages.", e);
        }
    }

    public WorklistModelFactory getWorklistModelFactory() {
        return this.worklistModelFactory;
    }

    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.executionFactory;
    }

    @Override
    public ClientStorage getClientStorage() {
        return this.clientStorage;
    }

    @Override
    public WorklistItemStorage getWorklistItemStorage() {
        return this.worklistItemStorage;
    }

    @Override
    public WorklistStorage getWorklistStorage() {
        return this.worklistStorage;
    }

    @Override
    public void initialUpdateComplete() throws DataSourceException {
        this.worklistItemStorage.initialUpdateComplete();
        HashSet<UUID> updatedWorklists = new HashSet<UUID>();
        UUID[] uUIDArray = this.worklistItemStorage.getInternalWorklistItems();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistItemID = uUIDArray[n2];
            InternalWorklistItem item = this.worklistItemStorage.getInternalWorklistItemReadonly(worklistItemID);
            UUID[] uUIDArray2 = item.getWorklistIDs();
            int n3 = uUIDArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                UUID worklistID = uUIDArray2[n4];
                updatedWorklists.add(worklistID);
                InternalWorklist<InternalWorklistItem> worklist = this.worklistStorage.getInternalWorklistReadonly(worklistID);
                worklist.addWorklistItem(item);
                ++n4;
            }
            ++n2;
        }
        for (UUID worklistID : updatedWorklists) {
            InternalWorklist<InternalWorklistItem> worklist = this.worklistStorage.getInternalWorklistReadonly(worklistID);
            this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
        }
    }

    public synchronized ExtendedConnection requestConnection(boolean forWriteAccess) throws SQLException {
        if (!forWriteAccess) {
            if (this.readConnection == null) {
                this.readConnection = this.dataSource.getConnection();
            }
            ++this.readConnectionCounter;
            return this.readConnection;
        }
        ExtendedConnection con = this.dataSource.getConnection();
        con.setAutoCommit(false);
        this.writeConnections.add(con);
        return con;
    }

    public synchronized void releaseConnection(ExtendedConnection con, boolean submit) throws SQLException {
        if (con == null) {
            return;
        }
        if (con.equals(this.readConnection)) {
            if (--this.readConnectionCounter <= 0) {
                this.readConnectionCounter = 0;
                this.readConnection = null;
                con.close();
            }
        } else if (this.writeConnections.contains(con)) {
            this.writeConnections.remove(con);
            if (submit) {
                JDBCTools.close(con);
            } else {
                JDBCTools.closeQuietly(con);
            }
        }
    }

    public void releaseConnectionFinally(ExtendedConnection con) {
        try {
            this.releaseConnection(con, false);
        }
        catch (Exception ex) {
            String msg = String.format("The exception %s will be ignored.", ex);
            LoggerTools.getLogger(this).finest(msg);
        }
    }

    protected boolean allTablesInDB(ExtendedConnection con) throws SQLException {
        return con.tableExists("wl_asw") && con.tableExists("wl_del") && con.tableExists("wl_enq") && con.tableExists("wl_hasc") && con.tableExists("wl_hasdr") && con.tableExists("wl_haser") && con.tableExists("wl_iwlis") && con.tableExists("wl_thres") && con.tableExists("wl_uri") && con.tableExists("wl_iwl") && con.tableExists("wl_iwli") && con.tableExists("wl_act");
    }

    protected boolean anyTablesInDB(ExtendedConnection con) throws SQLException {
        return con.tableExists("wl_asw") || con.tableExists("wl_del") || con.tableExists("wl_enq") || con.tableExists("wl_hasc") || con.tableExists("wl_hasdr") || con.tableExists("wl_haser") || con.tableExists("wl_iwlis") || con.tableExists("wl_thres") || con.tableExists("wl_uri") || con.tableExists("wl_iwl") || con.tableExists("wl_iwli") || con.tableExists("wl_act");
    }
}

