/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.dbstorage;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistStorageWithCaching;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBStorageTools;
import de.aristaflow.adept2.core.worklistmanager.storage.dbstorage.DBWorklistManagerStorage;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistFilters;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLExport;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLImport;
import de.aristaflow.adept2.util.DataSourceException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.w3c.dom.Document;

public class DBWorklistStorage
extends AbstractWorklistStorageWithCaching {
    private final WorklistModelFactory worklistModelFactory;
    private final FilterFactory filterFactory;
    private final WorklistModelXMLExport xmlExport;
    private final WorklistModelXMLImport xmlImport;
    private final WorklistItemStorage worklistItemStorage;
    private final DBWorklistManagerStorage manager;

    public DBWorklistStorage(DBWorklistManagerStorage worklistManagerStorage, long lockTimeout, WorklistItemStorage itemStorage) throws DataSourceException {
        super(lockTimeout);
        this.worklistModelFactory = worklistManagerStorage.getWorklistModelFactory();
        this.filterFactory = worklistManagerStorage.getFilterFactory();
        this.worklistItemStorage = itemStorage;
        this.manager = worklistManagerStorage;
        this.xmlExport = new WorklistModelXMLExport();
        this.xmlImport = new WorklistModelXMLImport(this.worklistModelFactory, this.filterFactory);
        this.initWorklistIDcache();
    }

    public WorklistModelFactory getWorklistModelFactory() {
        return this.worklistModelFactory;
    }

    @Override
    protected InternalWorklist<InternalWorklistItem> createInternalWorklist_internal(QualifiedAgent agent, long revision, Map<String, String> userAttributes) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                UUID worklistID = this.getNextWorklistID();
                worklist = this.getWorklistModelFactory().createInternalWorklist(worklistID, agent, revision, new ArrayList<InternalWorklistItem>(), "", -1L, -1L, userAttributes);
                this.createDBEntryForWorklist(worklist, con);
                this.manager.releaseConnection(con, true);
                this.createWorklistCacheEntry(worklist);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't create the worklist. An error in the database occurs.", e);
        }
        return worklist;
    }

    @Override
    protected Map<QualifiedAgent, UUID> getAgentAndWorklistIDs_internal() throws DataSourceException {
        ExtendedConnection con = null;
        Map<QualifiedAgent, UUID> agentsWorklist = super.getAgentAndWorklistIDs_internal();
        if (agentsWorklist != null) {
            return agentsWorklist;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                agentsWorklist = this.getDBEntryForAgentAndWorklist(con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the qualified agents of the worklists. An error in the database occurs.", e);
        }
        return agentsWorklist;
    }

    @Override
    protected InternalWorklist<InternalWorklistItem> getInternalWorklist_internal(UUID worklistID) throws DataSourceException {
        ExtendedConnection con = null;
        InternalWorklist<InternalWorklistItem> worklist = super.getInternalWorklist_internal(worklistID);
        if (worklist != null) {
            return worklist;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                worklist = this.getDBEntryForWorklist(worklistID, con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the worklist. An error in the database occurs.", e);
        }
        this.createWorklistCacheEntry(worklist);
        return worklist;
    }

    @Override
    protected Map<String, String> getWorklistConfiguration_internal(UUID worklistID) throws DataSourceException {
        ExtendedConnection con = null;
        Map<String, String> config = super.getWorklistConfiguration_internal(worklistID);
        if (config != null) {
            return config;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                config = this.getDBEntryForWorklistConfig(worklistID, con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the worklist configuration. An error in the database occurs.", e);
        }
        this.createWorklistConfigurationCachEntry(worklistID, config);
        return config;
    }

    @Override
    protected WorklistUpdateConfiguration getMailingClientWorklistConfig_internal(UUID worklistID) throws DataSourceException {
        ExtendedConnection con = null;
        WorklistUpdateConfiguration updateConfig = super.getMailingClientWorklistConfig_internal(worklistID);
        if (updateConfig != null) {
            return updateConfig;
        }
        try {
            try {
                con = this.manager.requestConnection(false);
                updateConfig = this.getDBEntryForUpdateConfiguration(worklistID, con);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't retrieve the worklist update configuration. An error in the database occurs.", e);
        }
        this.createUpdateConfigurationCacheEntry(worklistID, updateConfig);
        return updateConfig;
    }

    @Override
    protected void setWorklistConfiguration_internal(UUID worklistID, Map<String, String> worklistConfiguration) throws DataSourceException {
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                this.updateDBEntryForWorklistConfiguration(worklistID, worklistConfiguration, con);
                this.manager.releaseConnection(con, true);
                super.setWorklistConfiguration_internal(worklistID, worklistConfiguration);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't store the worklist configuration. An error in the database occurs.", e);
        }
    }

    @Override
    protected void setMailingClientWorklistConfig_internal(UUID worklistID, WorklistUpdateConfiguration updateConfig) throws DataSourceException {
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                this.removeDBEntryForThresholds(worklistID, con);
                this.updateDBEntryForWorklistUpdateConfiguration(worklistID, updateConfig, con);
                if (updateConfig != null) {
                    this.createDBEntryForThresholds(worklistID, updateConfig, con);
                }
                this.manager.releaseConnection(con, true);
                super.setMailingClientWorklistConfig_internal(worklistID, updateConfig);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't store the worklist update configuration. An error in the database occurs.", e);
        }
    }

    @Override
    protected void updateInternalWorklist_internal(InternalWorklist<InternalWorklistItem> worklist) throws DataSourceException {
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                this.updateDBentryForWorklist(worklist, con);
                this.manager.releaseConnection(con, true);
                super.updateInternalWorklist_internal(worklist);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't update the worklist. An error in the database occurs.", e);
        }
    }

    @Override
    protected void removeInternalWorklist_internal(UUID worklistID) throws DataSourceException {
        ExtendedConnection con = null;
        try {
            try {
                con = this.manager.requestConnection(true);
                this.removeDBEntryForThresholds(worklistID, con);
                this.removeDBEntryForWorklist(worklistID, con);
                this.manager.releaseConnection(con, true);
                super.removeInternalWorklist_internal(worklistID);
            }
            finally {
                this.manager.releaseConnectionFinally(con);
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("Can't remove the worklist. An error in the database occurs.", e);
        }
    }

    @Override
    protected UUID getNextWorklistID() {
        UUID worklistID = super.getNextWorklistID();
        List<UUID> worklistIDs = Arrays.asList(this.getInternalWorklists());
        if (worklistIDs.contains(worklistID)) {
            String message = String.format("A worklist with ID '%s' exists already!", worklistID);
            this.logger.warning(message);
            throw new RuntimeException(message);
        }
        return worklistID;
    }

    protected void createDBEntryForWorklist(InternalWorklist<InternalWorklistItem> worklist, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                Map<String, String> attributes = worklist.getUserAttributes();
                Document userAttributes = null;
                if (attributes.size() > 0) {
                    userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                }
                stmt = con.prepareStatement("INSERT INTO wl_iwl (idH, idL, agentID, orgPositionID, agentName, orgPositionName, revision, absenceFrom, absenceTo, substitutionRule, serializedUserAttributes, serializedWorklistConfig, updateThreshold, updateUserAttributes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                stmt.setLong(1, worklist.getID().getMostSignificantBits());
                stmt.setLong(2, worklist.getID().getLeastSignificantBits());
                stmt.setLong(3, worklist.getAgent().getAgentID());
                stmt.setLong(4, worklist.getAgent().getOrgPositionID());
                stmt.setString(5, worklist.getAgent().getAgentUserName());
                stmt.setString(6, worklist.getAgent().getOrgPositionName());
                stmt.setLong(7, worklist.getRevision());
                stmt.setLong(8, worklist.getAbsenceFromDate());
                stmt.setLong(9, worklist.getAbsenceToDate());
                stmt.setString(10, worklist.getSubstitutionRule());
                DBStorageTools.setStatementBlobParameter(stmt, 11, userAttributes);
                DBStorageTools.setStatementBlobParameter(stmt, 12, null);
                stmt.setNull(13, 4);
                stmt.setBytes(14, null);
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void createDBEntryForThresholds(UUID worklistID, WorklistUpdateConfiguration updateConfig, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                int[] nArray = updateConfig.getUpdateIntervalThresholds();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int prio = nArray[n2];
                    stmt = con.prepareStatement("INSERT INTO wl_thres (priority, interval_, idH, idL) VALUES(?, ?, ?, ?)");
                    stmt.setInt(1, prio);
                    stmt.setLong(2, updateConfig.getUpdateInterval(prio));
                    stmt.setLong(3, worklistID.getMostSignificantBits());
                    stmt.setLong(4, worklistID.getLeastSignificantBits());
                    stmt.executeUpdate();
                    stmt = JDBCTools.close(stmt);
                    ++n2;
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(stmt);
        }
    }

    protected Map<QualifiedAgent, UUID> getDBEntryForAgentAndWorklist(ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        HashMap<QualifiedAgent, UUID> resultMap = new HashMap<QualifiedAgent, UUID>();
        try {
            try {
                stmt = con.prepareStatement("SELECT idH, idL, agentID, orgPositionID, agentName, orgPositionName FROM wl_iwl");
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    long msb = rs.getLong("idH");
                    long lsb = rs.getLong("idL");
                    long agentID = rs.getLong("agentID");
                    long orgPosID = rs.getLong("orgPositionID");
                    String agentName = rs.getString("agentName");
                    String orgPosName = rs.getString("orgPositionName");
                    UUID worklistID = new UUID(msb, lsb);
                    QualifiedAgent worklistAgent = new QualifiedAgent(agentID, agentName, orgPosID, orgPosName);
                    resultMap.put(worklistAgent, worklistID);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
        return resultMap;
    }

    protected InternalWorklist<InternalWorklistItem> getDBEntryForWorklist(UUID id, ExtendedConnection con) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = con.prepareStatement("SELECT * FROM wl_iwl WHERE idH = ? AND idL = ?");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new DataSourceException("The requested worklist could not be received, with the current dataconnection.");
                }
                long uuid_h = rs.getLong("idH");
                long uuid_l = rs.getLong("idL");
                long agentID = rs.getLong("agentID");
                long orgPosID = rs.getLong("orgPositionID");
                String agentName = rs.getString("agentName");
                String orgPosName = rs.getString("orgPositionName");
                long revision = rs.getLong("revision");
                long absenceFrom = rs.getLong("absenceFrom");
                long absenceTo = rs.getLong("absenceTo");
                String substRule = rs.getString("substitutionRule");
                if (rs.wasNull()) {
                    substRule = "";
                }
                InputStream userAttributes_Blob = rs.getBinaryStream("serializedUserAttributes");
                Map<String, String> userAttributes = this.xmlImport.getStringMapFromInputStream(userAttributes_Blob);
                UUID worklistID = new UUID(uuid_h, uuid_l);
                QualifiedAgent agent = new QualifiedAgent(agentID, agentName, orgPosID, orgPosName);
                ArrayList<InternalWorklistItem> worklistItems = new ArrayList<InternalWorklistItem>();
                Map<ClientWorklist, Long> clientWorklists = this.getClientWorklists(worklistID);
                worklist = this.worklistModelFactory.createInternalWorklist(worklistID, agent, revision, worklistItems, substRule, absenceFrom, absenceTo, userAttributes, clientWorklists);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return worklist;
    }

    protected Set<UUID> getDBEntryForWorklistItemIDs(UUID worklistID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        HashSet<UUID> worklistItemIDs = new HashSet<UUID>();
        try {
            try {
                stmt = con.prepareStatement("SELECT itemID_h, itemID_l FROM wl_iwlis WHERE worklistID_h = ? AND worklistID_l = ?");
                stmt.setLong(1, worklistID.getMostSignificantBits());
                stmt.setLong(2, worklistID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long msb = rs.getLong("itemID_h");
                    long lsb = rs.getLong("itemID_l");
                    UUID itemID = new UUID(msb, lsb);
                    worklistItemIDs.add(itemID);
                }
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return worklistItemIDs;
    }

    protected Map<String, String> getDBEntryForWorklistConfig(UUID worklistID, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Map<String, String> configuration = new HashMap<String, String>();
        try {
            try {
                stmt = con.prepareStatement("SELECT serializedWorklistConfig FROM wl_iwl WHERE idH = ? AND idL = ?");
                stmt.setLong(1, worklistID.getMostSignificantBits());
                stmt.setLong(2, worklistID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                if (rs.next()) {
                    InputStream worklistConfig = rs.getBinaryStream("serializedWorklistConfig");
                    configuration = this.xmlImport.getWorklistConfigurationFromInputStream(worklistConfig);
                }
            }
            catch (SQLException e) {
                throw new DataSourceException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return configuration;
    }

    protected WorklistUpdateConfiguration getDBEntryForUpdateConfiguration(UUID worklistID, ExtendedConnection con) throws DataSourceException {
        WorklistUpdateConfiguration updateConfig;
        InputStream userAttributeBlob;
        int updateThreshold;
        ResultSet rs;
        PreparedStatement stmt;
        block10: {
            block9: {
                block8: {
                    stmt = null;
                    rs = null;
                    stmt = con.prepareStatement("SELECT updateThreshold, updateUserAttributes FROM wl_iwl WHERE idH = ? AND idL = ?");
                    stmt.setLong(1, worklistID.getMostSignificantBits());
                    stmt.setLong(2, worklistID.getLeastSignificantBits());
                    rs = stmt.executeQuery();
                    if (rs.next()) break block8;
                    JDBCTools.closeQuietly((Statement)stmt, rs);
                    return null;
                }
                updateThreshold = rs.getInt("updateThreshold");
                if (!rs.wasNull()) break block9;
                JDBCTools.closeQuietly((Statement)stmt, rs);
                return null;
            }
            userAttributeBlob = rs.getBinaryStream("updateUserAttributes");
            if (!rs.wasNull()) break block10;
            JDBCTools.closeQuietly((Statement)stmt, rs);
            return null;
        }
        try {
            try {
                Map<String, String> updateUserAttribues = this.xmlImport.getStringMapFromInputStream(userAttributeBlob);
                stmt = JDBCTools.close(stmt);
                stmt = con.prepareStatement("SELECT * FROM wl_thres WHERE idH = ? AND idL = ?");
                stmt.setLong(1, worklistID.getMostSignificantBits());
                stmt.setLong(2, worklistID.getLeastSignificantBits());
                rs = stmt.executeQuery();
                HashMap<Integer, Long> priorityThreshold = new HashMap<Integer, Long>();
                while (rs.next()) {
                    int priority = rs.getInt("priority");
                    long interval = rs.getLong("interval_");
                    priorityThreshold.put(priority, interval);
                }
                Filter filter = WorklistFilters.noTopLevelInstances(this.filterFactory);
                updateConfig = this.worklistModelFactory.createWorklistConfiguration(updateThreshold, priorityThreshold, filter, updateUserAttribues);
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)stmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt, rs);
        return updateConfig;
    }

    protected void updateDBentryForWorklist(InternalWorklist<InternalWorklistItem> worklist, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                Map<String, String> attributes = worklist.getUserAttributes();
                Document userAttributes = null;
                if (attributes.size() > 0) {
                    userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                }
                stmt = con.prepareStatement("UPDATE wl_iwl SET absenceFrom = ?,absenceTo = ?,substitutionRule = ?,serializedUserAttributes = ?  WHERE idH = ? AND idL = ?");
                stmt.setLong(1, worklist.getAbsenceFromDate());
                stmt.setLong(2, worklist.getAbsenceToDate());
                stmt.setString(3, worklist.getSubstitutionRule());
                DBStorageTools.setStatementBlobParameter(stmt, 4, userAttributes);
                stmt.setLong(5, worklist.getID().getMostSignificantBits());
                stmt.setLong(6, worklist.getID().getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void updateDBEntryForWorklistConfiguration(UUID worklistID, Map<String, String> worklistConfiguration, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                Document worklistConfigurationMap = null;
                if (worklistConfiguration.size() > 0) {
                    worklistConfigurationMap = this.xmlExport.getDocumentForWorklistConfig(worklistConfiguration);
                }
                stmt = con.prepareStatement("UPDATE wl_iwl SET serializedWorklistConfig = ?  WHERE idH = ? AND idL = ?");
                DBStorageTools.setStatementBlobParameter(stmt, 1, worklistConfigurationMap);
                stmt.setLong(2, worklistID.getMostSignificantBits());
                stmt.setLong(3, worklistID.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void updateDBEntryForWorklistUpdateConfiguration(UUID worklistID, WorklistUpdateConfiguration updateConfig, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("UPDATE wl_iwl SET updateThreshold = ?,updateUserAttributes = ?  WHERE idH = ? AND idL = ?");
                if (updateConfig != null) {
                    Map<String, String> attributes = updateConfig.getUserAttributes();
                    Document userAttributes = null;
                    if (attributes.size() > 0) {
                        userAttributes = this.xmlExport.getDocumentForUserAttributes(attributes);
                    }
                    stmt.setInt(1, updateConfig.getUpdateModeThreshold());
                    DBStorageTools.setStatementBlobParameter(stmt, 2, userAttributes);
                    stmt.setLong(3, worklistID.getMostSignificantBits());
                    stmt.setLong(4, worklistID.getLeastSignificantBits());
                } else {
                    stmt.setNull(1, 4);
                    stmt.setNull(2, 2004);
                    stmt.setLong(3, worklistID.getMostSignificantBits());
                    stmt.setLong(4, worklistID.getLeastSignificantBits());
                }
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForWorklist(UUID id, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_iwl WHERE idH = ? AND idL = ?");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }

    protected void removeDBEntryForThresholds(UUID id, ExtendedConnection con) throws DataSourceException {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = con.prepareStatement("DELETE FROM wl_thres WHERE idH = ? AND idL = ?");
                stmt.setLong(1, id.getMostSignificantBits());
                stmt.setLong(2, id.getLeastSignificantBits());
                stmt.execute();
            }
            catch (SQLException ex) {
                throw new DataSourceException(ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(stmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)stmt);
    }
}

