/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.storage.ClientStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLWorklistManagerStorage;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLExport;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLImport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleXMLClientStorage
implements ClientStorage {
    private final Logger logger = LoggerTools.getLogger(this);
    private final SimpleXMLWorklistManagerStorage worklistManagerStorage;
    private final ReadWriteLock clientsLock;

    public SimpleXMLClientStorage(SimpleXMLWorklistManagerStorage worklistManagerStorage) {
        this.worklistManagerStorage = worklistManagerStorage;
        this.clientsLock = new ReentrantReadWriteLock();
    }

    @Override
    public void addClientURIsToAgent(QualifiedAgent agent, URI[] clientURIs) throws DataSourceException {
        this.clientsLock.writeLock().lock();
        try {
            File file = this.getAgentFile(agent);
            ArrayList<URI[]> clients = file.exists() ? new ArrayList<URI[]>(this.getClientURIs(agent)) : new ArrayList<URI[]>();
            clients.add(clientURIs);
            try {
                this.writeAgentToFile(file, agent, clients);
            }
            catch (DataSourceException e) {
                String msg = String.format("Exception while writing '%s' to the file system.", file.getAbsoluteFile());
                this.logger.log(Level.SEVERE, msg, e);
                throw e;
            }
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    @Override
    public List<URI[]> getClientURIs(QualifiedAgent agent) throws DataSourceException {
        List<URI[]> clients;
        block9: {
            this.clientsLock.readLock().lock();
            try {
                File file = this.getAgentFile(agent);
                if (file.exists()) {
                    try {
                        clients = this.getXMLImport().getClientsFromAgentFile(file);
                        break block9;
                    }
                    catch (VersionException e) {
                        String message = String.format("Exception while reading agent file '%s'.", agent);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new DataSourceException(message, e);
                    }
                    catch (XMLFormatException e) {
                        String message = String.format("Exception while reading agent file '%s'.", agent);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new DataSourceException(message, e);
                    }
                    catch (IOException e) {
                        String message = String.format("Exception while reading agent file '%s'.", agent);
                        this.logger.log(Level.SEVERE, message, e);
                        throw new DataSourceException(message, e);
                    }
                }
                String message = String.format("Agent ID '%s' does not exist.", agent);
                this.logger.info(message);
                clients = null;
            }
            finally {
                this.clientsLock.readLock().unlock();
            }
        }
        if (clients != null) {
            return Collections.unmodifiableList(clients);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean removeClientURIsFromAgent(QualifiedAgent agent, URI[] clientURIs, boolean longterm) throws DataSourceException {
        boolean clientRemaining;
        block9: {
            this.clientsLock.writeLock().lock();
            try {
                File file = this.getAgentFile(agent);
                if (!file.exists()) {
                    String message = String.format("Agent ID '%s' does not exist.", agent);
                    this.logger.warning(message);
                    throw new IllegalArgumentException(message);
                }
                ArrayList<URI[]> clients = new ArrayList<URI[]>(this.getClientURIs(agent));
                Iterator iter = clients.iterator();
                while (iter.hasNext()) {
                    if (!Arrays.equals((Object[])iter.next(), clientURIs)) continue;
                    iter.remove();
                    break;
                }
                boolean bl = clientRemaining = clients.size() > 0;
                if (clientRemaining || !longterm) {
                    try {
                        this.writeAgentToFile(file, agent, clients);
                        break block9;
                    }
                    catch (DataSourceException e) {
                        String msg = String.format("Exception while writing '%s' to the file system.", file.getAbsoluteFile());
                        this.logger.log(Level.SEVERE, msg, e);
                        throw e;
                    }
                }
                if (!file.delete()) {
                    String message = String.format("Could not delete agent '%s'!", agent);
                    this.logger.warning(message);
                    throw new RuntimeException(message);
                }
            }
            finally {
                this.clientsLock.writeLock().unlock();
            }
        }
        return clientRemaining;
    }

    @Override
    public boolean isUserKnown(QualifiedAgent agent) throws DataSourceException {
        boolean userKnown;
        this.clientsLock.readLock().lock();
        try {
            File file = this.getAgentFile(agent);
            userKnown = file.exists();
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return userKnown;
    }

    private void writeAgentToFile(File file, QualifiedAgent agent, List<URI[]> clients) throws DataSourceException {
        boolean deleted;
        String message;
        File tempFile = null;
        if (file.exists()) {
            tempFile = this.getAgentTempFile(agent);
            if (tempFile.exists()) {
                String message2 = String.format("Old transaction file '%s' exists for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message2);
                throw new DataSourceException(message2);
            }
            boolean renameSuccess = file.renameTo(tempFile);
            if (!renameSuccess) {
                String message3 = String.format("Could not create temporary file '%s' for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message3);
                throw new DataSourceException(message3);
            }
        }
        DataSourceException exception = null;
        try {
            this.getXMLExport().writeAgentAndClientsToFile(agent, clients, file);
        }
        catch (IOException e) {
            message = String.format("Exception while writing worklist item file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        catch (XMLFormatException e) {
            message = String.format("Exception while writing worklist item file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        if (exception != null) {
            if (tempFile != null) {
                boolean renameSuccess;
                boolean deleted2 = file.delete();
                if (!deleted2) {
                    this.logger.fine(String.format("The file %s could not be deleted.", file));
                }
                if (!(renameSuccess = tempFile.renameTo(file))) {
                    this.logger.severe(String.format("Could not rollback file '%s' to '%s'", tempFile, file));
                }
            }
            throw exception;
        }
        if (tempFile != null && !(deleted = tempFile.delete())) {
            this.logger.warning(String.format("The temporary file %s could not be deleted!", tempFile));
        }
    }

    private File getAgentTempFile(QualifiedAgent agent) {
        return new File(this.getDataDir(), "agent(" + agent.getAgentID() + "_" + agent.getOrgPositionID() + ")" + ".ag" + ".tmp");
    }

    private File getAgentFile(QualifiedAgent agent) {
        return new File(this.getDataDir(), String.valueOf(agent.getAgentID()) + "-" + agent.getOrgPositionID() + ".ag");
    }

    protected WorklistModelXMLExport getXMLExport() {
        return this.worklistManagerStorage.getXMLExport();
    }

    protected WorklistModelXMLImport getXMLImport() {
        return this.worklistManagerStorage.getXMLImport();
    }

    protected File getDataDir() {
        return this.worklistManagerStorage.getDataDir();
    }
}

