/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLWorklistManagerStorage;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLExport;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLImport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.FileSuffixFilter;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class SimpleXMLWorklistItemStorage
extends AbstractWorklistItemStorage {
    private final SimpleXMLWorklistManagerStorage worklistManagerStorage;

    SimpleXMLWorklistItemStorage(SimpleXMLWorklistManagerStorage worklistManagerStorage, long lockTimeout) {
        super(lockTimeout);
        this.worklistManagerStorage = worklistManagerStorage;
        this.initAndCheckWorklistItems();
    }

    private void initAndCheckWorklistItems() {
        String[] strings;
        FileSuffixFilter fileNameFilter = new FileSuffixFilter(".wli");
        String[] stringArray = strings = this.getDataDir().list(fileNameFilter);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            EBPInstanceReference ebp;
            InternalWorklistItem worklistItem;
            String fileName = stringArray[n2];
            UUID id = this.getIDFromFilename(fileName);
            try {
                worklistItem = this.getInternalWorklistItemFromFile(id, null, null, WorklistConstants.WorklistItemState.AVAILABLE, null);
            }
            catch (DataSourceException e) {
                String message = String.format("Exception while retrieving '%s' from the file system.", fileName);
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            if (!id.equals(worklistItem.getID())) {
                String message = String.format("File '%s' has inconsistent file name. Expected '%s', was '%s'", fileName, id, worklistItem.getID());
                this.logger.log(Level.SEVERE, message);
                throw new InternalServiceException(message);
            }
            try {
                ebp = this.getEBPInstanceReferenceFromFile(id);
            }
            catch (DataSourceException e) {
                String message = String.format("Exception while retrieving '%s' from the file system.", fileName);
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            this.worklistItemsToEBP.put(id, ebp);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public InternalWorklistItem createInternalWorklistItem(String name, String description, ActivityReference activityReference, UUID iconID, String staffAssignmentRule, WorklistConstants.WorklistItemState state, int priority, long complexity, long activationDate, long escalationDate, long dueDate, String escalationHandlingProcedureID, String delegationHandlingProcedureID, String distributionHandlingProcedureID, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, ParameterDataContext parameterDataContext, Map<String, String> userAttributes, EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            worklistItemID = this.getInternalWorklistItemID(ebpInstanceReference);
            if (worklistItemID == null) ** GOTO lbl19
            if (this.initialUpdateActive) {
                worklistItem = this.getInternalWorklistItemFromFile(worklistItemID, activityReference, staffAssignmentRule, state, null);
                var31_24 = worklistItem.getWorklistIDs();
                var30_25 = var31_24.length;
                var29_27 = 0;
                while (var29_27 < var30_25) {
                    worklistID = var31_24[var29_27];
                    worklist = this.worklistManagerStorage.getWorklistStorage().getInternalWorklistReadonly(worklistID);
                    worklist.addWorklistItem(worklistItem);
                    ++var29_27;
                }
            } else {
                var34_32 = this.getInternalWorklistItemReadonly(worklistItemID);
                return var34_32;
lbl19:
                // 1 sources

                if (this.initialUpdateActive) {
                    this.logger.info(String.format("Could not restore Worklist Item '%s'. No file for the worklist item found!", new Object[]{ebpInstanceReference}));
                }
                worklistItemID = this.getNextWorklistItemID();
                worklistItem = this.getWorklistModelFactory().createInternalWorklistItem(worklistItemID, name, description, activityReference, iconID, staffAssignmentRule, state, new UUID[0], null, -1, new HashSet<IndividualWorklistItemSettings>(), priority, complexity, activationDate, 0L, null, escalationDate, dueDate, 0, escalationHandlingProcedureID, 0, delegationHandlingProcedureID, new ArrayList<WorklistItem.Delegation>(), null, new ArrayList<Enquiry>(), distributionHandlingProcedureID, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, parameterDataContext, userAttributes);
                file = this.getWorklistItemFile(worklistItemID);
                try {
                    this.writeWorklistItemToFile(file, worklistItem, ebpInstanceReference);
                }
                catch (DataSourceException e) {
                    msg = String.format("Exception while writing '%s' to the file system.", new Object[]{file.getAbsoluteFile()});
                    this.logger.log(Level.SEVERE, msg, e);
                    throw e;
                }
            }
            this.worklistItems.put(worklistItem.getID(), worklistItem);
            this.worklistItemsToEBP.put(worklistItem.getID(), ebpInstanceReference);
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
        return worklistItem;
    }

    private InternalWorklistItem getInternalWorklistItemFromFile(UUID worklistItemID, ActivityReference activityReference, String staffAssignmentRule, WorklistConstants.WorklistItemState worklistItemState, QualifiedAgent assignedAgent) throws DataSourceException {
        InternalWorklistItem worklistItem;
        this.worklistItemsLock.readLock().lock();
        try {
            File worklistItemFile = this.getWorklistItemFile(worklistItemID);
            if (!worklistItemFile.exists()) {
                String message = String.format("Worklist Item with ID '%s' does not exist.", worklistItemID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            try {
                worklistItem = this.getXMLImport().getWorklistItemFromFile(worklistItemFile, activityReference, staffAssignmentRule, worklistItemState, assignedAgent);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading worklist item file '%s'.", worklistItemFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading worklist item file '%s'.", worklistItemFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading worklist item file '%s'.", worklistItemFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
        return worklistItem;
    }

    private EBPInstanceReference getEBPInstanceReferenceFromFile(UUID worklistItemID) throws DataSourceException {
        EBPInstanceReference ebp;
        this.worklistItemsLock.readLock().lock();
        try {
            File worklistItemFile = this.getWorklistItemFile(worklistItemID);
            if (!worklistItemFile.exists()) {
                String message = String.format("Worklist Item with ID '%s' does not exist.", worklistItemID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            try {
                ebp = this.getXMLImport().getEBPInstanceReferenceFromWorklistItemFile(worklistItemFile);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading worklist item file '%s'.", worklistItemFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading worklist item file '%s'.", worklistItemFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading worklist item file '%s'.", worklistItemFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.worklistItemsLock.readLock().unlock();
        }
        return ebp;
    }

    @Override
    public void removeInternalWorklistItem(UUID worklistItemID) throws DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            File file = this.getWorklistItemFile(worklistItemID);
            if (!file.exists()) {
                String message = String.format("A worklist item with ID '%s' does not exist!", worklistItemID);
                this.logger.warning(message);
                throw new RuntimeException(message);
            }
            if (!file.delete()) {
                String message = String.format("Could not delete worklist item with ID '%s'!", worklistItemID);
                this.logger.warning(message);
                throw new DataSourceException(message);
            }
            super.removeInternalWorklistItem(worklistItemID);
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    @Override
    public void updateInternalWorklistItem(SessionToken session, InternalWorklistItem item) throws DataSourceException, LockException {
        this.worklistItemsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, item.getID())) {
                String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, item.getID());
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)item.getID(), "InternalWorklistItemUpdate");
            }
            if (this.transactions.containsKey(item.getID())) {
                ((AbstractWorklistItemStorage.StorageTransaction)this.transactions.get(item.getID())).changed();
            } else {
                File file = this.getWorklistItemFile(item.getID());
                if (!file.exists()) {
                    String message = String.format("Worklist Item with ID '%s' does not exist.", item.getID());
                    this.logger.warning(message);
                    throw new IllegalArgumentException(message);
                }
                EBPInstanceReference ebpInstanceReference = this.getEBPInstanceReference(item.getID());
                this.writeWorklistItemToFile(file, item, ebpInstanceReference);
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
    }

    private UUID getIDFromFilename(String fileName) {
        UUID ret;
        String idString = fileName.substring(0, fileName.lastIndexOf("."));
        try {
            ret = UUID.fromString(idString);
        }
        catch (IllegalArgumentException iae) {
            String message = String.format("File found with an invalid file name: '%s'.", fileName);
            this.logger.log(Level.SEVERE, message);
            throw new InternalServiceException(message, iae);
        }
        return ret;
    }

    private void writeWorklistItemToFile(File file, InternalWorklistItem worklistItem, EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        boolean deleted;
        String message;
        File tempFile = null;
        if (file.exists()) {
            tempFile = this.getWorklistItemTempFile(worklistItem.getID());
            if (tempFile.exists()) {
                String message2 = String.format("Old transaction file '%s' exists for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message2);
                throw new DataSourceException(message2);
            }
            boolean renameSuccess = file.renameTo(tempFile);
            if (!renameSuccess) {
                String message3 = String.format("Could not create temporary file '%s' for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message3);
                throw new DataSourceException(message3);
            }
        }
        DataSourceException exception = null;
        try {
            this.getXMLExport().writeWorklistItemToFile(worklistItem, ebpInstanceReference, file);
        }
        catch (IOException e) {
            message = String.format("Exception while writing worklist item file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        catch (XMLFormatException e) {
            message = String.format("Exception while writing worklist item file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        if (exception != null) {
            if (tempFile != null) {
                boolean renameSuccess;
                boolean deleted2 = file.delete();
                if (!deleted2) {
                    this.logger.fine(String.format("The file %s could not be deleted.", file));
                }
                if (!(renameSuccess = tempFile.renameTo(file))) {
                    this.logger.severe(String.format("Could not rollback file '%s' to '%s'", tempFile, file));
                }
            }
            throw exception;
        }
        if (tempFile != null && !(deleted = tempFile.delete())) {
            this.logger.warning(String.format("The temporary file %s could not be deleted!", tempFile));
        }
    }

    private File getWorklistItemTempFile(UUID worklistItemID) {
        return new File(this.getDataDir(), worklistItemID + ".wli" + ".tmp");
    }

    private File getWorklistItemFile(UUID worklistItemID) {
        return new File(this.getDataDir(), worklistItemID + ".wli");
    }

    private UUID getNextWorklistItemID() {
        UUID worklistItemID = UUID.randomUUID();
        File file = this.getWorklistItemFile(worklistItemID);
        if (file.exists()) {
            String message = String.format("A worklist Item with ID '%s' exists already!", worklistItemID);
            this.logger.warning(message);
            throw new RuntimeException(message);
        }
        return worklistItemID;
    }

    @Override
    public void initialUpdateComplete() throws DataSourceException {
        this.worklistItemsLock.writeLock().lock();
        try {
            HashSet uuidsInStore = new HashSet(this.worklistItemsToEBP.keySet());
            uuidsInStore.removeAll(this.worklistItems.keySet());
            for (UUID worklistItemID : uuidsInStore) {
                this.removeInternalWorklistItem(worklistItemID);
            }
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
        this.initialUpdateActive = false;
    }

    protected WorklistModelXMLExport getXMLExport() {
        return this.worklistManagerStorage.getXMLExport();
    }

    protected WorklistModelXMLImport getXMLImport() {
        return this.worklistManagerStorage.getXMLImport();
    }

    protected File getDataDir() {
        return this.worklistManagerStorage.getDataDir();
    }

    @Override
    protected WorklistModelFactory getWorklistModelFactory() {
        return this.worklistManagerStorage.getWorklistModelFactory();
    }
}

