/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.core.worklistmanager.defaultimplementation.AbstractWorklistManager;
import de.aristaflow.adept2.core.worklistmanager.storage.ClientStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistManagerStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.WorklistStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLClientStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLWorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLWorklistStorage;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLExport;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLImport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.FileSuffixFilter;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public class SimpleXMLWorklistManagerStorage
implements WorklistManagerStorage {
    public static final String CONFIGURATION_DATA_DIR = "StorageDataDir";
    public static final String FILE_SUFFIX_TEMP = ".tmp";
    public static final String FILE_SUFFIX_WORKLIST = ".wl";
    public static final String FILE_SUFFIX_WORKLIST_ITEM = ".wli";
    public static final String FILE_SUFFIX_AGENT = ".ag";
    protected static final long LOCK_TIMEOUT = 60000L;
    protected final Logger logger = LoggerTools.getLogger(this);
    private final String dataDirName;
    private final File dataDir;
    private final AbstractWorklistManager worklistManager;
    private final WorklistModelFactory worklistModelFactory;
    private final FilterFactory filterFactory;
    private final WorklistModelXMLImport xmlImport;
    private final WorklistModelXMLExport xmlExport;
    private final WorklistStorage worklistStorage;
    private final AbstractWorklistItemStorage worklistItemStorage;
    private final ClientStorage clientStorage;

    public SimpleXMLWorklistManagerStorage(Configuration configuration, WorklistModelFactory worklistModelFactory, FilterFactory filterFactory, AbstractWorklistManager worklistManager) throws ConfigurationException {
        this.worklistManager = worklistManager;
        this.dataDirName = configuration.getString(CONFIGURATION_DATA_DIR);
        this.worklistModelFactory = worklistModelFactory;
        this.filterFactory = filterFactory;
        this.xmlImport = new WorklistModelXMLImport(worklistModelFactory, filterFactory);
        this.xmlExport = new WorklistModelXMLExport();
        if (this.dataDirName == null) {
            String message = String.format("The required configuration value '%s' is not set.", CONFIGURATION_DATA_DIR);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        this.dataDir = new File(this.dataDirName);
        if (!this.dataDir.exists()) {
            this.logger.warning(String.format("Data dir '%s' does not exist. Creating it.", this.dataDir));
            boolean success = this.dataDir.mkdir();
            if (!success) {
                String msg = String.format("The directory %s could not be created!", this.dataDir.getAbsolutePath());
                this.logger.severe(msg);
            }
        }
        this.logger.info(String.format("Using '%s' as data dir.", this.dataDir));
        if (!this.dataDir.canRead() || !this.dataDir.canWrite()) {
            String message = String.format("Read / write access is required to the data dir '%s'.", this.dataDir);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        if (!this.dataDir.isDirectory()) {
            String message = String.format("The data dir '%s' is not a directory.", this.dataDir);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        Object[] tempFiles = this.dataDir.listFiles(new FileSuffixFilter(FILE_SUFFIX_TEMP));
        if (tempFiles.length > 0) {
            String tempFileString = Arrays.toString(tempFiles);
            String message = String.format("Found temporary files! This may occur in case of crashes or unclean shutdowns! Please check the following files: %s.", tempFileString);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        this.worklistItemStorage = new SimpleXMLWorklistItemStorage(this, 60000L);
        this.worklistStorage = new SimpleXMLWorklistStorage(this, 60000L);
        this.clientStorage = new SimpleXMLClientStorage(this);
    }

    @Override
    public ClientStorage getClientStorage() {
        return this.clientStorage;
    }

    @Override
    public WorklistItemStorage getWorklistItemStorage() {
        return this.worklistItemStorage;
    }

    @Override
    public WorklistStorage getWorklistStorage() {
        return this.worklistStorage;
    }

    WorklistModelXMLImport getXMLImport() {
        return this.xmlImport;
    }

    WorklistModelFactory getWorklistModelFactory() {
        return this.worklistModelFactory;
    }

    File getDataDir() {
        return this.dataDir;
    }

    WorklistModelXMLExport getXMLExport() {
        return this.xmlExport;
    }

    @Override
    public void initialUpdateComplete() throws DataSourceException {
        this.worklistItemStorage.initialUpdateComplete();
        HashSet<UUID> updatedWorklists = new HashSet<UUID>();
        UUID[] uUIDArray = this.worklistItemStorage.getInternalWorklistItems();
        int n = uUIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            UUID worklistItemID = uUIDArray[n2];
            InternalWorklistItem item = this.worklistItemStorage.getInternalWorklistItemReadonly(worklistItemID);
            UUID[] uUIDArray2 = item.getWorklistIDs();
            int n3 = uUIDArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                UUID worklistID = uUIDArray2[n4];
                updatedWorklists.add(worklistID);
                InternalWorklist<InternalWorklistItem> worklist = this.worklistStorage.getInternalWorklistReadonly(worklistID);
                worklist.addWorklistItem(item);
                ++n4;
            }
            ++n2;
        }
        for (UUID worklistID : updatedWorklists) {
            InternalWorklist<InternalWorklistItem> worklist = this.worklistStorage.getInternalWorklistReadonly(worklistID);
            this.worklistManager.asyncNotifyClientsAboutUpdate(worklist);
        }
    }
}

