/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.core.worklistmanager.storage.simplexmlstorage.SimpleXMLWorklistManagerStorage;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLExport;
import de.aristaflow.adept2.model.worklistmodel.xml.WorklistModelXMLImport;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.FileSuffixFilter;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class SimpleXMLWorklistStorage
extends AbstractWorklistStorage {
    private final SimpleXMLWorklistManagerStorage worklistManagerStorage;

    SimpleXMLWorklistStorage(SimpleXMLWorklistManagerStorage worklistManagerStorage, long lockTimeout) {
        super(lockTimeout);
        this.worklistManagerStorage = worklistManagerStorage;
        this.initAndCheckWorklists();
    }

    private void initAndCheckWorklists() {
        String[] strings;
        FileSuffixFilter fileNameFilter = new FileSuffixFilter(".wl");
        String[] stringArray = strings = this.getDataDir().list(fileNameFilter);
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            WorklistUpdateConfiguration mailingWorklistUpdateConfiguration;
            Map<String, String> worklistConfiguration;
            InternalWorklist<InternalWorklistItem> worklist;
            String fileName = stringArray[n2];
            UUID id = this.getIDFromFilename(fileName);
            try {
                worklist = this.getInternalWorklistFromFile(id);
            }
            catch (DataSourceException e) {
                String message = String.format("Exception while retrieving '%s' from the file system.", fileName);
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            if (!id.equals(worklist.getID())) {
                String message = String.format("File '%s' has inconsistent file name. Expected '%s', was '%s'", fileName, id, worklist.getID());
                this.logger.log(Level.SEVERE, message);
                throw new InternalServiceException(message);
            }
            try {
                worklistConfiguration = this.getWorklistConfigurationsFromFile(id);
                mailingWorklistUpdateConfiguration = this.getMailingWorklistConfigurationFromFile(id);
            }
            catch (DataSourceException e) {
                String message = String.format("Exception while retrieving '%s' from the file system.", fileName);
                this.logger.log(Level.SEVERE, message, e);
                throw new InternalServiceException(message, e);
            }
            this.worklists.put(id, worklist);
            this.worklistByAgent.put(worklist.getAgent(), worklist.getID());
            if (mailingWorklistUpdateConfiguration != null) {
                this.mailingClientWorklists.put(id, mailingWorklistUpdateConfiguration);
            }
            if (worklistConfiguration != null) {
                this.worklistConfigurations.put(id, worklistConfiguration);
            }
            ++n2;
        }
    }

    @Override
    public InternalWorklist<InternalWorklistItem> createInternalWorklist(QualifiedAgent agent, long revision, Map<String, String> userAttributes) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        this.worklistsLock.writeLock().lock();
        try {
            if (this.worklistByAgent.containsKey(agent)) {
                InternalWorklist<InternalWorklistItem> internalWorklist = this.getInternalWorklistReadonly((UUID)this.worklistByAgent.get(agent));
                return internalWorklist;
            }
            UUID worklistID = this.getNextWorklistID();
            worklist = this.getWorklistModelFactory().createInternalWorklist(worklistID, agent, revision, new ArrayList<InternalWorklistItem>(), "", -1L, -1L, userAttributes);
            File file = this.getWorklistFile(worklistID);
            try {
                this.writeWorklistToFile(file, worklist);
            }
            catch (DataSourceException e) {
                String msg = String.format("Exception while writing '%s' to the file system.", file.getAbsoluteFile());
                this.logger.log(Level.SEVERE, msg, e);
                throw e;
            }
            this.worklists.put(worklist.getID(), worklist);
            this.worklistByAgent.put(agent, worklist.getID());
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
        return worklist;
    }

    @Override
    protected UUID getNextWorklistID() {
        UUID worklistID = super.getNextWorklistID();
        File file = this.getWorklistFile(worklistID);
        if (file.exists()) {
            String message = String.format("A worklist with ID '%s' exists already!", worklistID);
            this.logger.warning(message);
            throw new RuntimeException(message);
        }
        return worklistID;
    }

    private InternalWorklist<InternalWorklistItem> getInternalWorklistFromFile(UUID worklistID) throws DataSourceException {
        InternalWorklist<InternalWorklistItem> worklist;
        this.worklistsLock.readLock().lock();
        try {
            File worklistFile = this.getWorklistFile(worklistID);
            if (!worklistFile.exists()) {
                String message = String.format("Worklist with ID '%s' does not exist.", worklistID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            try {
                worklist = this.getXMLImport().getWorklistFromFile(worklistFile);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return worklist;
    }

    private WorklistUpdateConfiguration getMailingWorklistConfigurationFromFile(UUID worklistID) throws DataSourceException {
        WorklistUpdateConfiguration worklistUpdateConfiguration;
        this.worklistsLock.readLock().lock();
        try {
            File worklistFile = this.getWorklistFile(worklistID);
            if (!worklistFile.exists()) {
                String message = String.format("Worklist with ID '%s' does not exist.", worklistID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            try {
                worklistUpdateConfiguration = this.getXMLImport().getMailingWorklistConfigurationFromFile(worklistFile);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return worklistUpdateConfiguration;
    }

    private Map<String, String> getWorklistConfigurationsFromFile(UUID worklistID) throws DataSourceException {
        Map<String, String> worklistUpdateConfiguration;
        this.worklistsLock.readLock().lock();
        try {
            File worklistFile = this.getWorklistFile(worklistID);
            if (!worklistFile.exists()) {
                String message = String.format("Worklist with ID '%s' does not exist.", worklistID);
                this.logger.warning(message);
                throw new IllegalArgumentException(message);
            }
            try {
                worklistUpdateConfiguration = this.getXMLImport().getWorklistConfigurationsFromFile(worklistFile);
            }
            catch (VersionException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (XMLFormatException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
            catch (IOException e) {
                String message = String.format("Exception while reading worklist file '%s'.", worklistFile);
                this.logger.log(Level.SEVERE, message, e);
                throw new DataSourceException(message, e);
            }
        }
        finally {
            this.worklistsLock.readLock().unlock();
        }
        return worklistUpdateConfiguration;
    }

    private WorklistModelXMLImport getXMLImport() {
        return this.worklistManagerStorage.getXMLImport();
    }

    private WorklistModelXMLExport getXMLExport() {
        return this.worklistManagerStorage.getXMLExport();
    }

    private File getDataDir() {
        return this.worklistManagerStorage.getDataDir();
    }

    @Override
    public void removeInternalWorklist(UUID worklistID) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            File file = this.getWorklistFile(worklistID);
            if (!file.exists()) {
                String message = String.format("A worklist with ID '%s' does not exist!", worklistID);
                this.logger.warning(message);
                throw new RuntimeException(message);
            }
            if (!file.delete()) {
                String message = String.format("Could not delete worklist with ID '%s'!", worklistID);
                this.logger.warning(message);
                throw new RuntimeException(message);
            }
            super.removeInternalWorklist(worklistID);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public void updateInternalWorklist(SessionToken session, InternalWorklist<InternalWorklistItem> worklist) throws DataSourceException, LockException {
        this.worklistsLock.writeLock().lock();
        try {
            if (!this.lockManager.hasLock(true, session, worklist.getID())) {
                String message = String.format("Session '%s' is not holiding any lock on worklist '%s'!", session, worklist.getID());
                this.logger.log(Level.SEVERE, message);
                throw new IllegalLockStateException(session, (Object)worklist.getID(), "InternalWorklistUpdate");
            }
            this.updateWorklistFile(worklist);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    protected WorklistModelFactory getWorklistModelFactory() {
        return this.worklistManagerStorage.getWorklistModelFactory();
    }

    private void writeWorklistToFile(File file, InternalWorklist<InternalWorklistItem> worklist) throws DataSourceException {
        boolean deleted;
        String message;
        File tempFile = null;
        if (file.exists()) {
            tempFile = this.getWorklistTempFile(worklist.getID());
            if (tempFile.exists()) {
                String message2 = String.format("Old transaction file '%s' exists for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message2);
                throw new DataSourceException(message2);
            }
            boolean renameSuccess = file.renameTo(tempFile);
            if (!renameSuccess) {
                String message3 = String.format("Could not create temporary file '%s' for file '%s'!", tempFile, file);
                this.logger.log(Level.SEVERE, message3);
                throw new DataSourceException(message3);
            }
        }
        DataSourceException exception = null;
        try {
            WorklistUpdateConfiguration mailingWorklistUpdateConfiguration = (WorklistUpdateConfiguration)this.mailingClientWorklists.get(worklist.getID());
            Map worklistConfiguration = (Map)this.worklistConfigurations.get(worklist.getID());
            this.getXMLExport().writeWorklistToFile(worklist, mailingWorklistUpdateConfiguration, worklistConfiguration, file);
        }
        catch (IOException e) {
            message = String.format("Exception while writing worklist file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        catch (XMLFormatException e) {
            message = String.format("Exception while writing worklist file '%s'.", file);
            this.logger.log(Level.SEVERE, message, e);
            exception = new DataSourceException(message, e);
        }
        if (exception != null) {
            if (tempFile != null) {
                boolean renameSuccess;
                boolean deleted2 = file.delete();
                if (!deleted2) {
                    this.logger.fine(String.format("The file %s could not be deleted.", file));
                }
                if (!(renameSuccess = tempFile.renameTo(file))) {
                    this.logger.severe(String.format("Could not rollback file '%s' to '%s'", tempFile, file));
                }
            }
            throw exception;
        }
        if (tempFile != null && !(deleted = tempFile.delete())) {
            this.logger.warning(String.format("The temporary file %s could not be deleted!", tempFile));
        }
    }

    private File getWorklistTempFile(UUID worklistID) {
        return new File(this.getDataDir(), worklistID + ".wl" + ".tmp");
    }

    private File getWorklistFile(UUID worklistID) {
        return new File(this.getDataDir(), worklistID + ".wl");
    }

    private UUID getIDFromFilename(String fileName) throws InternalServiceException {
        UUID ret;
        String idString = fileName.substring(0, fileName.lastIndexOf("."));
        try {
            ret = UUID.fromString(idString);
        }
        catch (IllegalArgumentException iae) {
            String message = String.format("File found with an invalid file name: '%s'.", fileName);
            this.logger.log(Level.SEVERE, message);
            throw new InternalServiceException(message, iae);
        }
        return ret;
    }

    @Override
    public void setMailingClientWorklistConfig(UUID worklistID, WorklistUpdateConfiguration config) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            super.setMailingClientWorklistConfig(worklistID, config);
            InternalWorklist<InternalWorklistItem> worklist = this.getInternalWorklistReadonly(worklistID);
            this.updateWorklistFile(worklist);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public void setWorklistConfiguration(UUID worklistID, Map<String, String> worklistConfiguration) throws DataSourceException {
        this.worklistsLock.writeLock().lock();
        try {
            super.setWorklistConfiguration(worklistID, worklistConfiguration);
            InternalWorklist<InternalWorklistItem> worklist = this.getInternalWorklistReadonly(worklistID);
            this.updateWorklistFile(worklist);
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    private void updateWorklistFile(InternalWorklist<InternalWorklistItem> worklist) throws DataSourceException {
        File file = this.getWorklistFile(worklist.getID());
        if (!file.exists()) {
            String message = String.format("A worklist with ID '%s' does not exist!", worklist.getID());
            this.logger.warning(message);
            throw new RuntimeException(message);
        }
        try {
            this.writeWorklistToFile(file, worklist);
        }
        catch (DataSourceException e) {
            String msg = String.format("Exception while writing '%s' to the file system.", file.getAbsoluteFile());
            this.logger.log(Level.SEVERE, msg, e);
            throw e;
        }
    }
}

