/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.transientstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.core.worklistmanager.storage.ClientStorage;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class TransientClientStorage
implements ClientStorage {
    protected final Logger logger = LoggerTools.getLogger(this);
    protected final Map<QualifiedAgent, List<URI[]>> agentToClients;
    protected final ReentrantReadWriteLock clientsLock = new ReentrantReadWriteLock();

    protected TransientClientStorage() {
        this.agentToClients = new HashMap<QualifiedAgent, List<URI[]>>();
    }

    @Override
    public void addClientURIsToAgent(QualifiedAgent agent, URI[] clientURIs) throws DataSourceException {
        if (clientURIs == null) {
            throw new IllegalArgumentException();
        }
        this.clientsLock.writeLock().lock();
        try {
            List<URI[]> clients = this.agentToClients.get(agent);
            if (clients == null) {
                clients = new ArrayList<URI[]>();
                this.agentToClients.put(agent, clients);
            }
            clients.add(clientURIs);
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeClientURIsFromAgent(QualifiedAgent agent, URI[] clientURIs, boolean longterm) throws DataSourceException {
        if (clientURIs == null) {
            throw new IllegalArgumentException();
        }
        this.clientsLock.writeLock().lock();
        try {
            List<URI[]> clients = this.agentToClients.get(agent);
            if (clients == null) {
                return false;
            }
            Iterator<URI[]> iter = clients.iterator();
            while (iter.hasNext()) {
                if (!Arrays.equals(iter.next(), clientURIs)) continue;
                iter.remove();
                break;
            }
            if (clients.size() == 0 && longterm) {
                this.agentToClients.remove(agent);
            }
            boolean bl = clients.size() > 0;
            return bl;
        }
        finally {
            this.clientsLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isUserKnown(QualifiedAgent agent) throws DataSourceException {
        boolean userKnown;
        this.clientsLock.readLock().lock();
        try {
            List<URI[]> clients = this.agentToClients.get(agent);
            userKnown = clients != null;
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
        return userKnown;
    }

    @Override
    public List<URI[]> getClientURIs(QualifiedAgent agent) throws DataSourceException {
        this.clientsLock.readLock().lock();
        try {
            List<URI[]> clients = this.agentToClients.get(agent);
            if (clients == null) {
                List<URI[]> list = Collections.emptyList();
                return list;
            }
            List<URI[]> list = Collections.unmodifiableList(new ArrayList<URI[]>(clients));
            return list;
        }
        finally {
            this.clientsLock.readLock().unlock();
        }
    }
}

