/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.transientstorage;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistItemStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.core.worklistmanager.storage.transientstorage.TransientWorklistManagerStorage;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.IndividualWorklistItemSettings;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.UUIDTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;

public class TransientWorklistItemStorage
extends AbstractWorklistItemStorage {
    protected final TransientWorklistManagerStorage worklistManagerStorage;

    public TransientWorklistItemStorage(TransientWorklistManagerStorage worklistManagerStorage, long lockTimeout) {
        super(lockTimeout);
        this.worklistManagerStorage = worklistManagerStorage;
    }

    @Override
    public InternalWorklistItem createInternalWorklistItem(String title, String description, ActivityReference activityReference, UUID iconID, String staffAssignmentRule, WorklistConstants.WorklistItemState state, int priority, long complexity, long activationDate, long escalationDate, long dueDate, String escalationHandlingProcedureID, String delegationHandlingProcedureID, String distributionHandlingProcedureID, String processTemplateName, String processInstanceName, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginDatas, ParameterDataContext parameterDataContext, Map<String, String> userAttributes, EBPInstanceReference ebpInstanceReference) throws DataSourceException {
        InternalWorklistItem item = this.getWorklistModelFactory().createInternalWorklistItem(this.getNextWorklistItemID(), title, description, activityReference, iconID, staffAssignmentRule, state, new UUID[0], null, -1, new HashSet<IndividualWorklistItemSettings>(), priority, complexity, activationDate, 0L, null, escalationDate, dueDate, 0, escalationHandlingProcedureID, 0, delegationHandlingProcedureID, new ArrayList<WorklistItem.Delegation>(), null, new ArrayList<Enquiry>(), distributionHandlingProcedureID, processTemplateName, processInstanceName, supportedPlugins, pluginDatas, parameterDataContext, userAttributes);
        this.worklistItemsLock.writeLock().lock();
        try {
            this.worklistItems.put(item.getID(), item);
            this.worklistItemsToEBP.put(item.getID(), ebpInstanceReference);
        }
        finally {
            this.worklistItemsLock.writeLock().unlock();
        }
        return item;
    }

    private UUID getNextWorklistItemID() {
        return UUIDTools.createRandomUUID();
    }

    @Override
    public void updateInternalWorklistItem(SessionToken session, InternalWorklistItem item) throws DataSourceException, LockException {
        if (!this.lockManager.hasLock(true, session, item.getID())) {
            String message = String.format("Session '%s' is not holiding any lock on worklist Item '%s'!", session, item.getID());
            this.logger.log(Level.SEVERE, message);
            throw new IllegalLockStateException(session, (Object)item.getID(), "InternalWorklistItemUpdate");
        }
    }

    @Override
    protected WorklistModelFactory getWorklistModelFactory() {
        return this.worklistManagerStorage.getWorklistModelFactory();
    }

    @Override
    public void initialUpdateComplete() throws DataSourceException {
    }
}

