/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.worklistmanager.storage.transientstorage;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.AbstractWorklistStorage;
import de.aristaflow.adept2.core.worklistmanager.storage.abstractstorage.IllegalLockStateException;
import de.aristaflow.adept2.core.worklistmanager.storage.transientstorage.TransientWorklistManagerStorage;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklist;
import de.aristaflow.adept2.model.worklistmodel.InternalWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.util.LockException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

public class TransientWorklistStorage
extends AbstractWorklistStorage {
    public final TransientWorklistManagerStorage worklistManagerStorage;

    protected TransientWorklistStorage(TransientWorklistManagerStorage worklistManagerStorage, long lockTimeout) {
        super(lockTimeout);
        this.worklistManagerStorage = worklistManagerStorage;
    }

    @Override
    public InternalWorklist<InternalWorklistItem> createInternalWorklist(QualifiedAgent agent, long revision, Map<String, String> userAttributes) {
        this.worklistsLock.writeLock().lock();
        try {
            if (this.worklistByAgent.containsKey(agent)) {
                InternalWorklist internalWorklist = (InternalWorklist)this.worklists.get(this.worklistByAgent.get(agent));
                return internalWorklist;
            }
            InternalWorklist<InternalWorklistItem> worklist = this.getWorklistModelFactory().createInternalWorklist(this.getNextWorklistID(), agent, revision, new ArrayList<InternalWorklistItem>(), "", -1L, -1L, userAttributes);
            this.worklistByAgent.put(agent, worklist.getID());
            this.worklists.put(worklist.getID(), worklist);
            InternalWorklist<InternalWorklistItem> internalWorklist = worklist;
            return internalWorklist;
        }
        finally {
            this.worklistsLock.writeLock().unlock();
        }
    }

    @Override
    public void updateInternalWorklist(SessionToken session, InternalWorklist<InternalWorklistItem> worklist) throws LockException {
        if (!this.lockManager.hasLock(true, session, worklist.getID())) {
            String message = String.format("Session '%s' is not holiding any lock on worklist '%s'!", session, worklist.getID());
            this.logger.log(Level.SEVERE, message);
            throw new IllegalLockStateException(session, (Object)worklist.getID(), "InternalWorklistUpdate");
        }
    }

    @Override
    protected WorklistModelFactory getWorklistModelFactory() {
        return this.worklistManagerStorage.getWorklistModelFactory();
    }
}

